/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.mir.schemas;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.lang.core.mir.schemas.MirAssertKind;
import org.rust.lang.core.mir.schemas.MirBasicBlock;
import org.rust.lang.core.mir.schemas.MirOperand;
import org.rust.lang.core.mir.schemas.MirPlace;
import org.rust.lang.core.mir.schemas.MirSourceInfo;
import org.rust.lang.core.mir.schemas.MirSwitchTargets;
import org.rust.lang.core.mir.schemas.UnwindAction;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u0000 \u0018*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0003:\u000b\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018J\b\u0010\b\u001a\u00020\tH\u0016R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u0082\u0001\n\u0019\u001a\u001b\u001c\u001d\u001e\u001f !\"\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006#\u00c0\u0006\u0001"}, d2={"Lorg/rust/lang/core/mir/schemas/MirTerminator;", "BB", "Lorg/rust/lang/core/mir/schemas/MirBasicBlock;", "", "source", "Lorg/rust/lang/core/mir/schemas/MirSourceInfo;", "getSource", "()Lorg/rust/lang/core/mir/schemas/MirSourceInfo;", "isDummy", "", "successors", "", "getSuccessors", "()Ljava/util/List;", "Return", "Resume", "Assert", "Goto", "SwitchInt", "FalseEdge", "FalseUnwind", "Unreachable", "Call", "Drop", "Companion", "Lorg/rust/lang/core/mir/schemas/MirTerminator$Assert;", "Lorg/rust/lang/core/mir/schemas/MirTerminator$Call;", "Lorg/rust/lang/core/mir/schemas/MirTerminator$Drop;", "Lorg/rust/lang/core/mir/schemas/MirTerminator$FalseEdge;", "Lorg/rust/lang/core/mir/schemas/MirTerminator$FalseUnwind;", "Lorg/rust/lang/core/mir/schemas/MirTerminator$Goto;", "Lorg/rust/lang/core/mir/schemas/MirTerminator$Resume;", "Lorg/rust/lang/core/mir/schemas/MirTerminator$Return;", "Lorg/rust/lang/core/mir/schemas/MirTerminator$SwitchInt;", "Lorg/rust/lang/core/mir/schemas/MirTerminator$Unreachable;", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nMirTerminator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MirTerminator.kt\norg/rust/lang/core/mir/schemas/MirTerminator\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,95:1\n19#2:96\n*S KotlinDebug\n*F\n+ 1 MirTerminator.kt\norg/rust/lang/core/mir/schemas/MirTerminator\n*L\n84#1:96\n*E\n"})
public sealed interface MirTerminator<BB extends MirBasicBlock> {
    @NotNull
    public static final Companion Companion = org.rust.lang.core.mir.schemas.MirTerminator$Companion.$$INSTANCE;

    @NotNull
    public MirSourceInfo getSource();

    default public boolean isDummy() {
        return this == Companion.getDummy();
    }

    @NotNull
    default public List<MirBasicBlock> getSuccessors() {
        List list;
        MirTerminator mirTerminator = this;
        if (mirTerminator instanceof Return || mirTerminator instanceof Resume || mirTerminator instanceof Unreachable) {
            list = CollectionsKt.emptyList();
        } else if (mirTerminator instanceof Assert) {
            Object[] objectArray = new MirBasicBlock[]{((Assert)this).getTarget(), ((Assert)this).getUnwind()};
            list = CollectionsKt.listOfNotNull((Object[])objectArray);
        } else if (mirTerminator instanceof Goto) {
            list = CollectionsKt.listOf(((Goto)this).getTarget());
        } else if (mirTerminator instanceof SwitchInt) {
            list = ((SwitchInt)this).getTargets().getTargets();
        } else if (mirTerminator instanceof FalseUnwind) {
            Object[] objectArray = new MirBasicBlock[]{((FalseUnwind)this).getRealTarget(), ((FalseUnwind)this).getUnwind()};
            list = CollectionsKt.listOfNotNull((Object[])objectArray);
        } else if (mirTerminator instanceof Call) {
            Object[] objectArray = new MirBasicBlock[]{((Call)this).getTarget(), ((Call)this).getUnwind()};
            list = CollectionsKt.listOfNotNull((Object[])objectArray);
        } else if (mirTerminator instanceof Drop) {
            Object[] objectArray = new MirBasicBlock[2];
            objectArray[0] = ((Drop)this).getTarget();
            UnwindAction $this$asSafely$iv = ((Drop)this).getUnwind();
            boolean $i$f$asSafely = false;
            UnwindAction unwindAction = $this$asSafely$iv;
            if (!(unwindAction instanceof UnwindAction.Cleanup)) {
                unwindAction = null;
            }
            UnwindAction.Cleanup cleanup = (UnwindAction.Cleanup)unwindAction;
            objectArray[1] = cleanup != null ? cleanup.getCleanup() : null;
            list = CollectionsKt.listOfNotNull((Object[])objectArray);
        } else if (mirTerminator instanceof FalseEdge) {
            Object[] objectArray = new MirBasicBlock[]{((FalseEdge)this).getRealTarget(), ((FalseEdge)this).getImaginaryTarget()};
            list = CollectionsKt.listOfNotNull((Object[])objectArray);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B9\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00028\u0001\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00018\u0001\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\t\u0010\u001c\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0007H\u00c6\u0003J\u000e\u0010\u001e\u001a\u00028\u0001H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0015J\t\u0010\u001f\u001a\u00020\nH\u00c6\u0003J\u0010\u0010 \u001a\u0004\u0018\u00018\u0001H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0015J\t\u0010!\u001a\u00020\rH\u00c6\u0003JR\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00028\u00012\b\b\u0002\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00018\u00012\b\b\u0002\u0010\f\u001a\u00020\rH\u00c6\u0001\u00a2\u0006\u0002\u0010#J\u0013\u0010$\u001a\u00020\u00072\b\u0010%\u001a\u0004\u0018\u00010&H\u00d6\u0003J\t\u0010'\u001a\u00020(H\u00d6\u0001J\t\u0010)\u001a\u00020*H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\b\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0015\u0010\u000b\u001a\u0004\u0018\u00018\u0001\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b\u0019\u0010\u0015R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006+"}, d2={"Lorg/rust/lang/core/mir/schemas/MirTerminator$Assert;", "BB", "Lorg/rust/lang/core/mir/schemas/MirBasicBlock;", "Lorg/rust/lang/core/mir/schemas/MirTerminator;", "cond", "Lorg/rust/lang/core/mir/schemas/MirOperand;", "expected", "", "target", "msg", "Lorg/rust/lang/core/mir/schemas/MirAssertKind;", "unwind", "source", "Lorg/rust/lang/core/mir/schemas/MirSourceInfo;", "<init>", "(Lorg/rust/lang/core/mir/schemas/MirOperand;ZLorg/rust/lang/core/mir/schemas/MirBasicBlock;Lorg/rust/lang/core/mir/schemas/MirAssertKind;Lorg/rust/lang/core/mir/schemas/MirBasicBlock;Lorg/rust/lang/core/mir/schemas/MirSourceInfo;)V", "getCond", "()Lorg/rust/lang/core/mir/schemas/MirOperand;", "getExpected", "()Z", "getTarget", "()Lorg/rust/lang/core/mir/schemas/MirBasicBlock;", "Lorg/rust/lang/core/mir/schemas/MirBasicBlock;", "getMsg", "()Lorg/rust/lang/core/mir/schemas/MirAssertKind;", "getUnwind", "getSource", "()Lorg/rust/lang/core/mir/schemas/MirSourceInfo;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "(Lorg/rust/lang/core/mir/schemas/MirOperand;ZLorg/rust/lang/core/mir/schemas/MirBasicBlock;Lorg/rust/lang/core/mir/schemas/MirAssertKind;Lorg/rust/lang/core/mir/schemas/MirBasicBlock;Lorg/rust/lang/core/mir/schemas/MirSourceInfo;)Lorg/rust/lang/core/mir/schemas/MirTerminator$Assert;", "equals", "other", "", "hashCode", "", "toString", "", "intellij.rustrover.core"})
    public static final class Assert<BB extends MirBasicBlock>
    implements MirTerminator<BB> {
        @NotNull
        private final MirOperand cond;
        private final boolean expected;
        @NotNull
        private final BB target;
        @NotNull
        private final MirAssertKind msg;
        @Nullable
        private final BB unwind;
        @NotNull
        private final MirSourceInfo source;

        public Assert(@NotNull MirOperand cond, boolean expected, @NotNull BB target, @NotNull MirAssertKind msg, @Nullable BB unwind, @NotNull MirSourceInfo source) {
            Intrinsics.checkNotNullParameter((Object)cond, (String)"cond");
            Intrinsics.checkNotNullParameter(target, (String)"target");
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            this.cond = cond;
            this.expected = expected;
            this.target = target;
            this.msg = msg;
            this.unwind = unwind;
            this.source = source;
        }

        @NotNull
        public final MirOperand getCond() {
            return this.cond;
        }

        public final boolean getExpected() {
            return this.expected;
        }

        @NotNull
        public final BB getTarget() {
            return this.target;
        }

        @NotNull
        public final MirAssertKind getMsg() {
            return this.msg;
        }

        @Nullable
        public final BB getUnwind() {
            return this.unwind;
        }

        @Override
        @NotNull
        public MirSourceInfo getSource() {
            return this.source;
        }

        @NotNull
        public final MirOperand component1() {
            return this.cond;
        }

        public final boolean component2() {
            return this.expected;
        }

        @NotNull
        public final BB component3() {
            return this.target;
        }

        @NotNull
        public final MirAssertKind component4() {
            return this.msg;
        }

        @Nullable
        public final BB component5() {
            return this.unwind;
        }

        @NotNull
        public final MirSourceInfo component6() {
            return this.source;
        }

        @NotNull
        public final Assert<BB> copy(@NotNull MirOperand cond, boolean expected, @NotNull BB target, @NotNull MirAssertKind msg, @Nullable BB unwind, @NotNull MirSourceInfo source) {
            Intrinsics.checkNotNullParameter((Object)cond, (String)"cond");
            Intrinsics.checkNotNullParameter(target, (String)"target");
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            return new Assert<BB>(cond, expected, target, msg, unwind, source);
        }

        public static /* synthetic */ Assert copy$default(Assert assert_, MirOperand mirOperand, boolean bl, MirBasicBlock mirBasicBlock, MirAssertKind mirAssertKind, MirBasicBlock mirBasicBlock2, MirSourceInfo mirSourceInfo, int n, Object object) {
            if ((n & 1) != 0) {
                mirOperand = assert_.cond;
            }
            if ((n & 2) != 0) {
                bl = assert_.expected;
            }
            if ((n & 4) != 0) {
                mirBasicBlock = assert_.target;
            }
            if ((n & 8) != 0) {
                mirAssertKind = assert_.msg;
            }
            if ((n & 0x10) != 0) {
                mirBasicBlock2 = assert_.unwind;
            }
            if ((n & 0x20) != 0) {
                mirSourceInfo = assert_.source;
            }
            return assert_.copy(mirOperand, bl, mirBasicBlock, mirAssertKind, mirBasicBlock2, mirSourceInfo);
        }

        @NotNull
        public String toString() {
            return "Assert(cond=" + this.cond + ", expected=" + this.expected + ", target=" + this.target + ", msg=" + this.msg + ", unwind=" + this.unwind + ", source=" + this.source + ")";
        }

        public int hashCode() {
            int result2 = this.cond.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.expected);
            result2 = result2 * 31 + this.target.hashCode();
            result2 = result2 * 31 + this.msg.hashCode();
            result2 = result2 * 31 + (this.unwind == null ? 0 : this.unwind.hashCode());
            result2 = result2 * 31 + this.source.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Assert)) {
                return false;
            }
            Assert assert_ = (Assert)other;
            if (!Intrinsics.areEqual((Object)this.cond, (Object)assert_.cond)) {
                return false;
            }
            if (this.expected != assert_.expected) {
                return false;
            }
            if (!Intrinsics.areEqual(this.target, assert_.target)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.msg, (Object)assert_.msg)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.unwind, assert_.unwind)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.source, (Object)assert_.source);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003BI\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00018\u0001\u0012\b\u0010\u000b\u001a\u0004\u0018\u00018\u0001\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\t\u0010 \u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007H\u00c6\u0003J\t\u0010\"\u001a\u00020\tH\u00c6\u0003J\u0010\u0010#\u001a\u0004\u0018\u00018\u0001H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010$\u001a\u0004\u0018\u00018\u0001H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0019J\t\u0010%\u001a\u00020\rH\u00c6\u0003J\t\u0010&\u001a\u00020\u000fH\u00c6\u0003Jd\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00018\u00012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00018\u00012\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u00c6\u0001\u00a2\u0006\u0002\u0010(J\u0013\u0010)\u001a\u00020\r2\b\u0010*\u001a\u0004\u0018\u00010+H\u00d6\u0003J\t\u0010,\u001a\u00020-H\u00d6\u0001J\t\u0010.\u001a\u00020/H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0015\u0010\n\u001a\u0004\u0018\u00018\u0001\u00a2\u0006\n\n\u0002\u0010\u001a\u001a\u0004\b\u0018\u0010\u0019R\u0015\u0010\u000b\u001a\u0004\u0018\u00018\u0001\u00a2\u0006\n\n\u0002\u0010\u001a\u001a\u0004\b\u001b\u0010\u0019R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u00060"}, d2={"Lorg/rust/lang/core/mir/schemas/MirTerminator$Call;", "BB", "Lorg/rust/lang/core/mir/schemas/MirBasicBlock;", "Lorg/rust/lang/core/mir/schemas/MirTerminator;", "callee", "Lorg/rust/lang/core/mir/schemas/MirOperand;", "args", "", "destination", "Lorg/rust/lang/core/mir/schemas/MirPlace;", "target", "unwind", "fromCall", "", "source", "Lorg/rust/lang/core/mir/schemas/MirSourceInfo;", "<init>", "(Lorg/rust/lang/core/mir/schemas/MirOperand;Ljava/util/List;Lorg/rust/lang/core/mir/schemas/MirPlace;Lorg/rust/lang/core/mir/schemas/MirBasicBlock;Lorg/rust/lang/core/mir/schemas/MirBasicBlock;ZLorg/rust/lang/core/mir/schemas/MirSourceInfo;)V", "getCallee", "()Lorg/rust/lang/core/mir/schemas/MirOperand;", "getArgs", "()Ljava/util/List;", "getDestination", "()Lorg/rust/lang/core/mir/schemas/MirPlace;", "getTarget", "()Lorg/rust/lang/core/mir/schemas/MirBasicBlock;", "Lorg/rust/lang/core/mir/schemas/MirBasicBlock;", "getUnwind", "getFromCall", "()Z", "getSource", "()Lorg/rust/lang/core/mir/schemas/MirSourceInfo;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "(Lorg/rust/lang/core/mir/schemas/MirOperand;Ljava/util/List;Lorg/rust/lang/core/mir/schemas/MirPlace;Lorg/rust/lang/core/mir/schemas/MirBasicBlock;Lorg/rust/lang/core/mir/schemas/MirBasicBlock;ZLorg/rust/lang/core/mir/schemas/MirSourceInfo;)Lorg/rust/lang/core/mir/schemas/MirTerminator$Call;", "equals", "other", "", "hashCode", "", "toString", "", "intellij.rustrover.core"})
    public static final class Call<BB extends MirBasicBlock>
    implements MirTerminator<BB> {
        @NotNull
        private final MirOperand callee;
        @NotNull
        private final List<MirOperand> args;
        @NotNull
        private final MirPlace destination;
        @Nullable
        private final BB target;
        @Nullable
        private final BB unwind;
        private final boolean fromCall;
        @NotNull
        private final MirSourceInfo source;

        public Call(@NotNull MirOperand callee, @NotNull List<? extends MirOperand> args, @NotNull MirPlace destination, @Nullable BB target, @Nullable BB unwind, boolean fromCall, @NotNull MirSourceInfo source) {
            Intrinsics.checkNotNullParameter((Object)callee, (String)"callee");
            Intrinsics.checkNotNullParameter(args, (String)"args");
            Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            this.callee = callee;
            this.args = args;
            this.destination = destination;
            this.target = target;
            this.unwind = unwind;
            this.fromCall = fromCall;
            this.source = source;
        }

        @NotNull
        public final MirOperand getCallee() {
            return this.callee;
        }

        @NotNull
        public final List<MirOperand> getArgs() {
            return this.args;
        }

        @NotNull
        public final MirPlace getDestination() {
            return this.destination;
        }

        @Nullable
        public final BB getTarget() {
            return this.target;
        }

        @Nullable
        public final BB getUnwind() {
            return this.unwind;
        }

        public final boolean getFromCall() {
            return this.fromCall;
        }

        @Override
        @NotNull
        public MirSourceInfo getSource() {
            return this.source;
        }

        @NotNull
        public final MirOperand component1() {
            return this.callee;
        }

        @NotNull
        public final List<MirOperand> component2() {
            return this.args;
        }

        @NotNull
        public final MirPlace component3() {
            return this.destination;
        }

        @Nullable
        public final BB component4() {
            return this.target;
        }

        @Nullable
        public final BB component5() {
            return this.unwind;
        }

        public final boolean component6() {
            return this.fromCall;
        }

        @NotNull
        public final MirSourceInfo component7() {
            return this.source;
        }

        @NotNull
        public final Call<BB> copy(@NotNull MirOperand callee, @NotNull List<? extends MirOperand> args, @NotNull MirPlace destination, @Nullable BB target, @Nullable BB unwind, boolean fromCall, @NotNull MirSourceInfo source) {
            Intrinsics.checkNotNullParameter((Object)callee, (String)"callee");
            Intrinsics.checkNotNullParameter(args, (String)"args");
            Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            return new Call<BB>(callee, args, destination, target, unwind, fromCall, source);
        }

        public static /* synthetic */ Call copy$default(Call call2, MirOperand mirOperand, List list, MirPlace mirPlace, MirBasicBlock mirBasicBlock, MirBasicBlock mirBasicBlock2, boolean bl, MirSourceInfo mirSourceInfo, int n, Object object) {
            if ((n & 1) != 0) {
                mirOperand = call2.callee;
            }
            if ((n & 2) != 0) {
                list = call2.args;
            }
            if ((n & 4) != 0) {
                mirPlace = call2.destination;
            }
            if ((n & 8) != 0) {
                mirBasicBlock = call2.target;
            }
            if ((n & 0x10) != 0) {
                mirBasicBlock2 = call2.unwind;
            }
            if ((n & 0x20) != 0) {
                bl = call2.fromCall;
            }
            if ((n & 0x40) != 0) {
                mirSourceInfo = call2.source;
            }
            return call2.copy(mirOperand, list, mirPlace, mirBasicBlock, mirBasicBlock2, bl, mirSourceInfo);
        }

        @NotNull
        public String toString() {
            return "Call(callee=" + this.callee + ", args=" + this.args + ", destination=" + this.destination + ", target=" + this.target + ", unwind=" + this.unwind + ", fromCall=" + this.fromCall + ", source=" + this.source + ")";
        }

        public int hashCode() {
            int result2 = this.callee.hashCode();
            result2 = result2 * 31 + ((Object)this.args).hashCode();
            result2 = result2 * 31 + this.destination.hashCode();
            result2 = result2 * 31 + (this.target == null ? 0 : this.target.hashCode());
            result2 = result2 * 31 + (this.unwind == null ? 0 : this.unwind.hashCode());
            result2 = result2 * 31 + Boolean.hashCode(this.fromCall);
            result2 = result2 * 31 + this.source.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Call)) {
                return false;
            }
            Call call2 = (Call)other;
            if (!Intrinsics.areEqual((Object)this.callee, (Object)call2.callee)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.args, call2.args)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.destination, (Object)call2.destination)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.target, call2.target)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.unwind, call2.unwind)) {
                return false;
            }
            if (this.fromCall != call2.fromCall) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.source, (Object)call2.source);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/rust/lang/core/mir/schemas/MirTerminator$Companion;", "", "<init>", "()V", "dummy", "Lorg/rust/lang/core/mir/schemas/MirTerminator$Resume;", "getDummy", "()Lorg/rust/lang/core/mir/schemas/MirTerminator$Resume;", "intellij.rustrover.core"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final Resume dummy;

        private Companion() {
        }

        @NotNull
        public final Resume getDummy() {
            return dummy;
        }

        static {
            $$INSTANCE = new Companion();
            dummy = new Resume(MirSourceInfo.Companion.getFake());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B-\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0001\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\u000e\u0010\u0017\u001a\u00028\u0001H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0010J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00010\bH\u00c6\u0003J\t\u0010\u0019\u001a\u00020\nH\u00c6\u0003JB\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00028\u00012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001\u00a2\u0006\u0002\u0010\u001bJ\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\t\u0010\"\u001a\u00020#H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0006\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006$"}, d2={"Lorg/rust/lang/core/mir/schemas/MirTerminator$Drop;", "BB", "Lorg/rust/lang/core/mir/schemas/MirBasicBlock;", "Lorg/rust/lang/core/mir/schemas/MirTerminator;", "place", "Lorg/rust/lang/core/mir/schemas/MirPlace;", "target", "unwind", "Lorg/rust/lang/core/mir/schemas/UnwindAction;", "source", "Lorg/rust/lang/core/mir/schemas/MirSourceInfo;", "<init>", "(Lorg/rust/lang/core/mir/schemas/MirPlace;Lorg/rust/lang/core/mir/schemas/MirBasicBlock;Lorg/rust/lang/core/mir/schemas/UnwindAction;Lorg/rust/lang/core/mir/schemas/MirSourceInfo;)V", "getPlace", "()Lorg/rust/lang/core/mir/schemas/MirPlace;", "getTarget", "()Lorg/rust/lang/core/mir/schemas/MirBasicBlock;", "Lorg/rust/lang/core/mir/schemas/MirBasicBlock;", "getUnwind", "()Lorg/rust/lang/core/mir/schemas/UnwindAction;", "getSource", "()Lorg/rust/lang/core/mir/schemas/MirSourceInfo;", "component1", "component2", "component3", "component4", "copy", "(Lorg/rust/lang/core/mir/schemas/MirPlace;Lorg/rust/lang/core/mir/schemas/MirBasicBlock;Lorg/rust/lang/core/mir/schemas/UnwindAction;Lorg/rust/lang/core/mir/schemas/MirSourceInfo;)Lorg/rust/lang/core/mir/schemas/MirTerminator$Drop;", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.rustrover.core"})
    public static final class Drop<BB extends MirBasicBlock>
    implements MirTerminator<BB> {
        @NotNull
        private final MirPlace place;
        @NotNull
        private final BB target;
        @NotNull
        private final UnwindAction<BB> unwind;
        @NotNull
        private final MirSourceInfo source;

        public Drop(@NotNull MirPlace place, @NotNull BB target, @NotNull UnwindAction<? extends BB> unwind, @NotNull MirSourceInfo source) {
            Intrinsics.checkNotNullParameter((Object)place, (String)"place");
            Intrinsics.checkNotNullParameter(target, (String)"target");
            Intrinsics.checkNotNullParameter(unwind, (String)"unwind");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            this.place = place;
            this.target = target;
            this.unwind = unwind;
            this.source = source;
        }

        @NotNull
        public final MirPlace getPlace() {
            return this.place;
        }

        @NotNull
        public final BB getTarget() {
            return this.target;
        }

        @NotNull
        public final UnwindAction<BB> getUnwind() {
            return this.unwind;
        }

        @Override
        @NotNull
        public MirSourceInfo getSource() {
            return this.source;
        }

        @NotNull
        public final MirPlace component1() {
            return this.place;
        }

        @NotNull
        public final BB component2() {
            return this.target;
        }

        @NotNull
        public final UnwindAction<BB> component3() {
            return this.unwind;
        }

        @NotNull
        public final MirSourceInfo component4() {
            return this.source;
        }

        @NotNull
        public final Drop<BB> copy(@NotNull MirPlace place, @NotNull BB target, @NotNull UnwindAction<? extends BB> unwind, @NotNull MirSourceInfo source) {
            Intrinsics.checkNotNullParameter((Object)place, (String)"place");
            Intrinsics.checkNotNullParameter(target, (String)"target");
            Intrinsics.checkNotNullParameter(unwind, (String)"unwind");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            return new Drop<BB>(place, target, unwind, source);
        }

        public static /* synthetic */ Drop copy$default(Drop drop, MirPlace mirPlace, MirBasicBlock mirBasicBlock, UnwindAction unwindAction, MirSourceInfo mirSourceInfo, int n, Object object) {
            if ((n & 1) != 0) {
                mirPlace = drop.place;
            }
            if ((n & 2) != 0) {
                mirBasicBlock = drop.target;
            }
            if ((n & 4) != 0) {
                unwindAction = drop.unwind;
            }
            if ((n & 8) != 0) {
                mirSourceInfo = drop.source;
            }
            return drop.copy(mirPlace, mirBasicBlock, unwindAction, mirSourceInfo);
        }

        @NotNull
        public String toString() {
            return "Drop(place=" + this.place + ", target=" + this.target + ", unwind=" + this.unwind + ", source=" + this.source + ")";
        }

        public int hashCode() {
            int result2 = this.place.hashCode();
            result2 = result2 * 31 + this.target.hashCode();
            result2 = result2 * 31 + this.unwind.hashCode();
            result2 = result2 * 31 + this.source.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Drop)) {
                return false;
            }
            Drop drop = (Drop)other;
            if (!Intrinsics.areEqual((Object)this.place, (Object)drop.place)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.target, drop.target)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.unwind, drop.unwind)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.source, (Object)drop.source);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B!\u0012\u0006\u0010\u0004\u001a\u00028\u0001\u0012\b\u0010\u0005\u001a\u0004\u0018\u00018\u0001\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0010\u001a\u00028\u0001H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0011\u001a\u0004\u0018\u00018\u0001H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J4\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0004\u001a\u00028\u00012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00018\u00012\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0014J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0013\u0010\u0004\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u0015\u0010\u0005\u001a\u0004\u0018\u00018\u0001\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lorg/rust/lang/core/mir/schemas/MirTerminator$FalseEdge;", "BB", "Lorg/rust/lang/core/mir/schemas/MirBasicBlock;", "Lorg/rust/lang/core/mir/schemas/MirTerminator;", "realTarget", "imaginaryTarget", "source", "Lorg/rust/lang/core/mir/schemas/MirSourceInfo;", "<init>", "(Lorg/rust/lang/core/mir/schemas/MirBasicBlock;Lorg/rust/lang/core/mir/schemas/MirBasicBlock;Lorg/rust/lang/core/mir/schemas/MirSourceInfo;)V", "getRealTarget", "()Lorg/rust/lang/core/mir/schemas/MirBasicBlock;", "Lorg/rust/lang/core/mir/schemas/MirBasicBlock;", "getImaginaryTarget", "getSource", "()Lorg/rust/lang/core/mir/schemas/MirSourceInfo;", "component1", "component2", "component3", "copy", "(Lorg/rust/lang/core/mir/schemas/MirBasicBlock;Lorg/rust/lang/core/mir/schemas/MirBasicBlock;Lorg/rust/lang/core/mir/schemas/MirSourceInfo;)Lorg/rust/lang/core/mir/schemas/MirTerminator$FalseEdge;", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.rustrover.core"})
    public static final class FalseEdge<BB extends MirBasicBlock>
    implements MirTerminator<BB> {
        @NotNull
        private final BB realTarget;
        @Nullable
        private final BB imaginaryTarget;
        @NotNull
        private final MirSourceInfo source;

        public FalseEdge(@NotNull BB realTarget, @Nullable BB imaginaryTarget, @NotNull MirSourceInfo source) {
            Intrinsics.checkNotNullParameter(realTarget, (String)"realTarget");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            this.realTarget = realTarget;
            this.imaginaryTarget = imaginaryTarget;
            this.source = source;
        }

        @NotNull
        public final BB getRealTarget() {
            return this.realTarget;
        }

        @Nullable
        public final BB getImaginaryTarget() {
            return this.imaginaryTarget;
        }

        @Override
        @NotNull
        public MirSourceInfo getSource() {
            return this.source;
        }

        @NotNull
        public final BB component1() {
            return this.realTarget;
        }

        @Nullable
        public final BB component2() {
            return this.imaginaryTarget;
        }

        @NotNull
        public final MirSourceInfo component3() {
            return this.source;
        }

        @NotNull
        public final FalseEdge<BB> copy(@NotNull BB realTarget, @Nullable BB imaginaryTarget, @NotNull MirSourceInfo source) {
            Intrinsics.checkNotNullParameter(realTarget, (String)"realTarget");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            return new FalseEdge<BB>(realTarget, imaginaryTarget, source);
        }

        public static /* synthetic */ FalseEdge copy$default(FalseEdge falseEdge, MirBasicBlock mirBasicBlock, MirBasicBlock mirBasicBlock2, MirSourceInfo mirSourceInfo, int n, Object object) {
            if ((n & 1) != 0) {
                mirBasicBlock = falseEdge.realTarget;
            }
            if ((n & 2) != 0) {
                mirBasicBlock2 = falseEdge.imaginaryTarget;
            }
            if ((n & 4) != 0) {
                mirSourceInfo = falseEdge.source;
            }
            return falseEdge.copy(mirBasicBlock, mirBasicBlock2, mirSourceInfo);
        }

        @NotNull
        public String toString() {
            return "FalseEdge(realTarget=" + this.realTarget + ", imaginaryTarget=" + this.imaginaryTarget + ", source=" + this.source + ")";
        }

        public int hashCode() {
            int result2 = this.realTarget.hashCode();
            result2 = result2 * 31 + (this.imaginaryTarget == null ? 0 : this.imaginaryTarget.hashCode());
            result2 = result2 * 31 + this.source.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FalseEdge)) {
                return false;
            }
            FalseEdge falseEdge = (FalseEdge)other;
            if (!Intrinsics.areEqual(this.realTarget, falseEdge.realTarget)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.imaginaryTarget, falseEdge.imaginaryTarget)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.source, (Object)falseEdge.source);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B!\u0012\u0006\u0010\u0004\u001a\u00028\u0001\u0012\b\u0010\u0005\u001a\u0004\u0018\u00018\u0001\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0010\u001a\u00028\u0001H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0011\u001a\u0004\u0018\u00018\u0001H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J4\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0004\u001a\u00028\u00012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00018\u00012\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0014J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0013\u0010\u0004\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u0015\u0010\u0005\u001a\u0004\u0018\u00018\u0001\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lorg/rust/lang/core/mir/schemas/MirTerminator$FalseUnwind;", "BB", "Lorg/rust/lang/core/mir/schemas/MirBasicBlock;", "Lorg/rust/lang/core/mir/schemas/MirTerminator;", "realTarget", "unwind", "source", "Lorg/rust/lang/core/mir/schemas/MirSourceInfo;", "<init>", "(Lorg/rust/lang/core/mir/schemas/MirBasicBlock;Lorg/rust/lang/core/mir/schemas/MirBasicBlock;Lorg/rust/lang/core/mir/schemas/MirSourceInfo;)V", "getRealTarget", "()Lorg/rust/lang/core/mir/schemas/MirBasicBlock;", "Lorg/rust/lang/core/mir/schemas/MirBasicBlock;", "getUnwind", "getSource", "()Lorg/rust/lang/core/mir/schemas/MirSourceInfo;", "component1", "component2", "component3", "copy", "(Lorg/rust/lang/core/mir/schemas/MirBasicBlock;Lorg/rust/lang/core/mir/schemas/MirBasicBlock;Lorg/rust/lang/core/mir/schemas/MirSourceInfo;)Lorg/rust/lang/core/mir/schemas/MirTerminator$FalseUnwind;", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.rustrover.core"})
    public static final class FalseUnwind<BB extends MirBasicBlock>
    implements MirTerminator<BB> {
        @NotNull
        private final BB realTarget;
        @Nullable
        private final BB unwind;
        @NotNull
        private final MirSourceInfo source;

        public FalseUnwind(@NotNull BB realTarget, @Nullable BB unwind, @NotNull MirSourceInfo source) {
            Intrinsics.checkNotNullParameter(realTarget, (String)"realTarget");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            this.realTarget = realTarget;
            this.unwind = unwind;
            this.source = source;
        }

        @NotNull
        public final BB getRealTarget() {
            return this.realTarget;
        }

        @Nullable
        public final BB getUnwind() {
            return this.unwind;
        }

        @Override
        @NotNull
        public MirSourceInfo getSource() {
            return this.source;
        }

        @NotNull
        public final BB component1() {
            return this.realTarget;
        }

        @Nullable
        public final BB component2() {
            return this.unwind;
        }

        @NotNull
        public final MirSourceInfo component3() {
            return this.source;
        }

        @NotNull
        public final FalseUnwind<BB> copy(@NotNull BB realTarget, @Nullable BB unwind, @NotNull MirSourceInfo source) {
            Intrinsics.checkNotNullParameter(realTarget, (String)"realTarget");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            return new FalseUnwind<BB>(realTarget, unwind, source);
        }

        public static /* synthetic */ FalseUnwind copy$default(FalseUnwind falseUnwind, MirBasicBlock mirBasicBlock, MirBasicBlock mirBasicBlock2, MirSourceInfo mirSourceInfo, int n, Object object) {
            if ((n & 1) != 0) {
                mirBasicBlock = falseUnwind.realTarget;
            }
            if ((n & 2) != 0) {
                mirBasicBlock2 = falseUnwind.unwind;
            }
            if ((n & 4) != 0) {
                mirSourceInfo = falseUnwind.source;
            }
            return falseUnwind.copy(mirBasicBlock, mirBasicBlock2, mirSourceInfo);
        }

        @NotNull
        public String toString() {
            return "FalseUnwind(realTarget=" + this.realTarget + ", unwind=" + this.unwind + ", source=" + this.source + ")";
        }

        public int hashCode() {
            int result2 = this.realTarget.hashCode();
            result2 = result2 * 31 + (this.unwind == null ? 0 : this.unwind.hashCode());
            result2 = result2 * 31 + this.source.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FalseUnwind)) {
                return false;
            }
            FalseUnwind falseUnwind = (FalseUnwind)other;
            if (!Intrinsics.areEqual(this.realTarget, falseUnwind.realTarget)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.unwind, falseUnwind.unwind)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.source, (Object)falseUnwind.source);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00028\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u000e\u001a\u00028\u0001H\u00c6\u0003\u00a2\u0006\u0002\u0010\nJ\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J(\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0004\u001a\u00028\u00012\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0011J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0013\u0010\u0004\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001a"}, d2={"Lorg/rust/lang/core/mir/schemas/MirTerminator$Goto;", "BB", "Lorg/rust/lang/core/mir/schemas/MirBasicBlock;", "Lorg/rust/lang/core/mir/schemas/MirTerminator;", "target", "source", "Lorg/rust/lang/core/mir/schemas/MirSourceInfo;", "<init>", "(Lorg/rust/lang/core/mir/schemas/MirBasicBlock;Lorg/rust/lang/core/mir/schemas/MirSourceInfo;)V", "getTarget", "()Lorg/rust/lang/core/mir/schemas/MirBasicBlock;", "Lorg/rust/lang/core/mir/schemas/MirBasicBlock;", "getSource", "()Lorg/rust/lang/core/mir/schemas/MirSourceInfo;", "component1", "component2", "copy", "(Lorg/rust/lang/core/mir/schemas/MirBasicBlock;Lorg/rust/lang/core/mir/schemas/MirSourceInfo;)Lorg/rust/lang/core/mir/schemas/MirTerminator$Goto;", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.rustrover.core"})
    public static final class Goto<BB extends MirBasicBlock>
    implements MirTerminator<BB> {
        @NotNull
        private final BB target;
        @NotNull
        private final MirSourceInfo source;

        public Goto(@NotNull BB target, @NotNull MirSourceInfo source) {
            Intrinsics.checkNotNullParameter(target, (String)"target");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            this.target = target;
            this.source = source;
        }

        @NotNull
        public final BB getTarget() {
            return this.target;
        }

        @Override
        @NotNull
        public MirSourceInfo getSource() {
            return this.source;
        }

        @NotNull
        public final BB component1() {
            return this.target;
        }

        @NotNull
        public final MirSourceInfo component2() {
            return this.source;
        }

        @NotNull
        public final Goto<BB> copy(@NotNull BB target, @NotNull MirSourceInfo source) {
            Intrinsics.checkNotNullParameter(target, (String)"target");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            return new Goto<BB>(target, source);
        }

        public static /* synthetic */ Goto copy$default(Goto goto_, MirBasicBlock mirBasicBlock, MirSourceInfo mirSourceInfo, int n, Object object) {
            if ((n & 1) != 0) {
                mirBasicBlock = goto_.target;
            }
            if ((n & 2) != 0) {
                mirSourceInfo = goto_.source;
            }
            return goto_.copy(mirBasicBlock, mirSourceInfo);
        }

        @NotNull
        public String toString() {
            return "Goto(target=" + this.target + ", source=" + this.source + ")";
        }

        public int hashCode() {
            int result2 = this.target.hashCode();
            result2 = result2 * 31 + this.source.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Goto)) {
                return false;
            }
            Goto goto_ = (Goto)other;
            if (!Intrinsics.areEqual(this.target, goto_.target)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.source, (Object)goto_.source);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\t\u001a\u00020\u0004H\u00c6\u0003J\u0013\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lorg/rust/lang/core/mir/schemas/MirTerminator$Resume;", "Lorg/rust/lang/core/mir/schemas/MirTerminator;", "", "source", "Lorg/rust/lang/core/mir/schemas/MirSourceInfo;", "<init>", "(Lorg/rust/lang/core/mir/schemas/MirSourceInfo;)V", "getSource", "()Lorg/rust/lang/core/mir/schemas/MirSourceInfo;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.rustrover.core"})
    public static final class Resume
    implements MirTerminator {
        @NotNull
        private final MirSourceInfo source;

        public Resume(@NotNull MirSourceInfo source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            this.source = source;
        }

        @Override
        @NotNull
        public MirSourceInfo getSource() {
            return this.source;
        }

        @NotNull
        public final MirSourceInfo component1() {
            return this.source;
        }

        @NotNull
        public final Resume copy(@NotNull MirSourceInfo source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            return new Resume(source);
        }

        public static /* synthetic */ Resume copy$default(Resume resume, MirSourceInfo mirSourceInfo, int n, Object object) {
            if ((n & 1) != 0) {
                mirSourceInfo = resume.source;
            }
            return resume.copy(mirSourceInfo);
        }

        @NotNull
        public String toString() {
            return "Resume(source=" + this.source + ")";
        }

        public int hashCode() {
            return this.source.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Resume)) {
                return false;
            }
            Resume resume = (Resume)other;
            return Intrinsics.areEqual((Object)this.source, (Object)resume.source);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\t\u001a\u00020\u0004H\u00c6\u0003J\u0013\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lorg/rust/lang/core/mir/schemas/MirTerminator$Return;", "Lorg/rust/lang/core/mir/schemas/MirTerminator;", "", "source", "Lorg/rust/lang/core/mir/schemas/MirSourceInfo;", "<init>", "(Lorg/rust/lang/core/mir/schemas/MirSourceInfo;)V", "getSource", "()Lorg/rust/lang/core/mir/schemas/MirSourceInfo;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.rustrover.core"})
    public static final class Return
    implements MirTerminator {
        @NotNull
        private final MirSourceInfo source;

        public Return(@NotNull MirSourceInfo source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            this.source = source;
        }

        @Override
        @NotNull
        public MirSourceInfo getSource() {
            return this.source;
        }

        @NotNull
        public final MirSourceInfo component1() {
            return this.source;
        }

        @NotNull
        public final Return copy(@NotNull MirSourceInfo source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            return new Return(source);
        }

        public static /* synthetic */ Return copy$default(Return return_, MirSourceInfo mirSourceInfo, int n, Object object) {
            if ((n & 1) != 0) {
                mirSourceInfo = return_.source;
            }
            return return_.copy(mirSourceInfo);
        }

        @NotNull
        public String toString() {
            return "Return(source=" + this.source + ")";
        }

        public int hashCode() {
            return this.source.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Return)) {
                return false;
            }
            Return return_ = (Return)other;
            return Intrinsics.areEqual((Object)this.source, (Object)return_.source);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B%\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\tH\u00c6\u0003J3\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lorg/rust/lang/core/mir/schemas/MirTerminator$SwitchInt;", "BB", "Lorg/rust/lang/core/mir/schemas/MirBasicBlock;", "Lorg/rust/lang/core/mir/schemas/MirTerminator;", "discriminant", "Lorg/rust/lang/core/mir/schemas/MirOperand;", "targets", "Lorg/rust/lang/core/mir/schemas/MirSwitchTargets;", "source", "Lorg/rust/lang/core/mir/schemas/MirSourceInfo;", "<init>", "(Lorg/rust/lang/core/mir/schemas/MirOperand;Lorg/rust/lang/core/mir/schemas/MirSwitchTargets;Lorg/rust/lang/core/mir/schemas/MirSourceInfo;)V", "getDiscriminant", "()Lorg/rust/lang/core/mir/schemas/MirOperand;", "getTargets", "()Lorg/rust/lang/core/mir/schemas/MirSwitchTargets;", "getSource", "()Lorg/rust/lang/core/mir/schemas/MirSourceInfo;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.rustrover.core"})
    public static final class SwitchInt<BB extends MirBasicBlock>
    implements MirTerminator<BB> {
        @NotNull
        private final MirOperand discriminant;
        @NotNull
        private final MirSwitchTargets<BB> targets;
        @NotNull
        private final MirSourceInfo source;

        public SwitchInt(@NotNull MirOperand discriminant, @NotNull MirSwitchTargets<BB> targets, @NotNull MirSourceInfo source) {
            Intrinsics.checkNotNullParameter((Object)discriminant, (String)"discriminant");
            Intrinsics.checkNotNullParameter(targets, (String)"targets");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            this.discriminant = discriminant;
            this.targets = targets;
            this.source = source;
        }

        @NotNull
        public final MirOperand getDiscriminant() {
            return this.discriminant;
        }

        @NotNull
        public final MirSwitchTargets<BB> getTargets() {
            return this.targets;
        }

        @Override
        @NotNull
        public MirSourceInfo getSource() {
            return this.source;
        }

        @NotNull
        public final MirOperand component1() {
            return this.discriminant;
        }

        @NotNull
        public final MirSwitchTargets<BB> component2() {
            return this.targets;
        }

        @NotNull
        public final MirSourceInfo component3() {
            return this.source;
        }

        @NotNull
        public final SwitchInt<BB> copy(@NotNull MirOperand discriminant, @NotNull MirSwitchTargets<BB> targets, @NotNull MirSourceInfo source) {
            Intrinsics.checkNotNullParameter((Object)discriminant, (String)"discriminant");
            Intrinsics.checkNotNullParameter(targets, (String)"targets");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            return new SwitchInt<BB>(discriminant, targets, source);
        }

        public static /* synthetic */ SwitchInt copy$default(SwitchInt switchInt, MirOperand mirOperand, MirSwitchTargets mirSwitchTargets, MirSourceInfo mirSourceInfo, int n, Object object) {
            if ((n & 1) != 0) {
                mirOperand = switchInt.discriminant;
            }
            if ((n & 2) != 0) {
                mirSwitchTargets = switchInt.targets;
            }
            if ((n & 4) != 0) {
                mirSourceInfo = switchInt.source;
            }
            return switchInt.copy(mirOperand, mirSwitchTargets, mirSourceInfo);
        }

        @NotNull
        public String toString() {
            return "SwitchInt(discriminant=" + this.discriminant + ", targets=" + this.targets + ", source=" + this.source + ")";
        }

        public int hashCode() {
            int result2 = this.discriminant.hashCode();
            result2 = result2 * 31 + this.targets.hashCode();
            result2 = result2 * 31 + this.source.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SwitchInt)) {
                return false;
            }
            SwitchInt switchInt = (SwitchInt)other;
            if (!Intrinsics.areEqual((Object)this.discriminant, (Object)switchInt.discriminant)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.targets, switchInt.targets)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.source, (Object)switchInt.source);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\t\u001a\u00020\u0004H\u00c6\u0003J\u0013\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lorg/rust/lang/core/mir/schemas/MirTerminator$Unreachable;", "Lorg/rust/lang/core/mir/schemas/MirTerminator;", "", "source", "Lorg/rust/lang/core/mir/schemas/MirSourceInfo;", "<init>", "(Lorg/rust/lang/core/mir/schemas/MirSourceInfo;)V", "getSource", "()Lorg/rust/lang/core/mir/schemas/MirSourceInfo;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.rustrover.core"})
    public static final class Unreachable
    implements MirTerminator {
        @NotNull
        private final MirSourceInfo source;

        public Unreachable(@NotNull MirSourceInfo source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            this.source = source;
        }

        @Override
        @NotNull
        public MirSourceInfo getSource() {
            return this.source;
        }

        @NotNull
        public final MirSourceInfo component1() {
            return this.source;
        }

        @NotNull
        public final Unreachable copy(@NotNull MirSourceInfo source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            return new Unreachable(source);
        }

        public static /* synthetic */ Unreachable copy$default(Unreachable unreachable, MirSourceInfo mirSourceInfo, int n, Object object) {
            if ((n & 1) != 0) {
                mirSourceInfo = unreachable.source;
            }
            return unreachable.copy(mirSourceInfo);
        }

        @NotNull
        public String toString() {
            return "Unreachable(source=" + this.source + ")";
        }

        public int hashCode() {
            return this.source.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Unreachable)) {
                return false;
            }
            Unreachable unreachable = (Unreachable)other;
            return Intrinsics.areEqual((Object)this.source, (Object)unreachable.source);
        }
    }
}

