/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.mir.schemas;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.lang.core.mir.MirBuildErrorReason;
import org.rust.lang.core.mir.MirBuildException;
import org.rust.lang.core.mir.schemas.MirProjectionElem;
import org.rust.lang.core.types.ty.Ty;
import org.rust.lang.core.types.ty.TyArray;
import org.rust.lang.core.types.ty.TyKt;
import org.rust.lang.core.types.ty.TySlice;
import org.rust.lang.core.types.ty.TyUnknown;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\r\u001a\u00020\u00002\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lorg/rust/lang/core/mir/schemas/MirPlaceTy;", "", "ty", "Lorg/rust/lang/core/types/ty/Ty;", "variantIndex", "", "<init>", "(Lorg/rust/lang/core/types/ty/Ty;Ljava/lang/Integer;)V", "getTy", "()Lorg/rust/lang/core/types/ty/Ty;", "getVariantIndex", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "projectionTy", "element", "Lorg/rust/lang/core/mir/schemas/MirProjectionElem;", "Companion", "intellij.rustrover.core"})
public final class MirPlaceTy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Ty ty;
    @Nullable
    private final Integer variantIndex;

    public MirPlaceTy(@NotNull Ty ty2, @Nullable Integer variantIndex) {
        Intrinsics.checkNotNullParameter((Object)ty2, (String)"ty");
        this.ty = ty2;
        this.variantIndex = variantIndex;
    }

    @NotNull
    public final Ty getTy() {
        return this.ty;
    }

    @Nullable
    public final Integer getVariantIndex() {
        return this.variantIndex;
    }

    @NotNull
    public final MirPlaceTy projectionTy(@NotNull MirProjectionElem<? extends Ty> element) {
        MirPlaceTy mirPlaceTy;
        Intrinsics.checkNotNullParameter(element, (String)"element");
        if (this.variantIndex != null && !(element instanceof MirProjectionElem.Field)) {
            throw new MirBuildException(MirBuildErrorReason.CannotUseNonFieldProjectionOnDowncastedPlace, null, 2, null);
        }
        MirProjectionElem<? extends Ty> mirProjectionElem = element;
        if (mirProjectionElem instanceof MirProjectionElem.Field) {
            mirPlaceTy = Companion.fromTy((Ty)((MirProjectionElem.Field)element).getElem());
        } else if (mirProjectionElem instanceof MirProjectionElem.Deref) {
            Object object = TyKt.builtinDeref$default(this.ty, null, false, 2, null);
            if (object == null || (object = (Ty)object.getFirst()) == null) {
                object = TyUnknown.INSTANCE;
            }
            mirPlaceTy = Companion.fromTy((Ty)object);
        } else if (mirProjectionElem instanceof MirProjectionElem.Index || mirProjectionElem instanceof MirProjectionElem.ConstantIndex) {
            Ty ty2 = TyKt.builtinIndex(this.ty);
            if (ty2 == null) {
                ty2 = TyUnknown.INSTANCE;
            }
            mirPlaceTy = Companion.fromTy(ty2);
        } else if (mirProjectionElem instanceof MirProjectionElem.Subslice) {
            Ty ty3;
            Ty ty4 = this.ty;
            if (ty4 instanceof TySlice) {
                ty3 = this.ty;
            } else {
                if (ty4 instanceof TyArray) {
                    throw new NotImplementedError(null, 1, null);
                }
                ty3 = TyUnknown.INSTANCE;
            }
            Ty ty5 = ty3;
            mirPlaceTy = Companion.fromTy(ty5);
        } else if (mirProjectionElem instanceof MirProjectionElem.Downcast) {
            mirPlaceTy = new MirPlaceTy(this.ty, ((MirProjectionElem.Downcast)element).getVariantIndex());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return mirPlaceTy;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/rust/lang/core/mir/schemas/MirPlaceTy$Companion;", "", "<init>", "()V", "fromTy", "Lorg/rust/lang/core/mir/schemas/MirPlaceTy;", "ty", "Lorg/rust/lang/core/types/ty/Ty;", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MirPlaceTy fromTy(@NotNull Ty ty2) {
            Intrinsics.checkNotNullParameter((Object)ty2, (String)"ty");
            return new MirPlaceTy(ty2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

