/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.mir.schemas;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.lang.core.mir.schemas.MirLocal;
import org.rust.lang.core.mir.schemas.MirPlaceTy;
import org.rust.lang.core.mir.schemas.MirProjectionElem;
import org.rust.lang.core.types.ty.Ty;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\b\u0018\u0000 \"2\u00020\u0001:\u0001\"B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\b\u0002\u0010\u0004\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00070\u0006j\u0002`\b0\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0000J\u001e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0007J\u0006\u0010\u0017\u001a\u00020\u0018J\u001e\u0010\u0019\u001a\u001a\u0012\u0004\u0012\u00020\u0000\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00070\u0006j\u0002`\b\u0018\u00010\u001aJ\b\u0010\u001b\u001a\u0004\u0018\u00010\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\u0019\u0010\u001d\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00070\u0006j\u0002`\b0\u0005H\u00c6\u0003J-\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0018\b\u0002\u0010\u0004\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00070\u0006j\u0002`\b0\u0005H\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020\u0014H\u00d6\u0001J\t\u0010!\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR!\u0010\u0004\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00070\u0006j\u0002`\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006#"}, d2={"Lorg/rust/lang/core/mir/schemas/MirPlace;", "", "local", "Lorg/rust/lang/core/mir/schemas/MirLocal;", "projections", "", "Lorg/rust/lang/core/mir/schemas/MirProjectionElem;", "Lorg/rust/lang/core/types/ty/Ty;", "Lorg/rust/lang/core/mir/schemas/PlaceElem;", "<init>", "(Lorg/rust/lang/core/mir/schemas/MirLocal;Ljava/util/List;)V", "getLocal", "()Lorg/rust/lang/core/mir/schemas/MirLocal;", "getProjections", "()Ljava/util/List;", "isPrefixOf", "", "other", "makeField", "fieldIndex", "", "fieldName", "", "ty", "Lorg/rust/lang/core/mir/schemas/MirPlaceTy;", "lastProjection", "Lkotlin/Pair;", "asLocal", "component1", "component2", "copy", "equals", "hashCode", "toString", "Companion", "intellij.rustrover.core"})
public final class MirPlace {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MirLocal local;
    @NotNull
    private final List<MirProjectionElem<Ty>> projections;

    public MirPlace(@NotNull MirLocal local, @NotNull List<? extends MirProjectionElem<? extends Ty>> projections) {
        Intrinsics.checkNotNullParameter((Object)local, (String)"local");
        Intrinsics.checkNotNullParameter(projections, (String)"projections");
        this.local = local;
        this.projections = projections;
    }

    public /* synthetic */ MirPlace(MirLocal mirLocal, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(mirLocal, list);
    }

    @NotNull
    public final MirLocal getLocal() {
        return this.local;
    }

    @NotNull
    public final List<MirProjectionElem<Ty>> getProjections() {
        return this.projections;
    }

    public final boolean isPrefixOf(@NotNull MirPlace other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Intrinsics.areEqual((Object)this.local, (Object)other.local) && this.projections.size() <= other.projections.size() && Intrinsics.areEqual(this.projections, (Object)CollectionsKt.take((Iterable)other.projections, (int)this.projections.size()));
    }

    @NotNull
    public final MirPlace makeField(int fieldIndex, @NotNull String fieldName, @NotNull Ty ty2) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter((Object)ty2, (String)"ty");
        List newProjections = CollectionsKt.toMutableList((Collection)this.projections);
        newProjections.add(new MirProjectionElem.Field<Ty>(fieldIndex, fieldName, ty2));
        return new MirPlace(this.local, newProjections);
    }

    @NotNull
    public final MirPlaceTy ty() {
        return Companion.tyFrom(this.local, this.projections);
    }

    @Nullable
    public final Pair<MirPlace, MirProjectionElem<Ty>> lastProjection() {
        if (this.projections.isEmpty()) {
            return null;
        }
        return TuplesKt.to((Object)new MirPlace(this.local, this.projections.subList(0, this.projections.size() - 1)), (Object)CollectionsKt.last(this.projections));
    }

    @Nullable
    public final MirLocal asLocal() {
        return this.projections.isEmpty() ? this.local : null;
    }

    @NotNull
    public final MirLocal component1() {
        return this.local;
    }

    @NotNull
    public final List<MirProjectionElem<Ty>> component2() {
        return this.projections;
    }

    @NotNull
    public final MirPlace copy(@NotNull MirLocal local, @NotNull List<? extends MirProjectionElem<? extends Ty>> projections) {
        Intrinsics.checkNotNullParameter((Object)local, (String)"local");
        Intrinsics.checkNotNullParameter(projections, (String)"projections");
        return new MirPlace(local, projections);
    }

    public static /* synthetic */ MirPlace copy$default(MirPlace mirPlace, MirLocal mirLocal, List list, int n, Object object) {
        if ((n & 1) != 0) {
            mirLocal = mirPlace.local;
        }
        if ((n & 2) != 0) {
            list = mirPlace.projections;
        }
        return mirPlace.copy(mirLocal, list);
    }

    @NotNull
    public String toString() {
        return "MirPlace(local=" + this.local + ", projections=" + this.projections + ")";
    }

    public int hashCode() {
        int result2 = this.local.hashCode();
        result2 = result2 * 31 + ((Object)this.projections).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MirPlace)) {
            return false;
        }
        MirPlace mirPlace = (MirPlace)other;
        if (!Intrinsics.areEqual((Object)this.local, (Object)mirPlace.local)) {
            return false;
        }
        return Intrinsics.areEqual(this.projections, mirPlace.projections);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t\u00a8\u0006\f"}, d2={"Lorg/rust/lang/core/mir/schemas/MirPlace$Companion;", "", "<init>", "()V", "tyFrom", "Lorg/rust/lang/core/mir/schemas/MirPlaceTy;", "local", "Lorg/rust/lang/core/mir/schemas/MirLocal;", "projections", "", "Lorg/rust/lang/core/mir/schemas/MirProjectionElem;", "Lorg/rust/lang/core/types/ty/Ty;", "intellij.rustrover.core"})
    @SourceDebugExtension(value={"SMAP\nMirPlace.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MirPlace.kt\norg/rust/lang/core/mir/schemas/MirPlace$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,81:1\n1803#2,3:82\n*S KotlinDebug\n*F\n+ 1 MirPlace.kt\norg/rust/lang/core/mir/schemas/MirPlace$Companion\n*L\n40#1:82,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final MirPlaceTy tyFrom(@NotNull MirLocal local, @NotNull List<? extends MirProjectionElem<? extends Ty>> projections) {
            void $this$fold$iv;
            Intrinsics.checkNotNullParameter((Object)local, (String)"local");
            Intrinsics.checkNotNullParameter(projections, (String)"projections");
            Iterable iterable = projections;
            MirPlaceTy initial$iv = MirPlaceTy.Companion.fromTy(local.getTy());
            boolean $i$f$fold = false;
            MirPlaceTy accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void element;
                MirProjectionElem mirProjectionElem = (MirProjectionElem)element$iv;
                MirPlaceTy placeTy = accumulator$iv;
                boolean bl = false;
                accumulator$iv = placeTy.projectionTy((MirProjectionElem<? extends Ty>)element);
            }
            return accumulator$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

