/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.mir.schemas;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.lang.core.mir.schemas.MirBasicBlock;
import org.rust.lang.core.mir.schemas.MirSourceInfo;
import org.rust.lang.core.mir.schemas.MirStatement;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001d"}, d2={"Lorg/rust/lang/core/mir/schemas/MirLocation;", "", "block", "Lorg/rust/lang/core/mir/schemas/MirBasicBlock;", "statementIndex", "", "<init>", "(Lorg/rust/lang/core/mir/schemas/MirBasicBlock;I)V", "getBlock", "()Lorg/rust/lang/core/mir/schemas/MirBasicBlock;", "getStatementIndex", "()I", "source", "Lorg/rust/lang/core/mir/schemas/MirSourceInfo;", "getSource", "()Lorg/rust/lang/core/mir/schemas/MirSourceInfo;", "statement", "Lorg/rust/lang/core/mir/schemas/MirStatement;", "getStatement", "()Lorg/rust/lang/core/mir/schemas/MirStatement;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.rustrover.core"})
public final class MirLocation {
    @NotNull
    private final MirBasicBlock block;
    private final int statementIndex;

    public MirLocation(@NotNull MirBasicBlock block, int statementIndex) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        this.block = block;
        this.statementIndex = statementIndex;
    }

    @NotNull
    public final MirBasicBlock getBlock() {
        return this.block;
    }

    public final int getStatementIndex() {
        return this.statementIndex;
    }

    @NotNull
    public final MirSourceInfo getSource() {
        return this.statementIndex == this.block.getStatements().size() ? this.block.getTerminator().getSource() : this.block.getStatements().get(this.statementIndex).getSource();
    }

    @Nullable
    public final MirStatement getStatement() {
        return (MirStatement)CollectionsKt.getOrNull(this.block.getStatements(), (int)this.statementIndex);
    }

    @NotNull
    public final MirBasicBlock component1() {
        return this.block;
    }

    public final int component2() {
        return this.statementIndex;
    }

    @NotNull
    public final MirLocation copy(@NotNull MirBasicBlock block, int statementIndex) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        return new MirLocation(block, statementIndex);
    }

    public static /* synthetic */ MirLocation copy$default(MirLocation mirLocation, MirBasicBlock mirBasicBlock, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            mirBasicBlock = mirLocation.block;
        }
        if ((n2 & 2) != 0) {
            n = mirLocation.statementIndex;
        }
        return mirLocation.copy(mirBasicBlock, n);
    }

    @NotNull
    public String toString() {
        return "MirLocation(block=" + this.block + ", statementIndex=" + this.statementIndex + ")";
    }

    public int hashCode() {
        int result2 = this.block.hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.statementIndex);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MirLocation)) {
            return false;
        }
        MirLocation mirLocation = (MirLocation)other;
        if (!Intrinsics.areEqual((Object)this.block, (Object)mirLocation.block)) {
            return false;
        }
        return this.statementIndex == mirLocation.statementIndex;
    }
}

