/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.mir.schemas;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.rust.lang.core.mir.MirBuilder;
import org.rust.lang.core.mir.schemas.MirBasicBlock;
import org.rust.lang.core.mir.schemas.MirLocal;
import org.rust.lang.core.mir.schemas.MirLocalKind;
import org.rust.lang.core.mir.schemas.MirSourceScope;
import org.rust.lang.core.mir.schemas.MirSpan;
import org.rust.lang.core.mir.schemas.MirStatement;
import org.rust.lang.core.mir.schemas.MirVarDebugInfo;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsInferenceContextOwner;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001:\u0001;J\b\u00103\u001a\u00020\u0014H\u0016J\u000e\u00104\u001a\b\u0012\u0004\u0012\u00020\u001405H\u0016J\b\u00106\u001a\u000207H\u0016J\u0010\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\u0014H\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0012R\u0012\u0010\u0016\u001a\u00020\u0017X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0018\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0012R\u0012\u0010\u001d\u001a\u00020\u001eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0018\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0012R\u0014\u0010$\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0014\u0010'\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0014\u0010*\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R&\u0010-\u001a\u0014\u0012\u0004\u0012\u00020\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u000f0.8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u001a\u00101\u001a\b\u0012\u0004\u0012\u00020\u00140\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u0010\u0012\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006<\u00c0\u0006\u0001"}, d2={"Lorg/rust/lang/core/mir/schemas/MirBody;", "", "contextOwner", "Lorg/rust/lang/core/psi/ext/RsInferenceContextOwner;", "getContextOwner", "()Lorg/rust/lang/core/psi/ext/RsInferenceContextOwner;", "buildContext", "Lorg/rust/lang/core/mir/MirBuilder$BuildContext;", "getBuildContext", "()Lorg/rust/lang/core/mir/MirBuilder$BuildContext;", "sourceElement", "Lorg/rust/lang/core/psi/ext/RsElement;", "getSourceElement", "()Lorg/rust/lang/core/psi/ext/RsElement;", "basicBlocks", "", "Lorg/rust/lang/core/mir/schemas/MirBasicBlock;", "getBasicBlocks", "()Ljava/util/List;", "localDecls", "Lorg/rust/lang/core/mir/schemas/MirLocal;", "getLocalDecls", "span", "Lorg/rust/lang/core/mir/schemas/MirSpan;", "getSpan", "()Lorg/rust/lang/core/mir/schemas/MirSpan;", "sourceScopes", "Lorg/rust/lang/core/mir/schemas/MirSourceScope;", "getSourceScopes", "argCount", "", "getArgCount", "()I", "varDebugInfo", "Lorg/rust/lang/core/mir/schemas/MirVarDebugInfo;", "getVarDebugInfo", "startBlock", "getStartBlock", "()Lorg/rust/lang/core/mir/schemas/MirBasicBlock;", "outermostScope", "getOutermostScope", "()Lorg/rust/lang/core/mir/schemas/MirSourceScope;", "returnLocal", "getReturnLocal", "()Lorg/rust/lang/core/mir/schemas/MirLocal;", "sourceScopesTree", "", "getSourceScopesTree", "()Ljava/util/Map;", "args", "getArgs", "returnPlace", "alwaysStorageLiveLocals", "", "getBasicBlocksPredecessors", "Lorg/rust/lang/core/mir/schemas/MirBody$BasicBlocksPredecessors;", "getLocalKind", "Lorg/rust/lang/core/mir/schemas/MirLocalKind;", "local", "BasicBlocksPredecessors", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nMirBody.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MirBody.kt\norg/rust/lang/core/mir/schemas/MirBody\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,78:1\n1869#2:79\n1870#2:87\n1869#2:88\n1869#2,2:89\n1870#2:91\n382#3,7:80\n1#4:92\n*S KotlinDebug\n*F\n+ 1 MirBody.kt\norg/rust/lang/core/mir/schemas/MirBody\n*L\n30#1:79\n30#1:87\n44#1:88\n45#1:89,2\n44#1:91\n32#1:80,7\n*E\n"})
public interface MirBody {
    @NotNull
    public RsInferenceContextOwner getContextOwner();

    @NotNull
    public MirBuilder.BuildContext getBuildContext();

    @NotNull
    public RsElement getSourceElement();

    @NotNull
    public List<MirBasicBlock> getBasicBlocks();

    @NotNull
    public List<MirLocal> getLocalDecls();

    @NotNull
    public MirSpan getSpan();

    @NotNull
    public List<MirSourceScope> getSourceScopes();

    public int getArgCount();

    @NotNull
    public List<MirVarDebugInfo> getVarDebugInfo();

    @NotNull
    default public MirBasicBlock getStartBlock() {
        return (MirBasicBlock)CollectionsKt.first(this.getBasicBlocks());
    }

    @NotNull
    default public MirSourceScope getOutermostScope() {
        return (MirSourceScope)CollectionsKt.first(this.getSourceScopes());
    }

    @NotNull
    default public MirLocal getReturnLocal() {
        return (MirLocal)CollectionsKt.first(this.getLocalDecls());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    default public Map<MirSourceScope, List<MirSourceScope>> getSourceScopesTree() {
        Map map2;
        Map $this$_get_sourceScopesTree__u24lambda_u240 = map2 = MapsKt.createMapBuilder();
        boolean bl = false;
        Iterable $this$forEach$iv = this.getSourceScopes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            void $this$getOrPut$iv;
            MirSourceScope parent2;
            MirSourceScope scope = (MirSourceScope)element$iv;
            boolean bl2 = false;
            if (scope.getParentScope() == null) continue;
            boolean bl3 = false;
            Map map3 = $this$_get_sourceScopesTree__u24lambda_u240;
            MirSourceScope key$iv = parent2;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl4 = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            List children = (List)object;
            children.add(scope);
        }
        return MapsKt.build((Map)map2);
    }

    @NotNull
    default public List<MirLocal> getArgs() {
        return this.getLocalDecls().subList(1, this.getArgCount() + 1);
    }

    @NotNull
    default public MirLocal returnPlace() {
        return (MirLocal)CollectionsKt.first(this.getLocalDecls());
    }

    @NotNull
    default public Set<MirLocal> alwaysStorageLiveLocals() {
        Set set;
        Set $this$alwaysStorageLiveLocals_u24lambda_u240 = set = CollectionsKt.toMutableSet((Iterable)this.getLocalDecls());
        boolean bl = false;
        Iterable $this$forEach$iv = this.getBasicBlocks();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MirBasicBlock block = (MirBasicBlock)element$iv;
            boolean bl2 = false;
            Iterable $this$forEach$iv2 = block.getStatements();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                MirStatement statement = (MirStatement)element$iv2;
                boolean bl3 = false;
                MirStatement mirStatement = statement;
                if (mirStatement instanceof MirStatement.StorageDead) {
                    $this$alwaysStorageLiveLocals_u24lambda_u240.remove(((MirStatement.StorageDead)statement).getLocal());
                    continue;
                }
                if (!(mirStatement instanceof MirStatement.StorageLive)) continue;
                $this$alwaysStorageLiveLocals_u24lambda_u240.remove(((MirStatement.StorageLive)statement).getLocal());
            }
        }
        return set;
    }

    @NotNull
    default public BasicBlocksPredecessors getBasicBlocksPredecessors() {
        int n = this.getBasicBlocks().size();
        ArrayList<List> arrayList = new ArrayList<List>(n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4 = n3 = n2++;
            ArrayList<List> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(new ArrayList());
        }
        List predecessors = arrayList;
        for (MirBasicBlock block : this.getBasicBlocks()) {
            for (MirBasicBlock successor : block.getTerminator().getSuccessors()) {
                ((List)predecessors.get(successor.getIndex())).add(block);
            }
        }
        return new BasicBlocksPredecessors(predecessors);
    }

    @NotNull
    default public MirLocalKind getLocalKind(@NotNull MirLocal local) {
        Intrinsics.checkNotNullParameter((Object)local, (String)"local");
        int n = local.getIndex();
        return n == 0 ? MirLocalKind.ReturnPointer : ((1 <= n ? n <= this.getArgCount() : false) ? MirLocalKind.Arg : MirLocalKind.Temp);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\b\u001a\u00020\u0004H\u0086\u0002R\u001a\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/rust/lang/core/mir/schemas/MirBody$BasicBlocksPredecessors;", "", "predecessors", "", "Lorg/rust/lang/core/mir/schemas/MirBasicBlock;", "<init>", "(Ljava/util/List;)V", "get", "block", "intellij.rustrover.core"})
    public static final class BasicBlocksPredecessors {
        @NotNull
        private final List<List<MirBasicBlock>> predecessors;

        public BasicBlocksPredecessors(@NotNull List<? extends List<? extends MirBasicBlock>> predecessors) {
            Intrinsics.checkNotNullParameter(predecessors, (String)"predecessors");
            this.predecessors = predecessors;
        }

        @NotNull
        public final List<MirBasicBlock> get(@NotNull MirBasicBlock block) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            return this.predecessors.get(block.getIndex());
        }
    }
}

