/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.mir.lldb;

import com.intellij.json.JsonLanguage;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.lang.core.mir.RsMirPreviewAction;
import org.rust.lang.core.mir.TargetProcessParams;
import org.rust.lang.core.mir.lldb.MirLldbBridge;
import org.rust.lang.core.mir.lldb.MirLldbException;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.ext.RsInferenceContextOwner;
import org.rust.stdext.RsResult;
import org.rust.stdext.RsResultKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\b\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006\r"}, d2={"Lorg/rust/lang/core/mir/lldb/RsMirLldbPreviewAction;", "Lorg/rust/lang/core/mir/RsMirPreviewAction;", "<init>", "()V", "getMirData", "Lorg/rust/lang/core/mir/RsMirPreviewAction$MirData;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "popupName", "", "MyMirData", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsMirLldbPreviewAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsMirLldbPreviewAction.kt\norg/rust/lang/core/mir/lldb/RsMirLldbPreviewAction\n+ 2 RsResult.kt\norg/rust/stdext/RsResult\n*L\n1#1,30:1\n29#2,4:31\n34#2,4:35\n*S KotlinDebug\n*F\n+ 1 RsMirLldbPreviewAction.kt\norg/rust/lang/core/mir/lldb/RsMirLldbPreviewAction\n*L\n23#1:31,4\n24#1:35,4\n*E\n"})
public final class RsMirLldbPreviewAction
extends RsMirPreviewAction {
    @Override
    @Nullable
    protected RsMirPreviewAction.MirData getMirData(@NotNull Editor editor2, @NotNull PsiFile file) {
        RsResult rsResult;
        RsResult rsResult2;
        Object it2;
        RsResult this_$iv;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Pair<RsInferenceContextOwner, PsiElement> pair = this.getContextOwnerAndMirTarget(editor2, file);
        Object object = pair != null ? (RsInferenceContextOwner)pair.getFirst() : null;
        RsFunction rsFunction = object instanceof RsFunction ? (RsFunction)object : null;
        if (rsFunction == null) {
            return null;
        }
        RsFunction function = rsFunction;
        object = MirLldbBridge.Companion.transform(function, true, TargetProcessParams.Companion.getDEFAULT());
        boolean $i$f$map = false;
        RsResult rsResult3 = this_$iv;
        if (rsResult3 instanceof RsResult.Ok) {
            it2 = (Pair)((RsResult.Ok)this_$iv).getOk();
            boolean bl = false;
            String string = (String)it2.getFirst();
            rsResult2 = new RsResult.Ok<String>(string);
        } else if (rsResult3 instanceof RsResult.Err) {
            rsResult2 = new RsResult.Err(((RsResult.Err)this_$iv).getErr());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this_$iv = rsResult2;
        boolean $i$f$mapErr = false;
        rsResult3 = this_$iv;
        if (rsResult3 instanceof RsResult.Ok) {
            rsResult = new RsResult.Ok(((RsResult.Ok)this_$iv).getOk());
        } else if (rsResult3 instanceof RsResult.Err) {
            it2 = (MirLldbException)((RsResult.Err)this_$iv).getErr();
            boolean bl = false;
            String string = ((MirLldbException)it2).getFriendlyText();
            rsResult = new RsResult.Err<String>(string);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        RsResult result2 = rsResult;
        return new MyMirData(result2);
    }

    @Override
    @NotNull
    protected String popupName() {
        return "MIR For LLDB Evaluation";
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\u0004\u0018\u00010\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/rust/lang/core/mir/lldb/RsMirLldbPreviewAction$MyMirData;", "Lorg/rust/lang/core/mir/RsMirPreviewAction$MirData;", "result", "Lorg/rust/stdext/RsResult;", "", "<init>", "(Lorg/rust/stdext/RsResult;)V", "text", "getText", "()Ljava/lang/String;", "language", "Lcom/intellij/lang/Language;", "getLanguage", "()Lcom/intellij/lang/Language;", "intellij.rustrover.core"})
    private static final class MyMirData
    implements RsMirPreviewAction.MirData {
        @NotNull
        private final RsResult<String, String> result;

        public MyMirData(@NotNull RsResult<String, String> result2) {
            Intrinsics.checkNotNullParameter(result2, (String)"result");
            this.result = result2;
        }

        @Override
        @NotNull
        public String getText() {
            return RsResultKt.okOrErr(this.result);
        }

        @Override
        @Nullable
        public Language getLanguage() {
            return this.result.isOk() ? (Language)JsonLanguage.INSTANCE : null;
        }
    }
}

