/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.mir.lldb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.rust.ide.presentation.QualifiedNameSettings;
import org.rust.ide.presentation.TypeRenderable;
import org.rust.ide.presentation.TypeRenderingKt;
import org.rust.lang.core.mir.lldb.MirLldbBridge;
import org.rust.lang.core.mir.lldb.MirLldbException;
import org.rust.lang.core.mir.lldb.MirLldbInliner;
import org.rust.lang.core.mir.lldb.MirLldbInliningEntry;
import org.rust.lang.core.mir.lldb.MirLldbMonomorphisation;
import org.rust.lang.core.mir.schemas.MirAssertKind;
import org.rust.lang.core.mir.schemas.MirBasicBlock;
import org.rust.lang.core.mir.schemas.MirBinaryOperator;
import org.rust.lang.core.mir.schemas.MirBody;
import org.rust.lang.core.mir.schemas.MirConstValue;
import org.rust.lang.core.mir.schemas.MirConstant;
import org.rust.lang.core.mir.schemas.MirLocal;
import org.rust.lang.core.mir.schemas.MirOperand;
import org.rust.lang.core.mir.schemas.MirOperandKt;
import org.rust.lang.core.mir.schemas.MirPlace;
import org.rust.lang.core.mir.schemas.MirProjectionElem;
import org.rust.lang.core.mir.schemas.MirRvalue;
import org.rust.lang.core.mir.schemas.MirScalarInt;
import org.rust.lang.core.mir.schemas.MirStatement;
import org.rust.lang.core.mir.schemas.MirTerminator;
import org.rust.lang.core.mir.schemas.MirUnaryOperator;
import org.rust.lang.core.mir.schemas.MirVarDebugInfo;
import org.rust.lang.core.psi.RsEnumItem;
import org.rust.lang.core.psi.RsEnumVariant;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsNamedFieldDecl;
import org.rust.lang.core.psi.ext.ArithmeticOp;
import org.rust.lang.core.psi.ext.ComparisonOp;
import org.rust.lang.core.psi.ext.EqualityOp;
import org.rust.lang.core.psi.ext.RsEnumItemKt;
import org.rust.lang.core.psi.ext.RsFieldsOwner;
import org.rust.lang.core.psi.ext.RsInferenceContextOwner;
import org.rust.lang.core.psi.ext.RsQualifiedNamedElement;
import org.rust.lang.core.psi.ext.RsStructOrEnumItemElement;
import org.rust.lang.core.resolve.ImplLookup;
import org.rust.lang.core.thir.MirrorKt;
import org.rust.lang.core.types.BoundElement;
import org.rust.lang.core.types.ExtensionsKt;
import org.rust.lang.core.types.consts.CtValueKt;
import org.rust.lang.core.types.infer.FoldKt;
import org.rust.lang.core.types.infer.NeedsDropCheck;
import org.rust.lang.core.types.infer.RsInferenceContext;
import org.rust.lang.core.types.ty.Ty;
import org.rust.lang.core.types.ty.TyFnDef;
import org.rust.lang.core.types.ty.TyNever;
import org.rust.lang.core.types.ty.TyPrimitive;
import org.rust.lang.utils.evaluation.ThreeValuedLogic;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00dc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0012J\u0010\u0010\u000e\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u000e\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\u0016\u0010\u000e\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001b0%H\u0002J\u0014\u0010&\u001a\u00020'2\n\u0010$\u001a\u0006\u0012\u0002\b\u00030(H\u0002J\u0010\u0010\u000e\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010\u000e\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002J\u001a\u0010\u000e\u001a\u00020/2\u0010\u00100\u001a\f\u0012\u0004\u0012\u00020201j\u0002`3H\u0002J\u0010\u0010\u000e\u001a\u0002042\u0006\u00105\u001a\u000206H\u0002J\u001a\u00107\u001a\u0004\u0018\u000108*\u0002092\n\u0010:\u001a\u00060;j\u0002`<H\u0002J\u001e\u0010=\u001a\b\u0012\u0004\u0012\u00020 0\u0012*\u0002092\n\u0010:\u001a\u00060;j\u0002`<H\u0002J\u0010\u0010\u000e\u001a\u00020>2\u0006\u0010?\u001a\u00020@H\u0002J\u0010\u0010\u000e\u001a\u00020A2\u0006\u0010?\u001a\u00020BH\u0002J\u0010\u0010C\u001a\u00020 2\u0006\u0010D\u001a\u000202H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lorg/rust/lang/core/mir/lldb/MirLldbMirrorContext;", "", "inliner", "Lorg/rust/lang/core/mir/lldb/MirLldbInliner;", "owner", "Lorg/rust/lang/core/psi/ext/RsInferenceContextOwner;", "needsDropCheck", "Lorg/rust/lang/core/types/infer/NeedsDropCheck;", "monomorphization", "Lorg/rust/lang/core/mir/lldb/MirLldbMonomorphisation;", "<init>", "(Lorg/rust/lang/core/mir/lldb/MirLldbInliner;Lorg/rust/lang/core/psi/ext/RsInferenceContextOwner;Lorg/rust/lang/core/types/infer/NeedsDropCheck;Lorg/rust/lang/core/mir/lldb/MirLldbMonomorphisation;)V", "implLookup", "Lorg/rust/lang/core/resolve/ImplLookup;", "mirror", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$FunctionBody;", "mir", "Lorg/rust/lang/core/mir/schemas/MirBody;", "", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$InputArg;", "debugInfos", "Lorg/rust/lang/core/mir/schemas/MirVarDebugInfo;", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Local;", "localDecl", "Lorg/rust/lang/core/mir/schemas/MirLocal;", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Block;", "block", "Lorg/rust/lang/core/mir/schemas/MirBasicBlock;", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Statement;", "statement", "Lorg/rust/lang/core/mir/schemas/MirStatement;", "formatAssertMsg", "", "kind", "Lorg/rust/lang/core/mir/schemas/MirAssertKind;", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Terminator;", "terminator", "Lorg/rust/lang/core/mir/schemas/MirTerminator;", "monomorphizeCall", "Lorg/rust/lang/core/mir/lldb/MirLldbInliningEntry$Function;", "Lorg/rust/lang/core/mir/schemas/MirTerminator$Call;", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Operand;", "operand", "Lorg/rust/lang/core/mir/schemas/MirOperand;", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Place;", "place", "Lorg/rust/lang/core/mir/schemas/MirPlace;", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Projection;", "projection", "Lorg/rust/lang/core/mir/schemas/MirProjectionElem;", "Lorg/rust/lang/core/types/ty/Ty;", "Lorg/rust/lang/core/mir/schemas/PlaceElem;", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Rvalue;", "rvalue", "Lorg/rust/lang/core/mir/schemas/MirRvalue;", "getDiscr", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Rvalue$Aggregate$Discr;", "Lorg/rust/lang/core/psi/ext/RsStructOrEnumItemElement;", "variantIndex", "", "Lorg/rust/lang/core/thir/MirVariantIndex;", "getFieldNames", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$BinaryOperator;", "op", "Lorg/rust/lang/core/mir/schemas/MirBinaryOperator;", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$UnaryOperator;", "Lorg/rust/lang/core/mir/schemas/MirUnaryOperator;", "mirrorAsPrimitive", "ty", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nMirLldbMirrorContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MirLldbMirrorContext.kt\norg/rust/lang/core/mir/lldb/MirLldbMirrorContext\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,295:1\n1563#2:296\n1634#2,3:297\n1563#2:300\n1634#2,3:301\n1617#2,9:304\n1869#2:313\n1870#2:315\n1626#2:316\n1617#2,9:317\n1869#2:326\n1870#2:328\n1626#2:329\n1563#2:330\n1634#2,3:331\n1563#2:334\n1634#2,3:335\n1563#2:338\n1634#2,3:339\n1563#2:342\n1634#2,3:343\n1563#2:346\n1634#2,3:347\n1563#2:350\n1634#2,3:351\n1563#2:354\n1634#2,3:355\n1563#2:358\n1634#2,3:359\n1#3:314\n1#3:327\n*S KotlinDebug\n*F\n+ 1 MirLldbMirrorContext.kt\norg/rust/lang/core/mir/lldb/MirLldbMirrorContext\n*L\n35#1:296\n35#1:297,3\n36#1:300\n36#1:301,3\n42#1:304,9\n42#1:313\n42#1:315\n42#1:316\n57#1:317,9\n57#1:326\n57#1:328\n57#1:329\n98#1:330\n98#1:331,3\n118#1:334\n118#1:335,3\n162#1:338\n162#1:339,3\n184#1:342\n184#1:343,3\n188#1:346\n188#1:347,3\n196#1:350\n196#1:351,3\n246#1:354\n246#1:355,3\n247#1:358\n247#1:359,3\n42#1:314\n57#1:327\n*E\n"})
public final class MirLldbMirrorContext {
    @NotNull
    private final MirLldbInliner inliner;
    @NotNull
    private final NeedsDropCheck needsDropCheck;
    @NotNull
    private final MirLldbMonomorphisation monomorphization;
    @NotNull
    private final ImplLookup implLookup;

    public MirLldbMirrorContext(@NotNull MirLldbInliner inliner, @NotNull RsInferenceContextOwner owner, @NotNull NeedsDropCheck needsDropCheck, @NotNull MirLldbMonomorphisation monomorphization) {
        Intrinsics.checkNotNullParameter((Object)inliner, (String)"inliner");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)needsDropCheck, (String)"needsDropCheck");
        Intrinsics.checkNotNullParameter((Object)monomorphization, (String)"monomorphization");
        this.inliner = inliner;
        this.needsDropCheck = needsDropCheck;
        this.monomorphization = monomorphization;
        this.implLookup = ExtensionsKt.getImplLookup(owner);
    }

    @NotNull
    public final MirLldbBridge.FunctionBody mirror(@NotNull MirBody mir) {
        Collection<MirLldbBridge.Block> collection;
        MirBasicBlock it2;
        Collection<MirLldbBridge.Local> collection2;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)mir, (String)"mir");
        Iterable iterable = mir.getArgs();
        int n = mir.getLocalDecls().size();
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            MirLocal mirLocal = (MirLocal)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(this.mirror((MirLocal)((Object)it2)));
        }
        collection2 = (List)destination$iv$iv;
        $this$map$iv = mir.getBasicBlocks();
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it2 = (MirBasicBlock)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.mirror(it2));
        }
        collection = (List)destination$iv$iv;
        int n2 = mir.getReturnLocal().getIndex();
        List list = collection;
        Collection<MirLldbBridge.Local> collection3 = collection2;
        int n3 = n;
        return new MirLldbBridge.FunctionBody(n3, (List<MirLldbBridge.Local>)collection3, list, n2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<MirLldbBridge.InputArg> mirror(@NotNull List<MirVarDebugInfo> debugInfos) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(debugInfos, (String)"debugInfos");
        Iterable $this$mapNotNull$iv = debugInfos;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            MirLldbBridge.InputArg it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            MirVarDebugInfo it2 = (MirVarDebugInfo)element$iv$iv;
            boolean bl2 = false;
            if ((it2.getArgumentIndex() != null ? new MirLldbBridge.InputArg(it2.getName()) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final MirLldbBridge.Local mirror(MirLocal localDecl) {
        return new MirLldbBridge.Local(localDecl.getIndex());
    }

    /*
     * WARNING - void declaration
     */
    private final MirLldbBridge.Block mirror(MirBasicBlock block) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = block.getStatements();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            MirLldbBridge.Statement it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            MirStatement it2 = (MirStatement)element$iv$iv;
            boolean bl2 = false;
            if (this.mirror(it2) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        MirLldbBridge.Terminator terminator = this.mirror(block.getTerminator());
        List list = (List)destination$iv$iv;
        return new MirLldbBridge.Block(list, terminator);
    }

    private final MirLldbBridge.Statement mirror(MirStatement statement) {
        MirLldbBridge.Statement statement2;
        MirStatement mirStatement = statement;
        if (mirStatement instanceof MirStatement.Assign) {
            statement2 = new MirLldbBridge.Statement(this.mirror(((MirStatement.Assign)statement).getPlace()), this.mirror(((MirStatement.Assign)statement).getRvalue()));
        } else if (mirStatement instanceof MirStatement.FakeRead) {
            statement2 = null;
        } else if (mirStatement instanceof MirStatement.PlaceMention) {
            statement2 = null;
        } else if (mirStatement instanceof MirStatement.StorageDead) {
            statement2 = null;
        } else if (mirStatement instanceof MirStatement.StorageLive) {
            statement2 = null;
        } else {
            if (mirStatement instanceof MirStatement.Drop) {
                throw new IllegalStateException("Drop statements are not allowed in the MIR built for lldb evaluation".toString());
            }
            if (mirStatement instanceof MirStatement.Uncontrolled) {
                throw new MirLldbException(MirLldbException.TransformationReason.Uncontrolled);
            }
            if (mirStatement instanceof MirStatement.UncontrolledAll) {
                throw new MirLldbException(MirLldbException.TransformationReason.UncontrolledAll);
            }
            throw new NoWhenBranchMatchedException();
        }
        return statement2;
    }

    private final String formatAssertMsg(MirAssertKind kind2) {
        String string;
        MirAssertKind mirAssertKind = kind2;
        if (mirAssertKind instanceof MirAssertKind.BoundsCheck) {
            string = "Bounds check assert failed";
        } else if (mirAssertKind instanceof MirAssertKind.DivisionByZero) {
            string = "Division by zero assert failed";
        } else if (mirAssertKind instanceof MirAssertKind.Overflow) {
            string = "Overflow assert failed";
        } else if (mirAssertKind instanceof MirAssertKind.OverflowNeg) {
            string = "Overflow on negate assert failed";
        } else if (mirAssertKind instanceof MirAssertKind.ReminderByZero) {
            string = "Reminder by zero assert failed";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final MirLldbBridge.Terminator mirror(MirTerminator<? extends MirBasicBlock> terminator) {
        MirLldbBridge.Terminator terminator2;
        MirTerminator<? extends MirBasicBlock> mirTerminator = terminator;
        if (mirTerminator instanceof MirTerminator.Assert) {
            terminator2 = new MirLldbBridge.Terminator.Assert(this.mirror(((MirTerminator.Assert)terminator).getCond()), ((MirTerminator.Assert)terminator).getExpected(), this.formatAssertMsg(((MirTerminator.Assert)terminator).getMsg()), ((MirTerminator.Assert)terminator).getTarget().getIndex());
        } else if (mirTerminator instanceof MirTerminator.Call) {
            void $this$mapTo$iv$iv;
            MirLldbInliningEntry.Function function = this.monomorphizeCall((MirTerminator.Call)terminator);
            Iterable $this$map$iv = ((MirTerminator.Call)terminator).getArgs();
            boolean $i$f$map2 = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                MirOperand mirOperand = (MirOperand)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.mirror((MirOperand)it2));
            }
            Object BB = ((MirTerminator.Call)terminator).getTarget();
            if (BB == null) {
                throw new MirLldbException(MirLldbException.TransformationReason.MissingCallTarget);
            }
            int n = BB.getIndex();
            int n2 = this.inliner.getEntryIndex(function);
            MirLldbBridge.Place place = this.mirror(((MirTerminator.Call)terminator).getDestination());
            List list = (List)destination$iv$iv;
            terminator2 = new MirLldbBridge.Terminator.Call(list, place, n2, n);
        } else if (mirTerminator instanceof MirTerminator.Drop) {
            Ty ty2 = (Ty)FoldKt.substitute(((MirTerminator.Drop)terminator).getPlace().getLocal().getTy(), this.monomorphization.getSubst());
            if (this.needsDropCheck.needsDrop(ty2) != ThreeValuedLogic.False) {
                throw new MirLldbException(MirLldbException.TransformationReason.UnsupportedDrop);
            }
            terminator2 = new MirLldbBridge.Terminator.Goto(((MirTerminator.Drop)terminator).getTarget().getIndex());
        } else if (mirTerminator instanceof MirTerminator.FalseEdge) {
            terminator2 = new MirLldbBridge.Terminator.Goto(((MirTerminator.FalseEdge)terminator).getRealTarget().getIndex());
        } else if (mirTerminator instanceof MirTerminator.FalseUnwind) {
            terminator2 = new MirLldbBridge.Terminator.Goto(((MirTerminator.FalseUnwind)terminator).getRealTarget().getIndex());
        } else if (mirTerminator instanceof MirTerminator.Goto) {
            terminator2 = new MirLldbBridge.Terminator.Goto(((MirTerminator.Goto)terminator).getTarget().getIndex());
        } else if (mirTerminator instanceof MirTerminator.Resume) {
            terminator2 = MirLldbBridge.Terminator.Return.INSTANCE;
        } else if (mirTerminator instanceof MirTerminator.Return) {
            terminator2 = MirLldbBridge.Terminator.Return.INSTANCE;
        } else if (mirTerminator instanceof MirTerminator.SwitchInt) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable ty2 = ((MirTerminator.SwitchInt)terminator).getTargets();
            MirLldbBridge.Operand operand = this.mirror(((MirTerminator.SwitchInt)terminator).getDiscriminant());
            boolean $i$f$map = false;
            void $i$f$map2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                long l = ((Number)pair.component1()).longValue();
                MirBasicBlock target = (MirBasicBlock)pair.component2();
                collection.add(new MirLldbBridge.Terminator.SwitchInt.Branch(l, target.getIndex()));
            }
            int n = ((MirTerminator.SwitchInt)terminator).getTargets().getOtherwise().getIndex();
            List list = (List)destination$iv$iv;
            MirLldbBridge.Operand operand2 = operand;
            terminator2 = new MirLldbBridge.Terminator.SwitchInt(operand2, list, n);
        } else if (mirTerminator instanceof MirTerminator.Unreachable) {
            terminator2 = MirLldbBridge.Terminator.Unreachable.INSTANCE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return terminator2;
    }

    private final MirLldbInliningEntry.Function monomorphizeCall(MirTerminator.Call<?> terminator) {
        Ty ty2 = MirOperandKt.getTy(terminator.getCallee());
        TyFnDef tyFnDef = ty2 instanceof TyFnDef ? (TyFnDef)ty2 : null;
        if (tyFnDef == null) {
            throw new MirLldbException(MirLldbException.TransformationReason.UnsupportedCallee);
        }
        TyFnDef callee = tyFnDef;
        RsQualifiedNamedElement rsQualifiedNamedElement = callee.getDef().getElement();
        RsFunction rsFunction = rsQualifiedNamedElement instanceof RsFunction ? (RsFunction)rsQualifiedNamedElement : null;
        if (rsFunction == null) {
            throw new MirLldbException(MirLldbException.TransformationReason.UnsupportedCallee);
        }
        RsFunction fn = rsFunction;
        BoundElement boundElement = RsInferenceContext.refine$default(this.implLookup.getCtx(), new BoundElement(fn, callee.getSubst().substituteInValues(this.monomorphization.getSubst()), null, 4, null), null, 2, null);
        if (boundElement == null) {
            throw new MirLldbException(MirLldbException.TransformationReason.CannotMonomorphizeCall);
        }
        BoundElement res2 = boundElement;
        return new MirLldbInliningEntry.Function((RsFunction)res2.getElement(), MirLldbMonomorphisation.Companion.create(res2.getSubst()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final MirLldbBridge.Operand mirror(MirOperand operand) {
        MirLldbBridge.Operand operand2;
        MirOperand mirOperand = operand;
        if (mirOperand instanceof MirOperand.Constant) {
            MirConstant constant = ((MirOperand.Constant)operand).getConstant();
            if (constant instanceof MirConstant.Value) {
                MirConstValue constValue = ((MirConstant.Value)constant).getConstValue();
                if (constValue instanceof MirConstValue.Scalar) {
                    MirScalarInt mirScalarInt = ((MirConstValue.Scalar)constValue).getValue().tryToInt();
                    if (mirScalarInt == null) {
                        throw new MirLldbException(MirLldbException.TransformationReason.ConstNonInt);
                    }
                    MirScalarInt mirScalarInt2 = mirScalarInt;
                    long value = mirScalarInt2.getData();
                    Ty ty2 = mirScalarInt2.getTy();
                    operand2 = new MirLldbBridge.Operand.Scalar(value, this.mirrorAsPrimitive(ty2));
                    return operand2;
                } else {
                    if (!(constValue instanceof MirConstValue.ZeroSized)) throw new NoWhenBranchMatchedException();
                    operand2 = new MirLldbBridge.Operand.ZeroSized(TypeRenderingKt.render$default(((MirConstant.Value)constant).getTy(), null, 0, null, null, null, null, null, null, QualifiedNameSettings.All.INSTANCE, false, false, false, false, false, false, false, null, 130815, null));
                }
                return operand2;
            } else {
                if (!(constant instanceof MirConstant.Unevaluated)) throw new MirLldbException(MirLldbException.TransformationReason.UnsupportedConst);
                int index = this.inliner.getEntryIndex(new MirLldbInliningEntry.Constant(((MirConstant.Unevaluated)constant).getDef()));
                operand2 = new MirLldbBridge.Operand.UnevaluatedConstant(index);
            }
            return operand2;
        } else if (mirOperand instanceof MirOperand.Copy) {
            operand2 = new MirLldbBridge.Operand.Place(this.mirror(((MirOperand.Copy)operand).getPlace()));
            return operand2;
        } else {
            if (!(mirOperand instanceof MirOperand.Move)) throw new NoWhenBranchMatchedException();
            operand2 = new MirLldbBridge.Operand.Place(this.mirror(((MirOperand.Move)operand).getPlace()));
        }
        return operand2;
    }

    /*
     * WARNING - void declaration
     */
    private final MirLldbBridge.Place mirror(MirPlace place) {
        Collection<MirLldbBridge.Projection> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = place.getProjections();
        int n = place.getLocal().getIndex();
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            MirProjectionElem mirProjectionElem = (MirProjectionElem)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.mirror((MirProjectionElem<? extends Ty>)it2));
        }
        collection = (List)destination$iv$iv;
        List list = collection;
        int n2 = n;
        return new MirLldbBridge.Place(n2, list);
    }

    private final MirLldbBridge.Projection mirror(MirProjectionElem<? extends Ty> projection) {
        MirLldbBridge.Projection projection2;
        MirProjectionElem<? extends Ty> mirProjectionElem = projection;
        if (Intrinsics.areEqual(mirProjectionElem, (Object)MirProjectionElem.Deref.INSTANCE)) {
            projection2 = MirLldbBridge.Projection.Deref.INSTANCE;
        } else if (mirProjectionElem instanceof MirProjectionElem.ConstantIndex) {
            projection2 = new MirLldbBridge.Projection.ConstantIndex(((MirProjectionElem.ConstantIndex)projection).getOffset(), ((MirProjectionElem.ConstantIndex)projection).getFromEnd());
        } else if (mirProjectionElem instanceof MirProjectionElem.Downcast) {
            projection2 = new MirLldbBridge.Projection.Downcast(((MirProjectionElem.Downcast)projection).getVariantIndex());
        } else if (mirProjectionElem instanceof MirProjectionElem.Field) {
            String string = ((MirProjectionElem.Field)projection).getFieldName();
            if (string == null) {
                throw new MirLldbException(MirLldbException.TransformationReason.NoFieldName);
            }
            String fieldName = string;
            projection2 = new MirLldbBridge.Projection.Field(fieldName);
        } else if (mirProjectionElem instanceof MirProjectionElem.Index) {
            projection2 = new MirLldbBridge.Projection.Index(((MirProjectionElem.Index)projection).getIndex().getIndex());
        } else if (mirProjectionElem instanceof MirProjectionElem.Subslice) {
            projection2 = new MirLldbBridge.Projection.Subslice(((MirProjectionElem.Subslice)projection).getFrom(), ((MirProjectionElem.Subslice)projection).getTo(), ((MirProjectionElem.Subslice)projection).getFromEnd());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return projection2;
    }

    /*
     * WARNING - void declaration
     */
    private final MirLldbBridge.Rvalue mirror(MirRvalue rvalue) {
        MirLldbBridge.Rvalue rvalue2;
        MirRvalue mirRvalue = rvalue;
        if (mirRvalue instanceof MirRvalue.Aggregate.Array) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = ((MirRvalue.Aggregate.Array)rvalue).getOperands();
            MirLldbBridge.Rvalue.Aggregate.Kind kind2 = MirLldbBridge.Rvalue.Aggregate.Kind.Array.INSTANCE;
            boolean $i$f$map = false;
            void var5_12 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                MirOperand mirOperand = (MirOperand)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.mirror((MirOperand)it2));
            }
            List list = (List)destination$iv$iv;
            MirLldbBridge.Rvalue.Aggregate.Kind kind3 = kind2;
            rvalue2 = new MirLldbBridge.Rvalue.Aggregate(kind3, list);
        } else if (mirRvalue instanceof MirRvalue.Aggregate.Tuple) {
            Iterable $this$map$iv = ((MirRvalue.Aggregate.Tuple)rvalue).getOperands();
            MirLldbBridge.Rvalue.Aggregate.Kind kind4 = MirLldbBridge.Rvalue.Aggregate.Kind.Tuple.INSTANCE;
            boolean $i$f$map = false;
            Iterable $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                MirOperand it2 = (MirOperand)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.mirror(it2));
            }
            List list = (List)destination$iv$iv;
            MirLldbBridge.Rvalue.Aggregate.Kind kind5 = kind4;
            rvalue2 = new MirLldbBridge.Rvalue.Aggregate(kind5, list);
        } else if (mirRvalue instanceof MirRvalue.Aggregate.Adt) {
            Iterable $this$map$iv = ((MirRvalue.Aggregate.Adt)rvalue).getOperands();
            MirLldbBridge.Rvalue.Aggregate.Kind kind6 = new MirLldbBridge.Rvalue.Aggregate.Kind.Adt(TypeRenderingKt.render$default((TypeRenderable)FoldKt.substitute(((MirRvalue.Aggregate.Adt)rvalue).getTy(), this.monomorphization.getSubst()), null, 0, null, null, null, null, null, null, QualifiedNameSettings.All.INSTANCE, false, false, false, false, false, false, false, null, 130815, null), this.getFieldNames(((MirRvalue.Aggregate.Adt)rvalue).getDefinition(), ((MirRvalue.Aggregate.Adt)rvalue).getVariantIndex()), this.getDiscr(((MirRvalue.Aggregate.Adt)rvalue).getDefinition(), ((MirRvalue.Aggregate.Adt)rvalue).getVariantIndex()));
            boolean $i$f$map = false;
            Iterable $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                MirOperand it3 = (MirOperand)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.mirror(it3));
            }
            List list = (List)destination$iv$iv;
            MirLldbBridge.Rvalue.Aggregate.Kind kind7 = kind6;
            rvalue2 = new MirLldbBridge.Rvalue.Aggregate(kind7, list);
        } else {
            if (mirRvalue instanceof MirRvalue.Aggregate.Closure) {
                throw new MirLldbException(MirLldbException.TransformationReason.RvalueClosure);
            }
            if (mirRvalue instanceof MirRvalue.BinaryOpUse) {
                rvalue2 = new MirLldbBridge.Rvalue.BinaryExpression(this.mirror(((MirRvalue.BinaryOpUse)rvalue).getOp()), this.mirror(((MirRvalue.BinaryOpUse)rvalue).getLeft()), this.mirror(((MirRvalue.BinaryOpUse)rvalue).getRight()));
            } else if (mirRvalue instanceof MirRvalue.Cast.IntToInt) {
                rvalue2 = new MirLldbBridge.Rvalue.Cast(MirLldbBridge.CastKind.Scalar, this.mirror(((MirRvalue.Cast.IntToInt)rvalue).getOperand()), this.mirrorAsPrimitive(((MirRvalue.Cast.IntToInt)rvalue).getTy()));
            } else if (mirRvalue instanceof MirRvalue.Cast.Unknown) {
                rvalue2 = new MirLldbBridge.Rvalue.Cast(MirLldbBridge.CastKind.Scalar, this.mirror(((MirRvalue.Cast.Unknown)rvalue).getOperand()), this.mirrorAsPrimitive(((MirRvalue.Cast.Unknown)rvalue).getTy()));
            } else if (mirRvalue instanceof MirRvalue.Cast.Pointer) {
                rvalue2 = new MirLldbBridge.Rvalue.Cast(MirLldbBridge.CastKind.PointerCoercion, this.mirror(((MirRvalue.Cast.Pointer)rvalue).getOperand()), null);
            } else if (mirRvalue instanceof MirRvalue.CheckedBinaryOpUse) {
                rvalue2 = new MirLldbBridge.Rvalue.BinaryExpression(this.mirror(((MirRvalue.CheckedBinaryOpUse)rvalue).getOp()), this.mirror(((MirRvalue.CheckedBinaryOpUse)rvalue).getLeft()), this.mirror(((MirRvalue.CheckedBinaryOpUse)rvalue).getRight()));
            } else {
                if (Intrinsics.areEqual((Object)mirRvalue, (Object)MirRvalue.CopyForDeref.INSTANCE)) {
                    throw new MirLldbException(MirLldbException.TransformationReason.RvalueCopyForDeref);
                }
                if (mirRvalue instanceof MirRvalue.Discriminant) {
                    rvalue2 = new MirLldbBridge.Rvalue.Discriminant(this.mirror(((MirRvalue.Discriminant)rvalue).getPlace()));
                } else if (mirRvalue instanceof MirRvalue.Len) {
                    rvalue2 = new MirLldbBridge.Rvalue.Len(this.mirror(((MirRvalue.Len)rvalue).getPlace()));
                } else {
                    if (Intrinsics.areEqual((Object)mirRvalue, (Object)MirRvalue.NullaryOpUse.INSTANCE)) {
                        throw new MirLldbException(MirLldbException.TransformationReason.RvalueNullary);
                    }
                    if (mirRvalue instanceof MirRvalue.Ref) {
                        rvalue2 = new MirLldbBridge.Rvalue.Ref(this.mirror(((MirRvalue.Ref)rvalue).getPlace()));
                    } else if (mirRvalue instanceof MirRvalue.AddressOf) {
                        rvalue2 = new MirLldbBridge.Rvalue.Ref(this.mirror(((MirRvalue.AddressOf)rvalue).getPlace()));
                    } else if (mirRvalue instanceof MirRvalue.Repeat) {
                        Long l = CtValueKt.asLong(((MirRvalue.Repeat)rvalue).getCount());
                        if (l == null) {
                            throw new MirLldbException(MirLldbException.TransformationReason.RepeatNonConstCount);
                        }
                        rvalue2 = new MirLldbBridge.Rvalue.Repeat(this.mirror(((MirRvalue.Repeat)rvalue).getOperand()), l);
                    } else {
                        if (mirRvalue instanceof MirRvalue.SubstitutesUse) {
                            throw new IllegalStateException("Substitutes should only be available in completion".toString());
                        }
                        if (Intrinsics.areEqual((Object)mirRvalue, (Object)MirRvalue.ThreadLocalRef.INSTANCE)) {
                            throw new MirLldbException(MirLldbException.TransformationReason.RvalueThreadLocalRef);
                        }
                        if (mirRvalue instanceof MirRvalue.UnaryOpUse) {
                            rvalue2 = new MirLldbBridge.Rvalue.UnaryExpression(this.mirror(((MirRvalue.UnaryOpUse)rvalue).getOp()), this.mirror(((MirRvalue.UnaryOpUse)rvalue).getOperand()));
                        } else if (mirRvalue instanceof MirRvalue.Use) {
                            rvalue2 = new MirLldbBridge.Rvalue.Operand(this.mirror(((MirRvalue.Use)rvalue).getOperand()));
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
            }
        }
        return rvalue2;
    }

    private final MirLldbBridge.Rvalue.Aggregate.Discr getDiscr(RsStructOrEnumItemElement $this$getDiscr, int variantIndex) {
        if ($this$getDiscr instanceof RsEnumItem) {
            RsEnumVariant variant = (RsEnumVariant)CollectionsKt.getOrNull(RsEnumItemKt.getVariants((RsEnumItem)$this$getDiscr), (int)variantIndex);
            Object object = variant;
            if (object == null || (object = object.getName()) == null) {
                throw new MirLldbException(MirLldbException.TransformationReason.MissingVariantName);
            }
            Object name2 = object;
            long index = variantIndex;
            return new MirLldbBridge.Rvalue.Aggregate.Discr(index, (String)name2);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getFieldNames(RsStructOrEnumItemElement $this$getFieldNames, int variantIndex) {
        List list;
        RsFieldsOwner rsFieldsOwner = MirrorKt.variant($this$getFieldNames, variantIndex);
        if (rsFieldsOwner == null) {
            throw new MirLldbException(MirLldbException.TransformationReason.MissingVariant);
        }
        RsFieldsOwner variant = rsFieldsOwner;
        Object object = variant.getBlockFields();
        if (object != null && (object = object.getNamedFieldDeclList()) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                RsNamedFieldDecl rsNamedFieldDecl = (RsNamedFieldDecl)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = it2.getName();
                if (string == null) {
                    throw new MirLldbException(MirLldbException.TransformationReason.NullVariantFieldName);
                }
                collection.add(string);
            }
            list = (List)destination$iv$iv;
        } else {
            Object object2 = variant.getTupleFields();
            if (object2 != null && (object2 = object2.getTupleFieldDeclList()) != null && (object2 = CollectionsKt.getIndices((Collection)((Collection)object2))) != null) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = (Iterable)object2;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator2 = $this$mapTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    void it3;
                    int item$iv$iv;
                    int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(String.valueOf((int)it3));
                }
                list = (List)destination$iv$iv;
            } else {
                list = CollectionsKt.emptyList();
            }
        }
        return list;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final MirLldbBridge.BinaryOperator mirror(MirBinaryOperator op) {
        MirBinaryOperator mirBinaryOperator = op;
        if (mirBinaryOperator instanceof MirBinaryOperator.Arithmetic) {
            ArithmeticOp arithmeticOp = ((MirBinaryOperator.Arithmetic)op).getOp();
            if (Intrinsics.areEqual((Object)arithmeticOp, (Object)ArithmeticOp.ADD.INSTANCE)) {
                v0 = MirLldbBridge.BinaryOperator.Plus;
                return v0;
            } else if (Intrinsics.areEqual((Object)arithmeticOp, (Object)ArithmeticOp.BIT_AND.INSTANCE)) {
                v0 = MirLldbBridge.BinaryOperator.BitAnd;
                return v0;
            } else if (Intrinsics.areEqual((Object)arithmeticOp, (Object)ArithmeticOp.BIT_OR.INSTANCE)) {
                v0 = MirLldbBridge.BinaryOperator.BitOr;
                return v0;
            } else if (Intrinsics.areEqual((Object)arithmeticOp, (Object)ArithmeticOp.BIT_XOR.INSTANCE)) {
                v0 = MirLldbBridge.BinaryOperator.BitXor;
                return v0;
            } else if (Intrinsics.areEqual((Object)arithmeticOp, (Object)ArithmeticOp.DIV.INSTANCE)) {
                v0 = MirLldbBridge.BinaryOperator.Div;
                return v0;
            } else if (Intrinsics.areEqual((Object)arithmeticOp, (Object)ArithmeticOp.MUL.INSTANCE)) {
                v0 = MirLldbBridge.BinaryOperator.Mult;
                return v0;
            } else if (Intrinsics.areEqual((Object)arithmeticOp, (Object)ArithmeticOp.REM.INSTANCE)) {
                v0 = MirLldbBridge.BinaryOperator.Mod;
                return v0;
            } else if (Intrinsics.areEqual((Object)arithmeticOp, (Object)ArithmeticOp.SHL.INSTANCE)) {
                v0 = MirLldbBridge.BinaryOperator.LeftShift;
                return v0;
            } else if (Intrinsics.areEqual((Object)arithmeticOp, (Object)ArithmeticOp.SHR.INSTANCE)) {
                v0 = MirLldbBridge.BinaryOperator.RightShift;
                return v0;
            } else {
                if (!Intrinsics.areEqual((Object)arithmeticOp, (Object)ArithmeticOp.SUB.INSTANCE)) throw new NoWhenBranchMatchedException();
                v0 = MirLldbBridge.BinaryOperator.Minus;
            }
            return v0;
        } else if (mirBinaryOperator instanceof MirBinaryOperator.Comparison) {
            ComparisonOp comparisonOp = ((MirBinaryOperator.Comparison)op).getOp();
            if (Intrinsics.areEqual((Object)comparisonOp, (Object)ComparisonOp.GT.INSTANCE)) {
                v0 = MirLldbBridge.BinaryOperator.Greater;
                return v0;
            } else if (Intrinsics.areEqual((Object)comparisonOp, (Object)ComparisonOp.GTEQ.INSTANCE)) {
                v0 = MirLldbBridge.BinaryOperator.GreaterEqual;
                return v0;
            } else if (Intrinsics.areEqual((Object)comparisonOp, (Object)ComparisonOp.LT.INSTANCE)) {
                v0 = MirLldbBridge.BinaryOperator.Less;
                return v0;
            } else {
                if (!Intrinsics.areEqual((Object)comparisonOp, (Object)ComparisonOp.LTEQ.INSTANCE)) throw new NoWhenBranchMatchedException();
                v0 = MirLldbBridge.BinaryOperator.LessEqual;
            }
            return v0;
        } else if (mirBinaryOperator instanceof MirBinaryOperator.Equality) {
            EqualityOp equalityOp = ((MirBinaryOperator.Equality)op).getOp();
            if (Intrinsics.areEqual((Object)equalityOp, (Object)EqualityOp.EQ.INSTANCE)) {
                v0 = MirLldbBridge.BinaryOperator.Equal;
                return v0;
            } else {
                if (!Intrinsics.areEqual((Object)equalityOp, (Object)EqualityOp.EXCLEQ.INSTANCE)) throw new NoWhenBranchMatchedException();
                v0 = MirLldbBridge.BinaryOperator.NotEqual;
            }
            return v0;
        } else {
            if (!Intrinsics.areEqual((Object)mirBinaryOperator, (Object)MirBinaryOperator.Offset.INSTANCE)) throw new NoWhenBranchMatchedException();
            throw new MirLldbException(MirLldbException.TransformationReason.BinOpOffset);
        }
    }

    private final MirLldbBridge.UnaryOperator mirror(MirUnaryOperator op) {
        return switch (WhenMappings.$EnumSwitchMapping$0[op.ordinal()]) {
            case 1 -> MirLldbBridge.UnaryOperator.Negate;
            case 2 -> MirLldbBridge.UnaryOperator.Not;
            case 3 -> MirLldbBridge.UnaryOperator.PtrMetadata;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final String mirrorAsPrimitive(Ty ty2) {
        Ty ty3 = ty2;
        if (Intrinsics.areEqual((Object)ty3, (Object)TyNever.INSTANCE)) {
            throw new MirLldbException(MirLldbException.TransformationReason.TyNeverSerialized);
        }
        if (!(ty3 instanceof TyPrimitive)) {
            throw new MirLldbException(MirLldbException.TransformationReason.NonPrimitiveTy);
        }
        return ((TyPrimitive)ty2).getName();
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MirUnaryOperator.values().length];
            try {
                nArray[MirUnaryOperator.Neg.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MirUnaryOperator.Not.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MirUnaryOperator.PtrMetadata.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

