/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.mir.lldb;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.rust.lang.core.mir.lldb.MirLldbInliningEntry;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00100\u0012H\u0086\b\u00f8\u0001\u0000J\u000e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0003J\u0006\u0010\u0015\u001a\u00020\u0003J\u0006\u0010\u0016\u001a\u00020\u0003J\u0006\u0010\u0017\u001a\u00020\u0018R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\r\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0019"}, d2={"Lorg/rust/lang/core/mir/lldb/MirLldbInliningQueue;", "", "initial", "Lorg/rust/lang/core/mir/lldb/MirLldbInliningEntry;", "<init>", "(Lorg/rust/lang/core/mir/lldb/MirLldbInliningEntry;)V", "queue", "Lkotlin/collections/ArrayDeque;", "value", "", "functionsCount", "getFunctionsCount", "()I", "constantsCount", "getConstantsCount", "process", "", "block", "Lkotlin/Function1;", "add", "entry", "peek", "pop", "isNotEmpty", "", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nMirLldbInliningQueue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MirLldbInliningQueue.kt\norg/rust/lang/core/mir/lldb/MirLldbInliningQueue\n+ 2 utils.kt\norg/rust/openapiext/UtilsKt\n*L\n1#1,62:1\n305#2,10:63\n*S KotlinDebug\n*F\n+ 1 MirLldbInliningQueue.kt\norg/rust/lang/core/mir/lldb/MirLldbInliningQueue\n*L\n24#1:63,10\n*E\n"})
public final class MirLldbInliningQueue {
    @NotNull
    private final ArrayDeque<MirLldbInliningEntry> queue;
    private int functionsCount;
    private int constantsCount;

    public MirLldbInliningQueue(@NotNull MirLldbInliningEntry initial) {
        Intrinsics.checkNotNullParameter((Object)initial, (String)"initial");
        this.queue = new ArrayDeque();
        this.add(initial);
    }

    public final int getFunctionsCount() {
        return this.functionsCount;
    }

    public final int getConstantsCount() {
        return this.constantsCount;
    }

    public final void process(@NotNull Function1<? super MirLldbInliningEntry, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$process = false;
        MirLldbInliningEntry entry2 = this.peek();
        block.invoke((Object)entry2);
        MirLldbInliningEntry popped = this.pop();
        boolean $i$f$testAssert = false;
        boolean $i$f$testAssert2 = false;
        if (UtilsKt.isUnitTestMode()) {
            boolean bl = false;
            if (!(popped == entry2)) {
                boolean bl2 = false;
                String message$iv$iv = "Assertion failed";
                throw new AssertionError((Object)message$iv$iv);
            }
        }
    }

    public final void add(@NotNull MirLldbInliningEntry entry2) {
        Intrinsics.checkNotNullParameter((Object)entry2, (String)"entry");
        this.queue.add((Object)entry2);
        MirLldbInliningEntry mirLldbInliningEntry = entry2;
        if (mirLldbInliningEntry instanceof MirLldbInliningEntry.DebuggerExpression) {
            int n = this.functionsCount;
            this.functionsCount = n + 1;
        } else if (mirLldbInliningEntry instanceof MirLldbInliningEntry.Function) {
            int n = this.functionsCount;
            this.functionsCount = n + 1;
        } else if (mirLldbInliningEntry instanceof MirLldbInliningEntry.Constant) {
            int n = this.constantsCount;
            this.constantsCount = n + 1;
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    @NotNull
    public final MirLldbInliningEntry peek() {
        return (MirLldbInliningEntry)this.queue.first();
    }

    @NotNull
    public final MirLldbInliningEntry pop() {
        MirLldbInliningEntry removed = (MirLldbInliningEntry)this.queue.removeFirst();
        MirLldbInliningEntry mirLldbInliningEntry = removed;
        if (mirLldbInliningEntry instanceof MirLldbInliningEntry.DebuggerExpression) {
            int n = this.functionsCount;
            this.functionsCount = n + -1;
        } else if (mirLldbInliningEntry instanceof MirLldbInliningEntry.Function) {
            int n = this.functionsCount;
            this.functionsCount = n + -1;
        } else if (mirLldbInliningEntry instanceof MirLldbInliningEntry.Constant) {
            int n = this.constantsCount;
            this.constantsCount = n + -1;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return removed;
    }

    public final boolean isNotEmpty() {
        return !((Collection)this.queue).isEmpty();
    }
}

