/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.mir.lldb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.rust.lang.core.mir.lldb.MirLldbBridge;
import org.rust.lang.core.mir.lldb.MirLldbFunctionAndMonomorphization;
import org.rust.lang.core.mir.lldb.MirLldbInliningEntry;
import org.rust.lang.core.mir.lldb.MirLldbInliningQueue;
import org.rust.lang.core.mir.lldb.MirLldbMonomorphisation;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dJ\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\bR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00140\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006%"}, d2={"Lorg/rust/lang/core/mir/lldb/MirLldbInliner;", "", "initial", "Lorg/rust/lang/core/mir/lldb/MirLldbInliningEntry;", "<init>", "(Lorg/rust/lang/core/mir/lldb/MirLldbInliningEntry;)V", "functions", "", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Function;", "getFunctions", "()Ljava/util/List;", "constants", "getConstants", "_functions", "", "Lorg/rust/lang/core/mir/lldb/MirLldbFunctionAndMonomorphization;", "_constants", "functionIndices", "", "Lorg/rust/lang/core/mir/lldb/MirLldbInliningEntry$Function;", "", "constantIndices", "Lorg/rust/lang/core/mir/lldb/MirLldbInliningEntry$Constant;", "inliningQueue", "Lorg/rust/lang/core/mir/lldb/MirLldbInliningQueue;", "getInliningQueue", "()Lorg/rust/lang/core/mir/lldb/MirLldbInliningQueue;", "getEntryIndex", "entry", "Lorg/rust/lang/core/mir/lldb/MirLldbInliningEntry$Inlinable;", "appendFunction", "", "function", "monomorphisation", "Lorg/rust/lang/core/mir/lldb/MirLldbMonomorphisation;", "appendConstant", "constant", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nMirLldbInliner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MirLldbInliner.kt\norg/rust/lang/core/mir/lldb/MirLldbInliner\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,51:1\n1563#2:52\n1634#2,3:53\n*S KotlinDebug\n*F\n+ 1 MirLldbInliner.kt\norg/rust/lang/core/mir/lldb/MirLldbInliner\n*L\n4#1:52\n4#1:53,3\n*E\n"})
public final class MirLldbInliner {
    @NotNull
    private final List<MirLldbFunctionAndMonomorphization> _functions;
    @NotNull
    private final List<MirLldbBridge.Function> _constants;
    @NotNull
    private final Map<MirLldbInliningEntry.Function, Integer> functionIndices;
    @NotNull
    private final Map<MirLldbInliningEntry.Constant, Integer> constantIndices;
    @NotNull
    private final MirLldbInliningQueue inliningQueue;

    public MirLldbInliner(@NotNull MirLldbInliningEntry initial) {
        Intrinsics.checkNotNullParameter((Object)initial, (String)"initial");
        this._functions = new ArrayList();
        this._constants = new ArrayList();
        this.functionIndices = new LinkedHashMap();
        this.constantIndices = new LinkedHashMap();
        this.inliningQueue = new MirLldbInliningQueue(initial);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<MirLldbBridge.Function> getFunctions() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this._functions;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            MirLldbFunctionAndMonomorphization mirLldbFunctionAndMonomorphization = (MirLldbFunctionAndMonomorphization)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it2.getFunction());
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final List<MirLldbBridge.Function> getConstants() {
        return CollectionsKt.toList((Iterable)this._constants);
    }

    @NotNull
    public final MirLldbInliningQueue getInliningQueue() {
        return this.inliningQueue;
    }

    public final int getEntryIndex(@NotNull MirLldbInliningEntry.Inlinable entry2) {
        int n;
        Integer n2;
        Intrinsics.checkNotNullParameter((Object)entry2, (String)"entry");
        MirLldbInliningEntry.Inlinable inlinable = entry2;
        if (inlinable instanceof MirLldbInliningEntry.Function) {
            n2 = this.functionIndices.get(entry2);
        } else if (inlinable instanceof MirLldbInliningEntry.Constant) {
            n2 = this.constantIndices.get(entry2);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Integer index = n2;
        if (index != null) {
            return index;
        }
        MirLldbInliningEntry.Inlinable inlinable2 = entry2;
        if (inlinable2 instanceof MirLldbInliningEntry.Constant) {
            newIndex = this._constants.size() + this.inliningQueue.getConstantsCount();
            this.constantIndices.put((MirLldbInliningEntry.Constant)entry2, newIndex);
            n = newIndex;
        } else if (inlinable2 instanceof MirLldbInliningEntry.Function) {
            newIndex = this._functions.size() + this.inliningQueue.getFunctionsCount();
            this.functionIndices.put((MirLldbInliningEntry.Function)entry2, newIndex);
            n = newIndex;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        int newIndex = n;
        this.inliningQueue.add(entry2);
        return newIndex;
    }

    public final void appendFunction(@NotNull MirLldbBridge.Function function, @NotNull MirLldbMonomorphisation monomorphisation) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        Intrinsics.checkNotNullParameter((Object)monomorphisation, (String)"monomorphisation");
        this._functions.add(new MirLldbFunctionAndMonomorphization(function, monomorphisation));
    }

    public final void appendConstant(@NotNull MirLldbBridge.Function constant) {
        Intrinsics.checkNotNullParameter((Object)constant, (String)"constant");
        this._constants.add(constant);
    }
}

