/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.mir.lldb;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.lang.core.mir.TargetProcessParams;
import org.rust.lang.core.mir.lldb.MirLldbAdapter;
import org.rust.lang.core.mir.lldb.MirLldbException;
import org.rust.lang.core.mir.lldb.MirLldbInliningEntry;
import org.rust.lang.core.mir.lldb.OperandPlaceAdapterFactory;
import org.rust.lang.core.mir.lldb.ScalarFloatTypeAdapterFactory;
import org.rust.lang.core.mir.lldb.SerializedClassName;
import org.rust.lang.core.mir.lldb.SkipSealedClassWrapping;
import org.rust.lang.core.mir.lldb.SuppressedErrors;
import org.rust.lang.core.mir.lldb.VariantTypeAdapterFactory;
import org.rust.lang.core.psi.RsDebuggerExpressionCodeFragment;
import org.rust.lang.core.psi.RsFunction;
import org.rust.stdext.RsResult;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0016\u0018\u0000 \u001c2\u00020\u0001:\u000f\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001cB1\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\u0004\b\b\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lorg/rust/lang/core/mir/lldb/MirLldbBridge;", "", "functions", "", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Function;", "constants", "args", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$InputArg;", "<init>", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getFunctions", "()Ljava/util/List;", "getConstants", "getArgs", "InputArg", "Local", "Place", "Projection", "BinaryOperator", "UnaryOperator", "CastKind", "Operand", "Rvalue", "Statement", "Terminator", "Block", "FunctionBody", "Function", "Companion", "intellij.rustrover.core"})
public final class MirLldbBridge {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Function> functions;
    @NotNull
    private final List<Function> constants;
    @NotNull
    private final List<InputArg> args;

    public MirLldbBridge(@NotNull List<Function> functions, @NotNull List<Function> constants, @NotNull List<InputArg> args) {
        Intrinsics.checkNotNullParameter(functions, (String)"functions");
        Intrinsics.checkNotNullParameter(constants, (String)"constants");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        this.functions = functions;
        this.constants = constants;
        this.args = args;
    }

    @NotNull
    public final List<Function> getFunctions() {
        return this.functions;
    }

    @NotNull
    public final List<Function> getConstants() {
        return this.constants;
    }

    @NotNull
    public final List<InputArg> getArgs() {
        return this.args;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0013\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013\u00a8\u0006\u0014"}, d2={"Lorg/rust/lang/core/mir/lldb/MirLldbBridge$BinaryOperator;", "", "<init>", "(Ljava/lang/String;I)V", "Equal", "NotEqual", "Less", "LessEqual", "Greater", "GreaterEqual", "LeftShift", "RightShift", "BitOr", "BitAnd", "BitXor", "Plus", "Minus", "Mult", "Div", "Mod", "intellij.rustrover.core"})
    public static final class BinaryOperator
    extends Enum<BinaryOperator> {
        public static final /* enum */ BinaryOperator Equal = new BinaryOperator();
        public static final /* enum */ BinaryOperator NotEqual = new BinaryOperator();
        public static final /* enum */ BinaryOperator Less = new BinaryOperator();
        public static final /* enum */ BinaryOperator LessEqual = new BinaryOperator();
        public static final /* enum */ BinaryOperator Greater = new BinaryOperator();
        public static final /* enum */ BinaryOperator GreaterEqual = new BinaryOperator();
        public static final /* enum */ BinaryOperator LeftShift = new BinaryOperator();
        public static final /* enum */ BinaryOperator RightShift = new BinaryOperator();
        public static final /* enum */ BinaryOperator BitOr = new BinaryOperator();
        public static final /* enum */ BinaryOperator BitAnd = new BinaryOperator();
        public static final /* enum */ BinaryOperator BitXor = new BinaryOperator();
        public static final /* enum */ BinaryOperator Plus = new BinaryOperator();
        public static final /* enum */ BinaryOperator Minus = new BinaryOperator();
        public static final /* enum */ BinaryOperator Mult = new BinaryOperator();
        public static final /* enum */ BinaryOperator Div = new BinaryOperator();
        public static final /* enum */ BinaryOperator Mod = new BinaryOperator();
        private static final /* synthetic */ BinaryOperator[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static BinaryOperator[] values() {
            return (BinaryOperator[])$VALUES.clone();
        }

        public static BinaryOperator valueOf(String value) {
            return Enum.valueOf(BinaryOperator.class, value);
        }

        @NotNull
        public static EnumEntries<BinaryOperator> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = binaryOperatorArray = new BinaryOperator[]{BinaryOperator.Equal, BinaryOperator.NotEqual, BinaryOperator.Less, BinaryOperator.LessEqual, BinaryOperator.Greater, BinaryOperator.GreaterEqual, BinaryOperator.LeftShift, BinaryOperator.RightShift, BinaryOperator.BitOr, BinaryOperator.BitAnd, BinaryOperator.BitXor, BinaryOperator.Plus, BinaryOperator.Minus, BinaryOperator.Mult, BinaryOperator.Div, BinaryOperator.Mod};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Block;", "", "statements", "", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Statement;", "terminator", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Terminator;", "<init>", "(Ljava/util/List;Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Terminator;)V", "getStatements", "()Ljava/util/List;", "getTerminator", "()Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Terminator;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.rustrover.core"})
    public static final class Block {
        @NotNull
        private final List<Statement> statements;
        @NotNull
        private final Terminator terminator;

        public Block(@NotNull List<Statement> statements, @NotNull Terminator terminator) {
            Intrinsics.checkNotNullParameter(statements, (String)"statements");
            Intrinsics.checkNotNullParameter((Object)terminator, (String)"terminator");
            this.statements = statements;
            this.terminator = terminator;
        }

        @NotNull
        public final List<Statement> getStatements() {
            return this.statements;
        }

        @NotNull
        public final Terminator getTerminator() {
            return this.terminator;
        }

        @NotNull
        public final List<Statement> component1() {
            return this.statements;
        }

        @NotNull
        public final Terminator component2() {
            return this.terminator;
        }

        @NotNull
        public final Block copy(@NotNull List<Statement> statements, @NotNull Terminator terminator) {
            Intrinsics.checkNotNullParameter(statements, (String)"statements");
            Intrinsics.checkNotNullParameter((Object)terminator, (String)"terminator");
            return new Block(statements, terminator);
        }

        public static /* synthetic */ Block copy$default(Block block, List list, Terminator terminator, int n, Object object) {
            if ((n & 1) != 0) {
                list = block.statements;
            }
            if ((n & 2) != 0) {
                terminator = block.terminator;
            }
            return block.copy(list, terminator);
        }

        @NotNull
        public String toString() {
            return "Block(statements=" + this.statements + ", terminator=" + this.terminator + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.statements).hashCode();
            result2 = result2 * 31 + this.terminator.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Block)) {
                return false;
            }
            Block block = (Block)other;
            if (!Intrinsics.areEqual(this.statements, block.statements)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.terminator, (Object)block.terminator);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/rust/lang/core/mir/lldb/MirLldbBridge$CastKind;", "", "<init>", "(Ljava/lang/String;I)V", "Scalar", "PointerCoercion", "intellij.rustrover.core"})
    public static final class CastKind
    extends Enum<CastKind> {
        public static final /* enum */ CastKind Scalar = new CastKind();
        public static final /* enum */ CastKind PointerCoercion = new CastKind();
        private static final /* synthetic */ CastKind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static CastKind[] values() {
            return (CastKind[])$VALUES.clone();
        }

        public static CastKind valueOf(String value) {
            return Enum.valueOf(CastKind.class, value);
        }

        @NotNull
        public static EnumEntries<CastKind> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = castKindArray = new CastKind[]{CastKind.Scalar, CastKind.PointerCoercion};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J8\u0010\u0004\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u0012\u0004\u0012\u00020\t0\u00052\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ8\u0010\u0004\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u0012\u0004\u0012\u00020\t0\u00052\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ8\u0010\u0004\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u0012\u0004\u0012\u00020\t0\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0014"}, d2={"Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Companion;", "", "<init>", "()V", "transform", "Lorg/rust/stdext/RsResult;", "Lkotlin/Pair;", "", "Lorg/rust/lang/core/mir/lldb/SuppressedErrors;", "Lorg/rust/lang/core/mir/lldb/MirLldbException;", "expr", "Lorg/rust/lang/core/psi/RsDebuggerExpressionCodeFragment;", "prettyPrint", "", "targetParams", "Lorg/rust/lang/core/mir/TargetProcessParams;", "function", "Lorg/rust/lang/core/psi/RsFunction;", "entry", "Lorg/rust/lang/core/mir/lldb/MirLldbInliningEntry;", "intellij.rustrover.core"})
    @SourceDebugExtension(value={"SMAP\nMirLldbBridge.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MirLldbBridge.kt\norg/rust/lang/core/mir/lldb/MirLldbBridge$Companion\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 MirLldbBridge.kt\norg/rust/lang/core/mir/lldb/VariantTypeAdapterFactory$Companion\n*L\n1#1,389:1\n52#2:390\n377#3:391\n377#3:392\n377#3:393\n377#3:394\n377#3:395\n*S KotlinDebug\n*F\n+ 1 MirLldbBridge.kt\norg/rust/lang/core/mir/lldb/MirLldbBridge$Companion\n*L\n260#1:390\n266#1:391\n267#1:392\n268#1:393\n269#1:394\n270#1:395\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RsResult<Pair<String, SuppressedErrors>, MirLldbException> transform(@NotNull RsDebuggerExpressionCodeFragment expr, boolean prettyPrint, @NotNull TargetProcessParams targetParams) {
            Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
            Intrinsics.checkNotNullParameter((Object)targetParams, (String)"targetParams");
            return this.transform(MirLldbInliningEntry.Companion.from(expr), prettyPrint, targetParams);
        }

        public static /* synthetic */ RsResult transform$default(Companion companion, RsDebuggerExpressionCodeFragment rsDebuggerExpressionCodeFragment, boolean bl, TargetProcessParams targetProcessParams, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.transform(rsDebuggerExpressionCodeFragment, bl, targetProcessParams);
        }

        @NotNull
        public final RsResult<Pair<String, SuppressedErrors>, MirLldbException> transform(@NotNull RsFunction function, boolean prettyPrint, @NotNull TargetProcessParams targetParams) {
            Intrinsics.checkNotNullParameter((Object)function, (String)"function");
            Intrinsics.checkNotNullParameter((Object)targetParams, (String)"targetParams");
            return this.transform(MirLldbInliningEntry.Companion.from(function), prettyPrint, targetParams);
        }

        public static /* synthetic */ RsResult transform$default(Companion companion, RsFunction rsFunction, boolean bl, TargetProcessParams targetProcessParams, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.transform(rsFunction, bl, targetProcessParams);
        }

        /*
         * WARNING - void declaration
         */
        private final RsResult<Pair<String, SuppressedErrors>, MirLldbException> transform(MirLldbInliningEntry entry2, boolean prettyPrint, TargetProcessParams targetParams) {
            void $this$registerSealedClass$iv;
            void $this$registerSealedClass$iv2;
            void $this$registerSealedClass$iv3;
            void $this$registerSealedClass$iv4;
            void $this$registerSealedClass$iv5;
            GsonBuilder gsonBuilder;
            Pair<MirLldbBridge, SuppressedErrors> pair;
            try {
                pair = MirLldbAdapter.Companion.convertAndInline(entry2, targetParams);
            }
            catch (MirLldbException e) {
                return new RsResult.Err<MirLldbException>(e);
            }
            Pair<MirLldbBridge, SuppressedErrors> pair2 = pair;
            MirLldbBridge bridge = (MirLldbBridge)pair2.component1();
            SuppressedErrors errors = (SuppressedErrors)pair2.component2();
            VariantTypeAdapterFactory.Companion companion = VariantTypeAdapterFactory.Companion;
            VariantTypeAdapterFactory.Companion companion2 = VariantTypeAdapterFactory.Companion;
            VariantTypeAdapterFactory.Companion companion3 = VariantTypeAdapterFactory.Companion;
            VariantTypeAdapterFactory.Companion companion4 = VariantTypeAdapterFactory.Companion;
            VariantTypeAdapterFactory.Companion companion5 = VariantTypeAdapterFactory.Companion;
            GsonBuilder gsonBuilder2 = new GsonBuilder();
            boolean condition$iv = prettyPrint;
            boolean $i$f$applyIf = false;
            if (condition$iv) {
                void $this$transform_u24lambda_u240 = $this$applyIf$iv;
                boolean bl = false;
                GsonBuilder gsonBuilder3 = $this$transform_u24lambda_u240.setPrettyPrinting();
                gsonBuilder = gsonBuilder3;
                Intrinsics.checkNotNullExpressionValue((Object)gsonBuilder3, (String)"setPrettyPrinting(...)");
            } else {
                gsonBuilder = $this$applyIf$iv;
            }
            GsonBuilder gsonBuilder4 = gsonBuilder.setFieldNamingPolicy(FieldNamingPolicy.UPPER_CAMEL_CASE).registerTypeAdapterFactory((TypeAdapterFactory)new OperandPlaceAdapterFactory()).registerTypeAdapterFactory((TypeAdapterFactory)new ScalarFloatTypeAdapterFactory());
            Intrinsics.checkNotNullExpressionValue((Object)gsonBuilder4, (String)"registerTypeAdapterFactory(...)");
            GsonBuilder gsonBuilder5 = gsonBuilder4;
            boolean $i$f$registerSealedClass = false;
            GsonBuilder gsonBuilder6 = $this$registerSealedClass$iv5.registerTypeAdapterFactory((TypeAdapterFactory)new VariantTypeAdapterFactory(Reflection.getOrCreateKotlinClass(Operand.class), null));
            Intrinsics.checkNotNullExpressionValue((Object)gsonBuilder6, (String)"registerTypeAdapterFactory(...)");
            GsonBuilder this_$iv = gsonBuilder6;
            boolean $i$f$registerSealedClass2 = false;
            GsonBuilder gsonBuilder7 = $this$registerSealedClass$iv4.registerTypeAdapterFactory((TypeAdapterFactory)new VariantTypeAdapterFactory(Reflection.getOrCreateKotlinClass(Projection.class), null));
            Intrinsics.checkNotNullExpressionValue((Object)gsonBuilder7, (String)"registerTypeAdapterFactory(...)");
            GsonBuilder this_$iv2 = gsonBuilder7;
            boolean $i$f$registerSealedClass3 = false;
            GsonBuilder gsonBuilder8 = $this$registerSealedClass$iv3.registerTypeAdapterFactory((TypeAdapterFactory)new VariantTypeAdapterFactory(Reflection.getOrCreateKotlinClass(Rvalue.class), null));
            Intrinsics.checkNotNullExpressionValue((Object)gsonBuilder8, (String)"registerTypeAdapterFactory(...)");
            GsonBuilder this_$iv3 = gsonBuilder8;
            boolean $i$f$registerSealedClass4 = false;
            GsonBuilder gsonBuilder9 = $this$registerSealedClass$iv2.registerTypeAdapterFactory((TypeAdapterFactory)new VariantTypeAdapterFactory(Reflection.getOrCreateKotlinClass(Terminator.class), null));
            Intrinsics.checkNotNullExpressionValue((Object)gsonBuilder9, (String)"registerTypeAdapterFactory(...)");
            GsonBuilder this_$iv4 = gsonBuilder9;
            boolean $i$f$registerSealedClass5 = false;
            GsonBuilder gsonBuilder10 = $this$registerSealedClass$iv.registerTypeAdapterFactory((TypeAdapterFactory)new VariantTypeAdapterFactory(Reflection.getOrCreateKotlinClass(Rvalue.Aggregate.Kind.class), null));
            Intrinsics.checkNotNullExpressionValue((Object)gsonBuilder10, (String)"registerTypeAdapterFactory(...)");
            Gson gson = gsonBuilder10.create();
            String json = gson.toJson((Object)bridge);
            return new RsResult.Ok<Pair>(TuplesKt.to((Object)json, (Object)errors));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u001d\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J!\u0010\u000e\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c2\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Function;", "", "qualifiedName", "", "body", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$FunctionBody;", "<init>", "(Ljava/lang/String;Lorg/rust/lang/core/mir/lldb/MirLldbBridge$FunctionBody;)V", "getQualifiedName", "()Ljava/lang/String;", "getBody", "()Lorg/rust/lang/core/mir/lldb/MirLldbBridge$FunctionBody;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "intellij.rustrover.core"})
    public static final class Function {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final String qualifiedName;
        @Nullable
        private final FunctionBody body;

        private Function(String qualifiedName, FunctionBody body) {
            this.qualifiedName = qualifiedName;
            this.body = body;
        }

        @Nullable
        public final String getQualifiedName() {
            return this.qualifiedName;
        }

        @Nullable
        public final FunctionBody getBody() {
            return this.body;
        }

        @Nullable
        public final String component1() {
            return this.qualifiedName;
        }

        @Nullable
        public final FunctionBody component2() {
            return this.body;
        }

        private final Function copy(String qualifiedName, FunctionBody body) {
            return new Function(qualifiedName, body);
        }

        static /* synthetic */ Function copy$default(Function function, String string, FunctionBody functionBody, int n, Object object) {
            if ((n & 1) != 0) {
                string = function.qualifiedName;
            }
            if ((n & 2) != 0) {
                functionBody = function.body;
            }
            return function.copy(string, functionBody);
        }

        @NotNull
        public String toString() {
            return "Function(qualifiedName=" + this.qualifiedName + ", body=" + this.body + ")";
        }

        public int hashCode() {
            int result2 = this.qualifiedName == null ? 0 : this.qualifiedName.hashCode();
            result2 = result2 * 31 + (this.body == null ? 0 : this.body.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Function)) {
                return false;
            }
            Function function = (Function)other;
            if (!Intrinsics.areEqual((Object)this.qualifiedName, (Object)function.qualifiedName)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.body, (Object)function.body);
        }

        public /* synthetic */ Function(String qualifiedName, FunctionBody body, DefaultConstructorMarker $constructor_marker) {
            this(qualifiedName, body);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Function$Companion;", "", "<init>", "()V", "create", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Function;", "qualifiedName", "", "body", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$FunctionBody;", "intellij.rustrover.core"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Function create(@NotNull String qualifiedName) {
                Intrinsics.checkNotNullParameter((Object)qualifiedName, (String)"qualifiedName");
                return new Function(qualifiedName, null, null);
            }

            @NotNull
            public final Function create(@Nullable String qualifiedName, @NotNull FunctionBody body) {
                Intrinsics.checkNotNullParameter((Object)body, (String)"body");
                return new Function(qualifiedName, body, null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J=\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\b\b\u0002\u0010\t\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\r\u00a8\u0006\u001d"}, d2={"Lorg/rust/lang/core/mir/lldb/MirLldbBridge$FunctionBody;", "", "localsSize", "", "args", "", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Local;", "blocks", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Block;", "returnLocalIndex", "<init>", "(ILjava/util/List;Ljava/util/List;I)V", "getLocalsSize", "()I", "getArgs", "()Ljava/util/List;", "getBlocks", "getReturnLocalIndex", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.rustrover.core"})
    public static final class FunctionBody {
        private final int localsSize;
        @NotNull
        private final List<Local> args;
        @NotNull
        private final List<Block> blocks;
        private final int returnLocalIndex;

        public FunctionBody(int localsSize, @NotNull List<Local> args, @NotNull List<Block> blocks, int returnLocalIndex) {
            Intrinsics.checkNotNullParameter(args, (String)"args");
            Intrinsics.checkNotNullParameter(blocks, (String)"blocks");
            this.localsSize = localsSize;
            this.args = args;
            this.blocks = blocks;
            this.returnLocalIndex = returnLocalIndex;
        }

        public final int getLocalsSize() {
            return this.localsSize;
        }

        @NotNull
        public final List<Local> getArgs() {
            return this.args;
        }

        @NotNull
        public final List<Block> getBlocks() {
            return this.blocks;
        }

        public final int getReturnLocalIndex() {
            return this.returnLocalIndex;
        }

        public final int component1() {
            return this.localsSize;
        }

        @NotNull
        public final List<Local> component2() {
            return this.args;
        }

        @NotNull
        public final List<Block> component3() {
            return this.blocks;
        }

        public final int component4() {
            return this.returnLocalIndex;
        }

        @NotNull
        public final FunctionBody copy(int localsSize, @NotNull List<Local> args, @NotNull List<Block> blocks, int returnLocalIndex) {
            Intrinsics.checkNotNullParameter(args, (String)"args");
            Intrinsics.checkNotNullParameter(blocks, (String)"blocks");
            return new FunctionBody(localsSize, args, blocks, returnLocalIndex);
        }

        public static /* synthetic */ FunctionBody copy$default(FunctionBody functionBody, int n, List list, List list2, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = functionBody.localsSize;
            }
            if ((n3 & 2) != 0) {
                list = functionBody.args;
            }
            if ((n3 & 4) != 0) {
                list2 = functionBody.blocks;
            }
            if ((n3 & 8) != 0) {
                n2 = functionBody.returnLocalIndex;
            }
            return functionBody.copy(n, list, list2, n2);
        }

        @NotNull
        public String toString() {
            return "FunctionBody(localsSize=" + this.localsSize + ", args=" + this.args + ", blocks=" + this.blocks + ", returnLocalIndex=" + this.returnLocalIndex + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.localsSize);
            result2 = result2 * 31 + ((Object)this.args).hashCode();
            result2 = result2 * 31 + ((Object)this.blocks).hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.returnLocalIndex);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FunctionBody)) {
                return false;
            }
            FunctionBody functionBody = (FunctionBody)other;
            if (this.localsSize != functionBody.localsSize) {
                return false;
            }
            if (!Intrinsics.areEqual(this.args, functionBody.args)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.blocks, functionBody.blocks)) {
                return false;
            }
            return this.returnLocalIndex == functionBody.returnLocalIndex;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/rust/lang/core/mir/lldb/MirLldbBridge$InputArg;", "", "name", "", "<init>", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.rustrover.core"})
    public static final class InputArg {
        @NotNull
        private final String name;

        public InputArg(@NotNull String name2) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            this.name = name2;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final InputArg copy(@NotNull String name2) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            return new InputArg(name2);
        }

        public static /* synthetic */ InputArg copy$default(InputArg inputArg, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = inputArg.name;
            }
            return inputArg.copy(string);
        }

        @NotNull
        public String toString() {
            return "InputArg(name=" + this.name + ")";
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof InputArg)) {
                return false;
            }
            InputArg inputArg = (InputArg)other;
            return Intrinsics.areEqual((Object)this.name, (Object)inputArg.name);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Local;", "", "localIndex", "", "<init>", "(I)V", "getLocalIndex", "()I", "component1", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.rustrover.core"})
    public static final class Local {
        private final int localIndex;

        public Local(int localIndex) {
            this.localIndex = localIndex;
        }

        public final int getLocalIndex() {
            return this.localIndex;
        }

        public final int component1() {
            return this.localIndex;
        }

        @NotNull
        public final Local copy(int localIndex) {
            return new Local(localIndex);
        }

        public static /* synthetic */ Local copy$default(Local local, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = local.localIndex;
            }
            return local.copy(n);
        }

        @NotNull
        public String toString() {
            return "Local(localIndex=" + this.localIndex + ")";
        }

        public int hashCode() {
            return Integer.hashCode(this.localIndex);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Local)) {
                return false;
            }
            Local local = (Local)other;
            return this.localIndex == local.localIndex;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0004\u0004\u0005\u0006\u0007B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0004\b\t\n\u000b\u00a8\u0006\f"}, d2={"Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Operand;", "", "<init>", "()V", "Scalar", "ZeroSized", "Place", "UnevaluatedConstant", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Operand$Place;", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Operand$Scalar;", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Operand$UnevaluatedConstant;", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Operand$ZeroSized;", "intellij.rustrover.core"})
    public static abstract sealed class Operand {
        private Operand() {
        }

        public /* synthetic */ Operand(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Operand$Place;", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Operand;", "value", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Place;", "<init>", "(Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Place;)V", "getValue", "()Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Place;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.rustrover.core"})
        public static final class Place
        extends Operand {
            @NotNull
            private final org.rust.lang.core.mir.lldb.MirLldbBridge$Place value;

            public Place(@NotNull org.rust.lang.core.mir.lldb.MirLldbBridge$Place value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                super(null);
                this.value = value;
            }

            @NotNull
            public final org.rust.lang.core.mir.lldb.MirLldbBridge$Place getValue() {
                return this.value;
            }

            @NotNull
            public final org.rust.lang.core.mir.lldb.MirLldbBridge$Place component1() {
                return this.value;
            }

            @NotNull
            public final Place copy(@NotNull org.rust.lang.core.mir.lldb.MirLldbBridge$Place value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return new Place(value);
            }

            public static /* synthetic */ Place copy$default(Place place, org.rust.lang.core.mir.lldb.MirLldbBridge$Place place2, int n, Object object) {
                if ((n & 1) != 0) {
                    place2 = place.value;
                }
                return place.copy(place2);
            }

            @NotNull
            public String toString() {
                return "Place(value=" + this.value + ")";
            }

            public int hashCode() {
                return this.value.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Place)) {
                    return false;
                }
                Place place = (Place)other;
                return Intrinsics.areEqual((Object)this.value, (Object)place.value);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0005H\u00d6\u0001R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Operand$Scalar;", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Operand;", "scalar", "", "ty", "", "<init>", "(JLjava/lang/String;)V", "getScalar", "()J", "getTy", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.rustrover.core"})
        public static final class Scalar
        extends Operand {
            @SerializedName(value="Val")
            private final long scalar;
            @NotNull
            private final String ty;

            public Scalar(long scalar, @NotNull String ty2) {
                Intrinsics.checkNotNullParameter((Object)ty2, (String)"ty");
                super(null);
                this.scalar = scalar;
                this.ty = ty2;
            }

            public final long getScalar() {
                return this.scalar;
            }

            @NotNull
            public final String getTy() {
                return this.ty;
            }

            public final long component1() {
                return this.scalar;
            }

            @NotNull
            public final String component2() {
                return this.ty;
            }

            @NotNull
            public final Scalar copy(long scalar, @NotNull String ty2) {
                Intrinsics.checkNotNullParameter((Object)ty2, (String)"ty");
                return new Scalar(scalar, ty2);
            }

            public static /* synthetic */ Scalar copy$default(Scalar scalar, long l, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    l = scalar.scalar;
                }
                if ((n & 2) != 0) {
                    string = scalar.ty;
                }
                return scalar.copy(l, string);
            }

            @NotNull
            public String toString() {
                return "Scalar(scalar=" + this.scalar + ", ty=" + this.ty + ")";
            }

            public int hashCode() {
                int result2 = Long.hashCode(this.scalar);
                result2 = result2 * 31 + this.ty.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Scalar)) {
                    return false;
                }
                Scalar scalar = (Scalar)other;
                if (this.scalar != scalar.scalar) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.ty, (Object)scalar.ty);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Operand$UnevaluatedConstant;", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Operand;", "constantIndex", "", "<init>", "(I)V", "getConstantIndex", "()I", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "", "intellij.rustrover.core"})
        public static final class UnevaluatedConstant
        extends Operand {
            private final int constantIndex;

            public UnevaluatedConstant(int constantIndex) {
                super(null);
                this.constantIndex = constantIndex;
            }

            public final int getConstantIndex() {
                return this.constantIndex;
            }

            public final int component1() {
                return this.constantIndex;
            }

            @NotNull
            public final UnevaluatedConstant copy(int constantIndex) {
                return new UnevaluatedConstant(constantIndex);
            }

            public static /* synthetic */ UnevaluatedConstant copy$default(UnevaluatedConstant unevaluatedConstant, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = unevaluatedConstant.constantIndex;
                }
                return unevaluatedConstant.copy(n);
            }

            @NotNull
            public String toString() {
                return "UnevaluatedConstant(constantIndex=" + this.constantIndex + ")";
            }

            public int hashCode() {
                return Integer.hashCode(this.constantIndex);
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof UnevaluatedConstant)) {
                    return false;
                }
                UnevaluatedConstant unevaluatedConstant = (UnevaluatedConstant)other;
                return this.constantIndex == unevaluatedConstant.constantIndex;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Operand$ZeroSized;", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Operand;", "ty", "", "<init>", "(Ljava/lang/String;)V", "getTy", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.rustrover.core"})
        public static final class ZeroSized
        extends Operand {
            @NotNull
            private final String ty;

            public ZeroSized(@NotNull String ty2) {
                Intrinsics.checkNotNullParameter((Object)ty2, (String)"ty");
                super(null);
                this.ty = ty2;
            }

            @NotNull
            public final String getTy() {
                return this.ty;
            }

            @NotNull
            public final String component1() {
                return this.ty;
            }

            @NotNull
            public final ZeroSized copy(@NotNull String ty2) {
                Intrinsics.checkNotNullParameter((Object)ty2, (String)"ty");
                return new ZeroSized(ty2);
            }

            public static /* synthetic */ ZeroSized copy$default(ZeroSized zeroSized, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = zeroSized.ty;
                }
                return zeroSized.copy(string);
            }

            @NotNull
            public String toString() {
                return "ZeroSized(ty=" + this.ty + ")";
            }

            public int hashCode() {
                return this.ty.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ZeroSized)) {
                    return false;
                }
                ZeroSized zeroSized = (ZeroSized)other;
                return Intrinsics.areEqual((Object)this.ty, (Object)zeroSized.ty);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Place;", "", "localIndex", "", "projections", "", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Projection;", "<init>", "(ILjava/util/List;)V", "getLocalIndex", "()I", "getProjections", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.rustrover.core"})
    public static final class Place {
        private final int localIndex;
        @NotNull
        private final List<Projection> projections;

        public Place(int localIndex, @NotNull List<? extends Projection> projections) {
            Intrinsics.checkNotNullParameter(projections, (String)"projections");
            this.localIndex = localIndex;
            this.projections = projections;
        }

        public final int getLocalIndex() {
            return this.localIndex;
        }

        @NotNull
        public final List<Projection> getProjections() {
            return this.projections;
        }

        public final int component1() {
            return this.localIndex;
        }

        @NotNull
        public final List<Projection> component2() {
            return this.projections;
        }

        @NotNull
        public final Place copy(int localIndex, @NotNull List<? extends Projection> projections) {
            Intrinsics.checkNotNullParameter(projections, (String)"projections");
            return new Place(localIndex, projections);
        }

        public static /* synthetic */ Place copy$default(Place place, int n, List list, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = place.localIndex;
            }
            if ((n2 & 2) != 0) {
                list = place.projections;
            }
            return place.copy(n, list);
        }

        @NotNull
        public String toString() {
            return "Place(localIndex=" + this.localIndex + ", projections=" + this.projections + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.localIndex);
            result2 = result2 * 31 + ((Object)this.projections).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Place)) {
                return false;
            }
            Place place = (Place)other;
            if (this.localIndex != place.localIndex) {
                return false;
            }
            return Intrinsics.areEqual(this.projections, place.projections);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0006\u0004\u0005\u0006\u0007\b\tB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0006\n\u000b\f\r\u000e\u000f\u00a8\u0006\u0010"}, d2={"Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Projection;", "", "<init>", "()V", "Deref", "Field", "Index", "ConstantIndex", "Subslice", "Downcast", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Projection$ConstantIndex;", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Projection$Deref;", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Projection$Downcast;", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Projection$Field;", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Projection$Index;", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Projection$Subslice;", "intellij.rustrover.core"})
    public static abstract sealed class Projection {
        private Projection() {
        }

        public /* synthetic */ Projection(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Projection$ConstantIndex;", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Projection;", "offset", "", "fromEnd", "", "<init>", "(JZ)V", "getOffset", "()J", "getFromEnd", "()Z", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "toString", "", "intellij.rustrover.core"})
        public static final class ConstantIndex
        extends Projection {
            private final long offset;
            private final boolean fromEnd;

            public ConstantIndex(long offset, boolean fromEnd) {
                super(null);
                this.offset = offset;
                this.fromEnd = fromEnd;
            }

            public final long getOffset() {
                return this.offset;
            }

            public final boolean getFromEnd() {
                return this.fromEnd;
            }

            public final long component1() {
                return this.offset;
            }

            public final boolean component2() {
                return this.fromEnd;
            }

            @NotNull
            public final ConstantIndex copy(long offset, boolean fromEnd) {
                return new ConstantIndex(offset, fromEnd);
            }

            public static /* synthetic */ ConstantIndex copy$default(ConstantIndex constantIndex, long l, boolean bl, int n, Object object) {
                if ((n & 1) != 0) {
                    l = constantIndex.offset;
                }
                if ((n & 2) != 0) {
                    bl = constantIndex.fromEnd;
                }
                return constantIndex.copy(l, bl);
            }

            @NotNull
            public String toString() {
                return "ConstantIndex(offset=" + this.offset + ", fromEnd=" + this.fromEnd + ")";
            }

            public int hashCode() {
                int result2 = Long.hashCode(this.offset);
                result2 = result2 * 31 + Boolean.hashCode(this.fromEnd);
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ConstantIndex)) {
                    return false;
                }
                ConstantIndex constantIndex = (ConstantIndex)other;
                if (this.offset != constantIndex.offset) {
                    return false;
                }
                return this.fromEnd == constantIndex.fromEnd;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Projection$Deref;", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Projection;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.rustrover.core"})
        public static final class Deref
        extends Projection {
            @NotNull
            public static final Deref INSTANCE = new Deref();

            private Deref() {
                super(null);
            }

            @NotNull
            public String toString() {
                return "Deref";
            }

            public int hashCode() {
                return -458612307;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Deref)) {
                    return false;
                }
                Deref cfr_ignored_0 = (Deref)other;
                return true;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Projection$Downcast;", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Projection;", "varIndex", "", "<init>", "(I)V", "getVarIndex", "()I", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "", "intellij.rustrover.core"})
        public static final class Downcast
        extends Projection {
            private final int varIndex;

            public Downcast(int varIndex) {
                super(null);
                this.varIndex = varIndex;
            }

            public final int getVarIndex() {
                return this.varIndex;
            }

            public final int component1() {
                return this.varIndex;
            }

            @NotNull
            public final Downcast copy(int varIndex) {
                return new Downcast(varIndex);
            }

            public static /* synthetic */ Downcast copy$default(Downcast downcast, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = downcast.varIndex;
                }
                return downcast.copy(n);
            }

            @NotNull
            public String toString() {
                return "Downcast(varIndex=" + this.varIndex + ")";
            }

            public int hashCode() {
                return Integer.hashCode(this.varIndex);
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Downcast)) {
                    return false;
                }
                Downcast downcast = (Downcast)other;
                return this.varIndex == downcast.varIndex;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Projection$Field;", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Projection;", "name", "", "<init>", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.rustrover.core"})
        public static final class Field
        extends Projection {
            @NotNull
            private final String name;

            public Field(@NotNull String name2) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                super(null);
                this.name = name2;
            }

            @NotNull
            public final String getName() {
                return this.name;
            }

            @NotNull
            public final String component1() {
                return this.name;
            }

            @NotNull
            public final Field copy(@NotNull String name2) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                return new Field(name2);
            }

            public static /* synthetic */ Field copy$default(Field field, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = field.name;
                }
                return field.copy(string);
            }

            @NotNull
            public String toString() {
                return "Field(name=" + this.name + ")";
            }

            public int hashCode() {
                return this.name.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Field)) {
                    return false;
                }
                Field field = (Field)other;
                return Intrinsics.areEqual((Object)this.name, (Object)field.name);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Projection$Index;", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Projection;", "localIndex", "", "<init>", "(I)V", "getLocalIndex", "()I", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "", "intellij.rustrover.core"})
        public static final class Index
        extends Projection {
            private final int localIndex;

            public Index(int localIndex) {
                super(null);
                this.localIndex = localIndex;
            }

            public final int getLocalIndex() {
                return this.localIndex;
            }

            public final int component1() {
                return this.localIndex;
            }

            @NotNull
            public final Index copy(int localIndex) {
                return new Index(localIndex);
            }

            public static /* synthetic */ Index copy$default(Index index, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = index.localIndex;
                }
                return index.copy(n);
            }

            @NotNull
            public String toString() {
                return "Index(localIndex=" + this.localIndex + ")";
            }

            public int hashCode() {
                return Integer.hashCode(this.localIndex);
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Index)) {
                    return false;
                }
                Index index = (Index)other;
                return this.localIndex == index.localIndex;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0019"}, d2={"Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Projection$Subslice;", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Projection;", "from", "", "to", "fromEnd", "", "<init>", "(JJZ)V", "getFrom", "()J", "getTo", "getFromEnd", "()Z", "component1", "component2", "component3", "copy", "equals", "other", "", "hashCode", "", "toString", "", "intellij.rustrover.core"})
        public static final class Subslice
        extends Projection {
            private final long from;
            private final long to;
            private final boolean fromEnd;

            public Subslice(long from, long to, boolean fromEnd) {
                super(null);
                this.from = from;
                this.to = to;
                this.fromEnd = fromEnd;
            }

            public final long getFrom() {
                return this.from;
            }

            public final long getTo() {
                return this.to;
            }

            public final boolean getFromEnd() {
                return this.fromEnd;
            }

            public final long component1() {
                return this.from;
            }

            public final long component2() {
                return this.to;
            }

            public final boolean component3() {
                return this.fromEnd;
            }

            @NotNull
            public final Subslice copy(long from, long to, boolean fromEnd) {
                return new Subslice(from, to, fromEnd);
            }

            public static /* synthetic */ Subslice copy$default(Subslice subslice, long l, long l2, boolean bl, int n, Object object) {
                if ((n & 1) != 0) {
                    l = subslice.from;
                }
                if ((n & 2) != 0) {
                    l2 = subslice.to;
                }
                if ((n & 4) != 0) {
                    bl = subslice.fromEnd;
                }
                return subslice.copy(l, l2, bl);
            }

            @NotNull
            public String toString() {
                return "Subslice(from=" + this.from + ", to=" + this.to + ", fromEnd=" + this.fromEnd + ")";
            }

            public int hashCode() {
                int result2 = Long.hashCode(this.from);
                result2 = result2 * 31 + Long.hashCode(this.to);
                result2 = result2 * 31 + Boolean.hashCode(this.fromEnd);
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Subslice)) {
                    return false;
                }
                Subslice subslice = (Subslice)other;
                if (this.from != subslice.from) {
                    return false;
                }
                if (this.to != subslice.to) {
                    return false;
                }
                return this.fromEnd == subslice.fromEnd;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\t\u0004\u0005\u0006\u0007\b\t\n\u000b\fB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\t\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u00a8\u0006\u0016"}, d2={"Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Rvalue;", "", "<init>", "()V", "Operand", "BinaryExpression", "UnaryExpression", "Discriminant", "Ref", "Len", "Aggregate", "Repeat", "Cast", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Rvalue$Aggregate;", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Rvalue$BinaryExpression;", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Rvalue$Cast;", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Rvalue$Discriminant;", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Rvalue$Len;", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Rvalue$Operand;", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Rvalue$Ref;", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Rvalue$Repeat;", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Rvalue$UnaryExpression;", "intellij.rustrover.core"})
    public static abstract sealed class Rvalue {
        private Rvalue() {
        }

        public /* synthetic */ Rvalue(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u0002\u0018\u0019B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001a"}, d2={"Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Rvalue$Aggregate;", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Rvalue;", "kind", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Rvalue$Aggregate$Kind;", "operands", "", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Operand;", "<init>", "(Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Rvalue$Aggregate$Kind;Ljava/util/List;)V", "getKind", "()Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Rvalue$Aggregate$Kind;", "getOperands", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "Discr", "Kind", "intellij.rustrover.core"})
        public static final class Aggregate
        extends Rvalue {
            @NotNull
            private final Kind kind;
            @NotNull
            private final List<org.rust.lang.core.mir.lldb.MirLldbBridge$Operand> operands;

            public Aggregate(@NotNull Kind kind2, @NotNull List<? extends org.rust.lang.core.mir.lldb.MirLldbBridge$Operand> operands) {
                Intrinsics.checkNotNullParameter((Object)kind2, (String)"kind");
                Intrinsics.checkNotNullParameter(operands, (String)"operands");
                super(null);
                this.kind = kind2;
                this.operands = operands;
            }

            @NotNull
            public final Kind getKind() {
                return this.kind;
            }

            @NotNull
            public final List<org.rust.lang.core.mir.lldb.MirLldbBridge$Operand> getOperands() {
                return this.operands;
            }

            @NotNull
            public final Kind component1() {
                return this.kind;
            }

            @NotNull
            public final List<org.rust.lang.core.mir.lldb.MirLldbBridge$Operand> component2() {
                return this.operands;
            }

            @NotNull
            public final Aggregate copy(@NotNull Kind kind2, @NotNull List<? extends org.rust.lang.core.mir.lldb.MirLldbBridge$Operand> operands) {
                Intrinsics.checkNotNullParameter((Object)kind2, (String)"kind");
                Intrinsics.checkNotNullParameter(operands, (String)"operands");
                return new Aggregate(kind2, operands);
            }

            public static /* synthetic */ Aggregate copy$default(Aggregate aggregate, Kind kind2, List list, int n, Object object) {
                if ((n & 1) != 0) {
                    kind2 = aggregate.kind;
                }
                if ((n & 2) != 0) {
                    list = aggregate.operands;
                }
                return aggregate.copy(kind2, list);
            }

            @NotNull
            public String toString() {
                return "Aggregate(kind=" + this.kind + ", operands=" + this.operands + ")";
            }

            public int hashCode() {
                int result2 = this.kind.hashCode();
                result2 = result2 * 31 + ((Object)this.operands).hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Aggregate)) {
                    return false;
                }
                Aggregate aggregate = (Aggregate)other;
                if (!Intrinsics.areEqual((Object)this.kind, (Object)aggregate.kind)) {
                    return false;
                }
                return Intrinsics.areEqual(this.operands, aggregate.operands);
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Rvalue$Aggregate$Discr;", "", "value", "", "name", "", "<init>", "(JLjava/lang/String;)V", "getValue", "()J", "getName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.rustrover.core"})
            public static final class Discr {
                private final long value;
                @NotNull
                private final String name;

                public Discr(long value, @NotNull String name2) {
                    Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                    this.value = value;
                    this.name = name2;
                }

                public final long getValue() {
                    return this.value;
                }

                @NotNull
                public final String getName() {
                    return this.name;
                }

                public final long component1() {
                    return this.value;
                }

                @NotNull
                public final String component2() {
                    return this.name;
                }

                @NotNull
                public final Discr copy(long value, @NotNull String name2) {
                    Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                    return new Discr(value, name2);
                }

                public static /* synthetic */ Discr copy$default(Discr discr, long l, String string, int n, Object object) {
                    if ((n & 1) != 0) {
                        l = discr.value;
                    }
                    if ((n & 2) != 0) {
                        string = discr.name;
                    }
                    return discr.copy(l, string);
                }

                @NotNull
                public String toString() {
                    return "Discr(value=" + this.value + ", name=" + this.name + ")";
                }

                public int hashCode() {
                    int result2 = Long.hashCode(this.value);
                    result2 = result2 * 31 + this.name.hashCode();
                    return result2;
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof Discr)) {
                        return false;
                    }
                    Discr discr = (Discr)other;
                    if (this.value != discr.value) {
                        return false;
                    }
                    return Intrinsics.areEqual((Object)this.name, (Object)discr.name);
                }
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u0004\u0005\u0006B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0003\u0007\b\t\u00a8\u0006\n"}, d2={"Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Rvalue$Aggregate$Kind;", "", "<init>", "()V", "Adt", "Tuple", "Array", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Rvalue$Aggregate$Kind$Adt;", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Rvalue$Aggregate$Kind$Array;", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Rvalue$Aggregate$Kind$Tuple;", "intellij.rustrover.core"})
            public static abstract sealed class Kind {
                private Kind() {
                }

                public /* synthetic */ Kind(DefaultConstructorMarker $constructor_marker) {
                    this();
                }

                @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J/\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Rvalue$Aggregate$Kind$Adt;", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Rvalue$Aggregate$Kind;", "name", "", "fieldNames", "", "discriminant", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Rvalue$Aggregate$Discr;", "<init>", "(Ljava/lang/String;Ljava/util/List;Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Rvalue$Aggregate$Discr;)V", "getName", "()Ljava/lang/String;", "getFieldNames", "()Ljava/util/List;", "getDiscriminant", "()Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Rvalue$Aggregate$Discr;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.rustrover.core"})
                public static final class Adt
                extends Kind {
                    @NotNull
                    private final String name;
                    @NotNull
                    private final List<String> fieldNames;
                    @Nullable
                    private final Discr discriminant;

                    public Adt(@NotNull String name2, @NotNull List<String> fieldNames, @Nullable Discr discriminant) {
                        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                        Intrinsics.checkNotNullParameter(fieldNames, (String)"fieldNames");
                        super(null);
                        this.name = name2;
                        this.fieldNames = fieldNames;
                        this.discriminant = discriminant;
                    }

                    @NotNull
                    public final String getName() {
                        return this.name;
                    }

                    @NotNull
                    public final List<String> getFieldNames() {
                        return this.fieldNames;
                    }

                    @Nullable
                    public final Discr getDiscriminant() {
                        return this.discriminant;
                    }

                    @NotNull
                    public final String component1() {
                        return this.name;
                    }

                    @NotNull
                    public final List<String> component2() {
                        return this.fieldNames;
                    }

                    @Nullable
                    public final Discr component3() {
                        return this.discriminant;
                    }

                    @NotNull
                    public final Adt copy(@NotNull String name2, @NotNull List<String> fieldNames, @Nullable Discr discriminant) {
                        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                        Intrinsics.checkNotNullParameter(fieldNames, (String)"fieldNames");
                        return new Adt(name2, fieldNames, discriminant);
                    }

                    public static /* synthetic */ Adt copy$default(Adt adt, String string, List list, Discr discr, int n, Object object) {
                        if ((n & 1) != 0) {
                            string = adt.name;
                        }
                        if ((n & 2) != 0) {
                            list = adt.fieldNames;
                        }
                        if ((n & 4) != 0) {
                            discr = adt.discriminant;
                        }
                        return adt.copy(string, list, discr);
                    }

                    @NotNull
                    public String toString() {
                        return "Adt(name=" + this.name + ", fieldNames=" + this.fieldNames + ", discriminant=" + this.discriminant + ")";
                    }

                    public int hashCode() {
                        int result2 = this.name.hashCode();
                        result2 = result2 * 31 + ((Object)this.fieldNames).hashCode();
                        result2 = result2 * 31 + (this.discriminant == null ? 0 : this.discriminant.hashCode());
                        return result2;
                    }

                    public boolean equals(@Nullable Object other) {
                        if (this == other) {
                            return true;
                        }
                        if (!(other instanceof Adt)) {
                            return false;
                        }
                        Adt adt = (Adt)other;
                        if (!Intrinsics.areEqual((Object)this.name, (Object)adt.name)) {
                            return false;
                        }
                        if (!Intrinsics.areEqual(this.fieldNames, adt.fieldNames)) {
                            return false;
                        }
                        return Intrinsics.areEqual((Object)this.discriminant, (Object)adt.discriminant);
                    }
                }

                @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Rvalue$Aggregate$Kind$Array;", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Rvalue$Aggregate$Kind;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.rustrover.core"})
                public static final class Array
                extends Kind {
                    @NotNull
                    public static final Array INSTANCE = new Array();

                    private Array() {
                        super(null);
                    }

                    @NotNull
                    public String toString() {
                        return "Array";
                    }

                    public int hashCode() {
                        return -434247805;
                    }

                    public boolean equals(@Nullable Object other) {
                        if (this == other) {
                            return true;
                        }
                        if (!(other instanceof Array)) {
                            return false;
                        }
                        Array cfr_ignored_0 = (Array)other;
                        return true;
                    }
                }

                @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Rvalue$Aggregate$Kind$Tuple;", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Rvalue$Aggregate$Kind;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.rustrover.core"})
                public static final class Tuple
                extends Kind {
                    @NotNull
                    public static final Tuple INSTANCE = new Tuple();

                    private Tuple() {
                        super(null);
                    }

                    @NotNull
                    public String toString() {
                        return "Tuple";
                    }

                    public int hashCode() {
                        return -416613134;
                    }

                    public boolean equals(@Nullable Object other) {
                        if (this == other) {
                            return true;
                        }
                        if (!(other instanceof Tuple)) {
                            return false;
                        }
                        Tuple cfr_ignored_0 = (Tuple)other;
                        return true;
                    }
                }
            }
        }

        @SerializedClassName(value="BinaryOp")
        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u001a"}, d2={"Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Rvalue$BinaryExpression;", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Rvalue;", "op", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$BinaryOperator;", "left", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Operand;", "right", "<init>", "(Lorg/rust/lang/core/mir/lldb/MirLldbBridge$BinaryOperator;Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Operand;Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Operand;)V", "getOp", "()Lorg/rust/lang/core/mir/lldb/MirLldbBridge$BinaryOperator;", "getLeft", "()Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Operand;", "getRight", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.rustrover.core"})
        public static final class BinaryExpression
        extends Rvalue {
            @NotNull
            private final BinaryOperator op;
            @NotNull
            private final org.rust.lang.core.mir.lldb.MirLldbBridge$Operand left;
            @NotNull
            private final org.rust.lang.core.mir.lldb.MirLldbBridge$Operand right;

            public BinaryExpression(@NotNull BinaryOperator op, @NotNull org.rust.lang.core.mir.lldb.MirLldbBridge$Operand left, @NotNull org.rust.lang.core.mir.lldb.MirLldbBridge$Operand right) {
                Intrinsics.checkNotNullParameter((Object)((Object)op), (String)"op");
                Intrinsics.checkNotNullParameter((Object)left, (String)"left");
                Intrinsics.checkNotNullParameter((Object)right, (String)"right");
                super(null);
                this.op = op;
                this.left = left;
                this.right = right;
            }

            @NotNull
            public final BinaryOperator getOp() {
                return this.op;
            }

            @NotNull
            public final org.rust.lang.core.mir.lldb.MirLldbBridge$Operand getLeft() {
                return this.left;
            }

            @NotNull
            public final org.rust.lang.core.mir.lldb.MirLldbBridge$Operand getRight() {
                return this.right;
            }

            @NotNull
            public final BinaryOperator component1() {
                return this.op;
            }

            @NotNull
            public final org.rust.lang.core.mir.lldb.MirLldbBridge$Operand component2() {
                return this.left;
            }

            @NotNull
            public final org.rust.lang.core.mir.lldb.MirLldbBridge$Operand component3() {
                return this.right;
            }

            @NotNull
            public final BinaryExpression copy(@NotNull BinaryOperator op, @NotNull org.rust.lang.core.mir.lldb.MirLldbBridge$Operand left, @NotNull org.rust.lang.core.mir.lldb.MirLldbBridge$Operand right) {
                Intrinsics.checkNotNullParameter((Object)((Object)op), (String)"op");
                Intrinsics.checkNotNullParameter((Object)left, (String)"left");
                Intrinsics.checkNotNullParameter((Object)right, (String)"right");
                return new BinaryExpression(op, left, right);
            }

            public static /* synthetic */ BinaryExpression copy$default(BinaryExpression binaryExpression, BinaryOperator binaryOperator, org.rust.lang.core.mir.lldb.MirLldbBridge$Operand operand, org.rust.lang.core.mir.lldb.MirLldbBridge$Operand operand2, int n, Object object) {
                if ((n & 1) != 0) {
                    binaryOperator = binaryExpression.op;
                }
                if ((n & 2) != 0) {
                    operand = binaryExpression.left;
                }
                if ((n & 4) != 0) {
                    operand2 = binaryExpression.right;
                }
                return binaryExpression.copy(binaryOperator, operand, operand2);
            }

            @NotNull
            public String toString() {
                return "BinaryExpression(op=" + this.op + ", left=" + this.left + ", right=" + this.right + ")";
            }

            public int hashCode() {
                int result2 = this.op.hashCode();
                result2 = result2 * 31 + this.left.hashCode();
                result2 = result2 * 31 + this.right.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof BinaryExpression)) {
                    return false;
                }
                BinaryExpression binaryExpression = (BinaryExpression)other;
                if (this.op != binaryExpression.op) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.left, (Object)binaryExpression.left)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.right, (Object)binaryExpression.right);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J)\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Rvalue$Cast;", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Rvalue;", "kind", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$CastKind;", "value", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Operand;", "ty", "", "<init>", "(Lorg/rust/lang/core/mir/lldb/MirLldbBridge$CastKind;Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Operand;Ljava/lang/String;)V", "getKind", "()Lorg/rust/lang/core/mir/lldb/MirLldbBridge$CastKind;", "getValue", "()Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Operand;", "getTy", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.rustrover.core"})
        public static final class Cast
        extends Rvalue {
            @NotNull
            private final CastKind kind;
            @NotNull
            private final org.rust.lang.core.mir.lldb.MirLldbBridge$Operand value;
            @Nullable
            private final String ty;

            public Cast(@NotNull CastKind kind2, @NotNull org.rust.lang.core.mir.lldb.MirLldbBridge$Operand value, @Nullable String ty2) {
                Intrinsics.checkNotNullParameter((Object)((Object)kind2), (String)"kind");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                super(null);
                this.kind = kind2;
                this.value = value;
                this.ty = ty2;
            }

            @NotNull
            public final CastKind getKind() {
                return this.kind;
            }

            @NotNull
            public final org.rust.lang.core.mir.lldb.MirLldbBridge$Operand getValue() {
                return this.value;
            }

            @Nullable
            public final String getTy() {
                return this.ty;
            }

            @NotNull
            public final CastKind component1() {
                return this.kind;
            }

            @NotNull
            public final org.rust.lang.core.mir.lldb.MirLldbBridge$Operand component2() {
                return this.value;
            }

            @Nullable
            public final String component3() {
                return this.ty;
            }

            @NotNull
            public final Cast copy(@NotNull CastKind kind2, @NotNull org.rust.lang.core.mir.lldb.MirLldbBridge$Operand value, @Nullable String ty2) {
                Intrinsics.checkNotNullParameter((Object)((Object)kind2), (String)"kind");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return new Cast(kind2, value, ty2);
            }

            public static /* synthetic */ Cast copy$default(Cast cast, CastKind castKind, org.rust.lang.core.mir.lldb.MirLldbBridge$Operand operand, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    castKind = cast.kind;
                }
                if ((n & 2) != 0) {
                    operand = cast.value;
                }
                if ((n & 4) != 0) {
                    string = cast.ty;
                }
                return cast.copy(castKind, operand, string);
            }

            @NotNull
            public String toString() {
                return "Cast(kind=" + this.kind + ", value=" + this.value + ", ty=" + this.ty + ")";
            }

            public int hashCode() {
                int result2 = this.kind.hashCode();
                result2 = result2 * 31 + this.value.hashCode();
                result2 = result2 * 31 + (this.ty == null ? 0 : this.ty.hashCode());
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Cast)) {
                    return false;
                }
                Cast cast = (Cast)other;
                if (this.kind != cast.kind) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.value, (Object)cast.value)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.ty, (Object)cast.ty);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Rvalue$Discriminant;", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Rvalue;", "place", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Place;", "<init>", "(Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Place;)V", "getPlace", "()Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Place;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.rustrover.core"})
        public static final class Discriminant
        extends Rvalue {
            @NotNull
            private final Place place;

            public Discriminant(@NotNull Place place) {
                Intrinsics.checkNotNullParameter((Object)place, (String)"place");
                super(null);
                this.place = place;
            }

            @NotNull
            public final Place getPlace() {
                return this.place;
            }

            @NotNull
            public final Place component1() {
                return this.place;
            }

            @NotNull
            public final Discriminant copy(@NotNull Place place) {
                Intrinsics.checkNotNullParameter((Object)place, (String)"place");
                return new Discriminant(place);
            }

            public static /* synthetic */ Discriminant copy$default(Discriminant discriminant, Place place, int n, Object object) {
                if ((n & 1) != 0) {
                    place = discriminant.place;
                }
                return discriminant.copy(place);
            }

            @NotNull
            public String toString() {
                return "Discriminant(place=" + this.place + ")";
            }

            public int hashCode() {
                return this.place.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Discriminant)) {
                    return false;
                }
                Discriminant discriminant = (Discriminant)other;
                return Intrinsics.areEqual((Object)this.place, (Object)discriminant.place);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Rvalue$Len;", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Rvalue;", "place", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Place;", "<init>", "(Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Place;)V", "getPlace", "()Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Place;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.rustrover.core"})
        public static final class Len
        extends Rvalue {
            @NotNull
            private final Place place;

            public Len(@NotNull Place place) {
                Intrinsics.checkNotNullParameter((Object)place, (String)"place");
                super(null);
                this.place = place;
            }

            @NotNull
            public final Place getPlace() {
                return this.place;
            }

            @NotNull
            public final Place component1() {
                return this.place;
            }

            @NotNull
            public final Len copy(@NotNull Place place) {
                Intrinsics.checkNotNullParameter((Object)place, (String)"place");
                return new Len(place);
            }

            public static /* synthetic */ Len copy$default(Len len, Place place, int n, Object object) {
                if ((n & 1) != 0) {
                    place = len.place;
                }
                return len.copy(place);
            }

            @NotNull
            public String toString() {
                return "Len(place=" + this.place + ")";
            }

            public int hashCode() {
                return this.place.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Len)) {
                    return false;
                }
                Len len = (Len)other;
                return Intrinsics.areEqual((Object)this.place, (Object)len.place);
            }
        }

        @SkipSealedClassWrapping
        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Rvalue$Operand;", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Rvalue;", "operand", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Operand;", "<init>", "(Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Operand;)V", "getOperand", "()Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Operand;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.rustrover.core"})
        public static final class Operand
        extends Rvalue {
            @NotNull
            private final org.rust.lang.core.mir.lldb.MirLldbBridge$Operand operand;

            public Operand(@NotNull org.rust.lang.core.mir.lldb.MirLldbBridge$Operand operand) {
                Intrinsics.checkNotNullParameter((Object)operand, (String)"operand");
                super(null);
                this.operand = operand;
            }

            @NotNull
            public final org.rust.lang.core.mir.lldb.MirLldbBridge$Operand getOperand() {
                return this.operand;
            }

            @NotNull
            public final org.rust.lang.core.mir.lldb.MirLldbBridge$Operand component1() {
                return this.operand;
            }

            @NotNull
            public final Operand copy(@NotNull org.rust.lang.core.mir.lldb.MirLldbBridge$Operand operand) {
                Intrinsics.checkNotNullParameter((Object)operand, (String)"operand");
                return new Operand(operand);
            }

            public static /* synthetic */ Operand copy$default(Operand operand, org.rust.lang.core.mir.lldb.MirLldbBridge$Operand operand2, int n, Object object) {
                if ((n & 1) != 0) {
                    operand2 = operand.operand;
                }
                return operand.copy(operand2);
            }

            @NotNull
            public String toString() {
                return "Operand(operand=" + this.operand + ")";
            }

            public int hashCode() {
                return this.operand.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Operand)) {
                    return false;
                }
                Operand operand = (Operand)other;
                return Intrinsics.areEqual((Object)this.operand, (Object)operand.operand);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Rvalue$Ref;", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Rvalue;", "place", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Place;", "<init>", "(Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Place;)V", "getPlace", "()Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Place;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.rustrover.core"})
        public static final class Ref
        extends Rvalue {
            @NotNull
            private final Place place;

            public Ref(@NotNull Place place) {
                Intrinsics.checkNotNullParameter((Object)place, (String)"place");
                super(null);
                this.place = place;
            }

            @NotNull
            public final Place getPlace() {
                return this.place;
            }

            @NotNull
            public final Place component1() {
                return this.place;
            }

            @NotNull
            public final Ref copy(@NotNull Place place) {
                Intrinsics.checkNotNullParameter((Object)place, (String)"place");
                return new Ref(place);
            }

            public static /* synthetic */ Ref copy$default(Ref ref, Place place, int n, Object object) {
                if ((n & 1) != 0) {
                    place = ref.place;
                }
                return ref.copy(place);
            }

            @NotNull
            public String toString() {
                return "Ref(place=" + this.place + ")";
            }

            public int hashCode() {
                return this.place.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Ref)) {
                    return false;
                }
                Ref ref = (Ref)other;
                return Intrinsics.areEqual((Object)this.place, (Object)ref.place);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Rvalue$Repeat;", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Rvalue;", "value", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Operand;", "count", "", "<init>", "(Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Operand;J)V", "getValue", "()Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Operand;", "getCount", "()J", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.rustrover.core"})
        public static final class Repeat
        extends Rvalue {
            @NotNull
            private final org.rust.lang.core.mir.lldb.MirLldbBridge$Operand value;
            private final long count;

            public Repeat(@NotNull org.rust.lang.core.mir.lldb.MirLldbBridge$Operand value, long count) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                super(null);
                this.value = value;
                this.count = count;
            }

            @NotNull
            public final org.rust.lang.core.mir.lldb.MirLldbBridge$Operand getValue() {
                return this.value;
            }

            public final long getCount() {
                return this.count;
            }

            @NotNull
            public final org.rust.lang.core.mir.lldb.MirLldbBridge$Operand component1() {
                return this.value;
            }

            public final long component2() {
                return this.count;
            }

            @NotNull
            public final Repeat copy(@NotNull org.rust.lang.core.mir.lldb.MirLldbBridge$Operand value, long count) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return new Repeat(value, count);
            }

            public static /* synthetic */ Repeat copy$default(Repeat repeat, org.rust.lang.core.mir.lldb.MirLldbBridge$Operand operand, long l, int n, Object object) {
                if ((n & 1) != 0) {
                    operand = repeat.value;
                }
                if ((n & 2) != 0) {
                    l = repeat.count;
                }
                return repeat.copy(operand, l);
            }

            @NotNull
            public String toString() {
                return "Repeat(value=" + this.value + ", count=" + this.count + ")";
            }

            public int hashCode() {
                int result2 = this.value.hashCode();
                result2 = result2 * 31 + Long.hashCode(this.count);
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Repeat)) {
                    return false;
                }
                Repeat repeat = (Repeat)other;
                if (!Intrinsics.areEqual((Object)this.value, (Object)repeat.value)) {
                    return false;
                }
                return this.count == repeat.count;
            }
        }

        @SerializedClassName(value="UnaryOp")
        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Rvalue$UnaryExpression;", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Rvalue;", "operator", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$UnaryOperator;", "value", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Operand;", "<init>", "(Lorg/rust/lang/core/mir/lldb/MirLldbBridge$UnaryOperator;Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Operand;)V", "getOperator", "()Lorg/rust/lang/core/mir/lldb/MirLldbBridge$UnaryOperator;", "getValue", "()Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Operand;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.rustrover.core"})
        public static final class UnaryExpression
        extends Rvalue {
            @SerializedName(value="Op")
            @NotNull
            private final UnaryOperator operator;
            @NotNull
            private final org.rust.lang.core.mir.lldb.MirLldbBridge$Operand value;

            public UnaryExpression(@NotNull UnaryOperator operator, @NotNull org.rust.lang.core.mir.lldb.MirLldbBridge$Operand value) {
                Intrinsics.checkNotNullParameter((Object)((Object)operator), (String)"operator");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                super(null);
                this.operator = operator;
                this.value = value;
            }

            @NotNull
            public final UnaryOperator getOperator() {
                return this.operator;
            }

            @NotNull
            public final org.rust.lang.core.mir.lldb.MirLldbBridge$Operand getValue() {
                return this.value;
            }

            @NotNull
            public final UnaryOperator component1() {
                return this.operator;
            }

            @NotNull
            public final org.rust.lang.core.mir.lldb.MirLldbBridge$Operand component2() {
                return this.value;
            }

            @NotNull
            public final UnaryExpression copy(@NotNull UnaryOperator operator, @NotNull org.rust.lang.core.mir.lldb.MirLldbBridge$Operand value) {
                Intrinsics.checkNotNullParameter((Object)((Object)operator), (String)"operator");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return new UnaryExpression(operator, value);
            }

            public static /* synthetic */ UnaryExpression copy$default(UnaryExpression unaryExpression, UnaryOperator unaryOperator, org.rust.lang.core.mir.lldb.MirLldbBridge$Operand operand, int n, Object object) {
                if ((n & 1) != 0) {
                    unaryOperator = unaryExpression.operator;
                }
                if ((n & 2) != 0) {
                    operand = unaryExpression.value;
                }
                return unaryExpression.copy(unaryOperator, operand);
            }

            @NotNull
            public String toString() {
                return "UnaryExpression(operator=" + this.operator + ", value=" + this.value + ")";
            }

            public int hashCode() {
                int result2 = this.operator.hashCode();
                result2 = result2 * 31 + this.value.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof UnaryExpression)) {
                    return false;
                }
                UnaryExpression unaryExpression = (UnaryExpression)other;
                if (this.operator != unaryExpression.operator) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.value, (Object)unaryExpression.value);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Statement;", "", "place", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Place;", "rvalue", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Rvalue;", "<init>", "(Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Place;Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Rvalue;)V", "getPlace", "()Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Place;", "getRvalue", "()Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Rvalue;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.rustrover.core"})
    public static final class Statement {
        @NotNull
        private final Place place;
        @SerializedName(value="RValue")
        @NotNull
        private final Rvalue rvalue;

        public Statement(@NotNull Place place, @NotNull Rvalue rvalue) {
            Intrinsics.checkNotNullParameter((Object)place, (String)"place");
            Intrinsics.checkNotNullParameter((Object)rvalue, (String)"rvalue");
            this.place = place;
            this.rvalue = rvalue;
        }

        @NotNull
        public final Place getPlace() {
            return this.place;
        }

        @NotNull
        public final Rvalue getRvalue() {
            return this.rvalue;
        }

        @NotNull
        public final Place component1() {
            return this.place;
        }

        @NotNull
        public final Rvalue component2() {
            return this.rvalue;
        }

        @NotNull
        public final Statement copy(@NotNull Place place, @NotNull Rvalue rvalue) {
            Intrinsics.checkNotNullParameter((Object)place, (String)"place");
            Intrinsics.checkNotNullParameter((Object)rvalue, (String)"rvalue");
            return new Statement(place, rvalue);
        }

        public static /* synthetic */ Statement copy$default(Statement statement, Place place, Rvalue rvalue, int n, Object object) {
            if ((n & 1) != 0) {
                place = statement.place;
            }
            if ((n & 2) != 0) {
                rvalue = statement.rvalue;
            }
            return statement.copy(place, rvalue);
        }

        @NotNull
        public String toString() {
            return "Statement(place=" + this.place + ", rvalue=" + this.rvalue + ")";
        }

        public int hashCode() {
            int result2 = this.place.hashCode();
            result2 = result2 * 31 + this.rvalue.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Statement)) {
                return false;
            }
            Statement statement = (Statement)other;
            if (!Intrinsics.areEqual((Object)this.place, (Object)statement.place)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.rvalue, (Object)statement.rvalue);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0006\u0004\u0005\u0006\u0007\b\tB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0006\n\u000b\f\r\u000e\u000f\u00a8\u0006\u0010"}, d2={"Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Terminator;", "", "<init>", "()V", "Return", "Goto", "Call", "SwitchInt", "Unreachable", "Assert", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Terminator$Assert;", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Terminator$Call;", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Terminator$Goto;", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Terminator$Return;", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Terminator$SwitchInt;", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Terminator$Unreachable;", "intellij.rustrover.core"})
    public static abstract sealed class Terminator {
        private Terminator() {
        }

        public /* synthetic */ Terminator(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\tH\u00c6\u0003J1\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u00052\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\tH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001e"}, d2={"Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Terminator$Assert;", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Terminator;", "cond", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Operand;", "expected", "", "message", "", "to", "", "<init>", "(Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Operand;ZLjava/lang/String;I)V", "getCond", "()Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Operand;", "getExpected", "()Z", "getMessage", "()Ljava/lang/String;", "getTo", "()I", "component1", "component2", "component3", "component4", "copy", "equals", "other", "", "hashCode", "toString", "intellij.rustrover.core"})
        public static final class Assert
        extends Terminator {
            @NotNull
            private final Operand cond;
            private final boolean expected;
            @NotNull
            private final String message;
            private final int to;

            public Assert(@NotNull Operand cond, boolean expected, @NotNull String message, int to) {
                Intrinsics.checkNotNullParameter((Object)cond, (String)"cond");
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                super(null);
                this.cond = cond;
                this.expected = expected;
                this.message = message;
                this.to = to;
            }

            @NotNull
            public final Operand getCond() {
                return this.cond;
            }

            public final boolean getExpected() {
                return this.expected;
            }

            @NotNull
            public final String getMessage() {
                return this.message;
            }

            public final int getTo() {
                return this.to;
            }

            @NotNull
            public final Operand component1() {
                return this.cond;
            }

            public final boolean component2() {
                return this.expected;
            }

            @NotNull
            public final String component3() {
                return this.message;
            }

            public final int component4() {
                return this.to;
            }

            @NotNull
            public final Assert copy(@NotNull Operand cond, boolean expected, @NotNull String message, int to) {
                Intrinsics.checkNotNullParameter((Object)cond, (String)"cond");
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                return new Assert(cond, expected, message, to);
            }

            public static /* synthetic */ Assert copy$default(Assert assert_, Operand operand, boolean bl, String string, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    operand = assert_.cond;
                }
                if ((n2 & 2) != 0) {
                    bl = assert_.expected;
                }
                if ((n2 & 4) != 0) {
                    string = assert_.message;
                }
                if ((n2 & 8) != 0) {
                    n = assert_.to;
                }
                return assert_.copy(operand, bl, string, n);
            }

            @NotNull
            public String toString() {
                return "Assert(cond=" + this.cond + ", expected=" + this.expected + ", message=" + this.message + ", to=" + this.to + ")";
            }

            public int hashCode() {
                int result2 = this.cond.hashCode();
                result2 = result2 * 31 + Boolean.hashCode(this.expected);
                result2 = result2 * 31 + this.message.hashCode();
                result2 = result2 * 31 + Integer.hashCode(this.to);
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Assert)) {
                    return false;
                }
                Assert assert_ = (Assert)other;
                if (!Intrinsics.areEqual((Object)this.cond, (Object)assert_.cond)) {
                    return false;
                }
                if (this.expected != assert_.expected) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.message, (Object)assert_.message)) {
                    return false;
                }
                return this.to == assert_.to;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0016\u001a\u00020\bH\u00c6\u0003J7\u0010\u0017\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\bH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011\u00a8\u0006\u001f"}, d2={"Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Terminator$Call;", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Terminator;", "args", "", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Operand;", "destination", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Place;", "calleeIndex", "", "to", "<init>", "(Ljava/util/List;Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Place;II)V", "getArgs", "()Ljava/util/List;", "getDestination", "()Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Place;", "getCalleeIndex", "()I", "getTo", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "toString", "", "intellij.rustrover.core"})
        public static final class Call
        extends Terminator {
            @NotNull
            private final List<Operand> args;
            @NotNull
            private final Place destination;
            private final int calleeIndex;
            private final int to;

            public Call(@NotNull List<? extends Operand> args, @NotNull Place destination, int calleeIndex, int to) {
                Intrinsics.checkNotNullParameter(args, (String)"args");
                Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
                super(null);
                this.args = args;
                this.destination = destination;
                this.calleeIndex = calleeIndex;
                this.to = to;
            }

            @NotNull
            public final List<Operand> getArgs() {
                return this.args;
            }

            @NotNull
            public final Place getDestination() {
                return this.destination;
            }

            public final int getCalleeIndex() {
                return this.calleeIndex;
            }

            public final int getTo() {
                return this.to;
            }

            @NotNull
            public final List<Operand> component1() {
                return this.args;
            }

            @NotNull
            public final Place component2() {
                return this.destination;
            }

            public final int component3() {
                return this.calleeIndex;
            }

            public final int component4() {
                return this.to;
            }

            @NotNull
            public final Call copy(@NotNull List<? extends Operand> args, @NotNull Place destination, int calleeIndex, int to) {
                Intrinsics.checkNotNullParameter(args, (String)"args");
                Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
                return new Call(args, destination, calleeIndex, to);
            }

            public static /* synthetic */ Call copy$default(Call call2, List list, Place place, int n, int n2, int n3, Object object) {
                if ((n3 & 1) != 0) {
                    list = call2.args;
                }
                if ((n3 & 2) != 0) {
                    place = call2.destination;
                }
                if ((n3 & 4) != 0) {
                    n = call2.calleeIndex;
                }
                if ((n3 & 8) != 0) {
                    n2 = call2.to;
                }
                return call2.copy(list, place, n, n2);
            }

            @NotNull
            public String toString() {
                return "Call(args=" + this.args + ", destination=" + this.destination + ", calleeIndex=" + this.calleeIndex + ", to=" + this.to + ")";
            }

            public int hashCode() {
                int result2 = ((Object)this.args).hashCode();
                result2 = result2 * 31 + this.destination.hashCode();
                result2 = result2 * 31 + Integer.hashCode(this.calleeIndex);
                result2 = result2 * 31 + Integer.hashCode(this.to);
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Call)) {
                    return false;
                }
                Call call2 = (Call)other;
                if (!Intrinsics.areEqual(this.args, call2.args)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.destination, (Object)call2.destination)) {
                    return false;
                }
                if (this.calleeIndex != call2.calleeIndex) {
                    return false;
                }
                return this.to == call2.to;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Terminator$Goto;", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Terminator;", "to", "", "<init>", "(I)V", "getTo", "()I", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "", "intellij.rustrover.core"})
        public static final class Goto
        extends Terminator {
            private final int to;

            public Goto(int to) {
                super(null);
                this.to = to;
            }

            public final int getTo() {
                return this.to;
            }

            public final int component1() {
                return this.to;
            }

            @NotNull
            public final Goto copy(int to) {
                return new Goto(to);
            }

            public static /* synthetic */ Goto copy$default(Goto goto_, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = goto_.to;
                }
                return goto_.copy(n);
            }

            @NotNull
            public String toString() {
                return "Goto(to=" + this.to + ")";
            }

            public int hashCode() {
                return Integer.hashCode(this.to);
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Goto)) {
                    return false;
                }
                Goto goto_ = (Goto)other;
                return this.to == goto_.to;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Terminator$Return;", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Terminator;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.rustrover.core"})
        public static final class Return
        extends Terminator {
            @NotNull
            public static final Return INSTANCE = new Return();

            private Return() {
                super(null);
            }

            @NotNull
            public String toString() {
                return "Return";
            }

            public int hashCode() {
                return 1783325501;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Return)) {
                    return false;
                }
                Return cfr_ignored_0 = (Return)other;
                return true;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001:\u0001\u001cB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\bH\u00c6\u0003J-\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\bH\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Terminator$SwitchInt;", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Terminator;", "discriminant", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Operand;", "branches", "", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Terminator$SwitchInt$Branch;", "otherwise", "", "<init>", "(Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Operand;Ljava/util/List;I)V", "getDiscriminant", "()Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Operand;", "getBranches", "()Ljava/util/List;", "getOtherwise", "()I", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "toString", "", "Branch", "intellij.rustrover.core"})
        public static final class SwitchInt
        extends Terminator {
            @SerializedName(value="Discr")
            @NotNull
            private final Operand discriminant;
            @NotNull
            private final List<Branch> branches;
            private final int otherwise;

            public SwitchInt(@NotNull Operand discriminant, @NotNull List<Branch> branches, int otherwise) {
                Intrinsics.checkNotNullParameter((Object)discriminant, (String)"discriminant");
                Intrinsics.checkNotNullParameter(branches, (String)"branches");
                super(null);
                this.discriminant = discriminant;
                this.branches = branches;
                this.otherwise = otherwise;
            }

            @NotNull
            public final Operand getDiscriminant() {
                return this.discriminant;
            }

            @NotNull
            public final List<Branch> getBranches() {
                return this.branches;
            }

            public final int getOtherwise() {
                return this.otherwise;
            }

            @NotNull
            public final Operand component1() {
                return this.discriminant;
            }

            @NotNull
            public final List<Branch> component2() {
                return this.branches;
            }

            public final int component3() {
                return this.otherwise;
            }

            @NotNull
            public final SwitchInt copy(@NotNull Operand discriminant, @NotNull List<Branch> branches, int otherwise) {
                Intrinsics.checkNotNullParameter((Object)discriminant, (String)"discriminant");
                Intrinsics.checkNotNullParameter(branches, (String)"branches");
                return new SwitchInt(discriminant, branches, otherwise);
            }

            public static /* synthetic */ SwitchInt copy$default(SwitchInt switchInt, Operand operand, List list, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    operand = switchInt.discriminant;
                }
                if ((n2 & 2) != 0) {
                    list = switchInt.branches;
                }
                if ((n2 & 4) != 0) {
                    n = switchInt.otherwise;
                }
                return switchInt.copy(operand, list, n);
            }

            @NotNull
            public String toString() {
                return "SwitchInt(discriminant=" + this.discriminant + ", branches=" + this.branches + ", otherwise=" + this.otherwise + ")";
            }

            public int hashCode() {
                int result2 = this.discriminant.hashCode();
                result2 = result2 * 31 + ((Object)this.branches).hashCode();
                result2 = result2 * 31 + Integer.hashCode(this.otherwise);
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof SwitchInt)) {
                    return false;
                }
                SwitchInt switchInt = (SwitchInt)other;
                if (!Intrinsics.areEqual((Object)this.discriminant, (Object)switchInt.discriminant)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.branches, switchInt.branches)) {
                    return false;
                }
                return this.otherwise == switchInt.otherwise;
            }

            /*
             * Illegal identifiers - consider using --renameillegalidents true
             */
            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Terminator$SwitchInt$Branch;", "", "case", "", "to", "", "<init>", "(JI)V", "getCase", "()J", "getTo", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.rustrover.core"})
            public static final class Branch {
                private final long case;
                private final int to;

                public Branch(long l, int to) {
                    this.case = l;
                    this.to = to;
                }

                public final long getCase() {
                    return this.case;
                }

                public final int getTo() {
                    return this.to;
                }

                public final long component1() {
                    return this.case;
                }

                public final int component2() {
                    return this.to;
                }

                @NotNull
                public final Branch copy(long l, int to) {
                    return new Branch(l, to);
                }

                public static /* synthetic */ Branch copy$default(Branch branch, long l, int n, int n2, Object object) {
                    if ((n2 & 1) != 0) {
                        l = branch.case;
                    }
                    if ((n2 & 2) != 0) {
                        n = branch.to;
                    }
                    return branch.copy(l, n);
                }

                @NotNull
                public String toString() {
                    return "Branch(case=" + this.case + ", to=" + this.to + ")";
                }

                public int hashCode() {
                    int result2 = Long.hashCode(this.case);
                    result2 = result2 * 31 + Integer.hashCode(this.to);
                    return result2;
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof Branch)) {
                        return false;
                    }
                    Branch branch = (Branch)other;
                    if (this.case != branch.case) {
                        return false;
                    }
                    return this.to == branch.to;
                }
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Terminator$Unreachable;", "Lorg/rust/lang/core/mir/lldb/MirLldbBridge$Terminator;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.rustrover.core"})
        public static final class Unreachable
        extends Terminator {
            @NotNull
            public static final Unreachable INSTANCE = new Unreachable();

            private Unreachable() {
                super(null);
            }

            @NotNull
            public String toString() {
                return "Unreachable";
            }

            public int hashCode() {
                return -1024367385;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Unreachable)) {
                    return false;
                }
                Unreachable cfr_ignored_0 = (Unreachable)other;
                return true;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/rust/lang/core/mir/lldb/MirLldbBridge$UnaryOperator;", "", "<init>", "(Ljava/lang/String;I)V", "Not", "Negate", "PtrMetadata", "intellij.rustrover.core"})
    public static final class UnaryOperator
    extends Enum<UnaryOperator> {
        public static final /* enum */ UnaryOperator Not = new UnaryOperator();
        public static final /* enum */ UnaryOperator Negate = new UnaryOperator();
        public static final /* enum */ UnaryOperator PtrMetadata = new UnaryOperator();
        private static final /* synthetic */ UnaryOperator[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static UnaryOperator[] values() {
            return (UnaryOperator[])$VALUES.clone();
        }

        public static UnaryOperator valueOf(String value) {
            return Enum.valueOf(UnaryOperator.class, value);
        }

        @NotNull
        public static EnumEntries<UnaryOperator> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = unaryOperatorArray = new UnaryOperator[]{UnaryOperator.Not, UnaryOperator.Negate, UnaryOperator.PtrMetadata};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

