/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.mir.lldb;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.lang.core.mir.lldb.MirLldbVerifier;
import org.rust.lang.core.mir.schemas.MirBasicBlock;
import org.rust.lang.core.mir.schemas.MirBody;
import org.rust.lang.core.mir.schemas.MirConstant;
import org.rust.lang.core.mir.schemas.MirLocal;
import org.rust.lang.core.mir.schemas.MirLocation;
import org.rust.lang.core.mir.schemas.MirRvalue;
import org.rust.lang.core.mir.schemas.MirStatement;
import org.rust.lang.core.mir.schemas.MirTerminator;
import org.rust.lang.core.mir.schemas.MirVisitor;
import org.rust.lang.core.mir.schemas.TyContext;
import org.rust.lang.core.psi.ext.RsAbstractable;
import org.rust.lang.core.psi.ext.RsAbstractableKt;
import org.rust.lang.core.psi.ext.RsAbstractableOwner;
import org.rust.lang.core.psi.ext.RsGenericDeclaration;
import org.rust.lang.core.psi.ext.RsGenericDeclarationKt;
import org.rust.lang.core.psi.ext.RsInferenceContextOwner;
import org.rust.lang.core.types.Substitution;
import org.rust.lang.core.types.SubstitutionKt;
import org.rust.lang.core.types.consts.Const;
import org.rust.lang.core.types.consts.CtConstParameter;
import org.rust.lang.core.types.infer.FoldKt;
import org.rust.lang.core.types.infer.TypeFoldable;
import org.rust.lang.core.types.infer.TypeVisitor;
import org.rust.lang.core.types.ty.Ty;
import org.rust.lang.core.types.ty.TyTypeParameter;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\r"}, d2={"Lorg/rust/lang/core/mir/lldb/MirConsistencyVerifier;", "Lorg/rust/lang/core/mir/lldb/MirLldbVerifier$PostBuildVerifier;", "<init>", "()V", "verify", "Lorg/rust/lang/core/mir/lldb/MirLldbVerifier$VerificationResult;", "mir", "Lorg/rust/lang/core/mir/schemas/MirBody;", "collectAllowedGenerics", "Lorg/rust/lang/core/types/Substitution;", "item", "Lorg/rust/lang/core/psi/ext/RsInferenceContextOwner;", "Visitor", "intellij.rustrover.core"})
final class MirConsistencyVerifier
implements MirLldbVerifier.PostBuildVerifier {
    @Override
    @NotNull
    public MirLldbVerifier.VerificationResult verify(@NotNull MirBody mir) {
        Intrinsics.checkNotNullParameter((Object)mir, (String)"mir");
        Substitution allowedGenerics = this.collectAllowedGenerics(mir.getContextOwner());
        Visitor visitor2 = new Visitor(mir.returnPlace(), allowedGenerics);
        visitor2.visitBody(mir);
        return visitor2.getResult();
    }

    private final Substitution collectAllowedGenerics(RsInferenceContextOwner item) {
        if (!(item instanceof RsGenericDeclaration)) {
            return SubstitutionKt.getEmptySubstitution();
        }
        Substitution selfSubst = RsGenericDeclarationKt.withIdentitySubstitution((RsGenericDeclaration)((Object)item)).getSubst();
        if (item instanceof RsAbstractable) {
            RsGenericDeclaration parent2;
            RsAbstractableOwner owner = RsAbstractableKt.getOwner((RsAbstractable)((Object)item));
            RsGenericDeclaration rsGenericDeclaration = owner instanceof RsAbstractableOwner.Impl ? (RsGenericDeclaration)((RsAbstractableOwner.Impl)owner).getImpl() : (parent2 = owner instanceof RsAbstractableOwner.Trait ? (RsGenericDeclaration)((RsAbstractableOwner.Trait)owner).getTrait() : null);
            if (parent2 != null) {
                return selfSubst.plus(SubstitutionKt.toTypeSubst(MapsKt.mapOf((Pair)TuplesKt.to((Object)TyTypeParameter.Companion.self(), (Object)TyTypeParameter.Companion.self())))).plus(RsGenericDeclarationKt.withIdentitySubstitution(parent2).getSubst());
            }
        }
        return selfSubst;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0002\u001a\u00020\u0003H\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001e\u0010\u0016\u001a\u00020\u000e2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u0018\u0010\"\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0014\u0010%\u001a\u00020\u000e2\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030&H\u0002J\u0010\u0010'\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020)H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006*"}, d2={"Lorg/rust/lang/core/mir/lldb/MirConsistencyVerifier$Visitor;", "Lorg/rust/lang/core/mir/schemas/MirVisitor;", "returnPlace", "Lorg/rust/lang/core/mir/schemas/MirLocal;", "allowedGenerics", "Lorg/rust/lang/core/types/Substitution;", "<init>", "(Lorg/rust/lang/core/mir/schemas/MirLocal;Lorg/rust/lang/core/types/Substitution;)V", "value", "Lorg/rust/lang/core/mir/lldb/MirLldbVerifier$VerificationResult;", "result", "getResult", "()Lorg/rust/lang/core/mir/lldb/MirLldbVerifier$VerificationResult;", "visitStatement", "", "statement", "Lorg/rust/lang/core/mir/schemas/MirStatement;", "location", "Lorg/rust/lang/core/mir/schemas/MirLocation;", "visitRvalue", "rvalue", "Lorg/rust/lang/core/mir/schemas/MirRvalue;", "visitTerminator", "terminator", "Lorg/rust/lang/core/mir/schemas/MirTerminator;", "Lorg/rust/lang/core/mir/schemas/MirBasicBlock;", "visitConstant", "constant", "Lorg/rust/lang/core/mir/schemas/MirConstant;", "visitTy", "ty", "Lorg/rust/lang/core/types/ty/Ty;", "context", "Lorg/rust/lang/core/mir/schemas/TyContext;", "visitTyConst", "const", "Lorg/rust/lang/core/types/consts/Const;", "checkTyInvariants", "Lorg/rust/lang/core/types/infer/TypeFoldable;", "decline", "reason", "Lorg/rust/lang/core/mir/lldb/MirLldbVerifier$DeclineReason;", "intellij.rustrover.core"})
    private static final class Visitor
    implements MirVisitor {
        @NotNull
        private final MirLocal returnPlace;
        @NotNull
        private final Substitution allowedGenerics;
        @NotNull
        private MirLldbVerifier.VerificationResult result;

        public Visitor(@NotNull MirLocal returnPlace, @NotNull Substitution allowedGenerics) {
            Intrinsics.checkNotNullParameter((Object)returnPlace, (String)"returnPlace");
            Intrinsics.checkNotNullParameter((Object)allowedGenerics, (String)"allowedGenerics");
            this.returnPlace = returnPlace;
            this.allowedGenerics = allowedGenerics;
            this.result = MirLldbVerifier.VerificationResult.Accept.INSTANCE;
        }

        @Override
        @NotNull
        public MirLocal returnPlace() {
            return this.returnPlace;
        }

        @NotNull
        public final MirLldbVerifier.VerificationResult getResult() {
            return this.result;
        }

        @Override
        public void visitStatement(@NotNull MirStatement statement, @NotNull MirLocation location) {
            block1: {
                MirStatement mirStatement;
                block0: {
                    Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
                    Intrinsics.checkNotNullParameter((Object)location, (String)"location");
                    MirVisitor.super.visitStatement(statement, location);
                    mirStatement = statement;
                    if (!(mirStatement instanceof MirStatement.Uncontrolled)) break block0;
                    this.decline(MirLldbVerifier.DeclineReason.UNCONTROLLED_STATEMENT);
                    break block1;
                }
                if (!(mirStatement instanceof MirStatement.UncontrolledAll)) break block1;
                this.decline(MirLldbVerifier.DeclineReason.UNCONTROLLED_ALL_STATEMENT);
            }
        }

        @Override
        public void visitRvalue(@NotNull MirRvalue rvalue, @NotNull MirLocation location) {
            block1: {
                MirRvalue mirRvalue;
                block0: {
                    Intrinsics.checkNotNullParameter((Object)rvalue, (String)"rvalue");
                    Intrinsics.checkNotNullParameter((Object)location, (String)"location");
                    MirVisitor.super.visitRvalue(rvalue, location);
                    mirRvalue = rvalue;
                    if (!(mirRvalue instanceof MirRvalue.Aggregate.Closure)) break block0;
                    this.decline(MirLldbVerifier.DeclineReason.CLOSURE_UNSUPPORTED);
                    break block1;
                }
                if (!(mirRvalue instanceof MirRvalue.SubstitutesUse)) break block1;
                this.decline(MirLldbVerifier.DeclineReason.SUBSTITUTES_USE_ONLY_IN_COMPLETION);
            }
        }

        @Override
        public void visitTerminator(@NotNull MirTerminator<? extends MirBasicBlock> terminator, @NotNull MirLocation location) {
            Intrinsics.checkNotNullParameter(terminator, (String)"terminator");
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            MirVisitor.super.visitTerminator(terminator, location);
            if (terminator.isDummy()) {
                this.decline(MirLldbVerifier.DeclineReason.DUMMY_TERMINATOR);
            }
        }

        @Override
        public void visitConstant(@NotNull MirConstant constant, @NotNull MirLocation location) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)constant, (String)"constant");
                Intrinsics.checkNotNullParameter((Object)location, (String)"location");
                MirVisitor.super.visitConstant(constant, location);
                if (!(constant instanceof MirConstant.Unknown)) break block0;
                this.decline(MirLldbVerifier.DeclineReason.UNKNOWN_CONSTANT);
            }
        }

        @Override
        public void visitTy(@NotNull Ty ty2, @NotNull TyContext context) {
            Intrinsics.checkNotNullParameter((Object)ty2, (String)"ty");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            MirVisitor.super.visitTy(ty2, context);
            this.checkTyInvariants(ty2);
        }

        @Override
        public void visitTyConst(@NotNull Const const_, @NotNull MirLocation location) {
            Intrinsics.checkNotNullParameter((Object)const_, (String)"const");
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            MirVisitor.super.visitTyConst(const_, location);
            this.checkTyInvariants(const_);
        }

        private final void checkTyInvariants(TypeFoldable<?> ty2) {
            boolean hasWrongGenerics2 = ty2.visitWith(new TypeVisitor(this){
                final /* synthetic */ Visitor this$0;
                {
                    this.this$0 = $receiver;
                }

                public boolean visitTy(Ty ty2) {
                    Intrinsics.checkNotNullParameter((Object)ty2, (String)"ty");
                    return ty2 instanceof TyTypeParameter ? Visitor.access$getAllowedGenerics$p(this.this$0).get((TyTypeParameter)ty2) == null : (FoldKt.getHasTyTypeParameters(ty2) || FoldKt.getHasCtConstParameters(ty2) ? ty2.superVisitWith(this) : false);
                }

                public boolean visitConst(Const const_) {
                    Intrinsics.checkNotNullParameter((Object)const_, (String)"const");
                    return const_ instanceof CtConstParameter ? Visitor.access$getAllowedGenerics$p(this.this$0).get((CtConstParameter)const_) == null : (FoldKt.getHasCtConstParameters(const_) ? const_.superVisitWith(this) : false);
                }
            });
            if (hasWrongGenerics2) {
                this.decline(MirLldbVerifier.DeclineReason.WRONG_GENERICS);
            }
        }

        private final void decline(MirLldbVerifier.DeclineReason reason) {
            this.result = new MirLldbVerifier.VerificationResult.Decline(reason, null, 2, null);
        }

        public static final /* synthetic */ Substitution access$getAllowedGenerics$p(Visitor $this) {
            return $this.allowedGenerics;
        }
    }
}

