/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.mir.dataflow.move;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.lang.core.mir.dataflow.move.LookupResult;
import org.rust.lang.core.mir.dataflow.move.MovePath;
import org.rust.lang.core.mir.schemas.MirAbstractDomainKt;
import org.rust.lang.core.mir.schemas.MirAbstractType;
import org.rust.lang.core.mir.schemas.MirLocal;
import org.rust.lang.core.mir.schemas.MirPlace;
import org.rust.lang.core.mir.schemas.MirProjectionElem;
import org.rust.lang.core.types.ty.Ty;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001BE\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012(\u0010\u0006\u001a$\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0005\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\n0\tj\u0002`\u000b0\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0004\b\f\u0010\rJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0004R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR3\u0010\u0006\u001a$\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0005\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\n0\tj\u0002`\u000b0\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lorg/rust/lang/core/mir/dataflow/move/MovePathLookup;", "", "locals", "", "Lorg/rust/lang/core/mir/schemas/MirLocal;", "Lorg/rust/lang/core/mir/dataflow/move/MovePath;", "projections", "", "Lkotlin/Pair;", "Lorg/rust/lang/core/mir/schemas/MirProjectionElem;", "Lorg/rust/lang/core/mir/schemas/MirAbstractType;", "Lorg/rust/lang/core/mir/schemas/MirAbstractElem;", "<init>", "(Ljava/util/Map;Ljava/util/Map;)V", "getLocals", "()Ljava/util/Map;", "getProjections", "find", "Lorg/rust/lang/core/mir/dataflow/move/LookupResult;", "place", "Lorg/rust/lang/core/mir/schemas/MirPlace;", "local", "intellij.rustrover.core"})
public final class MovePathLookup {
    @NotNull
    private final Map<MirLocal, MovePath> locals;
    @NotNull
    private final Map<Pair<MovePath, MirProjectionElem<MirAbstractType>>, MovePath> projections;

    public MovePathLookup(@NotNull Map<MirLocal, MovePath> locals, @NotNull Map<Pair<MovePath, MirProjectionElem<MirAbstractType>>, MovePath> projections) {
        Intrinsics.checkNotNullParameter(locals, (String)"locals");
        Intrinsics.checkNotNullParameter(projections, (String)"projections");
        this.locals = locals;
        this.projections = projections;
    }

    @NotNull
    public final Map<MirLocal, MovePath> getLocals() {
        return this.locals;
    }

    @NotNull
    public final Map<Pair<MovePath, MirProjectionElem<MirAbstractType>>, MovePath> getProjections() {
        return this.projections;
    }

    @NotNull
    public final LookupResult find(@NotNull MirPlace place) {
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        MovePath movePath = this.locals.get(place.getLocal());
        Intrinsics.checkNotNull((Object)movePath);
        MovePath result2 = movePath;
        for (MirProjectionElem<Ty> elem : place.getProjections()) {
            if (this.projections.get(TuplesKt.to((Object)result2, MirAbstractDomainKt.lift(elem))) != null) continue;
            return new LookupResult.Parent(result2);
        }
        return new LookupResult.Exact(result2);
    }

    @NotNull
    public final MovePath find(@NotNull MirLocal local) {
        Intrinsics.checkNotNullParameter((Object)local, (String)"local");
        MovePath movePath = this.locals.get(local);
        Intrinsics.checkNotNull((Object)movePath);
        return movePath;
    }
}

