/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.mir.dataflow.move;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.rust.lang.core.mir.dataflow.move.IllegalMoveOrigin;
import org.rust.lang.core.mir.dataflow.move.Init;
import org.rust.lang.core.mir.dataflow.move.InitKind;
import org.rust.lang.core.mir.dataflow.move.InitLocation;
import org.rust.lang.core.mir.dataflow.move.LookupResult;
import org.rust.lang.core.mir.dataflow.move.MirDataflowMoveUtilsKt;
import org.rust.lang.core.mir.dataflow.move.MoveData;
import org.rust.lang.core.mir.dataflow.move.MoveDataImpl;
import org.rust.lang.core.mir.dataflow.move.MoveError;
import org.rust.lang.core.mir.dataflow.move.MoveOut;
import org.rust.lang.core.mir.dataflow.move.MovePath;
import org.rust.lang.core.mir.dataflow.move.MovePathLookup;
import org.rust.lang.core.mir.schemas.MirAbstractDomainKt;
import org.rust.lang.core.mir.schemas.MirAbstractType;
import org.rust.lang.core.mir.schemas.MirBody;
import org.rust.lang.core.mir.schemas.MirLocal;
import org.rust.lang.core.mir.schemas.MirLocation;
import org.rust.lang.core.mir.schemas.MirOperand;
import org.rust.lang.core.mir.schemas.MirPlace;
import org.rust.lang.core.mir.schemas.MirProjectionElem;
import org.rust.lang.core.mir.schemas.MirRvalue;
import org.rust.lang.core.mir.schemas.MirStatement;
import org.rust.lang.core.mir.schemas.MirTerminator;
import org.rust.lang.core.mir.util.IndexAlloc;
import org.rust.lang.core.mir.util.IndexKeyMap;
import org.rust.lang.core.mir.util.LocationMap;
import org.rust.lang.core.psi.RsStructItem;
import org.rust.lang.core.psi.ext.RsStructItemKt;
import org.rust.lang.core.psi.ext.RsStructKind;
import org.rust.lang.core.psi.ext.RsStructOrEnumItemElement;
import org.rust.lang.core.types.ty.Ty;
import org.rust.lang.core.types.ty.TyAdt;
import org.rust.lang.core.types.ty.TyArray;
import org.rust.lang.core.types.ty.TyKt;
import org.rust.lang.core.types.ty.TyRawPtr;
import org.rust.lang.core.types.ty.TyRef;
import org.rust.lang.core.types.ty.TySlice;
import org.rust.stdext.RsResult;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 32\u00020\u0001:\u00013B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J\u001c\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\f0\u00132\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J,\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001bH\u0002J\u0016\u0010\u001c\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001eJ\u001a\u0010\u001f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\n\u0010 \u001a\u0006\u0012\u0002\b\u00030!J\u0018\u0010\"\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\u00102\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010(\u001a\u00020\u00102\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J\u0010\u0010,\u001a\u00020\u00102\u0006\u0010-\u001a\u00020\u0014H\u0002J\u0006\u0010.\u001a\u00020\u0010J4\u0010/\u001a0\u0012\u0004\u0012\u000200\u0012\"\u0012 \u0012\u0004\u0012\u000200\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n010\n0\u0013j\u0002`2R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lorg/rust/lang/core/mir/dataflow/move/MoveDataBuilder;", "", "body", "Lorg/rust/lang/core/mir/schemas/MirBody;", "data", "Lorg/rust/lang/core/mir/dataflow/move/MoveDataImpl;", "<init>", "(Lorg/rust/lang/core/mir/schemas/MirBody;Lorg/rust/lang/core/mir/dataflow/move/MoveDataImpl;)V", "errors", "", "Lkotlin/Pair;", "Lorg/rust/lang/core/mir/schemas/MirPlace;", "Lorg/rust/lang/core/mir/dataflow/move/MoveError;", "loc", "Lorg/rust/lang/core/mir/schemas/MirLocation;", "createMovePath", "", "place", "movePathFor", "Lorg/rust/stdext/RsResult;", "Lorg/rust/lang/core/mir/dataflow/move/MovePath;", "addMovePath", "base", "element", "Lorg/rust/lang/core/mir/schemas/MirProjectionElem;", "Lorg/rust/lang/core/types/ty/Ty;", "makePlace", "Lkotlin/Function0;", "gatherStatement", "stmt", "Lorg/rust/lang/core/mir/schemas/MirStatement;", "gatherTerminator", "term", "Lorg/rust/lang/core/mir/schemas/MirTerminator;", "gatherInit", "kind", "Lorg/rust/lang/core/mir/dataflow/move/InitKind;", "gatherRvalue", "rvalue", "Lorg/rust/lang/core/mir/schemas/MirRvalue;", "gatherOperand", "operand", "Lorg/rust/lang/core/mir/schemas/MirOperand;", "gatherMove", "recordMove", "path", "gatherArgs", "doFinalize", "Lorg/rust/lang/core/mir/dataflow/move/MoveData;", "", "Lorg/rust/lang/core/mir/dataflow/move/MoveDat;", "Companion", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nMovePaths.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MovePaths.kt\norg/rust/lang/core/mir/dataflow/move/MoveDataBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,491:1\n1878#2,3:492\n1869#2,2:502\n382#3,7:495\n382#3,7:504\n382#3,7:511\n*S KotlinDebug\n*F\n+ 1 MovePaths.kt\norg/rust/lang/core/mir/dataflow/move/MoveDataBuilder\n*L\n256#1:492,3\n315#1:502,2\n293#1:495,7\n360#1:504,7\n424#1:511,7\n*E\n"})
final class MoveDataBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MirBody body;
    @NotNull
    private final MoveDataImpl data;
    @NotNull
    private final List<Pair<MirPlace, MoveError>> errors;
    private MirLocation loc;

    public MoveDataBuilder(@NotNull MirBody body, @NotNull MoveDataImpl data2) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        this.body = body;
        this.data = data2;
        this.errors = new ArrayList();
    }

    private final void createMovePath(MirPlace place) {
        this.movePathFor(place);
    }

    /*
     * WARNING - void declaration
     */
    private final RsResult<MovePath, MoveError> movePathFor(MirPlace place) {
        MovePath base = null;
        MovePath movePath = this.data.getRevLookup().getLocals().get(place.getLocal());
        Intrinsics.checkNotNull((Object)movePath);
        base = movePath;
        Iterable $this$forEachIndexed$iv = place.getProjections();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void elem;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            MirProjectionElem mirProjectionElem = (MirProjectionElem)item$iv;
            int i2 = n;
            boolean bl = false;
            List<MirProjectionElem<Ty>> projectionBase = place.getProjections().subList(0, i2);
            Ty placeTy = MirPlace.Companion.tyFrom(place.getLocal(), projectionBase).getTy();
            if (placeTy instanceof TyRef || placeTy instanceof TyRawPtr) {
                List<MirProjectionElem<Ty>> proj = place.getProjections().subList(0, i2 + 1);
                MirLocation mirLocation = this.loc;
                if (mirLocation == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"loc");
                    mirLocation = null;
                }
                IllegalMoveOrigin.BorrowedContent origin = new IllegalMoveOrigin.BorrowedContent(mirLocation, new MirPlace(place.getLocal(), proj));
                return new RsResult.Err<MoveError.IllegalMove>(new MoveError.IllegalMove(origin));
            }
            if (placeTy instanceof TyAdt) {
                RsStructOrEnumItemElement rsStructOrEnumItemElement = ((TyAdt)placeTy).getItem();
                RsStructItem rsStructItem = rsStructOrEnumItemElement instanceof RsStructItem ? (RsStructItem)rsStructOrEnumItemElement : null;
                if ((rsStructItem != null ? RsStructItemKt.getKind(rsStructItem) : null) == RsStructKind.UNION) {
                    throw new NotImplementedError(null, 1, null);
                }
                if (MirDataflowMoveUtilsKt.getHasDestructor(((TyAdt)placeTy).getItem()) && !TyKt.isBox(placeTy)) {
                    throw new NotImplementedError(null, 1, null);
                }
            } else {
                if (placeTy instanceof TySlice) {
                    MirLocation mirLocation = this.loc;
                    if (mirLocation == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"loc");
                        mirLocation = null;
                    }
                    IllegalMoveOrigin.InteriorOfSliceOrArray origin = new IllegalMoveOrigin.InteriorOfSliceOrArray(mirLocation, elem instanceof MirProjectionElem.Index);
                    return new RsResult.Err<MoveError.IllegalMove>(new MoveError.IllegalMove(origin));
                }
                if (placeTy instanceof TyArray && elem instanceof MirProjectionElem.Index) {
                    MirLocation mirLocation = this.loc;
                    if (mirLocation == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"loc");
                        mirLocation = null;
                    }
                    IllegalMoveOrigin.InteriorOfSliceOrArray origin = new IllegalMoveOrigin.InteriorOfSliceOrArray(mirLocation, true);
                    return new RsResult.Err<MoveError.IllegalMove>(new MoveError.IllegalMove(origin));
                }
            }
            base = this.addMovePath(base, (MirProjectionElem<? extends Ty>)elem, (Function0<MirPlace>)((Function0)() -> MoveDataBuilder.movePathFor$lambda$0$0(place, i2)));
        }
        return new RsResult.Ok<MovePath>(base);
    }

    /*
     * WARNING - void declaration
     */
    private final MovePath addMovePath(MovePath base, MirProjectionElem<? extends Ty> element, Function0<MirPlace> makePlace) {
        Object object;
        void $this$getOrPut$iv;
        Pair key = TuplesKt.to((Object)base, MirAbstractDomainKt.lift(element));
        Map<Pair<MovePath, MirProjectionElem<MirAbstractType>>, MovePath> map2 = this.data.getRevLookup().getProjections();
        Pair key$iv = key;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            MovePath answer$iv = MoveDataBuilder.Companion.newMovePath(this.data.getMovePaths(), (IndexKeyMap)this.data.getPathMap(), (IndexKeyMap)this.data.getInitPathMap(), base, (MirPlace)makePlace.invoke());
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (MovePath)object;
    }

    public final void gatherStatement(@NotNull MirLocation loc, @NotNull MirStatement stmt) {
        Intrinsics.checkNotNullParameter((Object)loc, (String)"loc");
        Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
        this.loc = loc;
        MirStatement mirStatement = stmt;
        if (mirStatement instanceof MirStatement.Assign) {
            this.createMovePath(((MirStatement.Assign)stmt).getPlace());
            this.gatherInit(((MirStatement.Assign)stmt).getPlace(), InitKind.Deep);
            this.gatherRvalue(((MirStatement.Assign)stmt).getRvalue());
        } else if (mirStatement instanceof MirStatement.FakeRead) {
            this.createMovePath(((MirStatement.FakeRead)stmt).getPlace());
        } else if (!(mirStatement instanceof MirStatement.StorageLive)) {
            if (mirStatement instanceof MirStatement.StorageDead) {
                this.gatherMove(new MirPlace(((MirStatement.StorageDead)stmt).getLocal(), null, 2, null));
            } else if (!(mirStatement instanceof MirStatement.PlaceMention || mirStatement instanceof MirStatement.Drop || mirStatement instanceof MirStatement.Uncontrolled)) {
                if (mirStatement instanceof MirStatement.UncontrolledAll) {
                    Iterable $this$forEach$iv = this.body.getLocalDecls();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        MirLocal local = (MirLocal)element$iv;
                        boolean bl = false;
                        this.gatherInit(new MirPlace(local, null, 2, null), InitKind.Deep);
                    }
                } else {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
    }

    public final void gatherTerminator(@NotNull MirLocation loc, @NotNull MirTerminator<?> term) {
        Intrinsics.checkNotNullParameter((Object)loc, (String)"loc");
        Intrinsics.checkNotNullParameter(term, (String)"term");
        this.loc = loc;
        MirTerminator<?> mirTerminator = term;
        if (!(mirTerminator instanceof MirTerminator.Goto || mirTerminator instanceof MirTerminator.FalseEdge || mirTerminator instanceof MirTerminator.FalseUnwind || mirTerminator instanceof MirTerminator.Return || mirTerminator instanceof MirTerminator.Resume || mirTerminator instanceof MirTerminator.Unreachable || mirTerminator instanceof MirTerminator.Drop)) {
            if (mirTerminator instanceof MirTerminator.Assert) {
                this.gatherOperand(((MirTerminator.Assert)term).getCond());
            } else if (mirTerminator instanceof MirTerminator.SwitchInt) {
                this.gatherOperand(((MirTerminator.SwitchInt)term).getDiscriminant());
            } else if (mirTerminator instanceof MirTerminator.Call) {
                this.gatherOperand(((MirTerminator.Call)term).getCallee());
                for (MirOperand arg : ((MirTerminator.Call)term).getArgs()) {
                    this.gatherOperand(arg);
                }
                if (((MirTerminator.Call)term).getTarget() != null) {
                    this.createMovePath(((MirTerminator.Call)term).getDestination());
                    this.gatherInit(((MirTerminator.Call)term).getDestination(), InitKind.NonPanicPathOnly);
                }
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void gatherInit(MirPlace place, InitKind kind2) {
        block3: {
            Object object;
            void $this$getOrPut$iv;
            LookupResult lookup2 = this.data.getRevLookup().find(place);
            if (!(lookup2 instanceof LookupResult.Exact)) break block3;
            MovePath path = ((LookupResult.Exact)lookup2).getMovePath();
            Init init = this.data.getInits().allocate((Function1<Integer, Init>)((Function1)arg_0 -> MoveDataBuilder.gatherInit$lambda$0(path, this, kind2, arg_0)));
            Object v = ((IndexKeyMap)this.data.getInitPathMap()).get(path);
            Intrinsics.checkNotNull(v);
            ((List)v).add(init);
            Map map2 = this.data.getInitLocMap();
            MirLocation mirLocation = this.loc;
            if (mirLocation == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"loc");
                mirLocation = null;
            }
            MirLocation key$iv = mirLocation;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((List)object).add(init);
        }
    }

    private final void gatherRvalue(MirRvalue rvalue) {
        MirRvalue mirRvalue = rvalue;
        if (!(mirRvalue instanceof MirRvalue.ThreadLocalRef)) {
            if (mirRvalue instanceof MirRvalue.Use) {
                this.gatherOperand(((MirRvalue.Use)rvalue).getOperand());
            } else if (mirRvalue instanceof MirRvalue.Repeat) {
                this.gatherOperand(((MirRvalue.Repeat)rvalue).getOperand());
            } else if (mirRvalue instanceof MirRvalue.Aggregate) {
                for (MirOperand operand : ((MirRvalue.Aggregate)rvalue).getOperands()) {
                    this.gatherOperand(operand);
                }
            } else if (mirRvalue instanceof MirRvalue.BinaryOpUse) {
                this.gatherOperand(((MirRvalue.BinaryOpUse)rvalue).getLeft());
                this.gatherOperand(((MirRvalue.BinaryOpUse)rvalue).getRight());
            } else if (mirRvalue instanceof MirRvalue.CheckedBinaryOpUse) {
                this.gatherOperand(((MirRvalue.CheckedBinaryOpUse)rvalue).getLeft());
                this.gatherOperand(((MirRvalue.CheckedBinaryOpUse)rvalue).getRight());
            } else if (mirRvalue instanceof MirRvalue.UnaryOpUse) {
                this.gatherOperand(((MirRvalue.UnaryOpUse)rvalue).getOperand());
            } else {
                if (mirRvalue instanceof MirRvalue.CopyForDeref) {
                    throw new IllegalStateException("unreachable".toString());
                }
                if (mirRvalue instanceof MirRvalue.Cast) {
                    this.gatherOperand(((MirRvalue.Cast)rvalue).getOperand());
                } else if (!(mirRvalue instanceof MirRvalue.Ref || mirRvalue instanceof MirRvalue.AddressOf || mirRvalue instanceof MirRvalue.Discriminant || mirRvalue instanceof MirRvalue.Len || mirRvalue instanceof MirRvalue.NullaryOpUse || mirRvalue instanceof MirRvalue.SubstitutesUse)) {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
    }

    private final void gatherOperand(MirOperand operand) {
        if (operand instanceof MirOperand.Move) {
            this.gatherMove(((MirOperand.Move)operand).getPlace());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void gatherMove(MirPlace place) {
        RsResult<MovePath, MoveError> path = this.movePathFor(place);
        if (path instanceof RsResult.Ok) {
            this.recordMove((MovePath)((RsResult.Ok)path).getOk());
            return;
        } else {
            if (!(path instanceof RsResult.Err)) throw new NoWhenBranchMatchedException();
            if (!((MoveError)((RsResult.Err)path).getErr() instanceof MoveError.IllegalMove)) throw new NoWhenBranchMatchedException();
            this.errors.add((Pair<MirPlace, MoveError>)TuplesKt.to((Object)place, ((RsResult.Err)path).getErr()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void recordMove(MovePath path) {
        Object object;
        void $this$getOrPut$iv;
        MoveOut moveOut = this.data.getMoves().allocate((Function1<Integer, MoveOut>)((Function1)arg_0 -> MoveDataBuilder.recordMove$lambda$0(path, this, arg_0)));
        Object v = ((IndexKeyMap)this.data.getPathMap()).get(path);
        Intrinsics.checkNotNull(v);
        ((List)v).add(moveOut);
        Map map2 = this.data.getLocMap();
        MirLocation mirLocation = this.loc;
        if (mirLocation == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"loc");
            mirLocation = null;
        }
        MirLocation key$iv = mirLocation;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            List answer$iv = new ArrayList();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ((List)object).add(moveOut);
    }

    public final void gatherArgs() {
        for (MirLocal arg : this.body.getArgs()) {
            MovePath path = this.data.getRevLookup().find(arg);
            Init init = this.data.getInits().allocate((Function1<Integer, Init>)((Function1)arg_0 -> MoveDataBuilder.gatherArgs$lambda$0(path, arg, arg_0)));
            Object v = ((IndexKeyMap)this.data.getInitPathMap()).get(path);
            Intrinsics.checkNotNull(v);
            ((List)v).add(init);
        }
    }

    @NotNull
    public final RsResult<MoveData, Pair<MoveData, List<Pair<MirPlace, MoveError>>>> doFinalize() {
        return this.errors.isEmpty() ? (RsResult)new RsResult.Ok<MoveDataImpl>(this.data) : (RsResult)new RsResult.Err<Pair>(TuplesKt.to((Object)this.data, this.errors));
    }

    private static final MirPlace movePathFor$lambda$0$0(MirPlace $place, int $i) {
        return new MirPlace($place.getLocal(), $place.getProjections().subList(0, $i + 1));
    }

    private static final Init gatherInit$lambda$0(MovePath $path, MoveDataBuilder this$0, InitKind $kind, int it2) {
        MirLocation mirLocation = this$0.loc;
        if (mirLocation == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"loc");
            mirLocation = null;
        }
        return new Init(it2, $path, new InitLocation.Statement(mirLocation), $kind);
    }

    private static final MoveOut recordMove$lambda$0(MovePath $path, MoveDataBuilder this$0, int it2) {
        MirLocation mirLocation = this$0.loc;
        if (mirLocation == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"loc");
            mirLocation = null;
        }
        return new MoveOut(it2, $path, mirLocation);
    }

    private static final Init gatherArgs$lambda$0(MovePath $path, MirLocal $arg, int index) {
        return new Init(index, $path, new InitLocation.Argument($arg), InitKind.Deep);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\\\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\r2\u0018\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u000e0\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\u0015"}, d2={"Lorg/rust/lang/core/mir/dataflow/move/MoveDataBuilder$Companion;", "", "<init>", "()V", "new", "Lorg/rust/lang/core/mir/dataflow/move/MoveDataBuilder;", "body", "Lorg/rust/lang/core/mir/schemas/MirBody;", "newMovePath", "Lorg/rust/lang/core/mir/dataflow/move/MovePath;", "movePaths", "Lorg/rust/lang/core/mir/util/IndexAlloc;", "pathMap", "Lorg/rust/lang/core/mir/util/IndexKeyMap;", "", "Lorg/rust/lang/core/mir/dataflow/move/MoveOut;", "initPathMap", "Lorg/rust/lang/core/mir/dataflow/move/Init;", "parent", "place", "Lorg/rust/lang/core/mir/schemas/MirPlace;", "intellij.rustrover.core"})
    @SourceDebugExtension(value={"SMAP\nMovePaths.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MovePaths.kt\norg/rust/lang/core/mir/dataflow/move/MoveDataBuilder$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,491:1\n1563#2:492\n1634#2,3:493\n*S KotlinDebug\n*F\n+ 1 MovePaths.kt\norg/rust/lang/core/mir/dataflow/move/MoveDataBuilder$Companion\n*L\n460#1:492\n460#1:493,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final MoveDataBuilder new(@NotNull MirBody body) {
            Collection<MovePath> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            IndexAlloc<MovePath> movePaths = new IndexAlloc<MovePath>();
            IndexKeyMap<MovePath, List<MoveOut>> pathMap = new IndexKeyMap<MovePath, List<MoveOut>>();
            IndexKeyMap<MovePath, List<Init>> initPathMap = new IndexKeyMap<MovePath, List<Init>>();
            Iterable iterable = body.getLocalDecls();
            IndexKeyMap.Companion companion = IndexKeyMap.Companion;
            IndexKeyMap<MovePath, List<MoveOut>> indexKeyMap = pathMap;
            LocationMap<List<MoveOut>> locationMap = new LocationMap<List<MoveOut>>(body);
            IndexAlloc<MoveOut> indexAlloc = new IndexAlloc<MoveOut>();
            IndexAlloc<MovePath> indexAlloc2 = movePaths;
            MirBody mirBody = body;
            boolean $i$f$map = false;
            void var7_13 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                MirLocal mirLocal = (MirLocal)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Companion.newMovePath(movePaths, pathMap, initPathMap, null, new MirPlace((MirLocal)it2, null, 2, null)));
            }
            collection = (List)destination$iv$iv;
            Map map2 = new HashMap();
            Map<MirLocal, MovePath> map3 = companion.fromListUnchecked(collection);
            IndexKeyMap<MovePath, List<Init>> indexKeyMap2 = initPathMap;
            LocationMap<List<Init>> locationMap2 = new LocationMap<List<Init>>(body);
            IndexAlloc<Init> indexAlloc3 = new IndexAlloc<Init>();
            MovePathLookup movePathLookup = new MovePathLookup(map3, map2);
            IndexKeyMap<MovePath, List<MoveOut>> indexKeyMap3 = indexKeyMap;
            LocationMap<List<MoveOut>> locationMap3 = locationMap;
            IndexAlloc<MoveOut> indexAlloc4 = indexAlloc;
            IndexAlloc<MovePath> indexAlloc5 = indexAlloc2;
            MoveDataImpl moveDataImpl = new MoveDataImpl(indexAlloc5, indexAlloc4, locationMap3, indexKeyMap3, movePathLookup, indexAlloc3, locationMap2, indexKeyMap2);
            MirBody mirBody2 = mirBody;
            return new MoveDataBuilder(mirBody2, moveDataImpl);
        }

        private final MovePath newMovePath(IndexAlloc<MovePath> movePaths, IndexKeyMap<MovePath, List<MoveOut>> pathMap, IndexKeyMap<MovePath, List<Init>> initPathMap, MovePath parent2, MirPlace place) {
            MovePath movePath = movePaths.allocate((Function1<Integer, MovePath>)((Function1)arg_0 -> Companion.newMovePath$lambda$0(place, parent2, arg_0)));
            if (parent2 != null) {
                MovePath nextSibling = parent2.getFirstChild();
                parent2.setFirstChild(movePath);
                movePath.setNextSibling(nextSibling);
            }
            ((Map)pathMap).put(movePath, (List)new ArrayList());
            ((Map)initPathMap).put(movePath, (List)new ArrayList());
            return movePath;
        }

        private static final MovePath newMovePath$lambda$0(MirPlace $place, MovePath $parent, int it2) {
            return new MovePath(it2, $place, $parent, null, null, 24, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

