/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.mir.dataflow.move;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.lang.core.mir.dataflow.move.Init;
import org.rust.lang.core.mir.dataflow.move.MoveDataBuilder;
import org.rust.lang.core.mir.dataflow.move.MoveError;
import org.rust.lang.core.mir.dataflow.move.MoveOut;
import org.rust.lang.core.mir.dataflow.move.MovePath;
import org.rust.lang.core.mir.dataflow.move.MovePathLookup;
import org.rust.lang.core.mir.schemas.MirBasicBlock;
import org.rust.lang.core.mir.schemas.MirBody;
import org.rust.lang.core.mir.schemas.MirLocal;
import org.rust.lang.core.mir.schemas.MirLocation;
import org.rust.lang.core.mir.schemas.MirPlace;
import org.rust.lang.core.mir.schemas.MirStatement;
import org.rust.stdext.RsResult;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cJ\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\nH\u0016R$\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR$\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\bR\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR$\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00050\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\bR$\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00050\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\bR\u0012\u0010\u0015\u001a\u00020\u0016X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u001d\u00c0\u0006\u0001"}, d2={"Lorg/rust/lang/core/mir/dataflow/move/MoveData;", "", "locMap", "", "Lorg/rust/lang/core/mir/schemas/MirLocation;", "", "Lorg/rust/lang/core/mir/dataflow/move/MoveOut;", "getLocMap", "()Ljava/util/Map;", "pathMap", "Lorg/rust/lang/core/mir/dataflow/move/MovePath;", "getPathMap", "revLookup", "Lorg/rust/lang/core/mir/dataflow/move/MovePathLookup;", "getRevLookup", "()Lorg/rust/lang/core/mir/dataflow/move/MovePathLookup;", "initLocMap", "Lorg/rust/lang/core/mir/dataflow/move/Init;", "getInitLocMap", "initPathMap", "getInitPathMap", "movePathsCount", "", "getMovePathsCount", "()I", "baseLocal", "Lorg/rust/lang/core/mir/schemas/MirLocal;", "initPath", "Companion", "intellij.rustrover.core"})
public interface MoveData {
    @NotNull
    public static final Companion Companion = org.rust.lang.core.mir.dataflow.move.MoveData$Companion.$$INSTANCE;

    @NotNull
    public Map<MirLocation, List<MoveOut>> getLocMap();

    @NotNull
    public Map<MovePath, List<MoveOut>> getPathMap();

    @NotNull
    public MovePathLookup getRevLookup();

    @NotNull
    public Map<MirLocation, List<Init>> getInitLocMap();

    @NotNull
    public Map<MovePath, List<Init>> getInitPathMap();

    public int getMovePathsCount();

    @Nullable
    default public MirLocal baseLocal(@NotNull MovePath initPath) {
        Intrinsics.checkNotNullParameter((Object)initPath, (String)"initPath");
        MovePath path = initPath;
        while (true) {
            MirLocal local;
            if ((local = path.getPlace().getLocal()) != null) {
                return local;
            }
            MovePath parent2 = path.getParent();
            if (parent2 == null) break;
            path = parent2;
        }
        return null;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J<\u0010\u0004\u001a0\u0012\u0004\u0012\u00020\u0006\u0012\"\u0012 \u0012\u0004\u0012\u00020\u0006\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u00070\b0\u00070\u0005j\u0002`\u000b2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Lorg/rust/lang/core/mir/dataflow/move/MoveData$Companion;", "", "<init>", "()V", "gatherMoves", "Lorg/rust/stdext/RsResult;", "Lorg/rust/lang/core/mir/dataflow/move/MoveData;", "Lkotlin/Pair;", "", "Lorg/rust/lang/core/mir/schemas/MirPlace;", "Lorg/rust/lang/core/mir/dataflow/move/MoveError;", "Lorg/rust/lang/core/mir/dataflow/move/MoveDat;", "body", "Lorg/rust/lang/core/mir/schemas/MirBody;", "intellij.rustrover.core"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @NotNull
        public final RsResult<MoveData, Pair<MoveData, List<Pair<MirPlace, MoveError>>>> gatherMoves(@NotNull MirBody body) {
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            MoveDataBuilder builder = MoveDataBuilder.Companion.new(body);
            builder.gatherArgs();
            for (MirBasicBlock bb : body.getBasicBlocks()) {
                Iterator iterator2 = ((Iterable)bb.getStatements()).iterator();
                int n = 0;
                while (iterator2.hasNext()) {
                    int i2 = n++;
                    MirStatement stmt = (MirStatement)iterator2.next();
                    MirLocation loc = new MirLocation(bb, i2);
                    builder.gatherStatement(loc, stmt);
                }
                MirLocation terminatorLoc = new MirLocation(bb, bb.getStatements().size());
                builder.gatherTerminator(terminatorLoc, bb.getTerminator());
            }
            return builder.doFinalize();
        }

        static {
            $$INSTANCE = new Companion();
        }
    }
}

