/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.mir.dataflow.impls;

import java.util.BitSet;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.rust.lang.core.mir.dataflow.framework.Direction;
import org.rust.lang.core.mir.dataflow.framework.Forward;
import org.rust.lang.core.mir.dataflow.framework.GenKill;
import org.rust.lang.core.mir.dataflow.framework.GenKillAnalysis;
import org.rust.lang.core.mir.dataflow.move.DropFlagEffectKt;
import org.rust.lang.core.mir.dataflow.move.DropFlagState;
import org.rust.lang.core.mir.dataflow.move.LookupResult;
import org.rust.lang.core.mir.dataflow.move.MoveData;
import org.rust.lang.core.mir.dataflow.move.MovePath;
import org.rust.lang.core.mir.schemas.MirBasicBlock;
import org.rust.lang.core.mir.schemas.MirBody;
import org.rust.lang.core.mir.schemas.MirLocation;
import org.rust.lang.core.mir.schemas.MirPlace;
import org.rust.lang.core.mir.schemas.MirStatement;
import org.rust.lang.core.mir.schemas.MirTerminator;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0016J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u000bH\u0016J \u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J&\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u000b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J \u0010 \u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020#H\u0016J \u0010$\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006)"}, d2={"Lorg/rust/lang/core/mir/dataflow/impls/MaybeUninitializedPlaces;", "Lorg/rust/lang/core/mir/dataflow/framework/GenKillAnalysis;", "moveData", "Lorg/rust/lang/core/mir/dataflow/move/MoveData;", "<init>", "(Lorg/rust/lang/core/mir/dataflow/move/MoveData;)V", "direction", "Lorg/rust/lang/core/mir/dataflow/framework/Direction;", "getDirection", "()Lorg/rust/lang/core/mir/dataflow/framework/Direction;", "bottomValue", "Ljava/util/BitSet;", "body", "Lorg/rust/lang/core/mir/schemas/MirBody;", "domainSize", "", "mirBody", "statementEffect", "", "trans", "Lorg/rust/lang/core/mir/dataflow/framework/GenKill;", "statement", "Lorg/rust/lang/core/mir/schemas/MirStatement;", "location", "Lorg/rust/lang/core/mir/schemas/MirLocation;", "initializeStartBlock", "state", "applyStatementEffect", "applyTerminatorEffect", "terminator", "Lorg/rust/lang/core/mir/schemas/MirTerminator;", "Lorg/rust/lang/core/mir/schemas/MirBasicBlock;", "applyCallReturnEffect", "block", "returnPlace", "Lorg/rust/lang/core/mir/schemas/MirPlace;", "updateBits", "movePath", "Lorg/rust/lang/core/mir/dataflow/move/MovePath;", "movePathState", "Lorg/rust/lang/core/mir/dataflow/move/DropFlagState;", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nMaybeUninitializedPlaces.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MaybeUninitializedPlaces.kt\norg/rust/lang/core/mir/dataflow/impls/MaybeUninitializedPlaces\n+ 2 utils.kt\norg/rust/openapiext/UtilsKt\n*L\n1#1,68:1\n305#2,10:69\n*S KotlinDebug\n*F\n+ 1 MaybeUninitializedPlaces.kt\norg/rust/lang/core/mir/dataflow/impls/MaybeUninitializedPlaces\n*L\n37#1:69,10\n*E\n"})
public final class MaybeUninitializedPlaces
implements GenKillAnalysis {
    @NotNull
    private final MoveData moveData;
    @NotNull
    private final Direction direction;

    public MaybeUninitializedPlaces(@NotNull MoveData moveData) {
        Intrinsics.checkNotNullParameter((Object)moveData, (String)"moveData");
        this.moveData = moveData;
        this.direction = Forward.INSTANCE;
    }

    @Override
    @NotNull
    public Direction getDirection() {
        return this.direction;
    }

    @Override
    @NotNull
    public BitSet bottomValue(@NotNull MirBody body) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        return new BitSet(this.moveData.getMovePathsCount());
    }

    @Override
    public int domainSize(@NotNull MirBody mirBody) {
        Intrinsics.checkNotNullParameter((Object)mirBody, (String)"mirBody");
        return this.moveData.getMovePathsCount();
    }

    @Override
    public void statementEffect(@NotNull GenKill trans, @NotNull MirStatement statement, @NotNull MirLocation location) {
        Intrinsics.checkNotNullParameter((Object)trans, (String)"trans");
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        DropFlagEffectKt.dropFlagEffectsForLocation(this.moveData, location, (Function2<? super MovePath, ? super DropFlagState, Unit>)((Function2)(arg_0, arg_1) -> MaybeUninitializedPlaces.statementEffect$lambda$0(this, trans, arg_0, arg_1)));
    }

    @Override
    public void initializeStartBlock(@NotNull MirBody body, @NotNull BitSet state) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        state.set(0, this.moveData.getMovePathsCount());
        DropFlagEffectKt.dropFlagEffectsForFunctionEntry(body, this.moveData, (Function2<? super MovePath, ? super DropFlagState, Unit>)((Function2)(arg_0, arg_1) -> MaybeUninitializedPlaces.initializeStartBlock$lambda$0(state, arg_0, arg_1)));
    }

    @Override
    public void applyStatementEffect(@NotNull BitSet state, @NotNull MirStatement statement, @NotNull MirLocation location) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.statementEffect(GenKill.Companion.asGenKill(state), statement, location);
    }

    @Override
    public void applyTerminatorEffect(@NotNull BitSet state, @NotNull MirTerminator<? extends MirBasicBlock> terminator, @NotNull MirLocation location) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter(terminator, (String)"terminator");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        DropFlagEffectKt.dropFlagEffectsForLocation(this.moveData, location, (Function2<? super MovePath, ? super DropFlagState, Unit>)((Function2)(arg_0, arg_1) -> MaybeUninitializedPlaces.applyTerminatorEffect$lambda$0(this, state, arg_0, arg_1)));
    }

    @Override
    public void applyCallReturnEffect(@NotNull BitSet state, @NotNull MirBasicBlock block, @NotNull MirPlace returnPlace) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)returnPlace, (String)"returnPlace");
        LookupResult lookupResult = this.moveData.getRevLookup().find(returnPlace);
        if (lookupResult instanceof LookupResult.Exact) {
            DropFlagEffectKt.onAllChildrenBits(((LookupResult.Exact)lookupResult).getMovePath(), (Function1<? super MovePath, Unit>)((Function1)arg_0 -> MaybeUninitializedPlaces.applyCallReturnEffect$lambda$0(this, state, arg_0)));
        }
    }

    private final void updateBits(GenKill trans, MovePath movePath, DropFlagState movePathState) {
        switch (WhenMappings.$EnumSwitchMapping$0[movePathState.ordinal()]) {
            case 1: {
                trans.gen(movePath.getIndex());
                break;
            }
            case 2: {
                trans.kill(movePath.getIndex());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private static final Unit statementEffect$lambda$0(MaybeUninitializedPlaces this$0, GenKill $trans, MovePath movePath, DropFlagState movePathState) {
        Intrinsics.checkNotNullParameter((Object)movePath, (String)"movePath");
        Intrinsics.checkNotNullParameter((Object)((Object)movePathState), (String)"movePathState");
        this$0.updateBits($trans, movePath, movePathState);
        return Unit.INSTANCE;
    }

    private static final Unit initializeStartBlock$lambda$0(BitSet $state, MovePath path, DropFlagState dropFlagState) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)((Object)dropFlagState), (String)"dropFlagState");
        boolean $i$f$testAssert = false;
        boolean $i$f$testAssert2 = false;
        if (UtilsKt.isUnitTestMode()) {
            boolean bl = false;
            if (!(dropFlagState == DropFlagState.Present)) {
                boolean bl2 = false;
                String message$iv$iv = "Assertion failed";
                throw new AssertionError((Object)message$iv$iv);
            }
        }
        $state.clear(path.getIndex());
        return Unit.INSTANCE;
    }

    private static final Unit applyTerminatorEffect$lambda$0(MaybeUninitializedPlaces this$0, BitSet $state, MovePath movePath, DropFlagState movePathState) {
        Intrinsics.checkNotNullParameter((Object)movePath, (String)"movePath");
        Intrinsics.checkNotNullParameter((Object)((Object)movePathState), (String)"movePathState");
        this$0.updateBits(GenKill.Companion.asGenKill($state), movePath, movePathState);
        return Unit.INSTANCE;
    }

    private static final Unit applyCallReturnEffect$lambda$0(MaybeUninitializedPlaces this$0, BitSet $state, MovePath it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        this$0.updateBits(GenKill.Companion.asGenKill($state), it2, DropFlagState.Present);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DropFlagState.values().length];
            try {
                nArray[DropFlagState.Absent.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DropFlagState.Present.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

