/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.mir.dataflow.impls;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.rust.lang.core.mir.dataflow.framework.BorrowData;
import org.rust.lang.core.mir.dataflow.framework.BorrowSet;
import org.rust.lang.core.mir.dataflow.framework.Direction;
import org.rust.lang.core.mir.dataflow.framework.Forward;
import org.rust.lang.core.mir.dataflow.framework.GenKill;
import org.rust.lang.core.mir.dataflow.framework.GenKillAnalysis;
import org.rust.lang.core.mir.dataflow.impls.BorrowsKt;
import org.rust.lang.core.mir.schemas.MirBasicBlock;
import org.rust.lang.core.mir.schemas.MirBody;
import org.rust.lang.core.mir.schemas.MirLocation;
import org.rust.lang.core.mir.schemas.MirPlace;
import org.rust.lang.core.mir.schemas.MirRvalue;
import org.rust.lang.core.mir.schemas.MirStatement;
import org.rust.lang.core.mir.schemas.MirTerminator;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0012H\u0016J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0006H\u0016J\u0018\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u0010H\u0016J \u0010\u001f\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0006H\u0016J \u0010 \u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0006H\u0016J&\u0010!\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u00102\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010\u001c\u001a\u00020\u0006H\u0016J&\u0010%\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u00102\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010\u001c\u001a\u00020\u0006H\u0016J\u0018\u0010&\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u0006H\u0002J\u0018\u0010'\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010(\u001a\u00020)H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006*"}, d2={"Lorg/rust/lang/core/mir/dataflow/impls/Borrows;", "Lorg/rust/lang/core/mir/dataflow/framework/GenKillAnalysis;", "borrowSet", "Lorg/rust/lang/core/mir/dataflow/framework/BorrowSet;", "borrowsOutOfScopeAtLocation", "", "Lorg/rust/lang/core/mir/schemas/MirLocation;", "", "Lorg/rust/lang/core/mir/dataflow/framework/BorrowData;", "<init>", "(Lorg/rust/lang/core/mir/dataflow/framework/BorrowSet;Ljava/util/Map;)V", "direction", "Lorg/rust/lang/core/mir/dataflow/framework/Direction;", "getDirection", "()Lorg/rust/lang/core/mir/dataflow/framework/Direction;", "bottomValue", "Ljava/util/BitSet;", "body", "Lorg/rust/lang/core/mir/schemas/MirBody;", "domainSize", "", "mirBody", "statementEffect", "", "trans", "Lorg/rust/lang/core/mir/dataflow/framework/GenKill;", "statement", "Lorg/rust/lang/core/mir/schemas/MirStatement;", "location", "initializeStartBlock", "state", "applyBeforeStatementEffect", "applyStatementEffect", "applyBeforeTerminatorEffect", "terminator", "Lorg/rust/lang/core/mir/schemas/MirTerminator;", "Lorg/rust/lang/core/mir/schemas/MirBasicBlock;", "applyTerminatorEffect", "killLoansOutOfScopeAtLocation", "killBorrowsOnPlace", "place", "Lorg/rust/lang/core/mir/schemas/MirPlace;", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nBorrows.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Borrows.kt\norg/rust/lang/core/mir/dataflow/impls/Borrows\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,154:1\n774#2:155\n865#2,2:156\n*S KotlinDebug\n*F\n+ 1 Borrows.kt\norg/rust/lang/core/mir/dataflow/impls/Borrows\n*L\n107#1:155\n107#1:156,2\n*E\n"})
public final class Borrows
implements GenKillAnalysis {
    @NotNull
    private final BorrowSet borrowSet;
    @NotNull
    private final Map<MirLocation, List<BorrowData>> borrowsOutOfScopeAtLocation;
    @NotNull
    private final Direction direction;

    public Borrows(@NotNull BorrowSet borrowSet, @NotNull Map<MirLocation, ? extends List<BorrowData>> borrowsOutOfScopeAtLocation) {
        Intrinsics.checkNotNullParameter((Object)borrowSet, (String)"borrowSet");
        Intrinsics.checkNotNullParameter(borrowsOutOfScopeAtLocation, (String)"borrowsOutOfScopeAtLocation");
        this.borrowSet = borrowSet;
        this.borrowsOutOfScopeAtLocation = borrowsOutOfScopeAtLocation;
        this.direction = Forward.INSTANCE;
    }

    @Override
    @NotNull
    public Direction getDirection() {
        return this.direction;
    }

    @Override
    @NotNull
    public BitSet bottomValue(@NotNull MirBody body) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        return new BitSet(this.borrowSet.getSize());
    }

    @Override
    public int domainSize(@NotNull MirBody mirBody) {
        Intrinsics.checkNotNullParameter((Object)mirBody, (String)"mirBody");
        return this.borrowSet.getSize();
    }

    @Override
    public void statementEffect(@NotNull GenKill trans, @NotNull MirStatement statement, @NotNull MirLocation location) {
        Intrinsics.checkNotNullParameter((Object)trans, (String)"trans");
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        MirStatement mirStatement = statement;
        if (mirStatement instanceof MirStatement.Assign) {
            MirRvalue rhs = ((MirStatement.Assign)statement).getRvalue();
            if (rhs instanceof MirRvalue.Ref) {
                if (BorrowsKt.ignoreBorrow(((MirRvalue.Ref)rhs).getPlace(), this.borrowSet.getLocalsStateAtExit())) {
                    return;
                }
                BorrowData borrowData = this.borrowSet.getLocationMap().get(location);
                if (borrowData == null) {
                    return;
                }
                BorrowData borrowData2 = borrowData;
                trans.gen(borrowData2.getIndex());
            }
            this.killBorrowsOnPlace(trans, ((MirStatement.Assign)statement).getPlace());
        } else if (mirStatement instanceof MirStatement.StorageDead) {
            this.killBorrowsOnPlace(trans, new MirPlace(((MirStatement.StorageDead)statement).getLocal(), null, 2, null));
        }
    }

    @Override
    public void initializeStartBlock(@NotNull MirBody body, @NotNull BitSet state) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
    }

    @Override
    public void applyBeforeStatementEffect(@NotNull BitSet state, @NotNull MirStatement statement, @NotNull MirLocation location) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.killLoansOutOfScopeAtLocation(state, location);
    }

    @Override
    public void applyStatementEffect(@NotNull BitSet state, @NotNull MirStatement statement, @NotNull MirLocation location) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.statementEffect(GenKill.Companion.asGenKill(state), statement, location);
    }

    @Override
    public void applyBeforeTerminatorEffect(@NotNull BitSet state, @NotNull MirTerminator<? extends MirBasicBlock> terminator, @NotNull MirLocation location) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter(terminator, (String)"terminator");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.killLoansOutOfScopeAtLocation(state, location);
    }

    @Override
    public void applyTerminatorEffect(@NotNull BitSet state, @NotNull MirTerminator<? extends MirBasicBlock> terminator, @NotNull MirLocation location) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter(terminator, (String)"terminator");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
    }

    private final void killLoansOutOfScopeAtLocation(BitSet trans, MirLocation location) {
        List<BorrowData> list = this.borrowsOutOfScopeAtLocation.get(location);
        if (list == null) {
            return;
        }
        List<BorrowData> borrows = list;
        for (BorrowData borrow : borrows) {
            trans.set(borrow.getIndex(), false);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void killBorrowsOnPlace(GenKill trans, MirPlace place) {
        void $this$filterTo$iv$iv;
        Set otherBorrowsOfLocal;
        Set set = this.borrowSet.getLocalMap().get((Object)place.getLocal());
        if (set == null) {
            set = otherBorrowsOfLocal = SetsKt.emptySet();
        }
        if (place.getProjections().isEmpty()) {
            if (!place.getLocal().isRefToStatic()) {
                for (BorrowData borrow : otherBorrowsOfLocal) {
                    trans.kill(borrow.getIndex());
                }
            }
            return;
        }
        Iterable $this$filter$iv = otherBorrowsOfLocal;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            BorrowData cfr_ignored_0 = (BorrowData)element$iv$iv;
            boolean bl = false;
            if (!false) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List definitelyConflictingBorrows = (List)destination$iv$iv;
        for (BorrowData borrow : definitelyConflictingBorrows) {
            trans.kill(borrow.getIndex());
        }
    }
}

