/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.mir.dataflow.framework;

import java.util.ArrayDeque;
import java.util.BitSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.lang.core.mir.WithIndex;
import org.rust.lang.core.mir.dataflow.framework.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0013\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u000fJ\u000b\u0010\u0010\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0011J\u0006\u0010\u0012\u001a\u00020\u0013R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/rust/lang/core/mir/dataflow/framework/WorkQueue;", "T", "Lorg/rust/lang/core/mir/WithIndex;", "", "size", "", "<init>", "(I)V", "deque", "Ljava/util/ArrayDeque;", "set", "Ljava/util/BitSet;", "insert", "", "element", "(Lorg/rust/lang/core/mir/WithIndex;)V", "pop", "()Lorg/rust/lang/core/mir/WithIndex;", "isEmpty", "", "intellij.rustrover.core"})
public final class WorkQueue<T extends WithIndex> {
    @NotNull
    private final ArrayDeque<T> deque;
    @NotNull
    private final BitSet set;

    public WorkQueue(int size) {
        this.deque = new ArrayDeque(size);
        this.set = new BitSet(size);
    }

    public final void insert(@NotNull T element) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        if (UtilsKt.add(this.set, element.getIndex())) {
            this.deque.push(element);
        }
    }

    @NotNull
    public final T pop() {
        WithIndex element = (WithIndex)this.deque.pop();
        this.set.set(element.getIndex(), false);
        Intrinsics.checkNotNull((Object)element);
        return (T)element;
    }

    public final boolean isEmpty() {
        return this.deque.isEmpty();
    }
}

