/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.mir.dataflow.framework;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.lang.core.mir.dataflow.framework.Analysis;
import org.rust.lang.core.mir.dataflow.framework.Direction;
import org.rust.lang.core.mir.dataflow.framework.ResultsVisitable;
import org.rust.lang.core.mir.schemas.MirBasicBlock;
import org.rust.lang.core.mir.schemas.MirBody;
import org.rust.lang.core.mir.schemas.MirLocation;
import org.rust.lang.core.mir.schemas.MirStatement;
import org.rust.lang.core.mir.schemas.MirTerminator;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B#\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001d\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016J%\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016\u00a2\u0006\u0002\u0010\u001cJ%\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016\u00a2\u0006\u0002\u0010\u001cJ+\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00028\u00002\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00150 2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016\u00a2\u0006\u0002\u0010!J+\u0010\"\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00028\u00002\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00150 2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016\u00a2\u0006\u0002\u0010!J\u0015\u0010#\u001a\u00028\u00002\u0006\u0010$\u001a\u00020%H\u0016\u00a2\u0006\u0002\u0010&R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006'"}, d2={"Lorg/rust/lang/core/mir/dataflow/framework/Results;", "Domain", "Lorg/rust/lang/core/mir/dataflow/framework/ResultsVisitable;", "analysis", "Lorg/rust/lang/core/mir/dataflow/framework/Analysis;", "blockStates", "", "<init>", "(Lorg/rust/lang/core/mir/dataflow/framework/Analysis;Ljava/util/List;)V", "getAnalysis", "()Lorg/rust/lang/core/mir/dataflow/framework/Analysis;", "getBlockStates", "()Ljava/util/List;", "direction", "Lorg/rust/lang/core/mir/dataflow/framework/Direction;", "getDirection", "()Lorg/rust/lang/core/mir/dataflow/framework/Direction;", "resetToBlockEntry", "", "state", "block", "Lorg/rust/lang/core/mir/schemas/MirBasicBlock;", "(Ljava/lang/Object;Lorg/rust/lang/core/mir/schemas/MirBasicBlock;)V", "reconstructBeforeStatementEffect", "statement", "Lorg/rust/lang/core/mir/schemas/MirStatement;", "location", "Lorg/rust/lang/core/mir/schemas/MirLocation;", "(Ljava/lang/Object;Lorg/rust/lang/core/mir/schemas/MirStatement;Lorg/rust/lang/core/mir/schemas/MirLocation;)V", "reconstructStatementEffect", "reconstructBeforeTerminatorEffect", "terminator", "Lorg/rust/lang/core/mir/schemas/MirTerminator;", "(Ljava/lang/Object;Lorg/rust/lang/core/mir/schemas/MirTerminator;Lorg/rust/lang/core/mir/schemas/MirLocation;)V", "reconstructTerminatorEffect", "bottomValue", "body", "Lorg/rust/lang/core/mir/schemas/MirBody;", "(Lorg/rust/lang/core/mir/schemas/MirBody;)Ljava/lang/Object;", "intellij.rustrover.core"})
public final class Results<Domain>
implements ResultsVisitable<Domain> {
    @NotNull
    private final Analysis<Domain> analysis;
    @NotNull
    private final List<Domain> blockStates;

    public Results(@NotNull Analysis<Domain> analysis, @NotNull List<? extends Domain> blockStates) {
        Intrinsics.checkNotNullParameter(analysis, (String)"analysis");
        Intrinsics.checkNotNullParameter(blockStates, (String)"blockStates");
        this.analysis = analysis;
        this.blockStates = blockStates;
    }

    @NotNull
    public final Analysis<Domain> getAnalysis() {
        return this.analysis;
    }

    @NotNull
    public final List<Domain> getBlockStates() {
        return this.blockStates;
    }

    @Override
    @NotNull
    public Direction getDirection() {
        return this.analysis.getDirection();
    }

    @Override
    public void resetToBlockEntry(Domain state, @NotNull MirBasicBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        this.analysis.copyStateTo(this.blockStates.get(block.getIndex()), state);
    }

    @Override
    public void reconstructBeforeStatementEffect(Domain state, @NotNull MirStatement statement, @NotNull MirLocation location) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.analysis.applyBeforeStatementEffect(state, statement, location);
    }

    @Override
    public void reconstructStatementEffect(Domain state, @NotNull MirStatement statement, @NotNull MirLocation location) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.analysis.applyStatementEffect(state, statement, location);
    }

    @Override
    public void reconstructBeforeTerminatorEffect(Domain state, @NotNull MirTerminator<? extends MirBasicBlock> terminator, @NotNull MirLocation location) {
        Intrinsics.checkNotNullParameter(terminator, (String)"terminator");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.analysis.applyBeforeTerminatorEffect(state, terminator, location);
    }

    @Override
    public void reconstructTerminatorEffect(Domain state, @NotNull MirTerminator<? extends MirBasicBlock> terminator, @NotNull MirLocation location) {
        Intrinsics.checkNotNullParameter(terminator, (String)"terminator");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.analysis.applyTerminatorEffect(state, terminator, location);
    }

    @Override
    public Domain bottomValue(@NotNull MirBody body) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        return this.analysis.bottomValue(body);
    }
}

