/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.mir.dataflow.framework;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.rust.lang.core.mir.dataflow.framework.BorrowData;
import org.rust.lang.core.mir.dataflow.framework.LocalsStateAtExit;
import org.rust.lang.core.mir.dataflow.framework.TwoPhaseActivation;
import org.rust.lang.core.mir.dataflow.impls.BorrowsKt;
import org.rust.lang.core.mir.schemas.MirBody;
import org.rust.lang.core.mir.schemas.MirBorrowKind;
import org.rust.lang.core.mir.schemas.MirBorrowKindKt;
import org.rust.lang.core.mir.schemas.MirLocal;
import org.rust.lang.core.mir.schemas.MirLocation;
import org.rust.lang.core.mir.schemas.MirPlace;
import org.rust.lang.core.mir.schemas.MirPlaceContext;
import org.rust.lang.core.mir.schemas.MirRvalue;
import org.rust.lang.core.mir.schemas.MirVisitor;
import org.rust.lang.core.mir.util.IndexAlloc;
import org.rust.lang.core.mir.util.IndexKeyMap;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0081\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\t0\u0005\u0012\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\r0\u000b\u0012\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00070\u000b\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J\b\u0010 \u001a\u00020\fH\u0016J \u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0006H\u0016J \u0010(\u001a\u00020\"2\u0006\u0010)\u001a\u00020\f2\u0006\u0010*\u001a\u00020+2\u0006\u0010'\u001a\u00020\u0006H\u0016J \u0010,\u001a\u00020\"2\u0006\u0010-\u001a\u00020$2\u0006\u0010.\u001a\u00020/2\u0006\u0010\u0011\u001a\u00020\u0007H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R#\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\t0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0018R#\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\r0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00070\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u00060"}, d2={"Lorg/rust/lang/core/mir/dataflow/framework/GatherBorrows;", "Lorg/rust/lang/core/mir/schemas/MirVisitor;", "body", "Lorg/rust/lang/core/mir/schemas/MirBody;", "locationMap", "", "Lorg/rust/lang/core/mir/schemas/MirLocation;", "Lorg/rust/lang/core/mir/dataflow/framework/BorrowData;", "activationMap", "", "localMap", "Lorg/rust/lang/core/mir/util/IndexKeyMap;", "Lorg/rust/lang/core/mir/schemas/MirLocal;", "", "pendingActivations", "localsStateAtExit", "Lorg/rust/lang/core/mir/dataflow/framework/LocalsStateAtExit;", "borrowData", "Lorg/rust/lang/core/mir/util/IndexAlloc;", "<init>", "(Lorg/rust/lang/core/mir/schemas/MirBody;Ljava/util/Map;Ljava/util/Map;Lorg/rust/lang/core/mir/util/IndexKeyMap;Lorg/rust/lang/core/mir/util/IndexKeyMap;Lorg/rust/lang/core/mir/dataflow/framework/LocalsStateAtExit;Lorg/rust/lang/core/mir/util/IndexAlloc;)V", "getBody", "()Lorg/rust/lang/core/mir/schemas/MirBody;", "getLocationMap", "()Ljava/util/Map;", "getActivationMap", "getLocalMap", "()Lorg/rust/lang/core/mir/util/IndexKeyMap;", "getLocalsStateAtExit", "()Lorg/rust/lang/core/mir/dataflow/framework/LocalsStateAtExit;", "getBorrowData", "()Lorg/rust/lang/core/mir/util/IndexAlloc;", "returnPlace", "visitAssign", "", "place", "Lorg/rust/lang/core/mir/schemas/MirPlace;", "rvalue", "Lorg/rust/lang/core/mir/schemas/MirRvalue;", "location", "visitLocal", "local", "context", "Lorg/rust/lang/core/mir/schemas/MirPlaceContext;", "insertAsPendingIfTwoPhase", "assignedPlace", "kind", "Lorg/rust/lang/core/mir/schemas/MirBorrowKind;", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nBorrowSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BorrowSet.kt\norg/rust/lang/core/mir/dataflow/framework/GatherBorrows\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,203:1\n382#2,7:204\n382#2,7:211\n*S KotlinDebug\n*F\n+ 1 BorrowSet.kt\norg/rust/lang/core/mir/dataflow/framework/GatherBorrows\n*L\n170#1:204,7\n187#1:211,7\n*E\n"})
public final class GatherBorrows
implements MirVisitor {
    @NotNull
    private final MirBody body;
    @NotNull
    private final Map<MirLocation, BorrowData> locationMap;
    @NotNull
    private final Map<MirLocation, List<BorrowData>> activationMap;
    @NotNull
    private final IndexKeyMap<MirLocal, Set<BorrowData>> localMap;
    @NotNull
    private final IndexKeyMap<MirLocal, BorrowData> pendingActivations;
    @NotNull
    private final LocalsStateAtExit localsStateAtExit;
    @NotNull
    private final IndexAlloc<BorrowData> borrowData;

    public GatherBorrows(@NotNull MirBody body, @NotNull Map<MirLocation, BorrowData> locationMap, @NotNull Map<MirLocation, List<BorrowData>> activationMap, @NotNull IndexKeyMap<MirLocal, Set<BorrowData>> localMap, @NotNull IndexKeyMap<MirLocal, BorrowData> pendingActivations, @NotNull LocalsStateAtExit localsStateAtExit, @NotNull IndexAlloc<BorrowData> borrowData) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter(locationMap, (String)"locationMap");
        Intrinsics.checkNotNullParameter(activationMap, (String)"activationMap");
        Intrinsics.checkNotNullParameter(localMap, (String)"localMap");
        Intrinsics.checkNotNullParameter(pendingActivations, (String)"pendingActivations");
        Intrinsics.checkNotNullParameter((Object)localsStateAtExit, (String)"localsStateAtExit");
        Intrinsics.checkNotNullParameter(borrowData, (String)"borrowData");
        this.body = body;
        this.locationMap = locationMap;
        this.activationMap = activationMap;
        this.localMap = localMap;
        this.pendingActivations = pendingActivations;
        this.localsStateAtExit = localsStateAtExit;
        this.borrowData = borrowData;
    }

    @NotNull
    public final MirBody getBody() {
        return this.body;
    }

    @NotNull
    public final Map<MirLocation, BorrowData> getLocationMap() {
        return this.locationMap;
    }

    @NotNull
    public final Map<MirLocation, List<BorrowData>> getActivationMap() {
        return this.activationMap;
    }

    @NotNull
    public final IndexKeyMap<MirLocal, Set<BorrowData>> getLocalMap() {
        return this.localMap;
    }

    @NotNull
    public final LocalsStateAtExit getLocalsStateAtExit() {
        return this.localsStateAtExit;
    }

    @NotNull
    public final IndexAlloc<BorrowData> getBorrowData() {
        return this.borrowData;
    }

    @Override
    @NotNull
    public MirLocal returnPlace() {
        return this.body.returnPlace();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitAssign(@NotNull MirPlace place, @NotNull MirRvalue rvalue, @NotNull MirLocation location) {
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)rvalue, (String)"rvalue");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        if (rvalue instanceof MirRvalue.Ref) {
            Object object;
            void $this$getOrPut$iv;
            if (BorrowsKt.ignoreBorrow(((MirRvalue.Ref)rvalue).getPlace(), this.localsStateAtExit)) {
                return;
            }
            BorrowData borrow = this.borrowData.allocate((Function1<Integer, BorrowData>)((Function1)arg_0 -> GatherBorrows.visitAssign$lambda$0(location, rvalue, place, arg_0)));
            BorrowData borrowData = this.locationMap.putIfAbsent(location, borrow);
            if (borrowData == null) {
                borrowData = borrow;
            }
            BorrowData borrowFromMap = borrowData;
            this.insertAsPendingIfTwoPhase(place, ((MirRvalue.Ref)rvalue).getBorrowKind(), borrowFromMap);
            Map map2 = this.localMap;
            MirLocal key$iv = ((MirRvalue.Ref)rvalue).getPlace().getLocal();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                Set answer$iv = new LinkedHashSet();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((Set)object).add(borrowFromMap);
        }
        MirVisitor.super.visitAssign(place, rvalue, location);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitLocal(@NotNull MirLocal local, @NotNull MirPlaceContext context, @NotNull MirLocation location) {
        Intrinsics.checkNotNullParameter((Object)local, (String)"local");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        if (!context.isUse()) {
            return;
        }
        BorrowData borrowData = this.pendingActivations.get((Object)local);
        if (borrowData != null) {
            Object object;
            void $this$getOrPut$iv;
            if (Intrinsics.areEqual((Object)borrowData.getReserveLocation(), (Object)location) && context instanceof MirPlaceContext.MutatingUse.Store) {
                return;
            }
            Map<MirLocation, List<BorrowData>> map2 = this.activationMap;
            MirLocation key$iv = location;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((List)object).add(borrowData);
            borrowData.setActivationLocation(new TwoPhaseActivation.ActivatedAt(location));
        }
    }

    private final void insertAsPendingIfTwoPhase(MirPlace assignedPlace, MirBorrowKind kind2, BorrowData borrowData) {
        if (!MirBorrowKindKt.getAllowTwoPhaseBorrow(kind2)) {
            return;
        }
        borrowData.setActivationLocation(TwoPhaseActivation.NotActivated.INSTANCE);
        ((Map)this.pendingActivations).put(assignedPlace.getLocal(), borrowData);
    }

    private static final BorrowData visitAssign$lambda$0(MirLocation $location, MirRvalue $rvalue, MirPlace $place, int index) {
        return new BorrowData(index, $location, TwoPhaseActivation.NotTwoPhase.INSTANCE, ((MirRvalue.Ref)$rvalue).getBorrowKind(), ((MirRvalue.Ref)$rvalue).getPlace(), $place);
    }
}

