/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.mir.dataflow.framework;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.lang.core.mir.dataflow.framework.Analysis;
import org.rust.lang.core.mir.dataflow.framework.Direction;
import org.rust.lang.core.mir.dataflow.framework.Engine;
import org.rust.lang.core.mir.dataflow.framework.GenKill;
import org.rust.lang.core.mir.dataflow.framework.GenKillAnalysis;
import org.rust.lang.core.mir.dataflow.framework.ResultsVisitable;
import org.rust.lang.core.mir.dataflow.framework.ResultsVisitor;
import org.rust.lang.core.mir.schemas.MirBasicBlock;
import org.rust.lang.core.mir.schemas.MirLocation;
import org.rust.lang.core.mir.schemas.MirStatement;
import org.rust.lang.core.mir.schemas.MirTerminator;
import org.rust.lang.core.mir.schemas.UnwindAction;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JA\u0010\u0004\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00060\b2\u0006\u0010\t\u001a\u0002H\u00062\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u0002H\u0006\u0018\u00010\rH\u0016\u00a2\u0006\u0002\u0010\u000eJ \u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0016JK\u0010\u0013\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00060\b2\u0006\u0010\u0014\u001a\u0002H\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u00020\u00050\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017J?\u0010\u0018\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u00192\u0006\u0010\t\u001a\u0002H\u00192\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00190\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u00190\u001dH\u0016\u00a2\u0006\u0002\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lorg/rust/lang/core/mir/dataflow/framework/Forward;", "Lorg/rust/lang/core/mir/dataflow/framework/Direction;", "<init>", "()V", "applyEffectsInBlock", "", "Domain", "analysis", "Lorg/rust/lang/core/mir/dataflow/framework/Analysis;", "state", "block", "Lorg/rust/lang/core/mir/schemas/MirBasicBlock;", "statementEffect", "Lorg/rust/lang/core/mir/dataflow/framework/Engine$StatementEffect;", "(Lorg/rust/lang/core/mir/dataflow/framework/Analysis;Ljava/lang/Object;Lorg/rust/lang/core/mir/schemas/MirBasicBlock;Lorg/rust/lang/core/mir/dataflow/framework/Engine$StatementEffect;)V", "genKillStatementEffectsInBlock", "Lorg/rust/lang/core/mir/dataflow/framework/GenKillAnalysis;", "trans", "Lorg/rust/lang/core/mir/dataflow/framework/GenKill;", "joinStateIntoSuccessorsOf", "exitState", "propagate", "Lkotlin/Function2;", "(Lorg/rust/lang/core/mir/dataflow/framework/Analysis;Ljava/lang/Object;Lorg/rust/lang/core/mir/schemas/MirBasicBlock;Lkotlin/jvm/functions/Function2;)V", "visitResultsInBlock", "FlowState", "results", "Lorg/rust/lang/core/mir/dataflow/framework/ResultsVisitable;", "visitor", "Lorg/rust/lang/core/mir/dataflow/framework/ResultsVisitor;", "(Ljava/lang/Object;Lorg/rust/lang/core/mir/schemas/MirBasicBlock;Lorg/rust/lang/core/mir/dataflow/framework/ResultsVisitable;Lorg/rust/lang/core/mir/dataflow/framework/ResultsVisitor;)V", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nDirection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Direction.kt\norg/rust/lang/core/mir/dataflow/framework/Forward\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,141:1\n1#2:142\n19#3:143\n*S KotlinDebug\n*F\n+ 1 Direction.kt\norg/rust/lang/core/mir/dataflow/framework/Forward\n*L\n89#1:143\n*E\n"})
public final class Forward
implements Direction {
    @NotNull
    public static final Forward INSTANCE = new Forward();

    private Forward() {
    }

    @Override
    public <Domain> void applyEffectsInBlock(@NotNull Analysis<Domain> analysis, Domain state, @NotNull MirBasicBlock block, @Nullable Engine.StatementEffect<Domain> statementEffect) {
        Intrinsics.checkNotNullParameter(analysis, (String)"analysis");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        if (statementEffect != null) {
            statementEffect.apply(block, state);
        } else {
            Iterator iterator2 = ((Iterable)block.getStatements()).iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                int index = n++;
                MirStatement statement = (MirStatement)iterator2.next();
                MirLocation location = new MirLocation(block, index);
                analysis.applyStatementEffect(state, statement, location);
            }
        }
        MirLocation terminatorLocation = new MirLocation(block, block.getStatements().size());
        analysis.applyTerminatorEffect(state, block.getTerminator(), terminatorLocation);
    }

    @Override
    public void genKillStatementEffectsInBlock(@NotNull GenKillAnalysis analysis, @NotNull GenKill trans, @NotNull MirBasicBlock block) {
        Intrinsics.checkNotNullParameter((Object)analysis, (String)"analysis");
        Intrinsics.checkNotNullParameter((Object)trans, (String)"trans");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Iterator iterator2 = ((Iterable)block.getStatements()).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index = n++;
            MirStatement statement = (MirStatement)iterator2.next();
            MirLocation location = new MirLocation(block, index);
            analysis.statementEffect(trans, statement, location);
        }
    }

    @Override
    public <Domain> void joinStateIntoSuccessorsOf(@NotNull Analysis<Domain> analysis, Domain exitState, @NotNull MirBasicBlock block, @NotNull Function2<? super MirBasicBlock, ? super Domain, Unit> propagate) {
        Intrinsics.checkNotNullParameter(analysis, (String)"analysis");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter(propagate, (String)"propagate");
        MirTerminator<MirBasicBlock> terminator = block.getTerminator();
        if (!(terminator instanceof MirTerminator.Return || terminator instanceof MirTerminator.Resume || terminator instanceof MirTerminator.Unreachable)) {
            if (terminator instanceof MirTerminator.Goto) {
                propagate.invoke(((MirTerminator.Goto)terminator).getTarget(), exitState);
            } else if (terminator instanceof MirTerminator.Assert) {
                Object BB = ((MirTerminator.Assert)terminator).getUnwind();
                if (BB != null) {
                    Object it2 = BB;
                    boolean bl = false;
                    propagate.invoke(it2, exitState);
                }
                propagate.invoke(((MirTerminator.Assert)terminator).getTarget(), exitState);
            } else if (terminator instanceof MirTerminator.Drop) {
                UnwindAction.Cleanup cleanup;
                UnwindAction $this$asSafely$iv = ((MirTerminator.Drop)terminator).getUnwind();
                boolean $i$f$asSafely = false;
                UnwindAction unwindAction = $this$asSafely$iv;
                if (!(unwindAction instanceof UnwindAction.Cleanup)) {
                    unwindAction = null;
                }
                if ((cleanup = (UnwindAction.Cleanup)unwindAction) != null && (cleanup = cleanup.getCleanup()) != null) {
                    UnwindAction.Cleanup it3 = cleanup;
                    boolean bl = false;
                    propagate.invoke((Object)it3, exitState);
                }
                propagate.invoke(((MirTerminator.Drop)terminator).getTarget(), exitState);
            } else if (terminator instanceof MirTerminator.FalseUnwind) {
                Object BB = ((MirTerminator.FalseUnwind)terminator).getUnwind();
                if (BB != null) {
                    Object it4 = BB;
                    boolean bl = false;
                    propagate.invoke(it4, exitState);
                }
                propagate.invoke(((MirTerminator.FalseUnwind)terminator).getRealTarget(), exitState);
            } else if (terminator instanceof MirTerminator.FalseEdge) {
                propagate.invoke(((MirTerminator.FalseEdge)terminator).getRealTarget(), exitState);
                Object BB = ((MirTerminator.FalseEdge)terminator).getImaginaryTarget();
                if (BB != null) {
                    Object it5 = BB;
                    boolean bl = false;
                    propagate.invoke(it5, exitState);
                }
            } else if (terminator instanceof MirTerminator.SwitchInt) {
                for (MirBasicBlock target : ((MirTerminator.SwitchInt)terminator).getTargets().getTargets()) {
                    propagate.invoke((Object)target, exitState);
                }
            } else if (terminator instanceof MirTerminator.Call) {
                Object BB = ((MirTerminator.Call)terminator).getUnwind();
                if (BB != null) {
                    Object it6 = BB;
                    boolean bl = false;
                    propagate.invoke(it6, exitState);
                }
                if (((MirTerminator.Call)terminator).getTarget() != null) {
                    analysis.applyCallReturnEffect(exitState, block, ((MirTerminator.Call)terminator).getDestination());
                    propagate.invoke(((MirTerminator.Call)terminator).getTarget(), exitState);
                }
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @Override
    public <FlowState> void visitResultsInBlock(FlowState state, @NotNull MirBasicBlock block, @NotNull ResultsVisitable<FlowState> results, @NotNull ResultsVisitor<FlowState> visitor2) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter(results, (String)"results");
        Intrinsics.checkNotNullParameter(visitor2, (String)"visitor");
        results.resetToBlockEntry(state, block);
        visitor2.visitBlockStart(state, block);
        Iterator iterator2 = ((Iterable)block.getStatements()).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index = n++;
            MirStatement statement = (MirStatement)iterator2.next();
            MirLocation location = new MirLocation(block, index);
            results.reconstructBeforeStatementEffect(state, statement, location);
            visitor2.visitStatementBeforePrimaryEffect(state, statement, location);
            results.reconstructStatementEffect(state, statement, location);
            visitor2.visitStatementAfterPrimaryEffect(state, statement, location);
        }
        MirLocation terminatorLocation = new MirLocation(block, block.getStatements().size());
        results.reconstructBeforeTerminatorEffect(state, block.getTerminator(), terminatorLocation);
        visitor2.visitTerminatorBeforePrimaryEffect(state, block.getTerminator(), terminatorLocation);
        results.reconstructTerminatorEffect(state, block.getTerminator(), terminatorLocation);
        visitor2.visitTerminatorAfterPrimaryEffect(state, block.getTerminator(), terminatorLocation);
        visitor2.visitBlockEnd(state, block);
    }
}

