/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.mir.dataflow.framework;

import com.intellij.openapi.progress.ProgressManager;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.lang.core.mir.WithIndex;
import org.rust.lang.core.mir.dataflow.framework.Analysis;
import org.rust.lang.core.mir.dataflow.framework.Forward;
import org.rust.lang.core.mir.dataflow.framework.GenKillAnalysis;
import org.rust.lang.core.mir.dataflow.framework.GenKillSet;
import org.rust.lang.core.mir.dataflow.framework.Results;
import org.rust.lang.core.mir.dataflow.framework.UtilsKt;
import org.rust.lang.core.mir.dataflow.framework.WorkQueue;
import org.rust.lang.core.mir.schemas.MirBasicBlock;
import org.rust.lang.core.mir.schemas.MirBody;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u0012*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0002\u0011\u0012B/\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000eJ\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/rust/lang/core/mir/dataflow/framework/Engine;", "Domain", "", "body", "Lorg/rust/lang/core/mir/schemas/MirBody;", "analysis", "Lorg/rust/lang/core/mir/dataflow/framework/Analysis;", "applyStatementTransForBlock", "Lorg/rust/lang/core/mir/dataflow/framework/Engine$StatementEffect;", "<init>", "(Lorg/rust/lang/core/mir/schemas/MirBody;Lorg/rust/lang/core/mir/dataflow/framework/Analysis;Lorg/rust/lang/core/mir/dataflow/framework/Engine$StatementEffect;)V", "blockStates", "", "iterateToFixPoint", "Lorg/rust/lang/core/mir/dataflow/framework/Results;", "orderBasicBlocks", "Lorg/rust/lang/core/mir/schemas/MirBasicBlock;", "StatementEffect", "Companion", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nEngine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Engine.kt\norg/rust/lang/core/mir/dataflow/framework/Engine\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,110:1\n1#2:111\n*E\n"})
public final class Engine<Domain> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MirBody body;
    @NotNull
    private final Analysis<Domain> analysis;
    @Nullable
    private final StatementEffect<Domain> applyStatementTransForBlock;
    @NotNull
    private final List<Domain> blockStates;

    private Engine(MirBody body, Analysis<Domain> analysis, StatementEffect<Domain> applyStatementTransForBlock) {
        this.body = body;
        this.analysis = analysis;
        this.applyStatementTransForBlock = applyStatementTransForBlock;
        int n = this.body.getBasicBlocks().size();
        Engine engine = this;
        ArrayList<Domain> arrayList = new ArrayList<Domain>(n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4 = n3 = n2++;
            ArrayList<Domain> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(this.analysis.bottomValue(this.body));
        }
        engine.blockStates = arrayList;
        this.analysis.initializeStartBlock(this.body, CollectionsKt.first(this.blockStates));
    }

    @NotNull
    public final Results<Domain> iterateToFixPoint() {
        WorkQueue<WithIndex> dirtyQueue = new WorkQueue<WithIndex>(this.body.getBasicBlocks().size());
        for (MirBasicBlock block : this.orderBasicBlocks()) {
            dirtyQueue.insert(block);
        }
        Domain state = this.analysis.bottomValue(this.body);
        int iterations = 0;
        while (!dirtyQueue.isEmpty()) {
            if (iterations >= 10) {
                ProgressManager.checkCanceled();
                iterations = 0;
            }
            MirBasicBlock block = (MirBasicBlock)dirtyQueue.pop();
            Domain initialBlockState = this.blockStates.get(block.getIndex());
            this.analysis.copyStateTo(initialBlockState, state);
            this.analysis.getDirection().applyEffectsInBlock(this.analysis, state, block, this.applyStatementTransForBlock);
            this.analysis.getDirection().joinStateIntoSuccessorsOf(this.analysis, state, block, (arg_0, arg_1) -> Engine.iterateToFixPoint$lambda$0(this, dirtyQueue, arg_0, arg_1));
            ++iterations;
        }
        return new Results<Domain>(this.analysis, this.blockStates);
    }

    private final List<MirBasicBlock> orderBasicBlocks() {
        List<MirBasicBlock> result2 = UtilsKt.getBasicBlocksInPostOrder(this.body);
        if (!(this.analysis.getDirection() instanceof Forward)) {
            throw new NoWhenBranchMatchedException();
        }
        return CollectionsKt.asReversed(result2);
    }

    private static final Unit iterateToFixPoint$lambda$0(Engine this$0, WorkQueue $dirtyQueue, MirBasicBlock target, Object targetState) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        boolean changed = this$0.analysis.join(this$0.blockStates.get(target.getIndex()), targetState);
        if (changed) {
            $dirtyQueue.insert((WithIndex)target);
        }
        return Unit.INSTANCE;
    }

    public /* synthetic */ Engine(MirBody body, Analysis analysis, StatementEffect applyStatementTransForBlock, DefaultConstructorMarker $constructor_marker) {
        this(body, analysis, applyStatementTransForBlock);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ(\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\f0\u0005\"\u0004\b\u0001\u0010\f2\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\f0\r\u00a8\u0006\u000e"}, d2={"Lorg/rust/lang/core/mir/dataflow/framework/Engine$Companion;", "", "<init>", "()V", "newGenKill", "Lorg/rust/lang/core/mir/dataflow/framework/Engine;", "Ljava/util/BitSet;", "body", "Lorg/rust/lang/core/mir/schemas/MirBody;", "analysis", "Lorg/rust/lang/core/mir/dataflow/framework/GenKillAnalysis;", "newDefault", "Domain", "Lorg/rust/lang/core/mir/dataflow/framework/Analysis;", "intellij.rustrover.core"})
    @SourceDebugExtension(value={"SMAP\nEngine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Engine.kt\norg/rust/lang/core/mir/dataflow/framework/Engine$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,110:1\n1#2:111\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Engine<BitSet> newGenKill(@NotNull MirBody body, @NotNull GenKillAnalysis analysis) {
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            Intrinsics.checkNotNullParameter((Object)analysis, (String)"analysis");
            GenKillSet identity = GenKillSet.Companion.identity(analysis.domainSize(body));
            int n = body.getBasicBlocks().size();
            Pair pair3 = new ArrayList(n);
            int n2 = 0;
            while (n2 < n) {
                int n3;
                int n4 = n3 = n2++;
                Pair pair2 = pair3;
                boolean bl = false;
                pair2.add(identity.clone());
            }
            List transForBlock = (List)pair3;
            for (Pair pair3 : CollectionsKt.zip((Iterable)body.getBasicBlocks(), (Iterable)transForBlock)) {
                MirBasicBlock block = (MirBasicBlock)pair3.component1();
                GenKillSet trans = (GenKillSet)pair3.component2();
                analysis.getDirection().genKillStatementEffectsInBlock(analysis, trans, block);
            }
            return new Engine<BitSet>(body, analysis, (arg_0, arg_1) -> Companion.newGenKill$lambda$1(transForBlock, arg_0, arg_1), null);
        }

        @NotNull
        public final <Domain> Engine<Domain> newDefault(@NotNull MirBody body, @NotNull Analysis<Domain> analysis) {
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            Intrinsics.checkNotNullParameter(analysis, (String)"analysis");
            return new Engine(body, analysis, null, null);
        }

        private static final void newGenKill$lambda$1(List $transForBlock, MirBasicBlock block, BitSet state) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            ((GenKillSet)$transForBlock.get(block.getIndex())).apply(state);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00e6\u0080\u0001\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010\b\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lorg/rust/lang/core/mir/dataflow/framework/Engine$StatementEffect;", "Domain", "", "apply", "", "basicBlock", "Lorg/rust/lang/core/mir/schemas/MirBasicBlock;", "state", "(Lorg/rust/lang/core/mir/schemas/MirBasicBlock;Ljava/lang/Object;)V", "intellij.rustrover.core"})
    public static interface StatementEffect<Domain> {
        public void apply(@NotNull MirBasicBlock var1, Domain var2);
    }
}

