/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.mir.dataflow.framework;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.rust.lang.core.mir.dataflow.framework.BorrowData;
import org.rust.lang.core.mir.dataflow.framework.GatherBorrows;
import org.rust.lang.core.mir.dataflow.framework.LocalsStateAtExit;
import org.rust.lang.core.mir.dataflow.framework.UtilsKt;
import org.rust.lang.core.mir.dataflow.move.MoveData;
import org.rust.lang.core.mir.schemas.MirBasicBlock;
import org.rust.lang.core.mir.schemas.MirBody;
import org.rust.lang.core.mir.schemas.MirLocal;
import org.rust.lang.core.mir.schemas.MirLocation;
import org.rust.lang.core.mir.util.IndexAlloc;
import org.rust.lang.core.mir.util.IndexKeyMap;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010(\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\u0018\u0000 !2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001!Bg\b\u0002\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u0004\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00070\u0004\u0012\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000b0\t\u0012\u0006\u0010\f\u001a\u00020\r\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00020\u001dH\u0096\u0002J\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00020\u001f2\u0006\u0010 \u001a\u00020\u0005R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000b0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\""}, d2={"Lorg/rust/lang/core/mir/dataflow/framework/BorrowSet;", "", "Lorg/rust/lang/core/mir/dataflow/framework/BorrowData;", "locationMap", "", "Lorg/rust/lang/core/mir/schemas/MirLocation;", "activationMap", "", "localMap", "Lorg/rust/lang/core/mir/util/IndexKeyMap;", "Lorg/rust/lang/core/mir/schemas/MirLocal;", "", "localsStateAtExit", "Lorg/rust/lang/core/mir/dataflow/framework/LocalsStateAtExit;", "borrowData", "Lorg/rust/lang/core/mir/util/IndexAlloc;", "<init>", "(Ljava/util/Map;Ljava/util/Map;Lorg/rust/lang/core/mir/util/IndexKeyMap;Lorg/rust/lang/core/mir/dataflow/framework/LocalsStateAtExit;Lorg/rust/lang/core/mir/util/IndexAlloc;)V", "getLocationMap", "()Ljava/util/Map;", "getLocalMap", "()Lorg/rust/lang/core/mir/util/IndexKeyMap;", "getLocalsStateAtExit", "()Lorg/rust/lang/core/mir/dataflow/framework/LocalsStateAtExit;", "size", "", "getSize", "()I", "iterator", "", "activationsAtLocation", "", "location", "Companion", "intellij.rustrover.core"})
public final class BorrowSet
implements Iterable<BorrowData>,
KMappedMarker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<MirLocation, BorrowData> locationMap;
    @NotNull
    private final Map<MirLocation, List<BorrowData>> activationMap;
    @NotNull
    private final IndexKeyMap<MirLocal, Set<BorrowData>> localMap;
    @NotNull
    private final LocalsStateAtExit localsStateAtExit;
    @NotNull
    private final IndexAlloc<BorrowData> borrowData;

    private BorrowSet(Map<MirLocation, BorrowData> locationMap, Map<MirLocation, List<BorrowData>> activationMap, IndexKeyMap<MirLocal, Set<BorrowData>> localMap, LocalsStateAtExit localsStateAtExit, IndexAlloc<BorrowData> borrowData) {
        this.locationMap = locationMap;
        this.activationMap = activationMap;
        this.localMap = localMap;
        this.localsStateAtExit = localsStateAtExit;
        this.borrowData = borrowData;
    }

    @NotNull
    public final Map<MirLocation, BorrowData> getLocationMap() {
        return this.locationMap;
    }

    @NotNull
    public final IndexKeyMap<MirLocal, Set<BorrowData>> getLocalMap() {
        return this.localMap;
    }

    @NotNull
    public final LocalsStateAtExit getLocalsStateAtExit() {
        return this.localsStateAtExit;
    }

    public final int getSize() {
        return this.borrowData.getSize();
    }

    @Override
    @NotNull
    public Iterator<BorrowData> iterator() {
        return this.locationMap.values().iterator();
    }

    @NotNull
    public final List<BorrowData> activationsAtLocation(@NotNull MirLocation location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        List list = this.activationMap.get(location);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public /* synthetic */ BorrowSet(Map locationMap, Map activationMap, IndexKeyMap localMap, LocalsStateAtExit localsStateAtExit, IndexAlloc borrowData, DefaultConstructorMarker $constructor_marker) {
        this(locationMap, activationMap, localMap, localsStateAtExit, borrowData);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lorg/rust/lang/core/mir/dataflow/framework/BorrowSet$Companion;", "", "<init>", "()V", "build", "Lorg/rust/lang/core/mir/dataflow/framework/BorrowSet;", "body", "Lorg/rust/lang/core/mir/schemas/MirBody;", "localsAreInvalidatedAtExit", "", "moveData", "Lorg/rust/lang/core/mir/dataflow/move/MoveData;", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BorrowSet build(@NotNull MirBody body, boolean localsAreInvalidatedAtExit, @NotNull MoveData moveData) {
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            Intrinsics.checkNotNullParameter((Object)moveData, (String)"moveData");
            GatherBorrows visitor2 = new GatherBorrows(body, new LinkedHashMap(), new LinkedHashMap(), new IndexKeyMap<MirLocal, Set<BorrowData>>(), new IndexKeyMap<MirLocal, BorrowData>(), LocalsStateAtExit.Companion.build(localsAreInvalidatedAtExit, body, moveData), new IndexAlloc<BorrowData>());
            for (MirBasicBlock block : UtilsKt.getBasicBlocksInPreOrder(body)) {
                visitor2.visitBasicBlock(block);
            }
            return new BorrowSet(visitor2.getLocationMap(), visitor2.getActivationMap(), visitor2.getLocalMap(), visitor2.getLocalsStateAtExit(), visitor2.getBorrowData(), null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

