/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.mir.dataflow.framework;

import java.util.BitSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.lang.core.mir.dataflow.framework.Direction;
import org.rust.lang.core.mir.dataflow.framework.Forward;
import org.rust.lang.core.mir.dataflow.framework.Results;
import org.rust.lang.core.mir.dataflow.framework.ResultsVisitable;
import org.rust.lang.core.mir.schemas.MirBasicBlock;
import org.rust.lang.core.mir.schemas.MirBody;
import org.rust.lang.core.mir.schemas.MirLocation;
import org.rust.lang.core.mir.schemas.MirStatement;
import org.rust.lang.core.mir.schemas.MirTerminator;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001fB#\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J \u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J&\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u001a2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J&\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u001a2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006 "}, d2={"Lorg/rust/lang/core/mir/dataflow/framework/BorrowCheckResults;", "Lorg/rust/lang/core/mir/dataflow/framework/ResultsVisitable;", "Lorg/rust/lang/core/mir/dataflow/framework/BorrowCheckResults$State;", "uninits", "Lorg/rust/lang/core/mir/dataflow/framework/Results;", "Ljava/util/BitSet;", "borrows", "<init>", "(Lorg/rust/lang/core/mir/dataflow/framework/Results;Lorg/rust/lang/core/mir/dataflow/framework/Results;)V", "direction", "Lorg/rust/lang/core/mir/dataflow/framework/Direction;", "getDirection", "()Lorg/rust/lang/core/mir/dataflow/framework/Direction;", "resetToBlockEntry", "", "state", "block", "Lorg/rust/lang/core/mir/schemas/MirBasicBlock;", "reconstructBeforeStatementEffect", "statement", "Lorg/rust/lang/core/mir/schemas/MirStatement;", "location", "Lorg/rust/lang/core/mir/schemas/MirLocation;", "reconstructStatementEffect", "reconstructBeforeTerminatorEffect", "terminator", "Lorg/rust/lang/core/mir/schemas/MirTerminator;", "reconstructTerminatorEffect", "bottomValue", "body", "Lorg/rust/lang/core/mir/schemas/MirBody;", "State", "intellij.rustrover.core"})
public final class BorrowCheckResults
implements ResultsVisitable<State> {
    @NotNull
    private final Results<BitSet> uninits;
    @NotNull
    private final Results<BitSet> borrows;

    public BorrowCheckResults(@NotNull Results<BitSet> uninits, @NotNull Results<BitSet> borrows) {
        Intrinsics.checkNotNullParameter(uninits, (String)"uninits");
        Intrinsics.checkNotNullParameter(borrows, (String)"borrows");
        this.uninits = uninits;
        this.borrows = borrows;
    }

    @Override
    @NotNull
    public Direction getDirection() {
        return Forward.INSTANCE;
    }

    @Override
    public void resetToBlockEntry(@NotNull State state, @NotNull MirBasicBlock block) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        this.uninits.getAnalysis().copyStateTo(this.uninits.getBlockStates().get(block.getIndex()), state.getUninits());
        this.borrows.getAnalysis().copyStateTo(this.borrows.getBlockStates().get(block.getIndex()), state.getBorrows());
    }

    @Override
    public void reconstructBeforeStatementEffect(@NotNull State state, @NotNull MirStatement statement, @NotNull MirLocation location) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.uninits.reconstructBeforeStatementEffect(state.getUninits(), statement, location);
        this.borrows.reconstructBeforeStatementEffect(state.getBorrows(), statement, location);
    }

    @Override
    public void reconstructStatementEffect(@NotNull State state, @NotNull MirStatement statement, @NotNull MirLocation location) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.uninits.reconstructStatementEffect(state.getUninits(), statement, location);
        this.borrows.reconstructStatementEffect(state.getBorrows(), statement, location);
    }

    @Override
    public void reconstructBeforeTerminatorEffect(@NotNull State state, @NotNull MirTerminator<? extends MirBasicBlock> terminator, @NotNull MirLocation location) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter(terminator, (String)"terminator");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.uninits.reconstructBeforeTerminatorEffect(state.getUninits(), terminator, location);
        this.borrows.reconstructBeforeTerminatorEffect(state.getBorrows(), terminator, location);
    }

    @Override
    public void reconstructTerminatorEffect(@NotNull State state, @NotNull MirTerminator<? extends MirBasicBlock> terminator, @NotNull MirLocation location) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter(terminator, (String)"terminator");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.uninits.reconstructTerminatorEffect(state.getUninits(), terminator, location);
        this.borrows.reconstructTerminatorEffect(state.getBorrows(), terminator, location);
    }

    @Override
    @NotNull
    public State bottomValue(@NotNull MirBody body) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        return new State(this.uninits.bottomValue(body), this.borrows.bottomValue(body));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\n"}, d2={"Lorg/rust/lang/core/mir/dataflow/framework/BorrowCheckResults$State;", "", "uninits", "Ljava/util/BitSet;", "borrows", "<init>", "(Ljava/util/BitSet;Ljava/util/BitSet;)V", "getUninits", "()Ljava/util/BitSet;", "getBorrows", "intellij.rustrover.core"})
    public static final class State {
        @NotNull
        private final BitSet uninits;
        @NotNull
        private final BitSet borrows;

        public State(@NotNull BitSet uninits, @NotNull BitSet borrows) {
            Intrinsics.checkNotNullParameter((Object)uninits, (String)"uninits");
            Intrinsics.checkNotNullParameter((Object)borrows, (String)"borrows");
            this.uninits = uninits;
            this.borrows = borrows;
        }

        @NotNull
        public final BitSet getUninits() {
            return this.uninits;
        }

        @NotNull
        public final BitSet getBorrows() {
            return this.borrows;
        }
    }
}

