/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.mir.building;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.lang.core.mir.MirBuildErrorReason;
import org.rust.lang.core.mir.MirBuildException;
import org.rust.lang.core.mir.building.BreakableScope;
import org.rust.lang.core.mir.building.DropTree;
import org.rust.lang.core.mir.building.IfThenScope;
import org.rust.lang.core.mir.building.MirScope;
import org.rust.lang.core.thir.scopes.Scope;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0012J\u0006\u0010\u0016\u001a\u00020\u0014J\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u0012J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u0018J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00120\u001d2\b\b\u0002\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0010J\u0006\u0010!\u001a\u00020\u0014J\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00100\u001dJ\u0006\u0010#\u001a\u00020\u0010J\u0006\u0010$\u001a\u00020\u0014R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/rust/lang/core/mir/building/Scopes;", "", "<init>", "()V", "ifThenScope", "Lorg/rust/lang/core/mir/building/IfThenScope;", "getIfThenScope", "()Lorg/rust/lang/core/mir/building/IfThenScope;", "setIfThenScope", "(Lorg/rust/lang/core/mir/building/IfThenScope;)V", "unwindDrops", "Lorg/rust/lang/core/mir/building/DropTree;", "getUnwindDrops", "()Lorg/rust/lang/core/mir/building/DropTree;", "breakableScopes", "", "Lorg/rust/lang/core/mir/building/BreakableScope;", "stack", "Lorg/rust/lang/core/mir/building/MirScope;", "push", "", "scope", "pop", "topmost", "Lorg/rust/lang/core/thir/scopes/Scope;", "last", "scopeIndex", "", "scopes", "Lkotlin/sequences/Sequence;", "reversed", "", "pushBreakable", "popBreakable", "reversedBreakableScopes", "getReturnBreakableScope", "clearLastScope", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nScopes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Scopes.kt\norg/rust/lang/core/mir/building/Scopes\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,66:1\n388#2,7:67\n*S KotlinDebug\n*F\n+ 1 Scopes.kt\norg/rust/lang/core/mir/building/Scopes\n*L\n36#1:67,7\n*E\n"})
public final class Scopes {
    @Nullable
    private IfThenScope ifThenScope;
    @NotNull
    private final DropTree unwindDrops = new DropTree();
    @NotNull
    private final List<BreakableScope> breakableScopes = new ArrayList();
    @NotNull
    private final List<MirScope> stack = new ArrayList();

    @Nullable
    public final IfThenScope getIfThenScope() {
        return this.ifThenScope;
    }

    public final void setIfThenScope(@Nullable IfThenScope ifThenScope) {
        this.ifThenScope = ifThenScope;
    }

    @NotNull
    public final DropTree getUnwindDrops() {
        return this.unwindDrops;
    }

    public final void push(@NotNull MirScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.stack.add(scope);
    }

    public final void pop() {
        this.stack.removeLast();
    }

    @NotNull
    public final Scope topmost() {
        return ((MirScope)CollectionsKt.last(this.stack)).getRegionScope();
    }

    @NotNull
    public final MirScope last() {
        return (MirScope)CollectionsKt.last(this.stack);
    }

    public final int scopeIndex(@NotNull Scope scope) {
        int n;
        block1: {
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            List<MirScope> $this$indexOfLast$iv = this.stack;
            boolean $i$f$indexOfLast = false;
            ListIterator<MirScope> iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
            while (iterator$iv.hasPrevious()) {
                MirScope it2 = iterator$iv.previous();
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it2.getRegionScope(), (Object)scope)) continue;
                n = iterator$iv.nextIndex();
                break block1;
            }
            n = -1;
        }
        return n;
    }

    @NotNull
    public final Sequence<MirScope> scopes(boolean reversed) {
        return reversed ? CollectionsKt.asSequence((Iterable)CollectionsKt.asReversedMutable(this.stack)) : CollectionsKt.asSequence((Iterable)this.stack);
    }

    public static /* synthetic */ Sequence scopes$default(Scopes scopes, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return scopes.scopes(bl);
    }

    public final void pushBreakable(@NotNull BreakableScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.breakableScopes.add(scope);
    }

    public final void popBreakable() {
        this.breakableScopes.removeLast();
    }

    @NotNull
    public final Sequence<BreakableScope> reversedBreakableScopes() {
        return CollectionsKt.asSequence((Iterable)CollectionsKt.asReversedMutable(this.breakableScopes));
    }

    @NotNull
    public final BreakableScope getReturnBreakableScope() {
        BreakableScope breakableScope = (BreakableScope)CollectionsKt.firstOrNull(this.breakableScopes);
        if (breakableScope == null) {
            throw new MirBuildException(MirBuildErrorReason.NoReturnBreakableScope, null, 2, null);
        }
        return breakableScope;
    }

    public final void clearLastScope() {
        MirScope top = this.last();
        top.clearDrops();
        top.invalidateCaches();
    }
}

