/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.mir.building;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.lang.core.mir.MirBuildErrorReason;
import org.rust.lang.core.mir.MirBuildException;
import org.rust.lang.core.mir.MirBuilder;
import org.rust.lang.core.mir.building.MirCapture;
import org.rust.lang.core.mir.building.PlaceBase;
import org.rust.lang.core.mir.schemas.MirLocal;
import org.rust.lang.core.mir.schemas.MirPlace;
import org.rust.lang.core.mir.schemas.MirProjectionElem;
import org.rust.lang.core.psi.RsEnumItem;
import org.rust.lang.core.psi.ext.RsFieldsOwner;
import org.rust.lang.core.thir.LocalVar;
import org.rust.lang.core.thir.MirField;
import org.rust.lang.core.thir.MirrorKt;
import org.rust.lang.core.thir.hir.RsHir;
import org.rust.lang.core.types.infer.Projection;
import org.rust.lang.core.types.ty.Ty;
import org.rust.lang.core.types.ty.TyUnknown;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\u0010\u0004\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00070\u0006j\u0002`\b0\u0005\u00a2\u0006\u0004\b\t\u0010\nB\u0011\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\t\u0010\rB\u0011\b\u0016\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\t\u0010\u0010J\u000e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0007J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\fJ\u0018\u0010\u001b\u001a\u00020\u00002\u0010\u0010\u001c\u001a\f\u0012\u0004\u0012\u00020\u00070\u0006j\u0002`\bJ\u0018\u0010\u001d\u001a\u00020\u00002\u0010\u0010\u001c\u001a\f\u0012\u0004\u0012\u00020\u00070\u0006j\u0002`\bJ\u0006\u0010\u001e\u001a\u00020\u0000J\u0006\u0010\u001f\u001a\u00020\u0000J\u001a\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\"2\n\u0010#\u001a\u00060$j\u0002`%J\u0012\u0010&\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001a\u0010'\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020(H\u0002J,\u0010)\u001a\u0004\u0018\u00010*2\u0018\u0010+\u001a\u0014\u0012\u0004\u0012\u00020-\u0012\n\u0012\b\u0012\u0004\u0012\u00020*0.0,2\u0006\u0010\u000b\u001a\u00020(H\u0002J$\u0010/\u001a\u0002002\f\u00101\u001a\b\u0012\u0004\u0012\u0002020.2\f\u00103\u001a\b\u0012\u0004\u0012\u0002020.H\u0002J\u000e\u00104\u001a\b\u0012\u0004\u0012\u0002020.H\u0002J\t\u00105\u001a\u00020\u0003H\u00c6\u0003J\u0019\u00106\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00070\u0006j\u0002`\b0\u0005H\u00c2\u0003J-\u00107\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0018\b\u0002\u0010\u0004\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00070\u0006j\u0002`\b0\u0005H\u00c6\u0001J\u0013\u00108\u001a\u0002002\b\u00109\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010:\u001a\u00020$H\u00d6\u0001J\t\u0010;\u001a\u00020<H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0004\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00070\u0006j\u0002`\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lorg/rust/lang/core/mir/building/PlaceBuilder;", "", "base", "Lorg/rust/lang/core/mir/building/PlaceBase;", "projections", "", "Lorg/rust/lang/core/mir/schemas/MirProjectionElem;", "Lorg/rust/lang/core/types/ty/Ty;", "Lorg/rust/lang/core/mir/schemas/PlaceElem;", "<init>", "(Lorg/rust/lang/core/mir/building/PlaceBase;Ljava/util/List;)V", "local", "Lorg/rust/lang/core/mir/schemas/MirLocal;", "(Lorg/rust/lang/core/mir/schemas/MirLocal;)V", "place", "Lorg/rust/lang/core/mir/schemas/MirPlace;", "(Lorg/rust/lang/core/mir/schemas/MirPlace;)V", "getBase", "()Lorg/rust/lang/core/mir/building/PlaceBase;", "toPlace", "cx", "Lorg/rust/lang/core/mir/MirBuilder;", "tryToPlace", "field", "Lorg/rust/lang/core/thir/MirField;", "ty", "index", "project", "element", "cloneProject", "deref", "clone", "downcast", "item", "Lorg/rust/lang/core/psi/RsEnumItem;", "variantIndex", "", "Lorg/rust/lang/core/thir/MirVariantIndex;", "resolveUpvar", "toUpvarsResolvedPlaceBuilder", "Lorg/rust/lang/core/thir/LocalVar;", "findCaptureMatchingProjections", "Lorg/rust/lang/core/mir/building/MirCapture;", "upvars", "", "Lorg/rust/lang/core/thir/hir/RsHir$LocalVar;", "", "isAncestorOrSameCapture", "", "projPossibleAncestor", "Lorg/rust/lang/core/types/infer/Projection;", "projCapture", "convertToProjectionsAndTruncateForCapture", "component1", "component2", "copy", "equals", "other", "hashCode", "toString", "", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nPlaceBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlaceBuilder.kt\norg/rust/lang/core/mir/building/PlaceBuilder\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,122:1\n19#2:123\n19#2:124\n1740#3,3:125\n1#4:128\n*S KotlinDebug\n*F\n+ 1 PlaceBuilder.kt\norg/rust/lang/core/mir/building/PlaceBuilder\n*L\n39#1:123\n65#1:124\n96#1:125,3\n*E\n"})
public final class PlaceBuilder {
    @NotNull
    private final PlaceBase base;
    @NotNull
    private final List<MirProjectionElem<Ty>> projections;

    public PlaceBuilder(@NotNull PlaceBase base, @NotNull List<MirProjectionElem<Ty>> projections) {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        Intrinsics.checkNotNullParameter(projections, (String)"projections");
        this.base = base;
        this.projections = projections;
    }

    @NotNull
    public final PlaceBase getBase() {
        return this.base;
    }

    public PlaceBuilder(@NotNull MirLocal local) {
        Intrinsics.checkNotNullParameter((Object)local, (String)"local");
        this(new PlaceBase.Local(local), new ArrayList());
    }

    public PlaceBuilder(@NotNull MirPlace place) {
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        this(new PlaceBase.Local(place.getLocal()), CollectionsKt.toMutableList((Collection)place.getProjections()));
    }

    @NotNull
    public final MirPlace toPlace(@NotNull MirBuilder cx) {
        Intrinsics.checkNotNullParameter((Object)cx, (String)"cx");
        MirPlace mirPlace = this.tryToPlace(cx);
        if (mirPlace == null) {
            throw new MirBuildException(MirBuildErrorReason.CouldNotCratePlaceFromPlaceBuilder, null, 2, null);
        }
        return mirPlace;
    }

    @Nullable
    public final MirPlace tryToPlace(@NotNull MirBuilder cx) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)cx, (String)"cx");
        PlaceBuilder placeBuilder = this.resolveUpvar(cx);
        if (placeBuilder == null) {
            placeBuilder = this;
        }
        PlaceBuilder builder = placeBuilder;
        PlaceBase $this$asSafely$iv = builder.base;
        boolean $i$f$asSafely = false;
        PlaceBase placeBase = $this$asSafely$iv;
        if (!(placeBase instanceof PlaceBase.Local)) {
            placeBase = null;
        }
        if ((object = (PlaceBase.Local)placeBase) == null || (object = ((PlaceBase.Local)object).getLocal()) == null) {
            return null;
        }
        Object local = object;
        return new MirPlace((MirLocal)local, CollectionsKt.toList((Iterable)builder.projections));
    }

    @NotNull
    public final PlaceBuilder field(@NotNull MirField field, @NotNull Ty ty2) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)ty2, (String)"ty");
        return this.project((MirProjectionElem<? extends Ty>)new MirProjectionElem.Field<Ty>(field.getIndex(), field.getName(), ty2));
    }

    @NotNull
    public final PlaceBuilder index(@NotNull MirLocal index) {
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        return this.project(new MirProjectionElem.Index(index));
    }

    @NotNull
    public final PlaceBuilder project(@NotNull MirProjectionElem<? extends Ty> element) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        this.projections.add(element);
        return this;
    }

    @NotNull
    public final PlaceBuilder cloneProject(@NotNull MirProjectionElem<? extends Ty> element) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        return this.clone().project(element);
    }

    @NotNull
    public final PlaceBuilder deref() {
        PlaceBuilder placeBuilder;
        PlaceBuilder $this$deref_u24lambda_u240 = placeBuilder = this;
        boolean bl = false;
        $this$deref_u24lambda_u240.projections.add(MirProjectionElem.Deref.INSTANCE);
        return placeBuilder;
    }

    @NotNull
    public final PlaceBuilder clone() {
        return new PlaceBuilder(this.base, CollectionsKt.toMutableList((Collection)this.projections));
    }

    @NotNull
    public final PlaceBuilder downcast(@NotNull RsEnumItem item, int variantIndex) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        RsFieldsOwner rsFieldsOwner = MirrorKt.variant(item, variantIndex);
        return this.project(new MirProjectionElem.Downcast(rsFieldsOwner != null ? rsFieldsOwner.getName() : null, variantIndex));
    }

    private final PlaceBuilder resolveUpvar(MirBuilder cx) {
        PlaceBase $this$asSafely$iv = this.base;
        boolean $i$f$asSafely = false;
        PlaceBase placeBase = $this$asSafely$iv;
        if (!(placeBase instanceof PlaceBase.Upvar)) {
            placeBase = null;
        }
        PlaceBase.Upvar upvar = (PlaceBase.Upvar)placeBase;
        if (upvar == null) {
            return null;
        }
        PlaceBase.Upvar upvar2 = upvar;
        return this.toUpvarsResolvedPlaceBuilder(cx, upvar2.getLocal());
    }

    private final PlaceBuilder toUpvarsResolvedPlaceBuilder(MirBuilder cx, LocalVar local) {
        MirCapture mirCapture = this.findCaptureMatchingProjections(cx.getUpvars(), local);
        if (mirCapture == null) {
            return null;
        }
        MirCapture capture = mirCapture;
        PlaceBuilder upvarResolvedPlaceBuilder = new PlaceBuilder(capture.getUsePlace());
        List remainingProjections = CollectionsKt.drop((Iterable)this.projections, (int)capture.getCapturedPlace().getPlace().getProjections().size());
        upvarResolvedPlaceBuilder.projections.addAll(remainingProjections);
        return upvarResolvedPlaceBuilder;
    }

    private final MirCapture findCaptureMatchingProjections(Map<RsHir.LocalVar, ? extends List<MirCapture>> upvars, LocalVar local) {
        MirCapture mirCapture;
        List<Projection> projections = this.convertToProjectionsAndTruncateForCapture();
        LocalVar localVar = local;
        if (!(localVar instanceof LocalVar.Real)) {
            if (localVar instanceof LocalVar.Fake) {
                throw new MirBuildException(MirBuildErrorReason.UnexpectedFakeVariableInCapture, null, 2, null);
            }
            throw new NoWhenBranchMatchedException();
        }
        RsHir.LocalVar localElem = ((LocalVar.Real)local).getDelegate();
        List<MirCapture> list = upvars.get(localElem);
        if (list != null) {
            Object v1;
            block5: {
                Iterable iterable = list;
                for (Object t : iterable) {
                    MirCapture it2 = (MirCapture)t;
                    boolean bl = false;
                    if (!this.isAncestorOrSameCapture(it2.getCapturedPlace().getPlace().getProjections(), projections)) continue;
                    v1 = t;
                    break block5;
                }
                v1 = null;
            }
            mirCapture = v1;
        } else {
            mirCapture = null;
        }
        return mirCapture;
    }

    private final boolean isAncestorOrSameCapture(List<? extends Projection> projPossibleAncestor, List<? extends Projection> projCapture) {
        boolean bl;
        block4: {
            if (projPossibleAncestor.size() > projCapture.size()) {
                return false;
            }
            Iterable $this$all$iv = CollectionsKt.zip((Iterable)projPossibleAncestor, (Iterable)projCapture);
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Projection r;
                    Pair pair = (Pair)element$iv;
                    boolean bl2 = false;
                    Projection l = (Projection)pair.component1();
                    if (l.sameAs(r = (Projection)pair.component2())) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final List<Projection> convertToProjectionsAndTruncateForCapture() {
        List list;
        Integer variantIndex = null;
        List $this$convertToProjectionsAndTruncateForCapture_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        for (MirProjectionElem<Ty> element : this.projections) {
            Projection it2;
            Projection projection;
            MirProjectionElem<Ty> mirProjectionElem = element;
            if (Intrinsics.areEqual(mirProjectionElem, (Object)MirProjectionElem.Deref.INSTANCE)) {
                projection = new Projection.Deref(TyUnknown.INSTANCE);
            } else if (mirProjectionElem instanceof MirProjectionElem.Downcast) {
                variantIndex = ((MirProjectionElem.Downcast)element).getVariantIndex();
                projection = null;
            } else if (mirProjectionElem instanceof MirProjectionElem.Field) {
                Integer n = variantIndex;
                projection = new Projection.Field(TyUnknown.INSTANCE, new MirField(((MirProjectionElem.Field)element).getFieldIndex(), ((MirProjectionElem.Field)element).getFieldName()), n != null ? n : 0);
            } else {
                if (mirProjectionElem instanceof MirProjectionElem.ConstantIndex || mirProjectionElem instanceof MirProjectionElem.Index || mirProjectionElem instanceof MirProjectionElem.Subslice) break;
                throw new NoWhenBranchMatchedException();
            }
            Projection proj = projection;
            if (proj == null) continue;
            boolean bl2 = false;
            $this$convertToProjectionsAndTruncateForCapture_u24lambda_u240.add(it2);
        }
        return CollectionsKt.build((List)list);
    }

    @NotNull
    public final PlaceBase component1() {
        return this.base;
    }

    private final List<MirProjectionElem<Ty>> component2() {
        return this.projections;
    }

    @NotNull
    public final PlaceBuilder copy(@NotNull PlaceBase base, @NotNull List<MirProjectionElem<Ty>> projections) {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        Intrinsics.checkNotNullParameter(projections, (String)"projections");
        return new PlaceBuilder(base, projections);
    }

    public static /* synthetic */ PlaceBuilder copy$default(PlaceBuilder placeBuilder, PlaceBase placeBase, List list, int n, Object object) {
        if ((n & 1) != 0) {
            placeBase = placeBuilder.base;
        }
        if ((n & 2) != 0) {
            list = placeBuilder.projections;
        }
        return placeBuilder.copy(placeBase, list);
    }

    @NotNull
    public String toString() {
        return "PlaceBuilder(base=" + this.base + ", projections=" + this.projections + ")";
    }

    public int hashCode() {
        int result2 = this.base.hashCode();
        result2 = result2 * 31 + ((Object)this.projections).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PlaceBuilder)) {
            return false;
        }
        PlaceBuilder placeBuilder = (PlaceBuilder)other;
        if (!Intrinsics.areEqual((Object)this.base, (Object)placeBuilder.base)) {
            return false;
        }
        return Intrinsics.areEqual(this.projections, placeBuilder.projections);
    }
}

