/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.mir.building;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.lang.core.mir.building.Drop;
import org.rust.lang.core.mir.building.DropTree;
import org.rust.lang.core.mir.schemas.MirLocal;
import org.rust.lang.core.mir.schemas.MirSourceScope;
import org.rust.lang.core.thir.scopes.Scope;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0012J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001aJ\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001bJ\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u001bJ\u0006\u0010\u001c\u001a\u00020\u0017J\u000e\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u000eJ\u0006\u0010\u001f\u001a\u00020\u0017J\u0006\u0010 \u001a\u00020!J\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\t\u0010#\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010%\u001a\u00020!2\b\u0010&\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010'\u001a\u00020(H\u00d6\u0001J\t\u0010)\u001a\u00020*H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0013\u001a\u0004\u0018\u00010\u00122\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006+"}, d2={"Lorg/rust/lang/core/mir/building/MirScope;", "", "sourceScope", "Lorg/rust/lang/core/mir/schemas/MirSourceScope;", "regionScope", "Lorg/rust/lang/core/thir/scopes/Scope;", "<init>", "(Lorg/rust/lang/core/mir/schemas/MirSourceScope;Lorg/rust/lang/core/thir/scopes/Scope;)V", "getSourceScope", "()Lorg/rust/lang/core/mir/schemas/MirSourceScope;", "getRegionScope", "()Lorg/rust/lang/core/thir/scopes/Scope;", "drops", "", "Lorg/rust/lang/core/mir/building/Drop;", "movedLocals", "Lorg/rust/lang/core/mir/schemas/MirLocal;", "value", "Lorg/rust/lang/core/mir/building/DropTree$DropNode;", "cachedUnwindDrop", "getCachedUnwindDrop", "()Lorg/rust/lang/core/mir/building/DropTree$DropNode;", "setCachedUnwindDrop", "", "dropNode", "reversedDrops", "", "Lkotlin/sequences/Sequence;", "clearDrops", "addDrop", "drop", "invalidateCaches", "needsCleanup", "", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nMirScope.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MirScope.kt\norg/rust/lang/core/mir/building/MirScope\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,48:1\n1761#2,3:49\n*S KotlinDebug\n*F\n+ 1 MirScope.kt\norg/rust/lang/core/mir/building/MirScope\n*L\n40#1:49,3\n*E\n"})
public final class MirScope {
    @NotNull
    private final MirSourceScope sourceScope;
    @NotNull
    private final Scope regionScope;
    @NotNull
    private final List<Drop> drops;
    @NotNull
    private final List<MirLocal> movedLocals;
    @Nullable
    private DropTree.DropNode cachedUnwindDrop;

    public MirScope(@NotNull MirSourceScope sourceScope, @NotNull Scope regionScope) {
        Intrinsics.checkNotNullParameter((Object)sourceScope, (String)"sourceScope");
        Intrinsics.checkNotNullParameter((Object)regionScope, (String)"regionScope");
        this.sourceScope = sourceScope;
        this.regionScope = regionScope;
        this.drops = new ArrayList();
        this.movedLocals = new ArrayList();
    }

    @NotNull
    public final MirSourceScope getSourceScope() {
        return this.sourceScope;
    }

    @NotNull
    public final Scope getRegionScope() {
        return this.regionScope;
    }

    @Nullable
    public final DropTree.DropNode getCachedUnwindDrop() {
        return this.cachedUnwindDrop;
    }

    public final void setCachedUnwindDrop(@NotNull DropTree.DropNode dropNode) {
        Intrinsics.checkNotNullParameter((Object)dropNode, (String)"dropNode");
        this.cachedUnwindDrop = dropNode;
    }

    @NotNull
    public final Iterator<Drop> reversedDrops() {
        return CollectionsKt.asReversedMutable(this.drops).iterator();
    }

    @NotNull
    public final Sequence<Drop> drops() {
        return CollectionsKt.asSequence((Iterable)this.drops);
    }

    @NotNull
    public final Sequence<MirLocal> movedLocals() {
        return CollectionsKt.asSequence((Iterable)this.movedLocals);
    }

    public final void clearDrops() {
        this.drops.clear();
    }

    public final void addDrop(@NotNull Drop drop) {
        Intrinsics.checkNotNullParameter((Object)drop, (String)"drop");
        this.drops.add(drop);
    }

    public final void invalidateCaches() {
        this.cachedUnwindDrop = null;
    }

    public final boolean needsCleanup() {
        boolean bl;
        block7: {
            Iterable $this$any$iv = this.drops;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Drop drop = (Drop)element$iv;
                    boolean bl2 = false;
                    if (!(switch (WhenMappings.$EnumSwitchMapping$0[drop.getKind().ordinal()]) {
                        case 1 -> true;
                        case 2 -> false;
                        default -> throw new NoWhenBranchMatchedException();
                    })) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public final MirSourceScope component1() {
        return this.sourceScope;
    }

    @NotNull
    public final Scope component2() {
        return this.regionScope;
    }

    @NotNull
    public final MirScope copy(@NotNull MirSourceScope sourceScope, @NotNull Scope regionScope) {
        Intrinsics.checkNotNullParameter((Object)sourceScope, (String)"sourceScope");
        Intrinsics.checkNotNullParameter((Object)regionScope, (String)"regionScope");
        return new MirScope(sourceScope, regionScope);
    }

    public static /* synthetic */ MirScope copy$default(MirScope mirScope, MirSourceScope mirSourceScope, Scope scope, int n, Object object) {
        if ((n & 1) != 0) {
            mirSourceScope = mirScope.sourceScope;
        }
        if ((n & 2) != 0) {
            scope = mirScope.regionScope;
        }
        return mirScope.copy(mirSourceScope, scope);
    }

    @NotNull
    public String toString() {
        return "MirScope(sourceScope=" + this.sourceScope + ", regionScope=" + this.regionScope + ")";
    }

    public int hashCode() {
        int result2 = this.sourceScope.hashCode();
        result2 = result2 * 31 + this.regionScope.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MirScope)) {
            return false;
        }
        MirScope mirScope = (MirScope)other;
        if (!Intrinsics.areEqual((Object)this.sourceScope, (Object)mirScope.sourceScope)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.regionScope, (Object)mirScope.regionScope);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Drop.Kind.values().length];
            try {
                nArray[Drop.Kind.VALUE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Drop.Kind.STORAGE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

