/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.mir.borrowck;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.lang.core.macros.RsExpandedElementKt;
import org.rust.lang.core.mir.MirBuilder;
import org.rust.lang.core.mir.borrowck.UseOfMovedValueErrorInfo;
import org.rust.lang.core.mir.schemas.MirBody;
import org.rust.lang.core.mir.schemas.MirLocal;
import org.rust.lang.core.mir.schemas.MirLocalKind;
import org.rust.lang.core.mir.schemas.MirLocation;
import org.rust.lang.core.mir.schemas.MirOperand;
import org.rust.lang.core.mir.schemas.MirPlace;
import org.rust.lang.core.mir.schemas.MirRvalue;
import org.rust.lang.core.mir.schemas.MirSpan;
import org.rust.lang.core.mir.schemas.MirStatement;
import org.rust.lang.core.mir.schemas.MirTerminator;
import org.rust.lang.core.psi.RsLambdaExpr;
import org.rust.lang.core.psi.RsValueParameterList;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.types.infer.CapturedPlace;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00102\u00020\u0001:\u0003\u000e\u000f\u0010B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\b\u001a\u00020\u00002\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00000\nH\u0086\b\u00f8\u0001\u0000J\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fR\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\u0002\u0011\u0012\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0013"}, d2={"Lorg/rust/lang/core/mir/borrowck/UseSpans;", "", "<init>", "()V", "argsOrUse", "Lorg/rust/lang/core/mir/schemas/MirSpan;", "getArgsOrUse", "()Lorg/rust/lang/core/mir/schemas/MirSpan;", "orElse", "block", "Lkotlin/Function0;", "createUseInClosure", "Lorg/rust/lang/core/mir/borrowck/UseOfMovedValueErrorInfo$UseInClosure;", "Lcom/intellij/psi/PsiElement;", "ClosureUse", "OtherUse", "Companion", "Lorg/rust/lang/core/mir/borrowck/UseSpans$ClosureUse;", "Lorg/rust/lang/core/mir/borrowck/UseSpans$OtherUse;", "intellij.rustrover.core"})
public abstract sealed class UseSpans {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private UseSpans() {
    }

    @NotNull
    public final MirSpan getArgsOrUse() {
        MirSpan mirSpan;
        UseSpans useSpans = this;
        if (useSpans instanceof ClosureUse) {
            mirSpan = ((ClosureUse)this).getArgs();
        } else if (useSpans instanceof OtherUse) {
            mirSpan = ((OtherUse)this).getSpan();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return mirSpan;
    }

    @NotNull
    public final UseSpans orElse(@NotNull Function0<? extends UseSpans> block) {
        UseSpans useSpans;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$orElse = false;
        UseSpans useSpans2 = this;
        if (useSpans2 instanceof ClosureUse) {
            useSpans = this;
        } else if (useSpans2 instanceof OtherUse) {
            useSpans = (UseSpans)block.invoke();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return useSpans;
    }

    @Nullable
    public final UseOfMovedValueErrorInfo.UseInClosure<PsiElement> createUseInClosure() {
        UseOfMovedValueErrorInfo.UseInClosure<Object> useInClosure;
        if (this instanceof ClosureUse) {
            Pair<PsiElement, Boolean> macroCallExpandedFrom = RsExpandedElementKt.findElementExpandedFromOrMacroCallIdentifier(((ClosureUse)this).getPathExpr());
            useInClosure = new UseOfMovedValueErrorInfo.UseInClosure<Object>(((ClosureUse)this).getPathExpr(), macroCallExpandedFrom.getFirst());
        } else {
            useInClosure = null;
        }
        return useInClosure;
    }

    public /* synthetic */ UseSpans(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lorg/rust/lang/core/mir/borrowck/UseSpans$ClosureUse;", "Lorg/rust/lang/core/mir/borrowck/UseSpans;", "args", "Lorg/rust/lang/core/mir/schemas/MirSpan$PsiSpan;", "pathExpr", "Lorg/rust/lang/core/psi/ext/RsElement;", "<init>", "(Lorg/rust/lang/core/mir/schemas/MirSpan$PsiSpan;Lorg/rust/lang/core/psi/ext/RsElement;)V", "getArgs", "()Lorg/rust/lang/core/mir/schemas/MirSpan$PsiSpan;", "getPathExpr", "()Lorg/rust/lang/core/psi/ext/RsElement;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.rustrover.core"})
    public static final class ClosureUse
    extends UseSpans {
        @NotNull
        private final MirSpan.PsiSpan args;
        @NotNull
        private final RsElement pathExpr;

        public ClosureUse(@NotNull MirSpan.PsiSpan args, @NotNull RsElement pathExpr) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            Intrinsics.checkNotNullParameter((Object)pathExpr, (String)"pathExpr");
            super(null);
            this.args = args;
            this.pathExpr = pathExpr;
        }

        @NotNull
        public final MirSpan.PsiSpan getArgs() {
            return this.args;
        }

        @NotNull
        public final RsElement getPathExpr() {
            return this.pathExpr;
        }

        @NotNull
        public final MirSpan.PsiSpan component1() {
            return this.args;
        }

        @NotNull
        public final RsElement component2() {
            return this.pathExpr;
        }

        @NotNull
        public final ClosureUse copy(@NotNull MirSpan.PsiSpan args, @NotNull RsElement pathExpr) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            Intrinsics.checkNotNullParameter((Object)pathExpr, (String)"pathExpr");
            return new ClosureUse(args, pathExpr);
        }

        public static /* synthetic */ ClosureUse copy$default(ClosureUse closureUse, MirSpan.PsiSpan psiSpan, RsElement rsElement, int n, Object object) {
            if ((n & 1) != 0) {
                psiSpan = closureUse.args;
            }
            if ((n & 2) != 0) {
                rsElement = closureUse.pathExpr;
            }
            return closureUse.copy(psiSpan, rsElement);
        }

        @NotNull
        public String toString() {
            return "ClosureUse(args=" + this.args + ", pathExpr=" + this.pathExpr + ")";
        }

        public int hashCode() {
            int result2 = this.args.hashCode();
            result2 = result2 * 31 + this.pathExpr.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ClosureUse)) {
                return false;
            }
            ClosureUse closureUse = (ClosureUse)other;
            if (!Intrinsics.areEqual((Object)this.args, (Object)closureUse.args)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.pathExpr, (Object)closureUse.pathExpr);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001e\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bJ0\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u00a8\u0006\u0018"}, d2={"Lorg/rust/lang/core/mir/borrowck/UseSpans$Companion;", "", "<init>", "()V", "createMoveSpans", "Lorg/rust/lang/core/mir/borrowck/UseSpans;", "body", "Lorg/rust/lang/core/mir/schemas/MirBody;", "movedPlace", "Lorg/rust/lang/core/mir/schemas/MirPlace;", "location", "Lorg/rust/lang/core/mir/schemas/MirLocation;", "createBorrowSpans", "useSpan", "Lorg/rust/lang/core/mir/schemas/MirSpan;", "closureSpan", "Lorg/rust/lang/core/mir/borrowck/UseSpans$ClosureUse;", "definition", "Lorg/rust/lang/core/psi/ext/RsElement;", "places", "", "Lorg/rust/lang/core/mir/schemas/MirOperand;", "buildContext", "Lorg/rust/lang/core/mir/MirBuilder$BuildContext;", "intellij.rustrover.core"})
    @SourceDebugExtension(value={"SMAP\nMirBorrowCheckVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MirBorrowCheckVisitor.kt\norg/rust/lang/core/mir/borrowck/UseSpans$Companion\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 utils.kt\norg/rust/openapiext/UtilsKt\n*L\n1#1,757:1\n19#2:758\n19#2:760\n1#3:759\n318#4,10:761\n*S KotlinDebug\n*F\n+ 1 MirBorrowCheckVisitor.kt\norg/rust/lang/core/mir/borrowck/UseSpans$Companion\n*L\n703#1:758\n712#1:760\n743#1:761,10\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final UseSpans createMoveSpans(@NotNull MirBody body, @NotNull MirPlace movedPlace, @NotNull MirLocation location) {
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            Intrinsics.checkNotNullParameter((Object)movedPlace, (String)"movedPlace");
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            MirStatement mirStatement = location.getStatement();
            if (mirStatement == null) {
                return new OtherUse(location.getSource().getSpan());
            }
            MirStatement statement = mirStatement;
            if (statement instanceof MirStatement.Assign && ((MirStatement.Assign)statement).getRvalue() instanceof MirRvalue.Aggregate.Closure) {
                ClosureUse span = this.closureSpan(((MirRvalue.Aggregate.Closure)((MirStatement.Assign)statement).getRvalue()).getDefinition(), movedPlace, ((MirRvalue.Aggregate.Closure)((MirStatement.Assign)statement).getRvalue()).getOperands(), body.getBuildContext());
                if (span != null) {
                    return span;
                }
            } else if (statement instanceof MirStatement.FakeRead) {
                ClosureUse span;
                RsElement definition;
                MirStatement.FakeRead.Cause cause = ((MirStatement.FakeRead)statement).getCause();
                RsElement rsElement = cause instanceof MirStatement.FakeRead.Cause.ForMatchedPlace ? ((MirStatement.FakeRead.Cause.ForMatchedPlace)((MirStatement.FakeRead)statement).getCause()).getElement() : (definition = cause instanceof MirStatement.FakeRead.Cause.ForLet ? ((MirStatement.FakeRead.Cause.ForLet)((MirStatement.FakeRead)statement).getCause()).getElement() : null);
                if (definition != null && (span = this.closureSpan(definition, movedPlace, CollectionsKt.listOf((Object)new MirOperand.Move(movedPlace)), body.getBuildContext())) != null) {
                    return span;
                }
            }
            return new OtherUse(statement.getSource().getSpan());
        }

        @NotNull
        public final UseSpans createBorrowSpans(@NotNull MirBody body, @NotNull MirSpan useSpan, @NotNull MirLocation location) {
            MirLocal mirLocal;
            Object object;
            Object $this$asSafely$iv;
            Object object2;
            block8: {
                block7: {
                    MirLocal mirLocal2;
                    Intrinsics.checkNotNullParameter((Object)body, (String)"body");
                    Intrinsics.checkNotNullParameter((Object)useSpan, (String)"useSpan");
                    Intrinsics.checkNotNullParameter((Object)location, (String)"location");
                    MirStatement mirStatement = location.getStatement();
                    if (mirStatement == null) break block7;
                    object2 = mirStatement;
                    boolean $i$f$asSafely = false;
                    Object object3 = $this$asSafely$iv;
                    if (!(object3 instanceof MirStatement.Assign)) {
                        object3 = null;
                    }
                    if ((object = (MirStatement.Assign)object3) == null || ($this$asSafely$iv = ((MirStatement.Assign)object).getPlace()) == null || ($i$f$asSafely = ((MirPlace)$this$asSafely$iv).asLocal()) == null) break block7;
                    MirLocal it2 = mirLocal2 = $i$f$asSafely;
                    boolean bl = false;
                    MirLocal mirLocal3 = mirLocal = body.getLocalKind(it2) == MirLocalKind.Temp ? mirLocal2 : null;
                    if (mirLocal != null) break block8;
                }
                return new OtherUse(useSpan);
            }
            MirLocal target = mirLocal;
            $this$asSafely$iv = location.getBlock().getTerminator();
            boolean $i$f$asSafely = false;
            Object object4 = $this$asSafely$iv;
            if (!(object4 instanceof MirTerminator.Drop)) {
                object4 = null;
            }
            MirStatement additionalStatement = (object = (MirTerminator.Drop)object4) != null && (object2 = ((MirTerminator.Drop)object).getTarget()) != null && ($i$f$asSafely = object2.getStatements()) != null ? (MirStatement)CollectionsKt.firstOrNull($i$f$asSafely) : null;
            Sequence it3 = SequencesKt.drop((Sequence)CollectionsKt.asSequence((Iterable)location.getBlock().getStatements()), (int)(location.getStatementIndex() + 1));
            boolean bl = false;
            MirStatement mirStatement = additionalStatement;
            List statements = SequencesKt.toList((Sequence)(mirStatement == null ? it3 : SequencesKt.plus((Sequence)it3, (Object)mirStatement)));
            for (MirStatement statement : statements) {
                if (statement instanceof MirStatement.Assign) {
                    MirRvalue mirRvalue = ((MirStatement.Assign)statement).getRvalue();
                    MirRvalue.Aggregate.Closure closure = mirRvalue instanceof MirRvalue.Aggregate.Closure ? (MirRvalue.Aggregate.Closure)mirRvalue : null;
                    if (closure == null) continue;
                    MirRvalue.Aggregate.Closure closure2 = closure;
                    ClosureUse closureUse = this.closureSpan(closure2.getDefinition(), new MirPlace(target, null, 2, null), closure2.getOperands(), body.getBuildContext());
                    return closureUse != null ? (UseSpans)closureUse : (UseSpans)new OtherUse(useSpan);
                }
                if (Intrinsics.areEqual((Object)useSpan, (Object)statement.getSource().getSpan())) continue;
            }
            return new OtherUse(useSpan);
        }

        private final ClosureUse closureSpan(RsElement definition, MirPlace movedPlace, List<? extends MirOperand> places, MirBuilder.BuildContext buildContext) {
            if (!(definition instanceof RsLambdaExpr)) {
                return null;
            }
            List<CapturedPlace> captures = buildContext.getMinCapturesFlattened().get((RsLambdaExpr)definition);
            boolean $i$f$weakAssert = false;
            boolean $i$f$weakAssert2 = false;
            if (UtilsKt.isUnitTestMode() || UtilsKt.isInternal()) {
                boolean bl = false;
                if (!(captures.size() == places.size())) {
                    boolean bl2 = false;
                    String message$iv$iv = "Assertion failed";
                    throw new AssertionError((Object)message$iv$iv);
                }
            }
            for (Pair pair : CollectionsKt.zip((Iterable)captures, (Iterable)places)) {
                MirPlace operandPlace;
                MirPlace mirPlace;
                CapturedPlace capturedPlace = (CapturedPlace)pair.component1();
                MirOperand place = (MirOperand)pair.component2();
                MirOperand mirOperand = place;
                if (mirOperand instanceof MirOperand.Copy) {
                    mirPlace = ((MirOperand.Copy)place).getPlace();
                } else if (mirOperand instanceof MirOperand.Move) {
                    mirPlace = ((MirOperand.Move)place).getPlace();
                } else {
                    if (mirOperand instanceof MirOperand.Constant) continue;
                    throw new NoWhenBranchMatchedException();
                }
                if (!Intrinsics.areEqual((Object)(operandPlace = mirPlace), (Object)movedPlace)) continue;
                RsValueParameterList rsValueParameterList = ((RsLambdaExpr)definition).getValueParameterList();
                Intrinsics.checkNotNullExpressionValue((Object)rsValueParameterList, (String)"<get-valueParameterList>(...)");
                return new ClosureUse(new MirSpan.Full(rsValueParameterList), capturedPlace.getInfo().getPathExpr());
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/rust/lang/core/mir/borrowck/UseSpans$OtherUse;", "Lorg/rust/lang/core/mir/borrowck/UseSpans;", "span", "Lorg/rust/lang/core/mir/schemas/MirSpan;", "<init>", "(Lorg/rust/lang/core/mir/schemas/MirSpan;)V", "getSpan", "()Lorg/rust/lang/core/mir/schemas/MirSpan;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.rustrover.core"})
    public static final class OtherUse
    extends UseSpans {
        @NotNull
        private final MirSpan span;

        public OtherUse(@NotNull MirSpan span) {
            Intrinsics.checkNotNullParameter((Object)span, (String)"span");
            super(null);
            this.span = span;
        }

        @NotNull
        public final MirSpan getSpan() {
            return this.span;
        }

        @NotNull
        public final MirSpan component1() {
            return this.span;
        }

        @NotNull
        public final OtherUse copy(@NotNull MirSpan span) {
            Intrinsics.checkNotNullParameter((Object)span, (String)"span");
            return new OtherUse(span);
        }

        public static /* synthetic */ OtherUse copy$default(OtherUse otherUse, MirSpan mirSpan, int n, Object object) {
            if ((n & 1) != 0) {
                mirSpan = otherUse.span;
            }
            return otherUse.copy(mirSpan);
        }

        @NotNull
        public String toString() {
            return "OtherUse(span=" + this.span + ")";
        }

        public int hashCode() {
            return this.span.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof OtherUse)) {
                return false;
            }
            OtherUse otherUse = (OtherUse)other;
            return Intrinsics.areEqual((Object)this.span, (Object)otherUse.span);
        }
    }
}

