/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.mir;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.lang.core.macros.MacroExpansion;
import org.rust.lang.core.mir.MirBuildException;
import org.rust.lang.core.mir.RsBindingModeWrapper;
import org.rust.lang.core.mir.TargetProcessParams;
import org.rust.lang.core.mir.schemas.MirSpan;
import org.rust.lang.core.psi.RsBindingMode;
import org.rust.lang.core.psi.RsLambdaExpr;
import org.rust.lang.core.psi.RsMacroCall;
import org.rust.lang.core.psi.RsMacroExpr;
import org.rust.lang.core.psi.RsTraitItem;
import org.rust.lang.core.psi.ext.RsGenericDeclaration;
import org.rust.lang.core.psi.ext.RsGenericDeclarationKt;
import org.rust.lang.core.psi.ext.RsPossibleMacroCallKt;
import org.rust.lang.core.resolve.ImplLookup;
import org.rust.lang.core.resolve.KnownItems;
import org.rust.lang.core.thir.ThirBuildException;
import org.rust.lang.core.thir.hir.RsHir;
import org.rust.lang.core.thir.scopes.Scope;
import org.rust.lang.core.types.TraitRef;
import org.rust.lang.core.types.ty.Ty;
import org.rust.lang.core.types.ty.TyInteger;
import org.rust.lang.core.types.ty.TyNever;
import org.rust.stdext.RsResult;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000`\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u001a\u0010\u0014\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018\u001a@\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u0002H \u0012\u0006\u0012\u0004\u0018\u00010!0\u001f\"\b\b\u0000\u0010 *\u00020\"2\u001a\u0010#\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u0002H \u0012\u0006\u0012\u0004\u0018\u00010!0\u001f0$H\u0086\b\u00f8\u0001\u0000\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0015\u0010\t\u001a\u00020\n*\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\"\u0015\u0010\u000e\u001a\u00020\n*\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\r\"\u0015\u0010\u0010\u001a\u00020\n*\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\"\u0017\u0010\u0019\u001a\u00020\u001a*\u0004\u0018\u00010\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006%"}, d2={"isSigned", "", "Lorg/rust/lang/core/types/ty/Ty;", "(Lorg/rust/lang/core/types/ty/Ty;)Z", "minValue", "", "Lorg/rust/lang/core/types/ty/TyInteger;", "targetParams", "Lorg/rust/lang/core/mir/TargetProcessParams;", "asSpan", "Lorg/rust/lang/core/mir/schemas/MirSpan;", "Lcom/intellij/psi/PsiElement;", "getAsSpan", "(Lcom/intellij/psi/PsiElement;)Lorg/rust/lang/core/mir/schemas/MirSpan;", "asStartSpan", "getAsStartSpan", "span", "Lorg/rust/lang/core/thir/scopes/Scope;", "getSpan", "(Lorg/rust/lang/core/thir/scopes/Scope;)Lorg/rust/lang/core/mir/schemas/MirSpan;", "isClosure", "knownItems", "Lorg/rust/lang/core/resolve/KnownItems;", "implLookup", "Lorg/rust/lang/core/resolve/ImplLookup;", "wrapper", "Lorg/rust/lang/core/mir/RsBindingModeWrapper;", "Lorg/rust/lang/core/psi/RsBindingMode;", "getWrapper", "(Lorg/rust/lang/core/psi/RsBindingMode;)Lorg/rust/lang/core/psi/RsBindingMode;", "buildMirSafe", "Lorg/rust/stdext/RsResult;", "T", "", "", "action", "Lkotlin/Function0;", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\norg/rust/lang/core/mir/UtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,230:1\n1#2:231\n19#3:232\n*S KotlinDebug\n*F\n+ 1 Utils.kt\norg/rust/lang/core/mir/UtilsKt\n*L\n68#1:232\n*E\n"})
public final class UtilsKt {
    public static final boolean isSigned(@NotNull Ty $this$isSigned) {
        Intrinsics.checkNotNullParameter((Object)$this$isSigned, (String)"<this>");
        return $this$isSigned instanceof TyInteger.I8 || $this$isSigned instanceof TyInteger.I16 || $this$isSigned instanceof TyInteger.I32 || $this$isSigned instanceof TyInteger.I64 || $this$isSigned instanceof TyInteger.I128 || $this$isSigned instanceof TyInteger.ISize;
    }

    public static final long minValue(@NotNull TyInteger $this$minValue, @NotNull TargetProcessParams targetParams) {
        long l;
        Intrinsics.checkNotNullParameter((Object)$this$minValue, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)targetParams, (String)"targetParams");
        TyInteger tyInteger = $this$minValue;
        if (tyInteger instanceof TyInteger.I8) {
            l = -128L;
        } else if (tyInteger instanceof TyInteger.I16) {
            l = -32768L;
        } else if (tyInteger instanceof TyInteger.I32) {
            l = Integer.MIN_VALUE;
        } else if (tyInteger instanceof TyInteger.I64) {
            l = Long.MIN_VALUE;
        } else if (tyInteger instanceof TyInteger.ISize) {
            l = targetParams.is64Bit() ? Long.MIN_VALUE : Integer.MIN_VALUE;
        } else if (tyInteger instanceof TyInteger.U8 || tyInteger instanceof TyInteger.U16 || tyInteger instanceof TyInteger.U32 || tyInteger instanceof TyInteger.U64 || tyInteger instanceof TyInteger.U128 || tyInteger instanceof TyInteger.USize) {
            l = 0L;
        } else if (tyInteger instanceof TyInteger.I128) {
            l = Long.MIN_VALUE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return l;
    }

    @NotNull
    public static final MirSpan getAsSpan(@NotNull PsiElement $this$asSpan) {
        Intrinsics.checkNotNullParameter((Object)$this$asSpan, (String)"<this>");
        if (!($this$asSpan instanceof RsMacroExpr)) {
            return new MirSpan.Full($this$asSpan);
        }
        RsMacroCall rsMacroCall = ((RsMacroExpr)$this$asSpan).getMacroCall();
        Intrinsics.checkNotNullExpressionValue((Object)rsMacroCall, (String)"getMacroCall(...)");
        MacroExpansion macroExpansion = RsPossibleMacroCallKt.getExpansion(rsMacroCall);
        MacroExpansion.Expr expr = macroExpansion instanceof MacroExpansion.Expr ? (MacroExpansion.Expr)macroExpansion : null;
        if (expr == null) {
            return new MirSpan.Full($this$asSpan);
        }
        MacroExpansion.Expr expansion = expr;
        MirSpan it2 = UtilsKt.getAsSpan(expansion.getExpr());
        boolean bl = false;
        return it2;
    }

    @NotNull
    public static final MirSpan getAsStartSpan(@NotNull PsiElement $this$asStartSpan) {
        Intrinsics.checkNotNullParameter((Object)$this$asStartSpan, (String)"<this>");
        return new MirSpan.Start($this$asStartSpan);
    }

    @NotNull
    public static final MirSpan getSpan(@NotNull Scope $this$span) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$span, (String)"<this>");
        RsHir $this$asSafely$iv = $this$span.getElement();
        boolean $i$f$asSafely = false;
        RsHir rsHir = $this$asSafely$iv;
        if (!(rsHir instanceof RsLambdaExpr)) {
            rsHir = null;
        }
        if ((object = (RsLambdaExpr)((Object)rsHir)) == null || (object = object.getValueParameterList()) == null || (object = UtilsKt.getAsSpan((PsiElement)object)) == null) {
            object = UtilsKt.getAsSpan($this$span.getElement().getSource());
        }
        return object;
    }

    public static final boolean isClosure(@NotNull Ty $this$isClosure, @NotNull KnownItems knownItems, @NotNull ImplLookup implLookup) {
        Intrinsics.checkNotNullParameter((Object)$this$isClosure, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)knownItems, (String)"knownItems");
        Intrinsics.checkNotNullParameter((Object)implLookup, (String)"implLookup");
        RsTraitItem rsTraitItem = knownItems.getFnOnce();
        if (rsTraitItem == null) {
            return false;
        }
        RsTraitItem fn = rsTraitItem;
        Ty[] tyArray = new Ty[]{TyNever.INSTANCE};
        return ImplLookup.canSelectWithDeref$default(implLookup, new TraitRef($this$isClosure, RsGenericDeclarationKt.withSubst((RsGenericDeclaration)fn, tyArray)), 0, 2, null);
    }

    @NotNull
    public static final RsBindingMode getWrapper(@Nullable RsBindingMode $this$wrapper) {
        return RsBindingModeWrapper.constructor-impl($this$wrapper);
    }

    @NotNull
    public static final <T> RsResult<T, Throwable> buildMirSafe(@NotNull Function0<? extends RsResult<? extends T, ? extends Throwable>> action2) {
        RsResult rsResult;
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        boolean $i$f$buildMirSafe = false;
        try {
            rsResult = (RsResult)action2.invoke();
        }
        catch (ProcessCanceledException pce) {
            throw pce;
        }
        catch (NotImplementedError e) {
            rsResult = new RsResult.Err<NotImplementedError>(e);
        }
        catch (ThirBuildException e) {
            rsResult = new RsResult.Err<ThirBuildException>(e);
        }
        catch (MirBuildException e) {
            rsResult = new RsResult.Err<MirBuildException>(e);
        }
        catch (IllegalStateException e) {
            rsResult = new RsResult.Err<IllegalStateException>(e);
        }
        return rsResult;
    }
}

