/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.mir;

import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.popup.PopupPositionManager;
import java.awt.BorderLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.lang.core.psi.RsConstant;
import org.rust.lang.core.psi.RsElementTypes;
import org.rust.lang.core.psi.RsFile;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsLambdaExpr;
import org.rust.lang.core.psi.RsValueParameterList;
import org.rust.lang.core.psi.ext.PsiElementExtensionsKt;
import org.rust.lang.core.psi.ext.RsInferenceContextOwner;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH$J\b\u0010\n\u001a\u00020\u000bH$J\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J&\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00142\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0004\u00a8\u0006\u0018"}, d2={"Lorg/rust/lang/core/mir/RsMirPreviewAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "getMirData", "Lorg/rust/lang/core/mir/RsMirPreviewAction$MirData;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "popupName", "", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "getContextOwnerAndMirTarget", "Lkotlin/Pair;", "Lorg/rust/lang/core/psi/ext/RsInferenceContextOwner;", "Lcom/intellij/psi/PsiElement;", "MirData", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsMirPreviewAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsMirPreviewAction.kt\norg/rust/lang/core/mir/RsMirPreviewAction\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,128:1\n19#2:129\n19#2:132\n66#3,2:130\n67#3:133\n*S KotlinDebug\n*F\n+ 1 RsMirPreviewAction.kt\norg/rust/lang/core/mir/RsMirPreviewAction\n*L\n93#1:129\n96#1:132\n96#1:130,2\n100#1:133\n*E\n"})
public abstract class RsMirPreviewAction
extends AnAction {
    @Nullable
    protected abstract MirData getMirData(@NotNull Editor var1, @NotNull PsiFile var2);

    @NotNull
    protected abstract String popupName();

    @NotNull
    public final ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public final void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Object object = e.getData(CommonDataKeys.PSI_FILE);
        RsFile file = object instanceof RsFile ? (RsFile)object : null;
        Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (file == null || editor2 == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        MirData data2 = this.getMirData(editor2, (PsiFile)file);
        if (data2 == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setEnabledAndVisible(true);
    }

    public final void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        Object object = e.getData(CommonDataKeys.PSI_FILE);
        RsFile file = object instanceof RsFile ? (RsFile)object : null;
        Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (file == null || editor2 == null) {
            return;
        }
        MirData mirData = this.getMirData(editor2, (PsiFile)file);
        if (mirData == null) {
            throw new IllegalStateException("data is null");
        }
        MirData data2 = mirData;
        BorderLayout borderLayout = new BorderLayout();
        JPanel panel2 = new JPanel(data2, project2, borderLayout){
            {
                EditorFactory factory2 = EditorFactory.getInstance();
                Document document = factory2.createDocument((CharSequence)$data.getText());
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"createDocument(...)");
                Document doc = document;
                Language language = $data.getLanguage();
                LanguageFileType fileType = language != null ? language.getAssociatedFileType() : null;
                Editor editor2 = fileType != null ? factory2.createEditor(doc, $project, (FileType)fileType, false) : factory2.createEditor(doc, $project);
                this.add(editor2.getComponent());
            }
        };
        JBPopup jBPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)panel2, (JComponent)panel2).setProject(project2).setResizable(true).setMovable(true).setRequestFocus(true).setTitle(this.popupName()).createPopup();
        Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"createPopup(...)");
        JBPopup popup2 = jBPopup;
        PopupPositionManager.positionPopupInBestPosition((JBPopup)popup2, (Editor)editor2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected final Pair<RsInferenceContextOwner, PsiElement> getContextOwnerAndMirTarget(@NotNull Editor editor2, @NotNull PsiFile file) {
        void $this$parentOfType$iv;
        PsiElement mirTarget;
        PsiElement psiElement2;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        PsiElement psiElement3 = file.findElementAt(editor2.getCaretModel().getOffset());
        if (psiElement3 == null) {
            return null;
        }
        PsiElement element = psiElement3;
        if (Intrinsics.areEqual((Object)PsiElementExtensionsKt.getElementType(element), (Object)RsElementTypes.IDENTIFIER)) {
            PsiElement $this$asSafely$iv = element.getParent();
            boolean $i$f$asSafely = false;
            PsiElement psiElement4 = $this$asSafely$iv;
            if (!(psiElement4 instanceof RsFunction)) {
                psiElement4 = null;
            }
            RsFunction rsFunction = (RsFunction)psiElement4;
            if (rsFunction != null) {
                psiElement2 = rsFunction;
            } else {
                $this$asSafely$iv = element.getParent();
                $i$f$asSafely = false;
                PsiElement psiElement5 = $this$asSafely$iv;
                if (!(psiElement5 instanceof RsConstant)) {
                    psiElement5 = null;
                }
                psiElement2 = (RsConstant)psiElement5;
            }
        } else {
            RsLambdaExpr rsLambdaExpr;
            PsiElement $this$parentOfType_u24default$iv = element;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            RsValueParameterList rsValueParameterList = (RsValueParameterList)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, RsValueParameterList.class, (boolean)true);
            if (rsValueParameterList != null && (rsValueParameterList = rsValueParameterList.getParent()) != null) {
                RsValueParameterList $this$asSafely$iv = rsValueParameterList;
                boolean $i$f$asSafely = false;
                RsValueParameterList rsValueParameterList2 = $this$asSafely$iv;
                if (!(rsValueParameterList2 instanceof RsLambdaExpr)) {
                    rsValueParameterList2 = null;
                }
                rsLambdaExpr = (RsLambdaExpr)((Object)rsValueParameterList2);
            } else {
                rsLambdaExpr = null;
            }
            psiElement2 = rsLambdaExpr;
        }
        if (psiElement2 == null) {
            return null;
        }
        PsiElement psiElement6 = mirTarget = psiElement2;
        boolean withSelf$iv = true;
        boolean $i$f$parentOfType = false;
        RsInferenceContextOwner rsInferenceContextOwner = (RsInferenceContextOwner)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, RsInferenceContextOwner.class, (boolean)false);
        return rsInferenceContextOwner != null ? TuplesKt.to((Object)rsInferenceContextOwner, (Object)mirTarget) : null;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\bd\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lorg/rust/lang/core/mir/RsMirPreviewAction$MirData;", "", "text", "", "getText", "()Ljava/lang/String;", "language", "Lcom/intellij/lang/Language;", "getLanguage", "()Lcom/intellij/lang/Language;", "intellij.rustrover.core"})
    protected static interface MirData {
        @NotNull
        public String getText();

        @Nullable
        public Language getLanguage();
    }
}

