/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.mir;

import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.ide.presentation.QualifiedNameSettings;
import org.rust.ide.presentation.RenderableDefPath;
import org.rust.ide.presentation.TypeRenderingKt;
import org.rust.ide.utils.import.ImportContext;
import org.rust.lang.core.mir.TargetProcessParams;
import org.rust.lang.core.mir.UtilsKt;
import org.rust.lang.core.mir.schemas.MirAssertKind;
import org.rust.lang.core.mir.schemas.MirBasicBlock;
import org.rust.lang.core.mir.schemas.MirBinaryOperator;
import org.rust.lang.core.mir.schemas.MirBody;
import org.rust.lang.core.mir.schemas.MirBorrowKind;
import org.rust.lang.core.mir.schemas.MirConstValue;
import org.rust.lang.core.mir.schemas.MirConstant;
import org.rust.lang.core.mir.schemas.MirLocal;
import org.rust.lang.core.mir.schemas.MirOperand;
import org.rust.lang.core.mir.schemas.MirPlace;
import org.rust.lang.core.mir.schemas.MirProjectionElem;
import org.rust.lang.core.mir.schemas.MirRvalue;
import org.rust.lang.core.mir.schemas.MirScalar;
import org.rust.lang.core.mir.schemas.MirSourceInfo;
import org.rust.lang.core.mir.schemas.MirSourceScope;
import org.rust.lang.core.mir.schemas.MirSpan;
import org.rust.lang.core.mir.schemas.MirStatement;
import org.rust.lang.core.mir.schemas.MirTerminator;
import org.rust.lang.core.mir.schemas.MirUnaryOperator;
import org.rust.lang.core.mir.schemas.MirVarDebugInfo;
import org.rust.lang.core.mir.schemas.UnwindAction;
import org.rust.lang.core.psi.RsConstant;
import org.rust.lang.core.psi.RsEnumVariant;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsImplItem;
import org.rust.lang.core.psi.RsLambdaExpr;
import org.rust.lang.core.psi.RsPatBinding;
import org.rust.lang.core.psi.RsSelfParameter;
import org.rust.lang.core.psi.RsStructItem;
import org.rust.lang.core.psi.RsValueParameterList;
import org.rust.lang.core.psi.ext.ArithmeticOp;
import org.rust.lang.core.psi.ext.ComparisonOp;
import org.rust.lang.core.psi.ext.EqualityOp;
import org.rust.lang.core.psi.ext.PsiElementKt;
import org.rust.lang.core.psi.ext.RsEnumVariantKt;
import org.rust.lang.core.psi.ext.RsFieldDecl;
import org.rust.lang.core.psi.ext.RsFieldsOwner;
import org.rust.lang.core.psi.ext.RsFieldsOwnerKt;
import org.rust.lang.core.psi.ext.RsInferenceContextOwner;
import org.rust.lang.core.psi.ext.RsNamedElement;
import org.rust.lang.core.psi.ext.RsQualifiedNamedElement;
import org.rust.lang.core.resolve.KnownItems;
import org.rust.lang.core.resolve.KnownItemsKt;
import org.rust.lang.core.thir.MirrorKt;
import org.rust.lang.core.types.consts.Const;
import org.rust.lang.core.types.ty.Mutability;
import org.rust.lang.core.types.ty.Ty;
import org.rust.lang.core.types.ty.TyAdt;
import org.rust.lang.core.types.ty.TyBool;
import org.rust.lang.core.types.ty.TyClosure;
import org.rust.lang.core.types.ty.TyFloat;
import org.rust.lang.core.types.ty.TyFnDef;
import org.rust.lang.core.types.ty.TyFunctionBase;
import org.rust.lang.core.types.ty.TyInteger;
import org.rust.lang.core.types.ty.TyPrimitive;
import org.rust.lang.core.types.ty.TyTuple;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00d2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 Z2\u00020\u0001:\u0006UVWXYZB#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u000e\u001a\u00020\u0003J\u001c\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011*\u00060\u0010j\u0002`\u00112\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u001c\u0010\u0012\u001a\u00060\u0010j\u0002`\u0011*\u00060\u0010j\u0002`\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0016\u0010\u0015\u001a\u00020\u00032\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u0017H\u0002J\u001e\u0010\u0018\u001a\u00020\u0019*\u00060\u0010j\u0002`\u00112\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u0017H\u0002J\u0016\u0010\u001a\u001a\u00020\u00032\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u0017H\u0002J\u001c\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\u001c2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u0017H\u0002J\u0010\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010\u0015\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010\u0015\u001a\u00020\u00032\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010\u0015\u001a\u00020\u00032\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010\u0015\u001a\u00020\u00032\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010\u0015\u001a\u00020\u00032\u0006\u0010+\u001a\u00020-H\u0002J\u0010\u0010.\u001a\u00020\u00032\u0006\u0010/\u001a\u000200H\u0002J\u0010\u00101\u001a\u00020\u00032\u0006\u0010/\u001a\u000202H\u0002J8\u00103\u001a\u00020\u00032\u0006\u00104\u001a\u0002052\u0006\u0010/\u001a\u0002022\u0006\u00106\u001a\u00020\u00032\u0006\u00107\u001a\u0002002\u0006\u00108\u001a\u0002022\u0006\u00109\u001a\u000200H\u0002J \u0010:\u001a\u00020\u00032\u0006\u0010;\u001a\u00020\u00032\u0006\u0010<\u001a\u00020=2\u0006\u00106\u001a\u00020\u0003H\u0002J\u0014\u0010>\u001a\u00060\u0010j\u0002`\u0011*\u00060\u0010j\u0002`\u0011H\u0002J\u0014\u0010?\u001a\u00060\u0010j\u0002`\u0011*\u00060\u0010j\u0002`\u0011H\u0002J\u0010\u0010\u0015\u001a\u00020\u00032\u0006\u0010@\u001a\u00020AH\u0002J\u001a\u0010\u0015\u001a\u00020\u00032\u0006\u0010B\u001a\u00020C2\b\b\u0002\u0010D\u001a\u00020EH\u0002J>\u0010F\u001a\u00060\u0010j\u0002`\u0011*\u00060\u0010j\u0002`\u00112\u0018\u0010G\u001a\u0014\u0012\u0004\u0012\u00020I\u0012\n\u0012\b\u0012\u0004\u0012\u00020I0\u001c0H2\u0006\u0010J\u001a\u00020I2\u0006\u0010K\u001a\u000200H\u0002J\u0010\u0010\u0015\u001a\u00020\u00032\u0006\u0010L\u001a\u00020MH\u0002J\u0016\u0010N\u001a\u00020\u0003*\u00020\u00032\b\u0010O\u001a\u0004\u0018\u00010\u0003H\u0002J\u0014\u0010P\u001a\u00020\u0003*\u00020\u00032\u0006\u0010O\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0018\u0010Q\u001a\u00020\u0003*\u00020R8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bS\u0010T\u00a8\u0006["}, d2={"Lorg/rust/lang/core/mir/MirPrettyPrinter;", "", "filenamePrefix", "", "mir", "Lorg/rust/lang/core/mir/schemas/MirBody;", "commentSupplier", "Lorg/rust/lang/core/mir/MirPrettyPrinter$CommentSupplier;", "<init>", "(Ljava/lang/String;Lorg/rust/lang/core/mir/schemas/MirBody;Lorg/rust/lang/core/mir/MirPrettyPrinter$CommentSupplier;)V", "knownItems", "Lorg/rust/lang/core/resolve/KnownItems;", "getKnownItems", "()Lorg/rust/lang/core/resolve/KnownItems;", "print", "printMir", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "printBasicBlock", "block", "Lorg/rust/lang/core/mir/schemas/MirBasicBlock;", "format", "terminator", "Lorg/rust/lang/core/mir/schemas/MirTerminator;", "formatUnwind", "", "formatHead", "formatSuccessorLabels", "", "local", "Lorg/rust/lang/core/mir/schemas/MirLocal;", "msg", "Lorg/rust/lang/core/mir/schemas/MirAssertKind;", "rvalue", "Lorg/rust/lang/core/mir/schemas/MirRvalue;", "formatLocation", "Lorg/rust/lang/core/mir/MirPrettyPrinter$LocationRange;", "lambda", "Lorg/rust/lang/core/psi/RsLambdaExpr;", "operand", "Lorg/rust/lang/core/mir/schemas/MirOperand;", "place", "Lorg/rust/lang/core/mir/schemas/MirPlace;", "constant", "Lorg/rust/lang/core/mir/schemas/MirConstant;", "Lorg/rust/lang/core/mir/schemas/MirConstant$Value;", "formatFloat32", "bits", "", "formatFloat64", "", "formatFloatingPoint", "value", "", "suffix", "precision", "maskBits", "shiftBits", "formatFloatString", "numStr", "isNegZero", "", "printIntro", "printMirSignature", "cause", "Lorg/rust/lang/core/mir/schemas/MirStatement$FakeRead$Cause;", "ty", "Lorg/rust/lang/core/types/ty/Ty;", "importContextType", "Lorg/rust/ide/utils/import/ImportContext$Type;", "printScopeTree", "scopeTree", "", "Lorg/rust/lang/core/mir/schemas/MirSourceScope;", "parent", "depth", "contents", "Lorg/rust/lang/core/mir/schemas/MirVarDebugInfo$Contents;", "withComment", "comment", "withCommentAsIs", "formatted", "Lorg/rust/lang/core/mir/schemas/MirUnaryOperator;", "getFormatted", "(Lorg/rust/lang/core/mir/schemas/MirUnaryOperator;)Ljava/lang/String;", "CommentSupplier", "NoCommentSupplier", "ScopeCommentSupplier", "Location", "LocationRange", "Companion", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nMirPrettyPrinter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MirPrettyPrinter.kt\norg/rust/lang/core/mir/MirPrettyPrinter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 KnownItems.kt\norg/rust/lang/core/resolve/KnownItems\n+ 5 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 6 utils.kt\norg/rust/openapiext/UtilsKt\n*L\n1#1,782:1\n1#2:783\n1869#3,2:784\n1563#3:786\n1634#3,3:787\n1740#3,3:790\n1563#3:793\n1634#3,3:794\n1563#3:797\n1634#3,3:798\n295#3,2:803\n1878#3,3:805\n1878#3,3:810\n295#3,2:835\n1869#3,2:841\n69#4,2:801\n69#4,2:833\n64#4,4:837\n66#5,2:808\n318#6,10:813\n318#6,10:823\n*S KotlinDebug\n*F\n+ 1 MirPrettyPrinter.kt\norg/rust/lang/core/mir/MirPrettyPrinter\n*L\n50#1:784,2\n142#1:786\n142#1:787,3\n296#1:790,3\n306#1:793\n306#1:794,3\n325#1:797\n325#1:798,3\n442#1:803,2\n554#1:805,3\n581#1:810,3\n609#1:835,2\n643#1:841,2\n442#1:801,2\n609#1:833,2\n610#1:837,4\n562#1:808,2\n593#1:813,10\n594#1:823,10\n*E\n"})
public final class MirPrettyPrinter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String filenamePrefix;
    @NotNull
    private final MirBody mir;
    @NotNull
    private final CommentSupplier commentSupplier;
    @NotNull
    private static final String INDENT = "    ";
    private static final int ALIGN = 40;

    public MirPrettyPrinter(@NotNull String filenamePrefix, @NotNull MirBody mir, @NotNull CommentSupplier commentSupplier) {
        Intrinsics.checkNotNullParameter((Object)filenamePrefix, (String)"filenamePrefix");
        Intrinsics.checkNotNullParameter((Object)mir, (String)"mir");
        Intrinsics.checkNotNullParameter((Object)commentSupplier, (String)"commentSupplier");
        this.filenamePrefix = filenamePrefix;
        this.mir = mir;
        this.commentSupplier = commentSupplier;
    }

    public /* synthetic */ MirPrettyPrinter(String string, MirBody mirBody, CommentSupplier commentSupplier, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "src/";
        }
        if ((n & 4) != 0) {
            commentSupplier = new ScopeCommentSupplier(string);
        }
        this(string, mirBody, commentSupplier);
    }

    private final KnownItems getKnownItems() {
        return KnownItemsKt.getKnownItems(this.mir.getSourceElement());
    }

    @NotNull
    public final String print() {
        StringBuilder stringBuilder;
        StringBuilder $this$print_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        this.printMir($this$print_u24lambda_u240, this.mir);
        return stringBuilder.toString();
    }

    private final StringBuilder printMir(StringBuilder $this$printMir, MirBody mir) {
        StringBuilder stringBuilder;
        StringBuilder $this$printMir_u24lambda_u240 = stringBuilder = $this$printMir;
        boolean bl = false;
        this.printIntro($this$printMir_u24lambda_u240);
        for (MirBasicBlock block : mir.getBasicBlocks()) {
            $this$printMir_u24lambda_u240.append('\n');
            this.printBasicBlock($this$printMir_u24lambda_u240, block);
        }
        $this$printMir_u24lambda_u240.append("}");
        return stringBuilder;
    }

    private final StringBuilder printBasicBlock(StringBuilder $this$printBasicBlock, MirBasicBlock block) {
        StringBuilder stringBuilder;
        StringBuilder $this$printBasicBlock_u24lambda_u240 = stringBuilder = $this$printBasicBlock;
        boolean bl = false;
        String cleanup = block.getUnwind() ? " (cleanup)" : "";
        String blockHeader = "    bb" + block.getIndex() + cleanup + ": {";
        $this$printBasicBlock_u24lambda_u240.append(this.withComment(blockHeader, this.commentSupplier.blockStartComment(block))).append('\n');
        Iterable $this$forEach$iv = block.getStatements();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            MirStatement stmt = (MirStatement)element$iv;
            boolean bl2 = false;
            MirStatement mirStatement = stmt;
            if (mirStatement instanceof MirStatement.Assign) {
                object = "        " + this.format(((MirStatement.Assign)stmt).getPlace()) + " = " + this.format(((MirStatement.Assign)stmt).getRvalue()) + ";";
            } else if (mirStatement instanceof MirStatement.StorageLive) {
                object = "        StorageLive(" + this.format(((MirStatement.StorageLive)stmt).getLocal()) + ");";
            } else if (mirStatement instanceof MirStatement.StorageDead) {
                object = "        StorageDead(" + this.format(((MirStatement.StorageDead)stmt).getLocal()) + ");";
            } else if (mirStatement instanceof MirStatement.FakeRead) {
                object = "        FakeRead(" + this.format(((MirStatement.FakeRead)stmt).getCause()) + ", " + this.format(((MirStatement.FakeRead)stmt).getPlace().getLocal()) + ");";
            } else if (mirStatement instanceof MirStatement.PlaceMention) {
                object = "        PlaceMention(" + this.format(((MirStatement.PlaceMention)stmt).getPlace()) + ");";
            } else if (mirStatement instanceof MirStatement.Uncontrolled) {
                object = "        Uncontrolled(" + this.format(((MirStatement.Uncontrolled)stmt).getPlace()) + ");";
            } else if (mirStatement instanceof MirStatement.UncontrolledAll) {
                object = "        UncontrolledAll;";
            } else if (mirStatement instanceof MirStatement.Drop) {
                object = "        Drop(" + this.format(((MirStatement.Drop)stmt).getPlace()) + ");";
            } else {
                throw new NoWhenBranchMatchedException();
            }
            String statement = object;
            $this$printBasicBlock_u24lambda_u240.append(this.withComment(statement, this.commentSupplier.statementComment(stmt))).append('\n');
        }
        $this$printBasicBlock_u24lambda_u240.append(this.withComment(this.format(block.getTerminator()), this.commentSupplier.terminatorComment(block.getTerminator()))).append('\n');
        $this$printBasicBlock_u24lambda_u240.append(this.withComment("    }", this.commentSupplier.blockEndComment(block))).append('\n');
        return stringBuilder;
    }

    private final String format(MirTerminator<? extends MirBasicBlock> terminator) {
        StringBuilder stringBuilder;
        StringBuilder $this$format_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$format_u24lambda_u240.append("        ");
        $this$format_u24lambda_u240.append(this.formatHead(terminator));
        List<MirBasicBlock> successors = terminator.getSuccessors();
        List<String> labels = this.formatSuccessorLabels(terminator);
        if (!(successors.size() == labels.size())) {
            throw new IllegalStateException("Check failed.");
        }
        boolean showUnwind = terminator instanceof MirTerminator.Drop && !(((MirTerminator.Drop)terminator).getUnwind() instanceof UnwindAction.Cleanup);
        if (!successors.isEmpty() || showUnwind) {
            if (successors.isEmpty() && showUnwind) {
                $this$format_u24lambda_u240.append(" -> ");
                this.formatUnwind($this$format_u24lambda_u240, terminator);
            } else if (successors.size() == 1 && !showUnwind) {
                $this$format_u24lambda_u240.append(" -> bb" + ((MirBasicBlock)CollectionsKt.single(successors)).getIndex());
            } else {
                $this$format_u24lambda_u240.append(" -> [");
                String targets = CollectionsKt.joinToString$default((Iterable)CollectionsKt.zip((Iterable)labels, (Iterable)successors), (CharSequence)", ", null, null, (int)0, null, MirPrettyPrinter::format$lambda$0$0, (int)30, null);
                $this$format_u24lambda_u240.append(targets);
                if (showUnwind) {
                    $this$format_u24lambda_u240.append(", ");
                    this.formatUnwind($this$format_u24lambda_u240, terminator);
                }
                $this$format_u24lambda_u240.append("]");
            }
        }
        $this$format_u24lambda_u240.append(';');
        return stringBuilder.toString();
    }

    private final void formatUnwind(StringBuilder $this$formatUnwind, MirTerminator<? extends MirBasicBlock> terminator) {
        if (!(terminator instanceof MirTerminator.Drop && !(((MirTerminator.Drop)terminator).getUnwind() instanceof UnwindAction.Cleanup))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        $this$formatUnwind.append("unwind ");
        UnwindAction unwindAction = ((MirTerminator.Drop)terminator).getUnwind();
        if (unwindAction instanceof UnwindAction.Cleanup) {
            throw new IllegalStateException("unreachable".toString());
        }
        if (unwindAction instanceof UnwindAction.Continue) {
            v0 = $this$formatUnwind.append("continue");
        } else if (unwindAction instanceof UnwindAction.Unreachable) {
            v0 = $this$formatUnwind.append("unreachable");
        } else if (unwindAction instanceof UnwindAction.Terminate) {
            v0 = $this$formatUnwind.append("terminate(" + ((UnwindAction.Terminate)((MirTerminator.Drop)terminator).getUnwind()).getReason().toShortString() + ")");
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final String formatHead(MirTerminator<? extends MirBasicBlock> terminator) {
        Object object;
        MirTerminator<? extends MirBasicBlock> mirTerminator = terminator;
        if (mirTerminator instanceof MirTerminator.Goto) {
            object = "goto";
        } else if (mirTerminator instanceof MirTerminator.SwitchInt) {
            object = "switchInt(" + this.format(((MirTerminator.SwitchInt)terminator).getDiscriminant()) + ")";
        } else if (mirTerminator instanceof MirTerminator.Return) {
            object = "return";
        } else if (mirTerminator instanceof MirTerminator.Resume) {
            object = "resume";
        } else if (mirTerminator instanceof MirTerminator.Unreachable) {
            object = "unreachable";
        } else if (mirTerminator instanceof MirTerminator.Drop) {
            object = "drop(" + this.format(((MirTerminator.Drop)terminator).getPlace()) + ")";
        } else if (mirTerminator instanceof MirTerminator.Call) {
            String args = CollectionsKt.joinToString$default((Iterable)((MirTerminator.Call)terminator).getArgs(), (CharSequence)", ", null, null, (int)0, null, arg_0 -> MirPrettyPrinter.formatHead$lambda$0(this, arg_0), (int)30, null);
            object = this.format(((MirTerminator.Call)terminator).getDestination()) + " = " + this.format(((MirTerminator.Call)terminator).getCallee()) + "(" + args + ")";
        } else if (mirTerminator instanceof MirTerminator.Assert) {
            String neg = ((MirTerminator.Assert)terminator).getExpected() ? "" : "!";
            object = "assert(" + neg + this.format(((MirTerminator.Assert)terminator).getCond()) + this.format(((MirTerminator.Assert)terminator).getMsg()) + ")";
        } else if (mirTerminator instanceof MirTerminator.FalseEdge) {
            object = "falseEdge";
        } else if (mirTerminator instanceof MirTerminator.FalseUnwind) {
            object = "falseUnwind";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> formatSuccessorLabels(MirTerminator<? extends MirBasicBlock> terminator) {
        List list;
        MirTerminator<? extends MirBasicBlock> mirTerminator = terminator;
        if (mirTerminator instanceof MirTerminator.Return || mirTerminator instanceof MirTerminator.Resume || mirTerminator instanceof MirTerminator.Unreachable) {
            list = CollectionsKt.emptyList();
        } else if (mirTerminator instanceof MirTerminator.Goto) {
            list = CollectionsKt.listOf((Object)"");
        } else if (mirTerminator instanceof MirTerminator.SwitchInt) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = ((MirTerminator.SwitchInt)terminator).getTargets().getValues();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                long l = ((Number)item$iv$iv).longValue();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(String.valueOf((long)it2));
            }
            list = CollectionsKt.plus((Collection)((List)destination$iv$iv), (Object)"otherwise");
        } else if (mirTerminator instanceof MirTerminator.Call) {
            String string;
            Object[] objectArray = new String[2];
            String $this$mapTo$iv$iv = string = "return";
            int n = 0;
            Object[] objectArray2 = objectArray;
            boolean bl = false;
            boolean bl2 = ((MirTerminator.Call)terminator).getTarget() != null;
            objectArray2[n] = bl2 ? string : null;
            String it3 = string = "unwind";
            n = 1;
            objectArray2 = objectArray;
            boolean bl3 = false;
            bl2 = ((MirTerminator.Call)terminator).getUnwind() != null;
            objectArray2[n] = bl2 ? string : null;
            list = CollectionsKt.listOfNotNull((Object[])objectArray);
        } else if (mirTerminator instanceof MirTerminator.Drop && ((MirTerminator.Drop)terminator).getUnwind() instanceof UnwindAction.Cleanup) {
            Object[] objectArray = new String[]{"return", "unwind"};
            list = CollectionsKt.listOfNotNull((Object[])objectArray);
        } else if (mirTerminator instanceof MirTerminator.Drop) {
            list = CollectionsKt.listOfNotNull((Object)"return");
        } else if (mirTerminator instanceof MirTerminator.Assert) {
            String string;
            Object[] objectArray = new String[2];
            objectArray[0] = "success";
            String it4 = string = "unwind";
            int n = 1;
            Object[] objectArray3 = objectArray;
            boolean bl = false;
            boolean bl4 = ((MirTerminator.Assert)terminator).getUnwind() != null;
            objectArray3[n] = bl4 ? string : null;
            list = CollectionsKt.listOfNotNull((Object[])objectArray);
        } else if (mirTerminator instanceof MirTerminator.FalseEdge) {
            Object[] objectArray = new String[]{"real", "imaginary"};
            list = CollectionsKt.listOf((Object[])objectArray);
        } else if (mirTerminator instanceof MirTerminator.FalseUnwind) {
            String string;
            Object[] objectArray = new String[2];
            objectArray[0] = "real";
            String it5 = string = "unwind";
            int n = 1;
            Object[] objectArray4 = objectArray;
            boolean bl = false;
            boolean bl5 = ((MirTerminator.FalseUnwind)terminator).getUnwind() != null;
            objectArray4[n] = bl5 ? string : null;
            list = CollectionsKt.listOfNotNull((Object[])objectArray);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list;
    }

    private final String format(MirLocal local) {
        return "_" + local.getIndex();
    }

    private final String format(MirAssertKind msg) {
        String string;
        MirAssertKind mirAssertKind = msg;
        if (mirAssertKind instanceof MirAssertKind.OverflowNeg) {
            string = ", \"attempt to negate `{}`, which would overflow\", " + this.format(((MirAssertKind.OverflowNeg)msg).getArg());
        } else if (mirAssertKind instanceof MirAssertKind.Overflow) {
            ArithmeticOp arithmeticOp = ((MirAssertKind.Overflow)msg).getOp();
            if (Intrinsics.areEqual((Object)arithmeticOp, (Object)ArithmeticOp.SHL.INSTANCE)) {
                return ", \"attempt to shift left by `{}`, which would overflow\", " + this.format(((MirAssertKind.Overflow)msg).getRight());
            }
            if (Intrinsics.areEqual((Object)arithmeticOp, (Object)ArithmeticOp.SHR.INSTANCE)) {
                return ", \"attempt to shift right by `{}`, which would overflow\", " + this.format(((MirAssertKind.Overflow)msg).getRight());
            }
            if (Intrinsics.areEqual((Object)arithmeticOp, (Object)ArithmeticOp.REM.INSTANCE)) {
                return ", \"attempt to compute the remainder of `{} % {}`, which would overflow\", " + this.format(((MirAssertKind.Overflow)msg).getLeft()) + ", " + this.format(((MirAssertKind.Overflow)msg).getRight());
            }
            if (Intrinsics.areEqual((Object)arithmeticOp, (Object)ArithmeticOp.BIT_AND.INSTANCE)) {
                throw new IllegalStateException(((MirAssertKind.Overflow)msg).getOp() + " can't overflow");
            }
            String op = ((MirAssertKind.Overflow)msg).getOp().getSign();
            string = ", \"attempt to compute `{} " + op + " {}`, which would overflow\", " + this.format(((MirAssertKind.Overflow)msg).getLeft()) + ", " + this.format(((MirAssertKind.Overflow)msg).getRight());
        } else if (mirAssertKind instanceof MirAssertKind.DivisionByZero) {
            string = ", \"attempt to divide `{}` by zero\", " + this.format(((MirAssertKind.DivisionByZero)msg).getArg());
        } else if (mirAssertKind instanceof MirAssertKind.ReminderByZero) {
            string = ", \"attempt to calculate the remainder of `{}` with a divisor of zero\", " + this.format(((MirAssertKind.ReminderByZero)msg).getArg());
        } else if (mirAssertKind instanceof MirAssertKind.BoundsCheck) {
            string = ", \"index out of bounds: the length is {} but the index is {}\", " + this.format(((MirAssertKind.BoundsCheck)msg).getLen()) + ", " + this.format(((MirAssertKind.BoundsCheck)msg).getIndex());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String format(MirRvalue rvalue) {
        Object object;
        MirRvalue mirRvalue = rvalue;
        if (mirRvalue instanceof MirRvalue.BinaryOpUse) {
            String string;
            MirBinaryOperator op = ((MirRvalue.BinaryOpUse)rvalue).getOp();
            if (op instanceof MirBinaryOperator.Arithmetic) {
                string = ((MirBinaryOperator.Arithmetic)op).getOp().getTraitName();
            } else if (op instanceof MirBinaryOperator.Equality) {
                EqualityOp equalityOp = ((MirBinaryOperator.Equality)op).getOp();
                if (Intrinsics.areEqual((Object)equalityOp, (Object)EqualityOp.EQ.INSTANCE)) {
                    string = "Eq";
                } else {
                    if (!Intrinsics.areEqual((Object)equalityOp, (Object)EqualityOp.EXCLEQ.INSTANCE)) throw new NoWhenBranchMatchedException();
                    string = "Ne";
                }
            } else if (op instanceof MirBinaryOperator.Comparison) {
                ComparisonOp comparisonOp = ((MirBinaryOperator.Comparison)op).getOp();
                if (Intrinsics.areEqual((Object)comparisonOp, (Object)ComparisonOp.LT.INSTANCE)) {
                    string = "Lt";
                } else if (Intrinsics.areEqual((Object)comparisonOp, (Object)ComparisonOp.GT.INSTANCE)) {
                    string = "Gt";
                } else if (Intrinsics.areEqual((Object)comparisonOp, (Object)ComparisonOp.GTEQ.INSTANCE)) {
                    string = "Ge";
                } else {
                    if (!Intrinsics.areEqual((Object)comparisonOp, (Object)ComparisonOp.LTEQ.INSTANCE)) throw new NoWhenBranchMatchedException();
                    string = "Le";
                }
            } else {
                if (!Intrinsics.areEqual((Object)op, (Object)MirBinaryOperator.Offset.INSTANCE)) throw new NoWhenBranchMatchedException();
                throw new NotImplementedError(null, 1, null);
            }
            String opName = string;
            object = opName + "(" + this.format(((MirRvalue.BinaryOpUse)rvalue).getLeft()) + ", " + this.format(((MirRvalue.BinaryOpUse)rvalue).getRight()) + ")";
            return object;
        }
        if (mirRvalue instanceof MirRvalue.UnaryOpUse) {
            object = this.getFormatted(((MirRvalue.UnaryOpUse)rvalue).getOp()) + "(" + this.format(((MirRvalue.UnaryOpUse)rvalue).getOperand()) + ")";
            return object;
        }
        if (mirRvalue instanceof MirRvalue.Discriminant) {
            object = "discriminant(" + this.format(((MirRvalue.Discriminant)rvalue).getPlace()) + ")";
            return object;
        }
        if (mirRvalue instanceof MirRvalue.NullaryOpUse) {
            throw new NotImplementedError(null, 1, null);
        }
        if (mirRvalue instanceof MirRvalue.ThreadLocalRef) {
            throw new NotImplementedError(null, 1, null);
        }
        if (mirRvalue instanceof MirRvalue.Use) {
            object = this.format(((MirRvalue.Use)rvalue).getOperand());
            return object;
        }
        if (mirRvalue instanceof MirRvalue.CheckedBinaryOpUse) {
            MirBinaryOperator op = ((MirRvalue.CheckedBinaryOpUse)rvalue).getOp();
            if (!(op instanceof MirBinaryOperator.Arithmetic)) throw new IllegalStateException(op + " can't be checked");
            String funName = "Checked" + ((MirBinaryOperator.Arithmetic)op).getOp().getTraitName();
            object = funName + "(" + this.format(((MirRvalue.CheckedBinaryOpUse)rvalue).getLeft()) + ", " + this.format(((MirRvalue.CheckedBinaryOpUse)rvalue).getRight()) + ")";
            return object;
        }
        if (mirRvalue instanceof MirRvalue.CopyForDeref) {
            throw new NotImplementedError(null, 1, null);
        }
        if (mirRvalue instanceof MirRvalue.Repeat) {
            String value = this.format(((MirRvalue.Repeat)rvalue).getOperand());
            Const count = ((MirRvalue.Repeat)rvalue).getCount();
            object = "[" + value + "; " + count + "]";
            return object;
        }
        if (mirRvalue instanceof MirRvalue.Aggregate.Array) {
            switch (((MirRvalue.Aggregate.Array)rvalue).getOperands().size()) {
                case 0: {
                    return "[]";
                }
                case 1: {
                    object = "[" + this.format((MirOperand)CollectionsKt.single(((MirRvalue.Aggregate.Array)rvalue).getOperands())) + "]";
                    return object;
                }
                default: {
                    object = CollectionsKt.joinToString$default((Iterable)((MirRvalue.Aggregate.Array)rvalue).getOperands(), (CharSequence)", ", (CharSequence)"[", (CharSequence)"]", (int)0, null, arg_0 -> MirPrettyPrinter.format$lambda$1(this, arg_0), (int)24, null);
                    return object;
                }
            }
        }
        if (mirRvalue instanceof MirRvalue.Aggregate.Tuple) {
            switch (((MirRvalue.Aggregate.Tuple)rvalue).getOperands().size()) {
                case 0: {
                    return "()";
                }
                case 1: {
                    object = "(" + this.format((MirOperand)CollectionsKt.single(((MirRvalue.Aggregate.Tuple)rvalue).getOperands())) + ",)";
                    return object;
                }
                default: {
                    object = CollectionsKt.joinToString$default((Iterable)((MirRvalue.Aggregate.Tuple)rvalue).getOperands(), (CharSequence)", ", (CharSequence)"(", (CharSequence)")", (int)0, null, arg_0 -> MirPrettyPrinter.format$lambda$2(this, arg_0), (int)24, null);
                    return object;
                }
            }
        }
        if (mirRvalue instanceof MirRvalue.Aggregate.Adt) {
            Object object2;
            RsFieldsOwner definition = MirrorKt.variant(((MirRvalue.Aggregate.Adt)rvalue).getDefinition(), ((MirRvalue.Aggregate.Adt)rvalue).getVariantIndex());
            RsFieldsOwner rsFieldsOwner = definition;
            if (rsFieldsOwner instanceof RsStructItem) {
                RsQualifiedNamedElement rsQualifiedNamedElement = definition;
                Ty ty2 = ((MirRvalue.Aggregate.Adt)rvalue).getTy();
                Intrinsics.checkNotNull((Object)ty2, (String)"null cannot be cast to non-null type org.rust.lang.core.types.ty.TyAdt");
                object2 = TypeRenderingKt.render$default(new RenderableDefPath(rsQualifiedNamedElement, ((TyAdt)ty2).getTypeParameterValues(), true), this.mir.getContextOwner(), 0, null, null, null, null, null, null, QualifiedNameSettings.All.INSTANCE, false, false, false, false, false, false, false, ImportContext.Type.AUTO_IMPORT, 65278, null);
            } else {
                if (!(rsFieldsOwner instanceof RsEnumVariant)) throw new IllegalStateException("unreachable".toString());
                RsQualifiedNamedElement rsQualifiedNamedElement = RsEnumVariantKt.getParentEnum((RsEnumVariant)definition);
                Ty ty3 = ((MirRvalue.Aggregate.Adt)rvalue).getTy();
                Intrinsics.checkNotNull((Object)ty3, (String)"null cannot be cast to non-null type org.rust.lang.core.types.ty.TyAdt");
                String enumName = TypeRenderingKt.render$default(new RenderableDefPath(rsQualifiedNamedElement, ((TyAdt)ty3).getTypeParameterValues(), true), this.mir.getContextOwner(), 0, null, null, null, null, null, null, QualifiedNameSettings.All.INSTANCE, false, false, false, false, false, false, false, ImportContext.Type.AUTO_IMPORT, 65278, null);
                String string = ((RsEnumVariant)definition).getName();
                Intrinsics.checkNotNull((Object)string);
                object2 = enumName + "::" + string;
            }
            String name2 = object2;
            if (RsFieldsOwnerKt.isFieldless(definition)) {
                object = name2;
                return object;
            } else if (definition.getTupleFields() != null) {
                object = CollectionsKt.joinToString$default((Iterable)((MirRvalue.Aggregate.Adt)rvalue).getOperands(), (CharSequence)", ", (CharSequence)(name2 + "("), (CharSequence)")", (int)0, null, arg_0 -> MirPrettyPrinter.format$lambda$3(this, arg_0), (int)24, null);
                return object;
            } else {
                if (!(RsFieldsOwnerKt.getExpandedFields(definition).size() == ((MirRvalue.Aggregate.Adt)rvalue).getOperands().size())) {
                    throw new IllegalStateException("Check failed.");
                }
                String string = CollectionsKt.joinToString$default((Iterable)CollectionsKt.zip((Iterable)RsFieldsOwnerKt.getExpandedFields(definition), (Iterable)((MirRvalue.Aggregate.Adt)rvalue).getOperands()), null, null, null, (int)0, null, arg_0 -> MirPrettyPrinter.format$lambda$4(this, arg_0), (int)31, null);
                object = name2 + " { " + string + " }";
            }
            return object;
        }
        if (mirRvalue instanceof MirRvalue.Aggregate.Closure) {
            Object object3;
            Object it2;
            boolean bl;
            block67: {
                Iterable $this$all$iv = ((MirRvalue.Aggregate.Closure)rvalue).getOperands();
                boolean bl2 = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        boolean bl3;
                        it2 = (MirOperand)element$iv;
                        boolean bl4 = false;
                        Object object4 = it2;
                        if (object4 instanceof MirOperand.Copy) {
                            bl3 = ((MirOperand.Copy)it2).getPlace().getProjections().isEmpty();
                        } else if (object4 instanceof MirOperand.Move) {
                            bl3 = ((MirOperand.Move)it2).getPlace().getProjections().isEmpty();
                        } else {
                            if (!(object4 instanceof MirOperand.Constant)) throw new NoWhenBranchMatchedException();
                            bl3 = false;
                        }
                        if (bl3) continue;
                        bl = false;
                        break block67;
                    }
                    bl = true;
                }
            }
            boolean allHasNoFields = bl;
            if (((MirRvalue.Aggregate.Closure)rvalue).getOperands().isEmpty()) {
                object3 = "";
            } else if (allHasNoFields) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = this.mir.getBuildContext().getUpvarsMentioned().get(((MirRvalue.Aggregate.Closure)rvalue).getDefinition());
                boolean $i$f$map = false;
                it2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it3;
                    RsPatBinding rsPatBinding = (RsPatBinding)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl5 = false;
                    String string = it3.getName();
                    Intrinsics.checkNotNull((Object)string);
                    collection.add(string);
                }
                List list = (List)destination$iv$iv;
                String operands = CollectionsKt.joinToString$default((Iterable)CollectionsKt.zip((Iterable)list, (Iterable)((MirRvalue.Aggregate.Closure)rvalue).getOperands()), null, null, null, (int)0, null, arg_0 -> MirPrettyPrinter.format$lambda$7(this, arg_0), (int)31, null);
                object3 = " { " + operands + " }";
            } else {
                String string = CollectionsKt.joinToString$default((Iterable)((MirRvalue.Aggregate.Closure)rvalue).getOperands(), null, null, null, (int)0, null, arg_0 -> MirPrettyPrinter.format$lambda$8(this, arg_0), (int)31, null);
                object3 = " { " + string + " }";
            }
            String operands = object3;
            object = "{closure@" + this.formatLocation(((MirRvalue.Aggregate.Closure)rvalue).getDefinition()) + "}" + operands;
            return object;
        }
        if (mirRvalue instanceof MirRvalue.Ref) {
            object = "&" + (Intrinsics.areEqual((Object)((MirRvalue.Ref)rvalue).getBorrowKind(), (Object)MirBorrowKind.Shared.INSTANCE) ? "" : "mut ") + this.format(((MirRvalue.Ref)rvalue).getPlace());
            return object;
        } else if (mirRvalue instanceof MirRvalue.AddressOf) {
            object = "&raw " + (((MirRvalue.AddressOf)rvalue).getMutability() == Mutability.MUTABLE ? "mut" : "const") + " " + this.format(((MirRvalue.AddressOf)rvalue).getPlace());
            return object;
        } else if (mirRvalue instanceof MirRvalue.Len) {
            object = "Len(" + this.format(((MirRvalue.Len)rvalue).getPlace()) + ")";
            return object;
        } else if (mirRvalue instanceof MirRvalue.Cast.IntToInt) {
            object = this.format(((MirRvalue.Cast.IntToInt)rvalue).getOperand()) + " as " + MirPrettyPrinter.format$default(this, ((MirRvalue.Cast.IntToInt)rvalue).getTy(), null, 2, null) + " (IntToInt)";
            return object;
        } else if (mirRvalue instanceof MirRvalue.Cast.Unknown) {
            object = this.format(((MirRvalue.Cast.Unknown)rvalue).getOperand()) + " as " + MirPrettyPrinter.format$default(this, ((MirRvalue.Cast.Unknown)rvalue).getTy(), null, 2, null) + " (Unknown)";
            return object;
        } else if (mirRvalue instanceof MirRvalue.Cast.Pointer) {
            object = this.format(((MirRvalue.Cast.Pointer)rvalue).getOperand()) + " as " + MirPrettyPrinter.format$default(this, ((MirRvalue.Cast.Pointer)rvalue).getTy(), null, 2, null) + " (PointerCoercion(" + ((MirRvalue.Cast.Pointer)rvalue).getCast() + "))";
            return object;
        } else {
            if (!(mirRvalue instanceof MirRvalue.SubstitutesUse)) throw new NoWhenBranchMatchedException();
            Iterable $this$map$iv = ((MirRvalue.SubstitutesUse)rvalue).getSubstitutes();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : iterable) {
                void it4;
                MirRvalue.SubstitutesUse.SubstituteData $i$f$mapTo2 = (MirRvalue.SubstitutesUse.SubstituteData)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it4.getOperand());
            }
            object = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), null, (CharSequence)"Substitutes(", (CharSequence)")", (int)0, null, null, (int)57, null);
        }
        return object;
    }

    private final LocationRange formatLocation(RsLambdaExpr lambda) {
        String string = lambda.getContainingFile().getOriginalFile().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String fileName = string;
        String string2 = this.filenamePrefix + fileName;
        Location location = org.rust.lang.core.mir.MirPrettyPrinter$Companion.getStartLocation$default(Companion, lambda, 0, 2, null);
        RsValueParameterList rsValueParameterList = lambda.getValueParameterList();
        Intrinsics.checkNotNullExpressionValue((Object)rsValueParameterList, (String)"<get-valueParameterList>(...)");
        return new LocationRange(string2, location, MirPrettyPrinter.Companion.getEndLocation(rsValueParameterList));
    }

    private final String format(MirOperand operand) {
        Object object;
        MirOperand mirOperand = operand;
        if (mirOperand instanceof MirOperand.Constant) {
            MirConstant constant = ((MirOperand.Constant)operand).getConstant();
            String formattedConst = this.format(constant);
            object = constant instanceof MirConstant.Value && ((MirConstant.Value)constant).getTy() instanceof TyFunctionBase ? formattedConst : "const " + formattedConst;
        } else if (mirOperand instanceof MirOperand.Move) {
            object = "move " + this.format(((MirOperand.Move)operand).getPlace());
        } else if (mirOperand instanceof MirOperand.Copy) {
            object = this.format(((MirOperand.Copy)operand).getPlace());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    private final String format(MirPlace place) {
        MirProjectionElem mirProjectionElem;
        StringBuilder stringBuilder;
        int index = place.getLocal().getIndex();
        StringBuilder $this$format_u24lambda_u2410 = stringBuilder = new StringBuilder();
        boolean bl = false;
        for (MirProjectionElem mirProjectionElem2 : CollectionsKt.asReversed(place.getProjections())) {
            mirProjectionElem = mirProjectionElem2;
            if (mirProjectionElem instanceof MirProjectionElem.Downcast || mirProjectionElem instanceof MirProjectionElem.Field) {
                $this$format_u24lambda_u2410.append("(");
                continue;
            }
            if (mirProjectionElem instanceof MirProjectionElem.Deref) {
                $this$format_u24lambda_u2410.append("(*");
                continue;
            }
            if (mirProjectionElem instanceof MirProjectionElem.Index || mirProjectionElem instanceof MirProjectionElem.ConstantIndex || mirProjectionElem instanceof MirProjectionElem.Subslice) continue;
            throw new NoWhenBranchMatchedException();
        }
        $this$format_u24lambda_u2410.append("_" + index);
        for (MirProjectionElem mirProjectionElem3 : place.getProjections()) {
            StringBuilder stringBuilder2;
            mirProjectionElem = mirProjectionElem3;
            if (mirProjectionElem instanceof MirProjectionElem.Downcast) {
                Object object = ((MirProjectionElem.Downcast)mirProjectionElem3).getName();
                if (object == null) {
                    object = "variant#" + ((MirProjectionElem.Downcast)mirProjectionElem3).getVariantIndex();
                }
                String name2 = object;
                stringBuilder2 = $this$format_u24lambda_u2410.append(" as " + name2 + ")");
                continue;
            }
            if (mirProjectionElem instanceof MirProjectionElem.Field) {
                stringBuilder2 = $this$format_u24lambda_u2410.append("." + ((MirProjectionElem.Field)mirProjectionElem3).getFieldIndex() + ": " + MirPrettyPrinter.format$default(this, (Ty)((MirProjectionElem.Field)mirProjectionElem3).getElem(), null, 2, null) + ")");
                continue;
            }
            if (mirProjectionElem instanceof MirProjectionElem.Deref) {
                stringBuilder2 = $this$format_u24lambda_u2410.append(")");
                continue;
            }
            if (mirProjectionElem instanceof MirProjectionElem.Index) {
                stringBuilder2 = $this$format_u24lambda_u2410.append("[_" + ((MirProjectionElem.Index)mirProjectionElem3).getIndex().getIndex() + "]");
                continue;
            }
            if (mirProjectionElem instanceof MirProjectionElem.ConstantIndex) {
                $this$format_u24lambda_u2410.append("[");
                if (((MirProjectionElem.ConstantIndex)mirProjectionElem3).getFromEnd()) {
                    $this$format_u24lambda_u2410.append("-");
                }
                stringBuilder2 = $this$format_u24lambda_u2410.append(((MirProjectionElem.ConstantIndex)mirProjectionElem3).getOffset() + " of " + ((MirProjectionElem.ConstantIndex)mirProjectionElem3).getMinLength() + "]");
                continue;
            }
            if (mirProjectionElem instanceof MirProjectionElem.Subslice) {
                String str = ((MirProjectionElem.Subslice)mirProjectionElem3).getFromEnd() && ((MirProjectionElem.Subslice)mirProjectionElem3).getTo() == 0L ? "[" + ((MirProjectionElem.Subslice)mirProjectionElem3).getFrom() + ":]" : (((MirProjectionElem.Subslice)mirProjectionElem3).getFromEnd() && ((MirProjectionElem.Subslice)mirProjectionElem3).getFrom() == 0L ? "[:-" + ((MirProjectionElem.Subslice)mirProjectionElem3).getTo() + "]" : (((MirProjectionElem.Subslice)mirProjectionElem3).getFromEnd() ? "[" + ((MirProjectionElem.Subslice)mirProjectionElem3).getFrom() + ":-" + ((MirProjectionElem.Subslice)mirProjectionElem3).getTo() + "]" : "[" + ((MirProjectionElem.Subslice)mirProjectionElem3).getFrom() + ".." + ((MirProjectionElem.Subslice)mirProjectionElem3).getTo() + "]"));
                stringBuilder2 = $this$format_u24lambda_u2410.append(str);
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
        return stringBuilder.toString();
    }

    private final String format(MirConstant constant) {
        String string;
        MirConstant mirConstant = constant;
        if (mirConstant instanceof MirConstant.Value) {
            string = this.format((MirConstant.Value)constant);
        } else if (mirConstant instanceof MirConstant.Unevaluated) {
            string = "_";
        } else if (mirConstant instanceof MirConstant.Unknown) {
            string = "Unknown";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String format(MirConstant.Value constant) {
        Object object;
        MirConstValue mirConstValue = constant.getConstValue();
        if (mirConstValue instanceof MirConstValue.Scalar) {
            MirScalar value = ((MirConstValue.Scalar)constant.getConstValue()).getValue();
            if (!(value instanceof MirScalar.Int)) throw new NoWhenBranchMatchedException();
            long value2 = ((MirScalar.Int)value).getScalarInt().getData();
            Ty ty2 = constant.getTy();
            Intrinsics.checkNotNull((Object)ty2, (String)"null cannot be cast to non-null type org.rust.lang.core.types.ty.TyPrimitive");
            TyPrimitive type = (TyPrimitive)ty2;
            if (type instanceof TyInteger) {
                object = UtilsKt.isSigned(type) && UtilsKt.minValue((TyInteger)type, TargetProcessParams.Companion.getDEFAULT()) == value2 ? type.getName() + "::MIN" : value2 + "_" + type.getName();
                return object;
            } else {
                if (type instanceof TyBool) {
                    long l = value2;
                    if (l == 0L) {
                        return "false";
                    }
                    if (l != 1L) throw new NotImplementedError(null, 1, null);
                    return "true";
                }
                if (type instanceof TyFloat.F32) {
                    object = this.formatFloat32((int)value2);
                    return object;
                } else {
                    if (!(type instanceof TyFloat.F64)) throw new NotImplementedError(null, 1, null);
                    object = this.formatFloat64(value2);
                }
            }
            return object;
        }
        if (!(mirConstValue instanceof MirConstValue.ZeroSized)) throw new NoWhenBranchMatchedException();
        Ty ty3 = constant.getTy();
        if (ty3 instanceof TyTuple) {
            return "()";
        }
        if (ty3 instanceof TyFnDef) {
            Object v3;
            Object v2;
            RenderableDefPath renderableDefPath;
            block11: {
                renderableDefPath = new RenderableDefPath(((TyFnDef)ty3).getDef().getElement(), ((TyFnDef)ty3).getSubst(), true);
                KnownItems knownItems = this.getKnownItems();
                String path$iv = "std::array::IntoIter";
                boolean isStd$iv = true;
                boolean $i$f$findItem = false;
                Iterable $this$firstOrNull$iv$iv = knownItems.findItemRaw(path$iv, isStd$iv);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                    RsNamedElement it$iv = (RsNamedElement)element$iv$iv;
                    boolean bl = false;
                    if (!(it$iv instanceof RsQualifiedNamedElement)) continue;
                    v2 = element$iv$iv;
                    break block11;
                }
                v2 = v3 = null;
            }
            if (!(v2 instanceof RsQualifiedNamedElement)) {
                v3 = null;
            }
            Set set = SetsKt.setOfNotNull((Object)v3);
            QualifiedNameSettings.Selected selected = new QualifiedNameSettings.Selected(set);
            ImportContext.Type type = ImportContext.Type.AUTO_IMPORT;
            RsInferenceContextOwner rsInferenceContextOwner = this.mir.getContextOwner();
            object = TypeRenderingKt.render$default(renderableDefPath, rsInferenceContextOwner, 0, null, null, null, null, null, null, selected, false, false, false, false, false, false, false, type, 65278, null);
            return object;
        }
        object = ty3.toString();
        return object;
    }

    private final String formatFloat32(int bits) {
        return this.formatFloatingPoint(Float.valueOf(Float.intBitsToFloat(bits)), bits, "f32", 9, Integer.MAX_VALUE, 31);
    }

    private final String formatFloat64(long bits) {
        return this.formatFloatingPoint(Double.longBitsToDouble(bits), bits, "f64", 17, Long.MAX_VALUE, 63);
    }

    private final String formatFloatingPoint(Number value, long bits, String suffix, int precision, long maskBits, int shiftBits) {
        String string;
        if (Double.isNaN(value.doubleValue())) {
            string = "NaN" + suffix;
        } else if (Double.isInfinite(value.doubleValue())) {
            string = (value.doubleValue() > 0.0 ? "+Inf" : "-Inf") + suffix;
        } else {
            boolean isNegZero = (bits & maskBits) == 0L && bits >>> shiftBits == 1L;
            BigDecimal bd = new BigDecimal(value.doubleValue());
            BigDecimal bigDecimal = bd.round(new MathContext(precision, RoundingMode.HALF_UP));
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"round(...)");
            bd = bigDecimal;
            String string2 = bd.toPlainString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toPlainString(...)");
            return this.formatFloatString(string2, isNegZero, suffix);
        }
        return string;
    }

    private final String formatFloatString(String numStr, boolean isNegZero, String suffix) {
        String formattedNum = Intrinsics.areEqual((Object)numStr, (Object)"0") || Intrinsics.areEqual((Object)numStr, (Object)"-0") ? (isNegZero ? "-0.0" : "0.0") : (!StringsKt.contains$default((CharSequence)numStr, (char)'.', (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)numStr, (char)'E', (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)numStr, (char)'e', (boolean)false, (int)2, null) ? numStr + ".0" : numStr);
        return formattedNum + suffix;
    }

    private final StringBuilder printIntro(StringBuilder $this$printIntro) {
        StringBuilder stringBuilder;
        StringBuilder $this$printIntro_u24lambda_u240 = stringBuilder = $this$printIntro;
        boolean bl = false;
        this.printMirSignature($this$printIntro_u24lambda_u240);
        $this$printIntro_u24lambda_u240.append("{").append('\n');
        this.printScopeTree($this$printIntro_u24lambda_u240, this.mir.getSourceScopesTree(), this.mir.getOutermostScope(), 1);
        return stringBuilder;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final StringBuilder printMirSignature(StringBuilder $this$printMirSignature) {
        block22: {
            block24: {
                block23: {
                    block21: {
                        $this$printMirSignature_u24lambda_u240 = var2_2 = $this$printMirSignature;
                        $i$a$-apply-MirPrettyPrinter$printMirSignature$1 = false;
                        reference = this.mir.getSourceElement();
                        if (!(reference instanceof RsConstant)) break block21;
                        if (((RsConstant)reference).getConst() != null) {
                            v0 = $this$printMirSignature_u24lambda_u240.append("const ");
                        } else if (((RsConstant)reference).getStatic() != null && ((RsConstant)reference).getMut() != null) {
                            v0 = $this$printMirSignature_u24lambda_u240.append("static mut ");
                        } else if (((RsConstant)reference).getStatic() != null) {
                            v0 = $this$printMirSignature_u24lambda_u240.append("static ");
                        } else {
                            throw new IllegalStateException("Unexpected RsConstant");
                        }
                        v1 = ((RsConstant)reference).getName();
                        if (v1 == null) {
                            throw new NotImplementedError(null, 1, null);
                        }
                        $this$printMirSignature_u24lambda_u240.append(v1);
                        v2 = $this$printMirSignature_u24lambda_u240.append(": " + MirPrettyPrinter.format$default(this, this.mir.getReturnLocal().getTy(), null, 2, null) + " = ");
                        break block22;
                    }
                    if (!(reference instanceof RsFunction)) break block23;
                    $this$printMirSignature_u24lambda_u240.append("fn ");
                    var6_6 = ((RsFunction)reference).getParent();
                    if (var6_6 == null || (var7_8 = var6_6.getParent()) == null) ** GOTO lbl-1000
                    it = var7_8;
                    $i$a$-let-MirPrettyPrinter$printMirSignature$1$prefix$1 = false;
                    var10_16 = it instanceof RsImplItem ? (RsImplItem)it : null;
                    if (var10_16 != null) {
                        it = var10_16;
                        $i$a$-let-MirPrettyPrinter$printMirSignature$1$prefix$2 = 0;
                        v3 = it.getImpl();
                        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getImpl(...)");
                        impl /* !! */  = v3;
                        v4 = it.getTypeReference();
                        if (v4 == null) {
                            throw new IllegalStateException("Could not find type reference of impl".toString());
                        }
                        name = v4;
                        v5 = it.getContainingFile().getOriginalFile().getName();
                        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getName(...)");
                        fileName = v5;
                        location = new LocationRange(this.filenamePrefix + fileName, org.rust.lang.core.mir.MirPrettyPrinter$Companion.getStartLocation$default(MirPrettyPrinter.Companion, impl /* !! */ , 0, 2, null), org.rust.lang.core.mir.MirPrettyPrinter$Companion.access$getEndLocation(MirPrettyPrinter.Companion, name));
                        v6 = "<impl at " + location + ">::";
                    } else lbl-1000:
                    // 2 sources

                    {
                        v6 = null;
                    }
                    if ((v7 = (prefix = v6)) == null) {
                        v7 = "";
                    }
                    $this$printMirSignature_u24lambda_u240.append(v7 + ((RsFunction)reference).getName());
                    $this$printMirSignature_u24lambda_u240.append("(");
                    $this$forEachIndexed$iv = this.mir.getArgs();
                    $i$f$forEachIndexed = false;
                    index$iv = 0;
                    for (T item$iv : $this$forEachIndexed$iv) {
                        if (($i$a$-let-MirPrettyPrinter$printMirSignature$1$prefix$2 = index$iv++) < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        impl /* !! */  = (MirLocal)item$iv;
                        index = $i$a$-let-MirPrettyPrinter$printMirSignature$1$prefix$2;
                        $i$a$-forEachIndexed-MirPrettyPrinter$printMirSignature$1$1 = false;
                        if (index != 0) {
                            $this$printMirSignature_u24lambda_u240.append(", ");
                        }
                        $this$printMirSignature_u24lambda_u240.append(this.format((MirLocal)arg) + ": " + this.format(arg.getTy(), ImportContext.Type.AUTO_IMPORT));
                    }
                    v2 = $this$printMirSignature_u24lambda_u240.append(") -> " + this.format(this.mir.getReturnLocal().getTy(), ImportContext.Type.AUTO_IMPORT) + " ");
                    break block22;
                }
                if (!(reference instanceof RsLambdaExpr)) break block24;
                $this$printMirSignature_u24lambda_u240.append("fn ");
                $this$parentOfType_u24default$iv = reference;
                withSelf$iv = false;
                $i$f$parentOfType = false;
                v8 = PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, RsFunction.class, (boolean)true);
                Intrinsics.checkNotNull((Object)v8);
                fn = (RsFunction)v8;
                withSelf$iv = fn.getParent();
                if (withSelf$iv == null || ($i$f$parentOfType = withSelf$iv.getParent()) == null) ** GOTO lbl-1000
                it = $i$f$parentOfType;
                $i$a$-let-MirPrettyPrinter$printMirSignature$1$prefix$3 = false;
                var16_37 = it instanceof RsImplItem ? (RsImplItem)it : null;
                if (var16_37 != null) {
                    it = var16_37;
                    $i$a$-let-MirPrettyPrinter$printMirSignature$1$prefix$4 = false;
                    v9 = it.getImpl();
                    Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"getImpl(...)");
                    impl /* !! */  = v9;
                    v10 = it.getTypeReference();
                    if (v10 == null) {
                        throw new IllegalStateException("Could not find type reference of impl".toString());
                    }
                    name = v10;
                    v11 = it.getContainingFile().getOriginalFile().getName();
                    Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"getName(...)");
                    fileName = v11;
                    location = new LocationRange(this.filenamePrefix + fileName, org.rust.lang.core.mir.MirPrettyPrinter$Companion.getStartLocation$default(MirPrettyPrinter.Companion, impl /* !! */ , 0, 2, null), org.rust.lang.core.mir.MirPrettyPrinter$Companion.access$getEndLocation(MirPrettyPrinter.Companion, name));
                    v12 = "<impl at " + location + ">::";
                } else lbl-1000:
                // 2 sources

                {
                    v12 = null;
                }
                if ((v13 = (prefix = v12)) == null) {
                    v13 = "";
                }
                $this$printMirSignature_u24lambda_u240.append(v13 + fn.getName());
                $this$printMirSignature_u24lambda_u240.append("::{closure#0}");
                $this$printMirSignature_u24lambda_u240.append("(");
                $this$forEachIndexed$iv = this.mir.getArgs();
                $i$f$forEachIndexed = false;
                index$iv = 0;
                for (T item$iv : $this$forEachIndexed$iv) {
                    if ((var11_22 = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    impl /* !! */  = (MirLocal)item$iv;
                    index = var11_22;
                    $i$a$-forEachIndexed-MirPrettyPrinter$printMirSignature$1$2 = false;
                    if (index != 0) {
                        $this$printMirSignature_u24lambda_u240.append(", ");
                    }
                    $this$printMirSignature_u24lambda_u240.append(this.format((MirLocal)arg) + ": " + MirPrettyPrinter.format$default(this, arg.getTy(), null, 2, null));
                }
                v2 = $this$printMirSignature_u24lambda_u240.append(") -> " + MirPrettyPrinter.format$default(this, this.mir.getReturnLocal().getTy(), null, 2, null) + " ");
                break block22;
            }
            var15_35 = "Unsupported type " + Reflection.getOrCreateKotlinClass(reference.getClass());
            throw new NotImplementedError("An operation is not implemented: " + var15_35);
        }
        return var2_2;
    }

    private final String format(MirStatement.FakeRead.Cause cause) {
        String string;
        MirStatement.FakeRead.Cause cause2 = cause;
        if (cause2 instanceof MirStatement.FakeRead.Cause.ForMatchedPlace) {
            String string2;
            String it2 = string2 = "ForMatchedPlace(None)";
            boolean bl = false;
            boolean $i$f$weakAssert = false;
            boolean $i$f$weakAssert2 = false;
            if (org.rust.openapiext.UtilsKt.isUnitTestMode() || org.rust.openapiext.UtilsKt.isInternal()) {
                boolean bl2 = false;
                if (!(((MirStatement.FakeRead.Cause.ForMatchedPlace)cause).getElement() == null)) {
                    boolean bl3 = false;
                    String message$iv$iv = "Assertion failed";
                    throw new AssertionError((Object)message$iv$iv);
                }
            }
            string = string2;
        } else if (cause2 instanceof MirStatement.FakeRead.Cause.ForLet) {
            String string3;
            String it3 = string3 = "ForLet(None)";
            boolean bl = false;
            boolean $i$f$weakAssert = false;
            boolean $i$f$weakAssert3 = false;
            if (org.rust.openapiext.UtilsKt.isUnitTestMode() || org.rust.openapiext.UtilsKt.isInternal()) {
                boolean bl4 = false;
                if (!(((MirStatement.FakeRead.Cause.ForLet)cause).getElement() == null)) {
                    boolean bl5 = false;
                    String message$iv$iv = "Assertion failed";
                    throw new AssertionError((Object)message$iv$iv);
                }
            }
            string = string3;
        } else if (Intrinsics.areEqual((Object)cause2, (Object)MirStatement.FakeRead.Cause.ForIndex.INSTANCE)) {
            string = "ForIndex";
        } else if (Intrinsics.areEqual((Object)cause2, (Object)MirStatement.FakeRead.Cause.ForGuardBinding.INSTANCE)) {
            string = "ForGuardBinding";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final String format(Ty ty2, ImportContext.Type importContextType) {
        Object v1;
        Object v0;
        KnownItems $this$iv;
        Object[] objectArray;
        block3: {
            void path$iv;
            objectArray = new RsQualifiedNamedElement[8];
            objectArray[0] = this.getKnownItems().getRange();
            objectArray[1] = this.getKnownItems().getRangeInclusive();
            objectArray[2] = this.getKnownItems().getOption();
            objectArray[3] = this.getKnownItems().getControlFlow();
            objectArray[4] = this.getKnownItems().getInfallible();
            objectArray[5] = this.getKnownItems().getRc();
            KnownItems knownItems = this.getKnownItems();
            String string = "std::array::IntoIter";
            int n = 6;
            Object[] objectArray2 = objectArray;
            boolean isStd$iv = true;
            boolean $i$f$findItem = false;
            Iterable $this$firstOrNull$iv$iv = $this$iv.findItemRaw((String)path$iv, isStd$iv);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                RsNamedElement it$iv = (RsNamedElement)element$iv$iv;
                boolean bl = false;
                if (!(it$iv instanceof RsQualifiedNamedElement)) continue;
                v0 = element$iv$iv;
                break block3;
            }
            v0 = v1 = null;
        }
        if (!(v0 instanceof RsQualifiedNamedElement)) {
            v1 = null;
        }
        RsNamedElement rsNamedElement = v1;
        objectArray2[n] = rsNamedElement;
        $this$iv = this.getKnownItems();
        String langAttribute$iv = "RangeFull";
        String crateName$iv = "core";
        boolean $i$f$findLangItem = false;
        RsNamedElement rsNamedElement2 = $this$iv.findLangItemRaw(langAttribute$iv, crateName$iv);
        if (!(rsNamedElement2 instanceof RsQualifiedNamedElement)) {
            rsNamedElement2 = null;
        }
        objectArray[7] = (RsQualifiedNamedElement)rsNamedElement2;
        Set set = SetsKt.setOfNotNull((Object[])objectArray);
        QualifiedNameSettings.Selected useQualifiedName = new QualifiedNameSettings.Selected(set);
        return ty2 instanceof TyClosure ? "{closure@" + this.formatLocation(((TyClosure)ty2).getDef()) + "}" : TypeRenderingKt.render$default(ty2, this.mir.getSourceElement(), 0, null, null, null, null, null, null, useQualifiedName, false, false, false, false, false, false, false, importContextType, 65278, null);
    }

    static /* synthetic */ String format$default(MirPrettyPrinter mirPrettyPrinter, Ty ty2, ImportContext.Type type, int n, Object object) {
        if ((n & 2) != 0) {
            type = ImportContext.Type.OTHER;
        }
        return mirPrettyPrinter.format(ty2, type);
    }

    private final StringBuilder printScopeTree(StringBuilder $this$printScopeTree, Map<MirSourceScope, ? extends List<MirSourceScope>> scopeTree, MirSourceScope parent2, int depth) {
        StringBuilder stringBuilder;
        StringBuilder $this$printScopeTree_u24lambda_u240 = stringBuilder = $this$printScopeTree;
        boolean bl = false;
        String indent = StringsKt.repeat((CharSequence)INDENT, (int)depth);
        for (MirVarDebugInfo varDebugInfo : this.mir.getVarDebugInfo()) {
            if (!Intrinsics.areEqual((Object)varDebugInfo.getSource().getScope(), (Object)parent2)) continue;
            String debugInfo = indent + "debug " + varDebugInfo.getName() + " => " + this.format(varDebugInfo.getContents()) + ";";
            $this$printScopeTree_u24lambda_u240.append(this.withComment(debugInfo, this.commentSupplier.varDebugInfoComment(varDebugInfo))).append('\n');
        }
        for (MirLocal local : this.mir.getLocalDecls()) {
            int debugInfo = this.mir.getArgCount();
            int n = local.getIndex();
            if ((1 <= n ? n <= debugInfo : false) || !Intrinsics.areEqual((Object)local.getSource().getScope(), (Object)parent2)) continue;
            String mut = switch (WhenMappings.$EnumSwitchMapping$0[local.getMutability().ordinal()]) {
                case 1 -> "mut ";
                case 2 -> "";
                default -> throw new NoWhenBranchMatchedException();
            };
            String definition = indent + "let " + mut + this.format(local) + ": " + MirPrettyPrinter.format$default(this, local.getTy(), null, 2, null) + ";";
            $this$printScopeTree_u24lambda_u240.append(this.withComment(definition, this.commentSupplier.localComment(local))).append('\n');
        }
        List<MirSourceScope> list = scopeTree.get(parent2);
        if (list != null) {
            List<MirSourceScope> children = list;
            Iterable $this$forEach$iv = children;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MirSourceScope child = (MirSourceScope)element$iv;
                boolean bl2 = false;
                $this$printScopeTree_u24lambda_u240.append(indent + "scope " + child.getIndex() + " {").append('\n');
                this.printScopeTree($this$printScopeTree_u24lambda_u240, scopeTree, child, depth + 1);
                $this$printScopeTree_u24lambda_u240.append(indent + "}").append('\n');
            }
        }
        return stringBuilder;
    }

    private final String format(MirVarDebugInfo.Contents contents) {
        String string;
        MirVarDebugInfo.Contents contents2 = contents;
        if (contents2 instanceof MirVarDebugInfo.Contents.Composite) {
            throw new NotImplementedError(null, 1, null);
        }
        if (contents2 instanceof MirVarDebugInfo.Contents.Constant) {
            string = this.format(((MirVarDebugInfo.Contents.Constant)contents).getConstant());
        } else if (contents2 instanceof MirVarDebugInfo.Contents.Place) {
            string = this.format(((MirVarDebugInfo.Contents.Place)contents).getPlace());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private final String withComment(String $this$withComment, String comment) {
        return comment != null ? (StringsKt.startsWith$default((String)((Object)StringsKt.trimStart((CharSequence)comment)).toString(), (String)"//", (boolean)false, (int)2, null) ? this.withCommentAsIs($this$withComment, comment) : this.withCommentAsIs($this$withComment, " // " + comment)) : $this$withComment;
    }

    private final String withCommentAsIs(String $this$withCommentAsIs, String comment) {
        return $this$withCommentAsIs + StringsKt.repeat((CharSequence)" ", (int)Math.max(40 - $this$withCommentAsIs.length(), 0)) + comment;
    }

    private final String getFormatted(MirUnaryOperator $this$formatted) {
        return $this$formatted.name();
    }

    private static final CharSequence format$lambda$0$0(Pair pair) {
        Intrinsics.checkNotNullParameter((Object)pair, (String)"<destruct>");
        String label = (String)pair.component1();
        MirBasicBlock successor = (MirBasicBlock)pair.component2();
        return label + ": bb" + successor.getIndex();
    }

    private static final CharSequence formatHead$lambda$0(MirPrettyPrinter this$0, MirOperand it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return this$0.format(it2);
    }

    private static final CharSequence format$lambda$1(MirPrettyPrinter this$0, MirOperand it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return this$0.format(it2);
    }

    private static final CharSequence format$lambda$2(MirPrettyPrinter this$0, MirOperand it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return this$0.format(it2);
    }

    private static final CharSequence format$lambda$3(MirPrettyPrinter this$0, MirOperand it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return this$0.format(it2);
    }

    private static final CharSequence format$lambda$4(MirPrettyPrinter this$0, Pair pair) {
        Intrinsics.checkNotNullParameter((Object)pair, (String)"<destruct>");
        RsFieldDecl fieldDeclaration = (RsFieldDecl)pair.component1();
        MirOperand fieldValue = (MirOperand)pair.component2();
        return fieldDeclaration.getName() + ": " + this$0.format(fieldValue);
    }

    private static final CharSequence format$lambda$7(MirPrettyPrinter this$0, Pair pair) {
        Intrinsics.checkNotNullParameter((Object)pair, (String)"<destruct>");
        String u = (String)pair.component1();
        MirOperand o = (MirOperand)pair.component2();
        return u + ": " + this$0.format(o);
    }

    private static final CharSequence format$lambda$8(MirPrettyPrinter this$0, MirOperand it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return this$0.format(it2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u00032\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0013\u00c0\u0006\u0001"}, d2={"Lorg/rust/lang/core/mir/MirPrettyPrinter$CommentSupplier;", "", "varDebugInfoComment", "", "varDebugInfo", "Lorg/rust/lang/core/mir/schemas/MirVarDebugInfo;", "localComment", "local", "Lorg/rust/lang/core/mir/schemas/MirLocal;", "blockStartComment", "block", "Lorg/rust/lang/core/mir/schemas/MirBasicBlock;", "blockEndComment", "statementComment", "stmt", "Lorg/rust/lang/core/mir/schemas/MirStatement;", "terminatorComment", "terminator", "Lorg/rust/lang/core/mir/schemas/MirTerminator;", "intellij.rustrover.core"})
    public static interface CommentSupplier {
        @Nullable
        default public String varDebugInfoComment(@NotNull MirVarDebugInfo varDebugInfo) {
            Intrinsics.checkNotNullParameter((Object)varDebugInfo, (String)"varDebugInfo");
            return null;
        }

        @Nullable
        default public String localComment(@NotNull MirLocal local) {
            Intrinsics.checkNotNullParameter((Object)local, (String)"local");
            return null;
        }

        @Nullable
        default public String blockStartComment(@NotNull MirBasicBlock block) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            return null;
        }

        @Nullable
        default public String blockEndComment(@NotNull MirBasicBlock block) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            return null;
        }

        @Nullable
        default public String statementComment(@NotNull MirStatement stmt) {
            Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
            return null;
        }

        @Nullable
        default public String terminatorComment(@NotNull MirTerminator<?> terminator) {
            Intrinsics.checkNotNullParameter(terminator, (String)"terminator");
            return null;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001a\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0007H\u0002J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/rust/lang/core/mir/MirPrettyPrinter$Companion;", "", "<init>", "()V", "INDENT", "", "ALIGN", "", "createComment", "filenamePrefix", "source", "Lorg/rust/lang/core/mir/schemas/MirSourceInfo;", "getLocationRange", "Lorg/rust/lang/core/mir/MirPrettyPrinter$LocationRange;", "filePrefix", "span", "Lorg/rust/lang/core/mir/schemas/MirSpan$PsiSpan;", "getStartLocation", "Lorg/rust/lang/core/mir/MirPrettyPrinter$Location;", "element", "Lcom/intellij/psi/PsiElement;", "shift", "getEndLocation", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final String createComment(String filenamePrefix, MirSourceInfo source) {
            String string;
            int scope = source.getScope().getIndex();
            String scopeAt = "scope " + scope + " at";
            MirSpan span = source.getSpan();
            if (span instanceof MirSpan.PsiSpan) {
                PsiElement ref = ((MirSpan.PsiSpan)span).getReference();
                LocationRange location = this.getLocationRange(filenamePrefix, (MirSpan.PsiSpan)span);
                MirSpan.PsiSpan psiSpan = (MirSpan.PsiSpan)span;
                if (psiSpan instanceof MirSpan.Full) {
                    LocationRange locationRange;
                    if (ref instanceof RsSelfParameter && ((RsSelfParameter)ref).getColon() != null) {
                        String string2 = location.getFileName();
                        Location location2 = location.getStart();
                        PsiElement psiElement2 = ((RsSelfParameter)ref).getSelf();
                        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getSelf(...)");
                        locationRange = new LocationRange(string2, location2, this.getEndLocation(psiElement2));
                    } else {
                        locationRange = location;
                    }
                    LocationRange adjustedLocation = locationRange;
                    string = scopeAt + " " + adjustedLocation;
                    return string;
                } else if (psiSpan instanceof MirSpan.EndPoint) {
                    string = scopeAt + " " + new LocationRange(location.getFileName(), location.getEnd().getPrevious(), location.getEnd());
                    return string;
                } else if (psiSpan instanceof MirSpan.End) {
                    string = scopeAt + " " + new LocationRange(location.getFileName(), location.getEnd(), location.getEnd());
                    return string;
                } else if (psiSpan instanceof MirSpan.Start) {
                    string = scopeAt + " " + new LocationRange(location.getFileName(), location.getStart(), location.getStart());
                    return string;
                } else {
                    if (!(psiSpan instanceof MirSpan.FormatArgument)) throw new NoWhenBranchMatchedException();
                    string = scopeAt + " " + new LocationRange(location.getFileName(), location.getStart(), location.getEnd());
                }
                return string;
            } else {
                if (!Intrinsics.areEqual((Object)span, (Object)MirSpan.Fake.INSTANCE)) throw new NoWhenBranchMatchedException();
                string = scopeAt + " no-location";
            }
            return string;
        }

        private final LocationRange getLocationRange(String filePrefix, MirSpan.PsiSpan span) {
            String string = span.getReference().getContainingFile().getOriginalFile().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String fileName = string;
            if (!(span instanceof MirSpan.FormatArgument)) {
                return new LocationRange(filePrefix + fileName, org.rust.lang.core.mir.MirPrettyPrinter$Companion.getStartLocation$default(this, span.getReference(), 0, 2, null), this.getEndLocation(span.getReference()));
            }
            return new LocationRange(filePrefix + fileName, this.getStartLocation(((MirSpan.FormatArgument)span).getReference(), ((MirSpan.FormatArgument)span).getRangeInElement().getStartOffset()), this.getStartLocation(((MirSpan.FormatArgument)span).getReference(), ((MirSpan.FormatArgument)span).getRangeInElement().getEndOffset()));
        }

        private final Location getStartLocation(PsiElement element, int shift) {
            int startOffset = PsiElementKt.getStartOffset(element) + shift;
            PsiFile psiFile = element.getContainingFile().getOriginalFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getOriginalFile(...)");
            Document document = org.rust.openapiext.UtilsKt.getDocument(psiFile);
            Integer n = document != null ? Integer.valueOf(document.getLineNumber(startOffset)) : null;
            Intrinsics.checkNotNull((Object)n);
            int startLine = n;
            PsiFile psiFile2 = element.getContainingFile().getOriginalFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getOriginalFile(...)");
            Document document2 = org.rust.openapiext.UtilsKt.getDocument(psiFile2);
            Integer n2 = document2 != null ? Integer.valueOf(document2.getLineStartOffset(startLine)) : null;
            Intrinsics.checkNotNull((Object)n2);
            int startLineOffset = startOffset - n2;
            return new Location(startLine, startLineOffset);
        }

        static /* synthetic */ Location getStartLocation$default(Companion companion, PsiElement psiElement2, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 0;
            }
            return companion.getStartLocation(psiElement2, n);
        }

        private final Location getEndLocation(PsiElement element) {
            int endOffset = PsiElementKt.getEndOffset(element);
            PsiFile psiFile = element.getContainingFile().getOriginalFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getOriginalFile(...)");
            Document document = org.rust.openapiext.UtilsKt.getDocument(psiFile);
            Integer n = document != null ? Integer.valueOf(document.getLineNumber(endOffset)) : null;
            Intrinsics.checkNotNull((Object)n);
            int endLine = n;
            PsiFile psiFile2 = element.getContainingFile().getOriginalFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getOriginalFile(...)");
            Document document2 = org.rust.openapiext.UtilsKt.getDocument(psiFile2);
            Integer n2 = document2 != null ? Integer.valueOf(document2.getLineStartOffset(endLine)) : null;
            Intrinsics.checkNotNull((Object)n2);
            int endLineOffset = endOffset - n2;
            return new Location(endLine, endLineOffset);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0016J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\n\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lorg/rust/lang/core/mir/MirPrettyPrinter$Location;", "", "line", "", "lineOffset", "<init>", "(II)V", "getLine", "()I", "getLineOffset", "previous", "getPrevious", "()Lorg/rust/lang/core/mir/MirPrettyPrinter$Location;", "toString", "", "component1", "component2", "copy", "equals", "", "other", "hashCode", "intellij.rustrover.core"})
    @SourceDebugExtension(value={"SMAP\nMirPrettyPrinter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MirPrettyPrinter.kt\norg/rust/lang/core/mir/MirPrettyPrinter$Location\n+ 2 utils.kt\norg/rust/openapiext/UtilsKt\n*L\n1#1,782:1\n318#2,10:783\n*S KotlinDebug\n*F\n+ 1 MirPrettyPrinter.kt\norg/rust/lang/core/mir/MirPrettyPrinter$Location\n*L\n709#1:783,10\n*E\n"})
    private static final class Location {
        private final int line;
        private final int lineOffset;

        public Location(int line, int lineOffset) {
            this.line = line;
            this.lineOffset = lineOffset;
            boolean $i$f$weakAssert = false;
            boolean $i$f$weakAssert2 = false;
            if (org.rust.openapiext.UtilsKt.isUnitTestMode() || org.rust.openapiext.UtilsKt.isInternal()) {
                boolean bl = false;
                if (!(this.lineOffset >= 0)) {
                    boolean bl2 = false;
                    String message$iv$iv = "Assertion failed";
                    throw new AssertionError((Object)message$iv$iv);
                }
            }
        }

        public final int getLine() {
            return this.line;
        }

        public final int getLineOffset() {
            return this.lineOffset;
        }

        @NotNull
        public final Location getPrevious() {
            return new Location(this.line, this.lineOffset - 1);
        }

        @NotNull
        public String toString() {
            return this.line + 1 + ":" + (this.lineOffset + 1);
        }

        public final int component1() {
            return this.line;
        }

        public final int component2() {
            return this.lineOffset;
        }

        @NotNull
        public final Location copy(int line, int lineOffset) {
            return new Location(line, lineOffset);
        }

        public static /* synthetic */ Location copy$default(Location location, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = location.line;
            }
            if ((n3 & 2) != 0) {
                n2 = location.lineOffset;
            }
            return location.copy(n, n2);
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.line);
            result2 = result2 * 31 + Integer.hashCode(this.lineOffset);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Location)) {
                return false;
            }
            Location location = (Location)other;
            if (this.line != location.line) {
                return false;
            }
            return this.lineOffset == location.lineOffset;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000e\u001a\u00020\u0003H\u0016J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0018"}, d2={"Lorg/rust/lang/core/mir/MirPrettyPrinter$LocationRange;", "", "fileName", "", "start", "Lorg/rust/lang/core/mir/MirPrettyPrinter$Location;", "end", "<init>", "(Ljava/lang/String;Lorg/rust/lang/core/mir/MirPrettyPrinter$Location;Lorg/rust/lang/core/mir/MirPrettyPrinter$Location;)V", "getFileName", "()Ljava/lang/String;", "getStart", "()Lorg/rust/lang/core/mir/MirPrettyPrinter$Location;", "getEnd", "toString", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "intellij.rustrover.core"})
    private static final class LocationRange {
        @NotNull
        private final String fileName;
        @NotNull
        private final Location start;
        @NotNull
        private final Location end;

        public LocationRange(@NotNull String fileName, @NotNull Location start2, @NotNull Location end) {
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
            Intrinsics.checkNotNullParameter((Object)end, (String)"end");
            this.fileName = fileName;
            this.start = start2;
            this.end = end;
        }

        @NotNull
        public final String getFileName() {
            return this.fileName;
        }

        @NotNull
        public final Location getStart() {
            return this.start;
        }

        @NotNull
        public final Location getEnd() {
            return this.end;
        }

        @NotNull
        public String toString() {
            return this.fileName + ":" + this.start + ": " + this.end;
        }

        @NotNull
        public final String component1() {
            return this.fileName;
        }

        @NotNull
        public final Location component2() {
            return this.start;
        }

        @NotNull
        public final Location component3() {
            return this.end;
        }

        @NotNull
        public final LocationRange copy(@NotNull String fileName, @NotNull Location start2, @NotNull Location end) {
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
            Intrinsics.checkNotNullParameter((Object)end, (String)"end");
            return new LocationRange(fileName, start2, end);
        }

        public static /* synthetic */ LocationRange copy$default(LocationRange locationRange, String string, Location location, Location location2, int n, Object object) {
            if ((n & 1) != 0) {
                string = locationRange.fileName;
            }
            if ((n & 2) != 0) {
                location = locationRange.start;
            }
            if ((n & 4) != 0) {
                location2 = locationRange.end;
            }
            return locationRange.copy(string, location, location2);
        }

        public int hashCode() {
            int result2 = this.fileName.hashCode();
            result2 = result2 * 31 + this.start.hashCode();
            result2 = result2 * 31 + this.end.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LocationRange)) {
                return false;
            }
            LocationRange locationRange = (LocationRange)other;
            if (!Intrinsics.areEqual((Object)this.fileName, (Object)locationRange.fileName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.start, (Object)locationRange.start)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.end, (Object)locationRange.end);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/rust/lang/core/mir/MirPrettyPrinter$NoCommentSupplier;", "Lorg/rust/lang/core/mir/MirPrettyPrinter$CommentSupplier;", "<init>", "()V", "intellij.rustrover.core"})
    public static final class NoCommentSupplier
    implements CommentSupplier {
        @NotNull
        public static final NoCommentSupplier INSTANCE = new NoCommentSupplier();

        private NoCommentSupplier() {
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0014\u0010\u000f\u001a\u00020\u00032\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/rust/lang/core/mir/MirPrettyPrinter$ScopeCommentSupplier;", "Lorg/rust/lang/core/mir/MirPrettyPrinter$CommentSupplier;", "filenamePrefix", "", "<init>", "(Ljava/lang/String;)V", "varDebugInfoComment", "varDebugInfo", "Lorg/rust/lang/core/mir/schemas/MirVarDebugInfo;", "localComment", "local", "Lorg/rust/lang/core/mir/schemas/MirLocal;", "statementComment", "stmt", "Lorg/rust/lang/core/mir/schemas/MirStatement;", "terminatorComment", "terminator", "Lorg/rust/lang/core/mir/schemas/MirTerminator;", "intellij.rustrover.core"})
    public static final class ScopeCommentSupplier
    implements CommentSupplier {
        @NotNull
        private final String filenamePrefix;

        public ScopeCommentSupplier(@NotNull String filenamePrefix) {
            Intrinsics.checkNotNullParameter((Object)filenamePrefix, (String)"filenamePrefix");
            this.filenamePrefix = filenamePrefix;
        }

        @Override
        @NotNull
        public String varDebugInfoComment(@NotNull MirVarDebugInfo varDebugInfo) {
            Intrinsics.checkNotNullParameter((Object)varDebugInfo, (String)"varDebugInfo");
            return "in " + Companion.createComment(this.filenamePrefix, varDebugInfo.getSource());
        }

        @Override
        @NotNull
        public String localComment(@NotNull MirLocal local) {
            Intrinsics.checkNotNullParameter((Object)local, (String)"local");
            String localName = local.getIndex() == 0 ? " return place" : "";
            String comment = Companion.createComment(this.filenamePrefix, local.getSource());
            return " //" + localName + " in " + comment;
        }

        @Override
        @NotNull
        public String statementComment(@NotNull MirStatement stmt) {
            Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
            return Companion.createComment(this.filenamePrefix, stmt.getSource());
        }

        @Override
        @NotNull
        public String terminatorComment(@NotNull MirTerminator<?> terminator) {
            Intrinsics.checkNotNullParameter(terminator, (String)"terminator");
            return Companion.createComment(this.filenamePrefix, terminator.getSource());
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Mutability.values().length];
            try {
                nArray[Mutability.MUTABLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Mutability.IMMUTABLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

