/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.macros.tt;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.rust.lang.core.macros.tt.TokenId;
import org.rust.lang.core.macros.tt.TokenTree;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a \u0010\u0003\u001a\u00020\u0004*\u00020\u00022\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a \u0010\n\u001a\u00020\u0004*\u00020\u000b2\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0018\u0010\f\u001a\u00020\u0004*\u00020\r2\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007H\u0002\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u000fH\u0002*\n\u0010\u000e\"\u00020\t2\u00020\t\u00a8\u0006\u0010"}, d2={"toDebugString", "", "Lorg/rust/lang/core/macros/tt/TokenTree;", "debugPrintTokenTree", "", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "level", "", "debugPrintSubtree", "Lorg/rust/lang/core/macros/tt/TokenTree$Subtree;", "debugPrintLeaf", "Lorg/rust/lang/core/macros/tt/TokenTree$Leaf;", "RawTokenId", "Lorg/rust/lang/core/macros/tt/TokenId;", "intellij.rustrover.core"})
public final class TokenTreeKt {
    @NotNull
    public static final String toDebugString(@NotNull TokenTree $this$toDebugString) {
        Intrinsics.checkNotNullParameter((Object)$this$toDebugString, (String)"<this>");
        StringBuilder sb = new StringBuilder();
        TokenTreeKt.debugPrintTokenTree($this$toDebugString, sb, 0);
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final void debugPrintTokenTree(TokenTree $this$debugPrintTokenTree, StringBuilder sb, int level) {
        sb.append(StringsKt.repeat((CharSequence)"  ", (int)level));
        TokenTree tokenTree = $this$debugPrintTokenTree;
        if (tokenTree instanceof TokenTree.Leaf) {
            TokenTreeKt.debugPrintLeaf((TokenTree.Leaf)$this$debugPrintTokenTree, sb);
        } else if (tokenTree instanceof TokenTree.Subtree) {
            TokenTreeKt.debugPrintSubtree((TokenTree.Subtree)$this$debugPrintTokenTree, sb, level);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private static final void debugPrintSubtree(TokenTree.Subtree $this$debugPrintSubtree, StringBuilder sb, int level) {
        String aux = $this$debugPrintSubtree.getDelimiter() == null ? "$" : $this$debugPrintSubtree.getDelimiter().getKind().getOpenText() + $this$debugPrintSubtree.getDelimiter().getKind().getCloseText() + " " + TokenTreeKt.toDebugString($this$debugPrintSubtree.getDelimiter().getId());
        sb.append("SUBTREE " + aux);
        for (TokenTree tokenTree : $this$debugPrintSubtree.getTokenTrees()) {
            sb.append("\n");
            TokenTreeKt.debugPrintTokenTree(tokenTree, sb, level + 1);
        }
    }

    private static final void debugPrintLeaf(TokenTree.Leaf $this$debugPrintLeaf, StringBuilder sb) {
        TokenTree.Leaf leaf = $this$debugPrintLeaf;
        if (leaf instanceof TokenTree.Leaf.Literal) {
            v0 = sb.append("LITERAL " + ((TokenTree.Leaf.Literal)$this$debugPrintLeaf).getText() + " " + TokenTreeKt.toDebugString(((TokenTree.Leaf.Literal)$this$debugPrintLeaf).getId()));
        } else if (leaf instanceof TokenTree.Leaf.Punct) {
            String string = ((TokenTree.Leaf.Punct)$this$debugPrintLeaf).getChar();
            String string2 = ((TokenTree.Leaf.Punct)$this$debugPrintLeaf).getSpacing().toString().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            v0 = sb.append("PUNCT   " + string + " [" + string2 + "] " + TokenTreeKt.toDebugString(((TokenTree.Leaf.Punct)$this$debugPrintLeaf).getId()));
        } else if (leaf instanceof TokenTree.Leaf.Ident) {
            v0 = sb.append("IDENT   " + ((TokenTree.Leaf.Ident)$this$debugPrintLeaf).getText() + " " + TokenTreeKt.toDebugString(((TokenTree.Leaf.Ident)$this$debugPrintLeaf).getId()));
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private static final String toDebugString(TokenId $this$toDebugString) {
        String string;
        TokenId tokenId = $this$toDebugString;
        if (tokenId == TokenId.GlobalSpan.DefSite) {
            string = "DefSite";
        } else if (tokenId == TokenId.GlobalSpan.CallSite) {
            string = "CallSite";
        } else if (tokenId == TokenId.GlobalSpan.MixedSite) {
            string = "MixedSite";
        } else if (Intrinsics.areEqual((Object)tokenId, (Object)TokenId.None.INSTANCE)) {
            string = "-1";
        } else if (tokenId instanceof TokenId.SourceToken) {
            string = String.valueOf(((TokenId.SourceToken)$this$toDebugString).getRawId());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }
}

