/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.macros.tt;

import com.intellij.util.SmartList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.rust.lang.core.macros.ExpansionTextRange;
import org.rust.lang.core.macros.ExpansionTransparency;
import org.rust.lang.core.macros.MacroProducedTextRange;
import org.rust.lang.core.macros.MappedTextRange;
import org.rust.lang.core.macros.RangeMap;
import org.rust.lang.core.macros.RangeMapKt;
import org.rust.lang.core.macros.tt.Delimiter;
import org.rust.lang.core.macros.tt.MappedSubtreeKt;
import org.rust.lang.core.macros.tt.Spacing;
import org.rust.lang.core.macros.tt.TokenId;
import org.rust.lang.core.macros.tt.TokenMap;
import org.rust.lang.core.macros.tt.TokenMetadata;
import org.rust.lang.core.macros.tt.TokenTree;
import org.rust.lang.core.psi.MacroBraces;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001 B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fJ\u0016\u0010\u0012\u001a\u00020\u0013*\u00020\u00032\b\b\u0002\u0010\u0014\u001a\u00020\u0015H\u0002J\u001e\u0010\u0016\u001a\u00020\u0013*\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u0015H\u0002J\u0018\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00060\tj\u0002`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/rust/lang/core/macros/tt/SubtreeTextBuilder;", "", "subtree", "Lorg/rust/lang/core/macros/tt/TokenTree$Subtree;", "tokenMap", "Lorg/rust/lang/core/macros/tt/TokenMap;", "<init>", "(Lorg/rust/lang/core/macros/tt/TokenTree$Subtree;Lorg/rust/lang/core/macros/tt/TokenMap;)V", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "ranges", "Lcom/intellij/util/SmartList;", "Lorg/rust/lang/core/macros/ExpansionTextRange;", "toText", "Lkotlin/Pair;", "", "Lorg/rust/lang/core/macros/RangeMap;", "appendSubtree", "", "isRootSubtree", "", "appendLeaf", "Lorg/rust/lang/core/macros/tt/TokenTree$Leaf;", "nextTokenTree", "Lorg/rust/lang/core/macros/tt/TokenTree;", "hasDelimiter", "appendDelimiterPart", "delimiter", "Lorg/rust/lang/core/macros/tt/Delimiter;", "part", "Lorg/rust/lang/core/macros/tt/SubtreeTextBuilder$DelimiterBracePart;", "DelimiterBracePart", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nMappedSubtree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MappedSubtree.kt\norg/rust/lang/core/macros/tt/SubtreeTextBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,199:1\n1#2:200\n*E\n"})
final class SubtreeTextBuilder {
    @NotNull
    private final TokenTree.Subtree subtree;
    @NotNull
    private final TokenMap tokenMap;
    @NotNull
    private final StringBuilder sb;
    @NotNull
    private final SmartList<ExpansionTextRange<?>> ranges;

    public SubtreeTextBuilder(@NotNull TokenTree.Subtree subtree, @NotNull TokenMap tokenMap) {
        Intrinsics.checkNotNullParameter((Object)subtree, (String)"subtree");
        Intrinsics.checkNotNullParameter((Object)tokenMap, (String)"tokenMap");
        this.subtree = subtree;
        this.tokenMap = tokenMap;
        this.sb = new StringBuilder();
        this.ranges = new SmartList();
    }

    @NotNull
    public final Pair<CharSequence, RangeMap> toText() {
        this.appendSubtree(this.subtree, true);
        return TuplesKt.to((Object)this.sb, (Object)new RangeMap(this.ranges));
    }

    private final void appendSubtree(TokenTree.Subtree $this$appendSubtree, boolean isRootSubtree) {
        block4: {
            Delimiter it2;
            Delimiter delimiter = $this$appendSubtree.getDelimiter();
            if (delimiter != null) {
                it2 = delimiter;
                boolean bl = false;
                this.appendDelimiterPart(it2, DelimiterBracePart.OPEN);
            }
            for (Pair pair : org.rust.stdext.CollectionsKt.withNext(CollectionsKt.asSequence((Iterable)$this$appendSubtree.getTokenTrees()))) {
                TokenTree tokenTree = (TokenTree)pair.component1();
                TokenTree nextTokenTree = (TokenTree)pair.component2();
                TokenTree tokenTree2 = tokenTree;
                if (tokenTree2 instanceof TokenTree.Leaf) {
                    this.appendLeaf((TokenTree.Leaf)tokenTree, nextTokenTree, isRootSubtree || $this$appendSubtree.getDelimiter() != null);
                    continue;
                }
                if (tokenTree2 instanceof TokenTree.Subtree) {
                    SubtreeTextBuilder.appendSubtree$default(this, (TokenTree.Subtree)tokenTree, false, 1, null);
                    continue;
                }
                throw new NoWhenBranchMatchedException();
            }
            Delimiter delimiter2 = $this$appendSubtree.getDelimiter();
            if (delimiter2 == null) break block4;
            it2 = delimiter2;
            boolean bl = false;
            this.appendDelimiterPart(it2, DelimiterBracePart.CLOSE);
        }
    }

    static /* synthetic */ void appendSubtree$default(SubtreeTextBuilder subtreeTextBuilder, TokenTree.Subtree subtree, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        subtreeTextBuilder.appendSubtree(subtree, bl);
    }

    private final void appendLeaf(TokenTree.Leaf $this$appendLeaf, TokenTree nextTokenTree, boolean hasDelimiter) {
        TokenMetadata.Token meta;
        TokenMetadata.Token potentialToken;
        Pair pair;
        TokenTree.Leaf leaf = $this$appendLeaf;
        if (leaf instanceof TokenTree.Leaf.Literal) {
            pair = TuplesKt.to((Object)((TokenTree.Leaf.Literal)$this$appendLeaf).getText(), (Object)((Object)Spacing.Alone));
        } else if (leaf instanceof TokenTree.Leaf.Ident) {
            pair = TuplesKt.to((Object)((TokenTree.Leaf.Ident)$this$appendLeaf).getText(), (Object)((Object)Spacing.Alone));
        } else if (leaf instanceof TokenTree.Leaf.Punct) {
            pair = TuplesKt.to((Object)((TokenTree.Leaf.Punct)$this$appendLeaf).getChar(), (Object)((Object)((TokenTree.Leaf.Punct)$this$appendLeaf).getSpacing()));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Pair pair2 = pair;
        String text = (String)pair2.component1();
        Spacing spacing = (Spacing)((Object)pair2.component2());
        TokenId id = $this$appendLeaf.getId();
        TokenMetadata tokenMetadata = this.tokenMap.get(id);
        TokenMetadata.Token token = potentialToken = tokenMetadata instanceof TokenMetadata.Token ? (TokenMetadata.Token)tokenMetadata : null;
        if (potentialToken != null) {
            TokenMetadata.Token token2;
            TokenMetadata.Token it2 = token2 = potentialToken;
            boolean bl = false;
            v2 = it2.getOrigin().correspondsTo($this$appendLeaf) ? token2 : null;
        } else {
            v2 = meta = null;
        }
        if (meta != null) {
            RangeMapKt.mergeAdd((List)this.ranges, new MappedTextRange(meta.getStartOffset(), this.sb.length(), text.length() + meta.getRightTrivia().length()));
        } else if (id instanceof TokenId.GlobalSpan) {
            RangeMapKt.mergeAdd((List)this.ranges, new MacroProducedTextRange(MappedSubtreeKt.access$asTransparency((TokenId.GlobalSpan)id), this.sb.length(), text.length() + (spacing == Spacing.Alone ? 1 : 0)));
        } else if (potentialToken != null) {
            RangeMapKt.mergeAdd((List)this.ranges, new MacroProducedTextRange(new ExpansionTransparency.DelegatedTo(potentialToken.getStartOffset()), this.sb.length(), text.length() + (spacing == Spacing.Alone ? 1 : 0)));
        }
        this.sb.append(text);
        if (meta != null) {
            boolean bl;
            this.sb.append(meta.getRightTrivia());
            TokenTree tokenTree = nextTokenTree;
            if (tokenTree instanceof TokenTree.Leaf) {
                TokenId.SourceToken sourceToken = id instanceof TokenId.SourceToken ? (TokenId.SourceToken)id : null;
                bl = Intrinsics.areEqual((Object)(sourceToken != null ? sourceToken.next() : null), (Object)((TokenTree.Leaf)nextTokenTree).getId());
            } else if (tokenTree instanceof TokenTree.Subtree) {
                bl = true;
            } else if (tokenTree == null) {
                bl = hasDelimiter;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            boolean canOmitSpace = bl;
            if (meta.getRightTrivia().length() == 0 && spacing == Spacing.Alone && !canOmitSpace) {
                this.sb.append(" ");
            }
        } else if (spacing == Spacing.Alone) {
            this.sb.append(" ");
        }
    }

    private final void appendDelimiterPart(Delimiter delimiter, DelimiterBracePart part) {
        TokenMetadata.Delimiter.DelimiterPart meta;
        TokenMetadata tokenMetadata = this.tokenMap.get(delimiter.getId());
        TokenMetadata.Delimiter delimiter2 = tokenMetadata instanceof TokenMetadata.Delimiter ? (TokenMetadata.Delimiter)tokenMetadata : null;
        if (delimiter2 != null) {
            TokenMetadata.Delimiter it2 = delimiter2;
            boolean bl = false;
            v1 = (TokenMetadata.Delimiter.DelimiterPart)part.getMetaGetter().invoke((Object)it2);
        } else {
            v1 = meta = null;
        }
        if (meta != null) {
            RangeMapKt.mergeAdd((List)this.ranges, new MappedTextRange(meta.getStartOffset(), this.sb.length(), 1 + meta.getRightTrivia().length()));
        }
        this.sb.append((String)part.getTextGetter().invoke((Object)delimiter.getKind()));
        if (meta != null) {
            this.sb.append(meta.getRightTrivia());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B3\b\u0002\u0012\u0014\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\u0004\b\t\u0010\nR\u001f\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fj\u0002\b\u000ej\u0002\b\u000f\u00a8\u0006\u0010"}, d2={"Lorg/rust/lang/core/macros/tt/SubtreeTextBuilder$DelimiterBracePart;", "", "metaGetter", "Lkotlin/Function1;", "Lorg/rust/lang/core/macros/tt/TokenMetadata$Delimiter;", "Lorg/rust/lang/core/macros/tt/TokenMetadata$Delimiter$DelimiterPart;", "textGetter", "Lorg/rust/lang/core/psi/MacroBraces;", "", "<init>", "(Ljava/lang/String;ILkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "getMetaGetter", "()Lkotlin/jvm/functions/Function1;", "getTextGetter", "OPEN", "CLOSE", "intellij.rustrover.core"})
    private static final class DelimiterBracePart
    extends Enum<DelimiterBracePart> {
        @NotNull
        private final Function1<TokenMetadata.Delimiter, TokenMetadata.Delimiter.DelimiterPart> metaGetter;
        @NotNull
        private final Function1<MacroBraces, String> textGetter;
        public static final /* enum */ DelimiterBracePart OPEN = new DelimiterBracePart((Function1<? super TokenMetadata.Delimiter, TokenMetadata.Delimiter.DelimiterPart>)((Function1)1.INSTANCE), (Function1<? super MacroBraces, String>)((Function1)2.INSTANCE));
        public static final /* enum */ DelimiterBracePart CLOSE = new DelimiterBracePart((Function1<? super TokenMetadata.Delimiter, TokenMetadata.Delimiter.DelimiterPart>)((Function1)3.INSTANCE), (Function1<? super MacroBraces, String>)((Function1)4.INSTANCE));
        private static final /* synthetic */ DelimiterBracePart[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private DelimiterBracePart(Function1<? super TokenMetadata.Delimiter, TokenMetadata.Delimiter.DelimiterPart> metaGetter, Function1<? super MacroBraces, String> textGetter) {
            this.metaGetter = metaGetter;
            this.textGetter = textGetter;
        }

        @NotNull
        public final Function1<TokenMetadata.Delimiter, TokenMetadata.Delimiter.DelimiterPart> getMetaGetter() {
            return this.metaGetter;
        }

        @NotNull
        public final Function1<MacroBraces, String> getTextGetter() {
            return this.textGetter;
        }

        public static DelimiterBracePart[] values() {
            return (DelimiterBracePart[])$VALUES.clone();
        }

        public static DelimiterBracePart valueOf(String value) {
            return Enum.valueOf(DelimiterBracePart.class, value);
        }

        @NotNull
        public static EnumEntries<DelimiterBracePart> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = delimiterBracePartArray = new DelimiterBracePart[]{DelimiterBracePart.OPEN, DelimiterBracePart.CLOSE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

