/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.macros.tt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.rust.lang.core.macros.tt.Delimiter;
import org.rust.lang.core.macros.tt.TokenId;
import org.rust.lang.core.macros.tt.TokenMap;
import org.rust.lang.core.macros.tt.TokenMetadata;
import org.rust.lang.core.macros.tt.TokenTree;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\n\u001a\u00020\u0003J\f\u0010\u000b\u001a\u00020\u0003*\u00020\u0003H\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/rust/lang/core/macros/tt/SubtreeIdRecovery;", "", "subtree", "Lorg/rust/lang/core/macros/tt/TokenTree$Subtree;", "tokenMap", "Lorg/rust/lang/core/macros/tt/TokenMap;", "<init>", "(Lorg/rust/lang/core/macros/tt/TokenTree$Subtree;Lorg/rust/lang/core/macros/tt/TokenMap;)V", "previousLeafId", "Lorg/rust/lang/core/macros/tt/TokenId;", "recover", "processSubtree", "processLeaf", "Lorg/rust/lang/core/macros/tt/TokenTree$Leaf;", "leaf", "Lorg/rust/lang/core/macros/tt/TokenTree$Leaf$Punct;", "processDelimiter", "Lorg/rust/lang/core/macros/tt/Delimiter;", "delimiter", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nMappedSubtree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MappedSubtree.kt\norg/rust/lang/core/macros/tt/SubtreeIdRecovery\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,199:1\n1#2:200\n1563#3:201\n1634#3,3:202\n*S KotlinDebug\n*F\n+ 1 MappedSubtree.kt\norg/rust/lang/core/macros/tt/SubtreeIdRecovery\n*L\n150#1:201\n150#1:202,3\n*E\n"})
final class SubtreeIdRecovery {
    @NotNull
    private final TokenTree.Subtree subtree;
    @NotNull
    private final TokenMap tokenMap;
    @NotNull
    private TokenId previousLeafId;

    public SubtreeIdRecovery(@NotNull TokenTree.Subtree subtree, @NotNull TokenMap tokenMap) {
        Intrinsics.checkNotNullParameter((Object)subtree, (String)"subtree");
        Intrinsics.checkNotNullParameter((Object)tokenMap, (String)"tokenMap");
        this.subtree = subtree;
        this.tokenMap = tokenMap;
        this.previousLeafId = TokenId.None.INSTANCE;
    }

    @NotNull
    public final TokenTree.Subtree recover() {
        return this.processSubtree(this.subtree);
    }

    /*
     * WARNING - void declaration
     */
    private final TokenTree.Subtree processSubtree(TokenTree.Subtree $this$processSubtree) {
        void $this$mapTo$iv$iv;
        Delimiter adjustedDelimiter;
        Delimiter delimiter = $this$processSubtree.getDelimiter();
        if (delimiter != null) {
            Delimiter it2 = delimiter;
            boolean bl = false;
            v1 = this.processDelimiter(it2);
        } else {
            v1 = adjustedDelimiter = null;
        }
        if (adjustedDelimiter != null) {
            this.previousLeafId = adjustedDelimiter.getId();
        }
        Iterable $this$map$iv = $this$processSubtree.getTokenTrees();
        boolean $i$f$map = false;
        Iterable bl = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            TokenTree tokenTree;
            void tokenTree2;
            TokenTree tokenTree3 = (TokenTree)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            void var13_14 = tokenTree2;
            if (var13_14 instanceof TokenTree.Leaf) {
                TokenTree.Leaf newLeaf = tokenTree2 instanceof TokenTree.Leaf.Punct ? this.processLeaf((TokenTree.Leaf.Punct)tokenTree2) : (TokenTree.Leaf)tokenTree2;
                this.previousLeafId = newLeaf.getId();
                tokenTree = newLeaf;
            } else if (var13_14 instanceof TokenTree.Subtree) {
                tokenTree = this.processSubtree((TokenTree.Subtree)tokenTree2);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            collection.add(tokenTree);
        }
        List adjustedTokenTrees = (List)destination$iv$iv;
        return new TokenTree.Subtree(adjustedDelimiter, adjustedTokenTrees);
    }

    private final TokenTree.Leaf processLeaf(TokenTree.Leaf.Punct leaf) {
        TokenId previousLeafId = this.previousLeafId;
        if (leaf.getId() instanceof TokenId.SourceToken || !(previousLeafId instanceof TokenId.SourceToken)) {
            return leaf;
        }
        TokenId.SourceToken recoveredId = ((TokenId.SourceToken)previousLeafId).next();
        TokenMetadata tokenMetadata = this.tokenMap.get(recoveredId);
        TokenMetadata.Token token = tokenMetadata instanceof TokenMetadata.Token ? (TokenMetadata.Token)tokenMetadata : null;
        if (token == null) {
            return leaf;
        }
        TokenMetadata.Token recoveredMeta = token;
        TokenTree.Leaf.Punct newLeaf = TokenTree.Leaf.Punct.copy$default(leaf, null, null, recoveredId, 3, null);
        if (!Intrinsics.areEqual((Object)newLeaf, (Object)recoveredMeta.getOrigin())) {
            return leaf;
        }
        return newLeaf;
    }

    private final Delimiter processDelimiter(Delimiter delimiter) {
        TokenId previousLeafId = this.previousLeafId;
        if (delimiter.getId() instanceof TokenId.SourceToken || !(previousLeafId instanceof TokenId.SourceToken)) {
            return delimiter;
        }
        TokenId.SourceToken recoveredId = ((TokenId.SourceToken)previousLeafId).next();
        TokenMetadata tokenMetadata = this.tokenMap.get(recoveredId);
        TokenMetadata.Delimiter delimiter2 = tokenMetadata instanceof TokenMetadata.Delimiter ? (TokenMetadata.Delimiter)tokenMetadata : null;
        if (delimiter2 == null) {
            return delimiter;
        }
        TokenMetadata.Delimiter recoveredMeta = delimiter2;
        if (delimiter.getKind() != recoveredMeta.getOriginKind()) {
            return delimiter;
        }
        return Delimiter.copy$default(delimiter, recoveredId, null, 2, null);
    }
}

