/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.macros.tt;

import com.google.common.primitives.Ints;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.rust.lang.core.macros.proc.ProcMacroExpanderVersion;
import org.rust.lang.core.macros.tt.Delimiter;
import org.rust.lang.core.macros.tt.FlatTreeBuilder;
import org.rust.lang.core.macros.tt.LitKind;
import org.rust.lang.core.macros.tt.Spacing;
import org.rust.lang.core.macros.tt.TokenIdProvider;
import org.rust.lang.core.macros.tt.TokenTree;
import org.rust.lang.core.psi.MacroBraces;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001c"}, d2={"Lorg/rust/lang/core/macros/tt/FlatTree;", "", "subtree", "Lit/unimi/dsi/fastutil/ints/IntArrayList;", "literal", "punct", "ident", "tokenTree", "text", "", "", "<init>", "(Lit/unimi/dsi/fastutil/ints/IntArrayList;Lit/unimi/dsi/fastutil/ints/IntArrayList;Lit/unimi/dsi/fastutil/ints/IntArrayList;Lit/unimi/dsi/fastutil/ints/IntArrayList;Lit/unimi/dsi/fastutil/ints/IntArrayList;Ljava/util/List;)V", "getSubtree", "()Lit/unimi/dsi/fastutil/ints/IntArrayList;", "getLiteral", "getPunct", "getIdent", "getTokenTree", "getText", "()Ljava/util/List;", "toTokenTree", "Lorg/rust/lang/core/macros/tt/TokenTree$Subtree;", "tokenIdProvider", "Lorg/rust/lang/core/macros/tt/TokenIdProvider;", "version", "Lorg/rust/lang/core/macros/proc/ProcMacroExpanderVersion;", "Companion", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nFlatTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlatTree.kt\norg/rust/lang/core/macros/tt/FlatTree\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,268:1\n1#2:269\n*E\n"})
public final class FlatTree {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IntArrayList subtree;
    @NotNull
    private final IntArrayList literal;
    @NotNull
    private final IntArrayList punct;
    @NotNull
    private final IntArrayList ident;
    @NotNull
    private final IntArrayList tokenTree;
    @NotNull
    private final List<String> text;

    public FlatTree(@NotNull IntArrayList subtree, @NotNull IntArrayList literal, @NotNull IntArrayList punct, @NotNull IntArrayList ident, @NotNull IntArrayList tokenTree, @NotNull List<String> text) {
        Intrinsics.checkNotNullParameter((Object)subtree, (String)"subtree");
        Intrinsics.checkNotNullParameter((Object)literal, (String)"literal");
        Intrinsics.checkNotNullParameter((Object)punct, (String)"punct");
        Intrinsics.checkNotNullParameter((Object)ident, (String)"ident");
        Intrinsics.checkNotNullParameter((Object)tokenTree, (String)"tokenTree");
        Intrinsics.checkNotNullParameter(text, (String)"text");
        this.subtree = subtree;
        this.literal = literal;
        this.punct = punct;
        this.ident = ident;
        this.tokenTree = tokenTree;
        this.text = text;
    }

    @NotNull
    public final IntArrayList getSubtree() {
        return this.subtree;
    }

    @NotNull
    public final IntArrayList getLiteral() {
        return this.literal;
    }

    @NotNull
    public final IntArrayList getPunct() {
        return this.punct;
    }

    @NotNull
    public final IntArrayList getIdent() {
        return this.ident;
    }

    @NotNull
    public final IntArrayList getTokenTree() {
        return this.tokenTree;
    }

    @NotNull
    public final List<String> getText() {
        return this.text;
    }

    @NotNull
    public final TokenTree.Subtree toTokenTree(@NotNull TokenIdProvider tokenIdProvider, @NotNull ProcMacroExpanderVersion version) {
        Intrinsics.checkNotNullParameter((Object)tokenIdProvider, (String)"tokenIdProvider");
        Intrinsics.checkNotNullParameter((Object)((Object)version), (String)"version");
        boolean encodeCloseSpan = version.compareTo((Enum)ProcMacroExpanderVersion.ENCODE_CLOSE_SPAN_VERSION) >= 0;
        int offset = encodeCloseSpan ? 1 : 0;
        int stepSize = encodeCloseSpan ? 5 : 4;
        List res2 = new ArrayList(this.subtree.size());
        int n = this.subtree.size();
        int n2 = 0;
        while (n2 < n) {
            int it2 = n2++;
            boolean bl = false;
            res2.add(null);
        }
        boolean extendedLeafData = version.compareTo((Enum)ProcMacroExpanderVersion.EXTENDED_LEAF_DATA) >= 0;
        int literalStep = extendedLeafData ? 4 : 2;
        int identStep = extendedLeafData ? 3 : 2;
        IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)this.subtree.size())), (int)stepSize);
        int n3 = intProgression.getFirst();
        int i2 = intProgression.getLast();
        int n4 = -intProgression.getStep();
        if (n4 > 0 && i2 <= n3 || n4 < 0 && n3 <= i2) {
            while (true) {
                Delimiter delimiter;
                int delimiterId = this.subtree.getInt(i2);
                int kind2 = this.subtree.getInt(i2 + offset + 1);
                int lo = this.subtree.getInt(i2 + offset + 2);
                int len = this.subtree.getInt(i2 + offset + 3);
                IntArrayList rawTokenTrees = this.tokenTree;
                ArrayList tokenTrees = new ArrayList(len - lo);
                for (int j = lo; j < len; ++j) {
                    int idxTag = rawTokenTrees.getInt(j);
                    int tag = idxTag & 3;
                    int idx = idxTag >> 2;
                    Collection collection = tokenTrees;
                    TokenTree tokenTree = switch (tag) {
                        case 0 -> {
                            Object v0 = res2.get(idx);
                            Intrinsics.checkNotNull(v0);
                            yield (TokenTree)v0;
                        }
                        case 1 -> {
                            Pair v5;
                            int index = idx * literalStep;
                            int tokenId = this.literal.getInt(index);
                            int text = this.literal.getInt(index + 1);
                            if (extendedLeafData) {
                                String v4;
                                byte[] var30_36;
                                Intrinsics.checkNotNullExpressionValue((Object)Ints.toByteArray((int)this.literal.getInt(index + 2)), (String)"toByteArray(...)");
                                byte thirdKindByte = var30_36[2];
                                byte fourthKindByte = var30_36[3];
                                LitKind v2 = switch (fourthKindByte) {
                                    case 0 -> LitKind.Err.INSTANCE;
                                    case 1 -> LitKind.Byte.INSTANCE;
                                    case 2 -> LitKind.Char.INSTANCE;
                                    case 3 -> LitKind.Integer.INSTANCE;
                                    case 4 -> LitKind.Float.INSTANCE;
                                    case 5 -> LitKind.Str.INSTANCE;
                                    case 6 -> new LitKind.StrRaw(thirdKindByte);
                                    case 7 -> LitKind.ByteStr.INSTANCE;
                                    case 8 -> new LitKind.ByteStrRaw(thirdKindByte);
                                    case 9 -> LitKind.CStr.INSTANCE;
                                    case 10 -> new LitKind.CStrRaw(thirdKindByte);
                                    default -> throw new IllegalStateException("Unsupported kind byte".toString());
                                };
                                LitKind kind = v2;
                                Integer var35_43 = this.literal.getInt(index + 3);
                                int it = ((Number)var35_43).intValue();
                                boolean $i$a$-takeIf-FlatTree$toTokenTree$suffix$1 = false;
                                Integer v3 = it != -1 ? var35_43 : null;
                                if (v3 != null) {
                                    it = ((Number)v3).intValue();
                                    boolean $i$a$-let-FlatTree$toTokenTree$suffix$2 = false;
                                    v4 = this.text.get(it);
                                } else {
                                    v4 = null;
                                }
                                String suffix = v4;
                                v5 = TuplesKt.to((Object)kind, suffix);
                            } else {
                                v5 = TuplesKt.to(null, null);
                            }
                            Pair var29_32 = v5;
                            LitKind kind = (LitKind)var29_32.component1();
                            String suffix = (String)var29_32.component2();
                            yield new TokenTree.Leaf.Literal(this.text.get(text), tokenIdProvider.fromRaw(tokenId), kind, suffix);
                        }
                        case 2 -> {
                            int index = idx * 3;
                            int tokenId = this.punct.getInt(index);
                            char chr = (char)this.punct.getInt(index + 1);
                            int spacing = this.punct.getInt(index + 2);
                            Spacing v6 = switch (spacing) {
                                case 0 -> Spacing.Alone;
                                case 1 -> Spacing.Joint;
                                default -> throw new IllegalStateException(("Unknown spacing " + spacing).toString());
                            };
                            Spacing spacing = v6;
                            yield new TokenTree.Leaf.Punct(String.valueOf(chr), spacing, tokenIdProvider.fromRaw(tokenId));
                        }
                        case 3 -> {
                            TokenTree.Leaf.Ident v7;
                            int index = idx * identStep;
                            int tokenId = this.ident.getInt(index);
                            int text = this.ident.getInt(index + 1);
                            if (extendedLeafData) {
                                boolean isRaw = this.ident.getInt(index + 2) == 1;
                                v7 = new TokenTree.Leaf.Ident(this.text.get(text), tokenIdProvider.fromRaw(tokenId), isRaw);
                            } else {
                                String ident = this.text.get(text);
                                v7 = new TokenTree.Leaf.Ident(StringsKt.removePrefix((String)ident, (CharSequence)"r#"), tokenIdProvider.fromRaw(tokenId), StringsKt.startsWith$default((String)ident, (String)"r#", (boolean)false, (int)2, null));
                            }
                            yield v7;
                        }
                        default -> throw new IllegalStateException(("bad tag " + tag).toString());
                    };
                    collection.add(tokenTree);
                }
                MacroBraces delimiterKind = switch (kind2) {
                    case 0 -> null;
                    case 1 -> MacroBraces.PARENS;
                    case 2 -> MacroBraces.BRACES;
                    case 3 -> MacroBraces.BRACKS;
                    default -> throw new IllegalStateException(("Unknown kind " + kind2).toString());
                };
                List list = res2;
                int n5 = i2 / stepSize;
                if (delimiterKind != null) {
                    int n6 = n5;
                    List list2 = list;
                    boolean bl = false;
                    Delimiter delimiter2 = new Delimiter(tokenIdProvider.fromRaw(delimiterId), delimiterKind);
                    list = list2;
                    n5 = n6;
                    delimiter = delimiter2;
                } else {
                    delimiter = null;
                }
                List list3 = tokenTrees;
                Delimiter delimiter3 = delimiter;
                list.set(n5, new TokenTree.Subtree(delimiter3, list3));
                if (i2 == n3) break;
                i2 += n4;
            }
        }
        Object e = res2.get(0);
        Intrinsics.checkNotNull(e);
        return (TokenTree.Subtree)e;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lorg/rust/lang/core/macros/tt/FlatTree$Companion;", "", "<init>", "()V", "fromSubtree", "Lorg/rust/lang/core/macros/tt/FlatTree;", "root", "Lorg/rust/lang/core/macros/tt/TokenTree$Subtree;", "tokenIdProvider", "Lorg/rust/lang/core/macros/tt/TokenIdProvider;", "version", "Lorg/rust/lang/core/macros/proc/ProcMacroExpanderVersion;", "intellij.rustrover.core"})
    @SourceDebugExtension(value={"SMAP\nFlatTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlatTree.kt\norg/rust/lang/core/macros/tt/FlatTree$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,268:1\n1#2:269\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FlatTree fromSubtree(@NotNull TokenTree.Subtree root, @NotNull TokenIdProvider tokenIdProvider, @NotNull ProcMacroExpanderVersion version) {
            FlatTreeBuilder flatTreeBuilder;
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)tokenIdProvider, (String)"tokenIdProvider");
            Intrinsics.checkNotNullParameter((Object)((Object)version), (String)"version");
            FlatTreeBuilder $this$fromSubtree_u24lambda_u240 = flatTreeBuilder = new FlatTreeBuilder(version.compareTo((Enum)ProcMacroExpanderVersion.ENCODE_CLOSE_SPAN_VERSION) >= 0, version.compareTo((Enum)ProcMacroExpanderVersion.EXTENDED_LEAF_DATA) >= 0, tokenIdProvider);
            boolean bl = false;
            $this$fromSubtree_u24lambda_u240.write(root);
            return flatTreeBuilder.toFlatTree();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

