/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.macros.proc;

import com.fasterxml.jackson.core.JacksonException;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Disposer;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.rust.cargo.toolchain.BacktraceMode;
import org.rust.cargo.toolchain.RsToolchainBase;
import org.rust.cargo.toolchain.wsl.RsWslToolchain;
import org.rust.lang.core.macros.MacroExpansionManagerKt;
import org.rust.lang.core.macros.proc.ProcMacroJsonParser;
import org.rust.lang.core.macros.proc.ProcessAbortedException;
import org.rust.lang.core.macros.proc.ProcessCreationException;
import org.rust.lang.core.macros.proc.Request;
import org.rust.lang.core.macros.proc.Response;
import org.rust.lang.core.resolve2.ResolveCommonThreadPool;
import org.rust.openapiext.UtilsKt;
import org.rust.stdext.ConcurrencyKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0006\b\u0002\u0018\u0000 ,2\u00020\u00012\u00020\u0002:\u0001,B\u0019\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u0019J\b\u0010$\u001a\u00020%H\u0016J\u0012\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020'H\u0002J\u0012\u0010)\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001d\u001a\u00020\u0012H\u0002J\b\u0010*\u001a\u00020%H\u0016J\b\u0010+\u001a\u00020%H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000f\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001f\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u0006-"}, d2={"Lorg/rust/lang/core/macros/proc/ProcMacroServerProcess;", "Ljava/lang/Runnable;", "Lcom/intellij/openapi/Disposable;", "process", "Ljava/lang/Process;", "isWsl", "", "<init>", "(Ljava/lang/Process;Z)V", "stdout", "Ljava/io/BufferedReader;", "stdin", "Ljava/io/Writer;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "requestQueue", "Ljava/util/concurrent/SynchronousQueue;", "Lkotlin/Pair;", "Lorg/rust/lang/core/macros/proc/Request;", "Ljava/util/concurrent/CompletableFuture;", "Lorg/rust/lang/core/macros/proc/Response;", "task", "Ljava/util/concurrent/Future;", "stderrDiscardingTask", "lastUsed", "", "isDisposed", "isFirstRequest", "send", "request", "timeout", "isValid", "()Z", "idleTime", "getIdleTime", "()J", "run", "", "tryRefineException", "", "e", "writeAndRead", "dispose", "killProcess", "Companion", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nProcMacroServerPool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProcMacroServerPool.kt\norg/rust/lang/core/macros/proc/ProcMacroServerProcess\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,439:1\n60#2,5:440\n*S KotlinDebug\n*F\n+ 1 ProcMacroServerPool.kt\norg/rust/lang/core/macros/proc/ProcMacroServerProcess\n*L\n376#1:440,5\n*E\n"})
final class ProcMacroServerProcess
implements Runnable,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Process process;
    private final boolean isWsl;
    @NotNull
    private final BufferedReader stdout;
    @NotNull
    private final Writer stdin;
    @NotNull
    private final ReentrantLock lock;
    @NotNull
    private final SynchronousQueue<Pair<Request, CompletableFuture<Response>>> requestQueue;
    @NotNull
    private final Future<?> task;
    @NotNull
    private final Future<?> stderrDiscardingTask;
    private volatile long lastUsed;
    private volatile boolean isDisposed;
    private boolean isFirstRequest;

    private ProcMacroServerProcess(Process process2, boolean isWsl) {
        this.process = process2;
        this.isWsl = isWsl;
        this.stdout = new BufferedReader(new InputStreamReader(this.process.getInputStream(), Charsets.UTF_8));
        this.stdin = new OutputStreamWriter(this.process.getOutputStream(), Charsets.UTF_8);
        this.lock = new ReentrantLock();
        this.requestQueue = new SynchronousQueue();
        Future<?> future = ProcessIOExecutorService.INSTANCE.submit(this);
        Intrinsics.checkNotNullExpressionValue(future, (String)"submit(...)");
        this.task = future;
        Future<?> future2 = ProcessIOExecutorService.INSTANCE.submit(() -> ProcMacroServerProcess.stderrDiscardingTask$lambda$0(this));
        Intrinsics.checkNotNullExpressionValue(future2, (String)"submit(...)");
        this.stderrDiscardingTask = future2;
        this.lastUsed = System.currentTimeMillis();
        this.isFirstRequest = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Response send(@NotNull Request request, long timeout) throws IOException, TimeoutException {
        Response response;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (!this.lock.tryLock()) {
            throw new IllegalStateException("`send` must not be called from multiple threads simultaneously".toString());
        }
        try {
            Response response2;
            CompletableFuture<Response> responseFuture2 = new CompletableFuture<Response>(){

                public Executor defaultExecutor() {
                    return ResolveCommonThreadPool.Companion.get();
                }
            };
            if (!this.requestQueue.offer((Pair<Request, CompletableFuture<Response>>)TuplesKt.to((Object)request, (Object)responseFuture2), timeout, TimeUnit.MILLISECONDS)) {
                throw new TimeoutException();
            }
            try {
                response2 = (Response)ConcurrencyKt.getWithCheckCanceled((Future)responseFuture2, timeout);
            }
            catch (ExecutionException e) {
                Throwable throwable = e.getCause();
                if (throwable == null) {
                    throwable = new IllegalStateException("Unexpected ExecutionException without a cause", e);
                }
                throw throwable;
            }
            catch (InterruptedException e) {
                throw new ProcessCanceledException((Throwable)e);
            }
            response = response2;
            Intrinsics.checkNotNull((Object)response);
        }
        catch (Throwable t) {
            Disposer.dispose((Disposable)this);
            throw t;
        }
        finally {
            this.lastUsed = System.currentTimeMillis();
            this.lock.unlock();
        }
        return response;
    }

    public final boolean isValid() {
        return !this.isDisposed && this.process.isAlive();
    }

    public final long getIdleTime() {
        return System.currentTimeMillis() - this.lastUsed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (!this.isDisposed) {
                Response response;
                CompletableFuture responder;
                block16: {
                    Pair<Request, CompletableFuture<Response>> pair;
                    try {
                        pair = this.requestQueue.take();
                    }
                    catch (InterruptedException interruptedException) {
                        if (!this.isDisposed) {
                            this.killProcess();
                        }
                        return;
                    }
                    Pair<Request, CompletableFuture<Response>> pair2 = pair;
                    Request request = (Request)pair2.component1();
                    responder = (CompletableFuture)pair2.component2();
                    try {
                        if (this.writeAndRead(request) != null) break block16;
                        return;
                    }
                    catch (Throwable e) {
                        Throwable throwable = this.tryRefineException(e);
                        if (throwable == null) {
                            throwable = e;
                        }
                        responder.completeExceptionally(throwable);
                        if (!this.isDisposed) {
                            this.killProcess();
                        }
                        return;
                    }
                }
                Response response2 = response;
                Response response3 = response2;
                this.isFirstRequest = false;
                responder.complete(response3);
            }
        }
        finally {
            if (!this.isDisposed) {
                this.killProcess();
            }
        }
    }

    private final Throwable tryRefineException(Throwable e) {
        boolean isEOF;
        if (this.isWsl && this.isFirstRequest && e instanceof IOException && Intrinsics.areEqual((Object)e.getMessage(), (Object)"The pipe is being closed")) {
            return new ProcessCreationException(e);
        }
        boolean bl = isEOF = e instanceof IOException && !(e instanceof JacksonException);
        if (isEOF && this.process.waitFor(UtilsKt.isUnitTestMode() ? 5000L : 100L, TimeUnit.MILLISECONDS)) {
            return new ProcessAbortedException(e, this.process.exitValue());
        }
        return null;
    }

    private final Response writeAndRead(Request request) throws IOException {
        String requestJson = ProcMacroJsonParser.INSTANCE.getJSON_MAPPER().writeValueAsString((Object)request);
        this.stdin.write(requestJson);
        this.stdin.write("\n");
        this.stdin.flush();
        while (!this.isDisposed) {
            Response response;
            String responseJson;
            if (this.stdout.readLine() == null) {
                throw new EOFException();
            }
            if (((CharSequence)responseJson).length() == 0 || !StringsKt.startsWith$default((String)responseJson, (String)"{", (boolean)false, (int)2, null)) continue;
            try {
                response = (Response)ProcMacroJsonParser.INSTANCE.getJSON_MAPPER().readValue(responseJson, Response.class);
            }
            catch (JacksonException e) {
                if (UtilsKt.isUnitTestMode()) continue;
                MacroExpansionManagerKt.MACRO_LOG.warn("Can't deserialize proc macro expander output line as json: `" + responseJson + "`", (Throwable)e);
                continue;
            }
            return response;
        }
        return null;
    }

    public void dispose() {
        this.isDisposed = true;
        this.task.cancel(true);
        this.stderrDiscardingTask.cancel(true);
        this.killProcess();
    }

    private final void killProcess() {
        Logger $this$debug_u24default$iv = MacroExpansionManagerKt.MACRO_LOG;
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Killing proc macro expander process (pid: " + this.process.pid() + ")", e$iv);
        }
        this.process.destroyForcibly();
    }

    private static final void stderrDiscardingTask$lambda$0(ProcMacroServerProcess this$0) {
        InputStream stderr = this$0.process.getErrorStream();
        byte[] buffer = new byte[2048];
        while (!this$0.isDisposed) {
            try {
                if (stderr.read(buffer) != -1) continue;
            }
            catch (InterruptedException interruptedException) {}
            break;
        }
    }

    public /* synthetic */ ProcMacroServerProcess(Process process2, boolean isWsl, DefaultConstructorMarker $constructor_marker) {
        this(process2, isWsl);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/rust/lang/core/macros/proc/ProcMacroServerProcess$Companion;", "", "<init>", "()V", "createAndRun", "Lorg/rust/lang/core/macros/proc/ProcMacroServerProcess;", "toolchain", "Lorg/rust/cargo/toolchain/RsToolchainBase;", "expanderExecutable", "Ljava/nio/file/Path;", "intellij.rustrover.core"})
    @SourceDebugExtension(value={"SMAP\nProcMacroServerPool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProcMacroServerPool.kt\norg/rust/lang/core/macros/proc/ProcMacroServerProcess$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,439:1\n60#2,5:440\n60#2,5:445\n*S KotlinDebug\n*F\n+ 1 ProcMacroServerPool.kt\norg/rust/lang/core/macros/proc/ProcMacroServerProcess$Companion\n*L\n383#1:440,5\n419#1:445,5\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ProcMacroServerProcess createAndRun(@NotNull RsToolchainBase toolchain2, @NotNull Path expanderExecutable) throws ProcessCreationException {
            Process process22;
            Logger logger;
            Intrinsics.checkNotNullParameter((Object)toolchain2, (String)"toolchain");
            Intrinsics.checkNotNullParameter((Object)expanderExecutable, (String)"expanderExecutable");
            Logger $this$debug_u24default$iv = MacroExpansionManagerKt.MACRO_LOG;
            Pair[] e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                logger = $this$debug_u24default$iv;
                boolean process22 = false;
                logger.debug("Starting proc macro expander process " + expanderExecutable, (Throwable)e$iv);
            }
            e$iv = new Pair[]{TuplesKt.to((Object)"INTELLIJ_RUST", (Object)"1"), TuplesKt.to((Object)"RA_DONT_COPY_PROC_MACRO_DLL", (Object)"1"), TuplesKt.to((Object)"RUST_ANALYZER_INTERNALS_DO_NOT_USE", (Object)"this is unstable")};
            Map env = MapsKt.mutableMapOf((Pair[])e$iv);
            if (StringsKt.endsWith$default((String)PathsKt.getName((Path)expanderExecutable), (String)".exe", (boolean)false, (int)2, null)) {
                Path bin;
                Path path = expanderExecutable.getParent();
                Path path2 = path != null && (path = path.getParent()) != null ? path.resolve("bin") : (bin = null);
                if (bin != null) {
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    if (Files.exists(bin, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                        String path3 = System.getenv("PATH");
                        env.put("PATH", bin + ";" + path3);
                    }
                }
            }
            Path path = expanderExecutable.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getParent(...)");
            EnvironmentVariablesData environmentVariablesData = EnvironmentVariablesData.create((Map)env, (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)environmentVariablesData, (String)"create(...)");
            GeneralCommandLine path3 = RsToolchainBase.createGeneralCommandLine$default(toolchain2, null, expanderExecutable, path, null, BacktraceMode.NO, environmentVariablesData, CollectionsKt.emptyList(), false, false, true, null, 1024, null).withRedirectErrorStream(false);
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"withRedirectErrorStream(...)");
            GeneralCommandLine commandLine = path3;
            try {
                process22 = commandLine.createProcess();
                Intrinsics.checkNotNull((Object)process22);
            }
            catch (com.intellij.execution.ExecutionException e) {
                throw new ProcessCreationException(e);
            }
            Process process3 = process22;
            Logger $this$debug_u24default$iv2 = MacroExpansionManagerKt.MACRO_LOG;
            Throwable e$iv2 = null;
            boolean $i$f$debug2 = false;
            if ($this$debug_u24default$iv2.isDebugEnabled()) {
                logger = $this$debug_u24default$iv2;
                boolean bl = false;
                logger.debug("Started proc macro expander process (pid: " + process3.pid() + ")", e$iv2);
            }
            return new ProcMacroServerProcess(process3, toolchain2 instanceof RsWslToolchain, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

