/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.macros.proc;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.TimeoutException;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.cargo.toolchain.RsToolchainBase;
import org.rust.cargo.toolchain.wsl.RsWslToolchain;
import org.rust.lang.core.macros.proc.Pool;
import org.rust.lang.core.macros.proc.ProcMacroExpanderVersion;
import org.rust.lang.core.macros.proc.ProcMacroServerProcess;
import org.rust.lang.core.macros.proc.ProcessCreationException;
import org.rust.lang.core.macros.proc.Request;
import org.rust.lang.core.macros.proc.RequestSendError;
import org.rust.lang.core.macros.proc.Response;
import org.rust.openapiext.RsPathManager;
import org.rust.stdext.RsResult;
import org.rust.stdext.SynchronizedCancellableLazyKt;
import org.rust.stdext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rJ\"\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u000f0\r2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ$\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u000f0\r2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R'\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001f"}, d2={"Lorg/rust/lang/core/macros/proc/ProcMacroServerPool;", "Lcom/intellij/openapi/Disposable;", "toolchain", "Lorg/rust/cargo/toolchain/RsToolchainBase;", "needsVersionCheck", "", "expanderExecutable", "Ljava/nio/file/Path;", "<init>", "(Lorg/rust/cargo/toolchain/RsToolchainBase;ZLjava/nio/file/Path;)V", "pool", "Lorg/rust/lang/core/macros/proc/Pool;", "expanderVersion", "Lorg/rust/stdext/RsResult;", "Lorg/rust/lang/core/macros/proc/ProcMacroExpanderVersion;", "Lorg/rust/lang/core/macros/proc/RequestSendError;", "getExpanderVersion", "()Lorg/rust/stdext/RsResult;", "expanderVersion$delegate", "Lkotlin/Lazy;", "requestExpanderVersion", "send", "Lorg/rust/lang/core/macros/proc/Response;", "request", "Lorg/rust/lang/core/macros/proc/Request;", "timeout", "", "sendInner", "dispose", "", "Companion", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nProcMacroServerPool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProcMacroServerPool.kt\norg/rust/lang/core/macros/proc/ProcMacroServerPool\n+ 2 RsResult.kt\norg/rust/stdext/RsResultKt\n*L\n1#1,439:1\n60#2,4:440\n49#2,4:444\n*S KotlinDebug\n*F\n+ 1 ProcMacroServerPool.kt\norg/rust/lang/core/macros/proc/ProcMacroServerPool\n*L\n75#1:440,4\n54#1:444,4\n*E\n"})
public final class ProcMacroServerPool
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean needsVersionCheck;
    @NotNull
    private final Pool pool;
    @NotNull
    private final Lazy expanderVersion$delegate;

    private ProcMacroServerPool(RsToolchainBase toolchain2, boolean needsVersionCheck, Path expanderExecutable) {
        this.needsVersionCheck = needsVersionCheck;
        this.pool = new Pool(4, (Function0<ProcMacroServerProcess>)((Function0)() -> ProcMacroServerPool.pool$lambda$0(toolchain2, expanderExecutable)));
        this.expanderVersion$delegate = SynchronizedCancellableLazyKt.cancelableLazy(() -> ProcMacroServerPool.expanderVersion_delegate$lambda$0(this));
        Disposer.register((Disposable)this, (Disposable)this.pool);
    }

    private final RsResult<ProcMacroExpanderVersion, RequestSendError> getExpanderVersion() {
        Lazy lazy = this.expanderVersion$delegate;
        return (RsResult)lazy.getValue();
    }

    @NotNull
    public final RsResult<ProcMacroExpanderVersion, RequestSendError> requestExpanderVersion() {
        if (!this.needsVersionCheck) {
            return new RsResult.Ok<ProcMacroExpanderVersion>(ProcMacroExpanderVersion.NO_VERSION_CHECK_VERSION);
        }
        return this.getExpanderVersion();
    }

    @NotNull
    public final RsResult<Response, RequestSendError> send(@NotNull Request request, long timeout) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        RsResult<ProcMacroExpanderVersion, RequestSendError> $this$unwrapOrElse$iv = this.requestExpanderVersion();
        boolean $i$f$unwrapOrElse = false;
        RsResult<ProcMacroExpanderVersion, RequestSendError> rsResult = $this$unwrapOrElse$iv;
        if (!(rsResult instanceof RsResult.Ok)) {
            if (rsResult instanceof RsResult.Err) {
                RequestSendError it2 = (RequestSendError)((RsResult.Err)$this$unwrapOrElse$iv).getErr();
                boolean bl = false;
                return new RsResult.Err<RequestSendError>(it2);
            }
            throw new NoWhenBranchMatchedException();
        }
        ((RsResult.Ok)$this$unwrapOrElse$iv).getOk();
        return this.sendInner(request, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final RsResult<Response, RequestSendError> sendInner(Request request, long timeout) {
        Object object;
        try {
            object = this.pool.alloc();
        }
        catch (ProcessCreationException e) {
            return new RsResult.Err<RequestSendError.ProcessCreation>(new RequestSendError.ProcessCreation(e));
        }
        ProcMacroServerProcess io = object;
        try {
            object = new RsResult.Ok<Response>(io.send(request, timeout));
        }
        catch (IOException e) {
            object = new RsResult.Err<RequestSendError.IO>(new RequestSendError.IO(e));
        }
        catch (TimeoutException e) {
            object = new RsResult.Err<RequestSendError.Timeout>(new RequestSendError.Timeout(e));
        }
        finally {
            this.pool.free(io);
        }
        return object;
    }

    public void dispose() {
    }

    private static final ProcMacroServerProcess pool$lambda$0(RsToolchainBase $toolchain, Path $expanderExecutable) {
        return ProcMacroServerProcess.Companion.createAndRun($toolchain, $expanderExecutable);
    }

    private static final RsResult expanderVersion_delegate$lambda$0(ProcMacroServerPool this$0) {
        RsResult rsResult;
        RsResult<Response, RequestSendError> $this$andThen$iv = this$0.sendInner(Request.ApiVersionCheck.INSTANCE, 10000L);
        boolean $i$f$andThen = false;
        RsResult<Response, RequestSendError> rsResult2 = $this$andThen$iv;
        if (rsResult2 instanceof RsResult.Ok) {
            ProcMacroExpanderVersion version;
            Response it2 = (Response)((RsResult.Ok)$this$andThen$iv).getOk();
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it2, (String)"null cannot be cast to non-null type org.rust.lang.core.macros.proc.Response.ApiVersionCheck");
            int i2 = (int)((Response.ApiVersionCheck)it2).getVersion();
            ProcMacroExpanderVersion procMacroExpanderVersion = version = ProcMacroExpanderVersion.Companion.from(i2);
            rsResult = (procMacroExpanderVersion == null ? -1 : WhenMappings.$EnumSwitchMapping$0[procMacroExpanderVersion.ordinal()]) == -1 ? (RsResult)new RsResult.Err<RequestSendError.UnknownVersion>(new RequestSendError.UnknownVersion(i2)) : (RsResult)new RsResult.Ok<ProcMacroExpanderVersion>(version);
        } else if (rsResult2 instanceof RsResult.Err) {
            rsResult = new RsResult.Err(((RsResult.Err)$this$andThen$iv).getErr());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return rsResult;
    }

    public /* synthetic */ ProcMacroServerPool(RsToolchainBase toolchain2, boolean needsVersionCheck, Path expanderExecutable, DefaultConstructorMarker $constructor_marker) {
        this(toolchain2, needsVersionCheck, expanderExecutable);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u0013"}, d2={"Lorg/rust/lang/core/macros/proc/ProcMacroServerPool$Companion;", "", "<init>", "()V", "new", "Lorg/rust/lang/core/macros/proc/ProcMacroServerPool;", "toolchain", "Lorg/rust/cargo/toolchain/RsToolchainBase;", "needsVersionCheck", "", "expanderExecutable", "Ljava/nio/file/Path;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "findExpanderExecutablePath", "sysroot", "", "findExpanderFromToolchain", "findEmbeddedExpander", "intellij.rustrover.core"})
    @SourceDebugExtension(value={"SMAP\nProcMacroServerPool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProcMacroServerPool.kt\norg/rust/lang/core/macros/proc/ProcMacroServerPool$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,439:1\n1#2:440\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ProcMacroServerPool new(@NotNull RsToolchainBase toolchain2, boolean needsVersionCheck, @NotNull Path expanderExecutable, @NotNull Disposable parentDisposable) {
            ProcMacroServerPool procMacroServerPool;
            Intrinsics.checkNotNullParameter((Object)toolchain2, (String)"toolchain");
            Intrinsics.checkNotNullParameter((Object)expanderExecutable, (String)"expanderExecutable");
            Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
            ProcMacroServerPool it2 = procMacroServerPool = new ProcMacroServerPool(toolchain2, needsVersionCheck, expanderExecutable, null);
            boolean bl = false;
            Disposer.register((Disposable)parentDisposable, (Disposable)it2);
            return procMacroServerPool;
        }

        @Nullable
        public final Path findExpanderExecutablePath(@NotNull RsToolchainBase toolchain2, @NotNull String sysroot) {
            Intrinsics.checkNotNullParameter((Object)toolchain2, (String)"toolchain");
            Intrinsics.checkNotNullParameter((Object)sysroot, (String)"sysroot");
            Path path = this.findExpanderFromToolchain(toolchain2, sysroot);
            if (path == null) {
                path = this.findEmbeddedExpander(toolchain2);
            }
            return path;
        }

        private final Path findExpanderFromToolchain(RsToolchainBase toolchain2, String sysroot) {
            String binaryName = toolchain2.getExecutableName("rust-analyzer-proc-macro-srv");
            String[] stringArray = new String[]{"libexec", binaryName};
            Path expanderPath = Path.of(sysroot, stringArray);
            if (toolchain2 instanceof RsWslToolchain) {
                if (!expanderPath.toFile().isFile()) {
                    return null;
                }
            } else {
                Intrinsics.checkNotNull((Object)expanderPath);
                if (!UtilsKt.isExecutable(expanderPath)) {
                    return null;
                }
            }
            return expanderPath;
        }

        private final Path findEmbeddedExpander(RsToolchainBase toolchain2) {
            return RsPathManager.INSTANCE.nativeHelper(toolchain2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            $EnumSwitchMapping$0 = new int[ProcMacroExpanderVersion.values().length];
        }
    }
}

