/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.macros.proc;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.cargo.project.model.CargoProjectServiceKt;
import org.rust.cargo.project.model.ProcMacroExpanderExecutable;
import org.rust.cargo.project.model.RustcInfo;
import org.rust.cargo.project.settings.RsProjectSettingsServiceBase;
import org.rust.cargo.project.settings.RustProjectSettingsService;
import org.rust.cargo.toolchain.RsToolchainBase;
import org.rust.cargo.toolchain.wsl.RsWslToolchain;
import org.rust.ide.experiments.RsExperiments;
import org.rust.lang.core.macros.proc.ProcMacroServerPool;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0002\u000f\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006J\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\rH\u0016R\u001c\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/rust/lang/core/macros/proc/ProcMacroApplicationService;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "servers", "", "Lorg/rust/cargo/project/model/ProcMacroExpanderExecutable;", "Lorg/rust/lang/core/macros/proc/ProcMacroServerPool;", "getServer", "toolchain", "Lorg/rust/cargo/toolchain/RsToolchainBase;", "procMacroExpanderExecutable", "removeUnusableSevers", "", "dispose", "DistributionIdAndExpanderPath", "Companion", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nProcMacroApplicationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProcMacroApplicationService.kt\norg/rust/lang/core/macros/proc/ProcMacroApplicationService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,130:1\n1#2:131\n1#2:145\n774#3:132\n865#3,2:133\n1617#3,9:135\n1869#3:144\n1870#3:146\n1626#3:147\n1869#3,2:148\n*S KotlinDebug\n*F\n+ 1 ProcMacroApplicationService.kt\norg/rust/lang/core/macros/proc/ProcMacroApplicationService\n*L\n79#1:145\n78#1:132\n78#1:133,2\n79#1:135,9\n79#1:144\n79#1:146\n79#1:147\n80#1:148,2\n*E\n"})
public final class ProcMacroApplicationService
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<ProcMacroExpanderExecutable, ProcMacroServerPool> servers = new HashMap();

    public ProcMacroApplicationService() {
        MessageBusConnection connect = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        connect.subscribe(RsProjectSettingsServiceBase.Companion.getRUST_SETTINGS_TOPIC(), (Object)new RsProjectSettingsServiceBase.RsSettingsListener(){

            @Override
            public <T extends RsProjectSettingsServiceBase.RsProjectSettingsBase<T>> void settingsChanged(RsProjectSettingsServiceBase.SettingsChangedEventBase<T> e) {
                Intrinsics.checkNotNullParameter(e, (String)"e");
                if (!(e instanceof RustProjectSettingsService.SettingsChangedEvent)) {
                    return;
                }
                RsToolchainBase rsToolchainBase = ((RustProjectSettingsService.RustProjectSettings)((Object)((RustProjectSettingsService.SettingsChangedEvent)e).getOldState())).getToolchain();
                RsToolchainBase rsToolchainBase2 = ((RustProjectSettingsService.RustProjectSettings)((Object)((RustProjectSettingsService.SettingsChangedEvent)e).getNewState())).getToolchain();
                if (!Intrinsics.areEqual((Object)(rsToolchainBase != null ? Companion.getDistributionId(rsToolchainBase) : null), (Object)(rsToolchainBase2 != null ? Companion.getDistributionId(rsToolchainBase2) : null))) {
                    this.removeUnusableSevers();
                }
            }
        });
        Topic topic = ProjectManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        connect.subscribe(topic, (Object)new ProjectManagerListener(){

            public void projectClosed(Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                this.removeUnusableSevers();
            }
        });
    }

    @Nullable
    public final synchronized ProcMacroServerPool getServer(@NotNull RsToolchainBase toolchain2, @NotNull ProcMacroExpanderExecutable procMacroExpanderExecutable) {
        Intrinsics.checkNotNullParameter((Object)toolchain2, (String)"toolchain");
        Intrinsics.checkNotNullParameter((Object)procMacroExpanderExecutable, (String)"procMacroExpanderExecutable");
        if (!Companion.isAnyEnabled()) {
            return null;
        }
        ProcMacroServerPool server = this.servers.get(procMacroExpanderExecutable);
        if (server == null) {
            server = ProcMacroServerPool.Companion.new(toolchain2, procMacroExpanderExecutable.getNeedsVersionCheck(), procMacroExpanderExecutable.getProcMacroExpanderPath(), this);
            this.servers.put(procMacroExpanderExecutable, server);
        }
        return server;
    }

    /*
     * WARNING - void declaration
     */
    private final synchronized void removeUnusableSevers() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        boolean bl;
        Set procMacroExpanders = new LinkedHashSet();
        Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
        for (Project project : projectArray) {
            Intrinsics.checkNotNull((Object)project);
            Project project2 = project;
            for (Object cargoProject : CargoProjectServiceKt.getCargoProjects(project2).getAllProjects()) {
                Object object = cargoProject.getRustcInfo();
                if (object == null || (object = ((RustcInfo)object).getProcMacroExpanderExecutable()) == null) continue;
                Object it2 = object;
                bl = false;
                procMacroExpanders.add(it2);
            }
        }
        Iterable $this$filter$iv = this.servers.keySet();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean bl2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ProcMacroExpanderExecutable it3 = (ProcMacroExpanderExecutable)element$iv$iv;
            boolean bl3 = false;
            if (!(!procMacroExpanders.contains(it3))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean bl4 = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ProcMacroServerPool it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            bl = false;
            ProcMacroExpanderExecutable it4 = (ProcMacroExpanderExecutable)element$iv$iv;
            boolean bl22 = false;
            if (this.servers.remove(it4) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            ProcMacroServerPool procMacroServerPool = (ProcMacroServerPool)element$iv;
            boolean bl5 = false;
            Disposer.dispose((Disposable)procMacroServerPool);
        }
    }

    public void dispose() {
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\u0007J\u0006\u0010\t\u001a\u00020\u0007J\u0006\u0010\n\u001a\u00020\u0007J\u0006\u0010\u000b\u001a\u00020\u0007R\u0018\u0010\f\u001a\u00020\r*\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/rust/lang/core/macros/proc/ProcMacroApplicationService$Companion;", "", "<init>", "()V", "getInstance", "Lorg/rust/lang/core/macros/proc/ProcMacroApplicationService;", "isFullyEnabled", "", "isAnyEnabled", "isFunctionLikeEnabled", "isDeriveEnabled", "isAttrEnabled", "distributionId", "", "Lorg/rust/cargo/toolchain/RsToolchainBase;", "getDistributionId", "(Lorg/rust/cargo/toolchain/RsToolchainBase;)Ljava/lang/String;", "intellij.rustrover.core"})
    @SourceDebugExtension(value={"SMAP\nProcMacroApplicationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProcMacroApplicationService.kt\norg/rust/lang/core/macros/proc/ProcMacroApplicationService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,130:1\n42#2,3:131\n*S KotlinDebug\n*F\n+ 1 ProcMacroApplicationService.kt\norg/rust/lang/core/macros/proc/ProcMacroApplicationService$Companion\n*L\n92#1:131,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ProcMacroApplicationService getInstance() {
            boolean $i$f$service = false;
            Class<ProcMacroApplicationService> serviceClass$iv = ProcMacroApplicationService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (ProcMacroApplicationService)object;
        }

        public final boolean isFullyEnabled() {
            return RsExperiments.INSTANCE.getEVALUATE_BUILD_SCRIPTS().asBoolean() && (RsExperiments.INSTANCE.getPROC_MACROS().asBoolean() || RsExperiments.INSTANCE.getFN_LIKE_PROC_MACROS().asBoolean() && RsExperiments.INSTANCE.getDERIVE_PROC_MACROS().asBoolean() && RsExperiments.INSTANCE.getATTR_PROC_MACROS().asBoolean());
        }

        public final boolean isAnyEnabled() {
            return RsExperiments.INSTANCE.getEVALUATE_BUILD_SCRIPTS().asBoolean() && (RsExperiments.INSTANCE.getPROC_MACROS().asBoolean() || RsExperiments.INSTANCE.getFN_LIKE_PROC_MACROS().asBoolean() || RsExperiments.INSTANCE.getDERIVE_PROC_MACROS().asBoolean() || RsExperiments.INSTANCE.getATTR_PROC_MACROS().asBoolean());
        }

        public final boolean isFunctionLikeEnabled() {
            return RsExperiments.INSTANCE.getEVALUATE_BUILD_SCRIPTS().asBoolean() && (RsExperiments.INSTANCE.getPROC_MACROS().asBoolean() || RsExperiments.INSTANCE.getFN_LIKE_PROC_MACROS().asBoolean());
        }

        public final boolean isDeriveEnabled() {
            return RsExperiments.INSTANCE.getEVALUATE_BUILD_SCRIPTS().asBoolean() && (RsExperiments.INSTANCE.getPROC_MACROS().asBoolean() || RsExperiments.INSTANCE.getDERIVE_PROC_MACROS().asBoolean());
        }

        public final boolean isAttrEnabled() {
            return RsExperiments.INSTANCE.getEVALUATE_BUILD_SCRIPTS().asBoolean() && (RsExperiments.INSTANCE.getPROC_MACROS().asBoolean() || RsExperiments.INSTANCE.getATTR_PROC_MACROS().asBoolean());
        }

        private final String getDistributionId(RsToolchainBase $this$distributionId) {
            return $this$distributionId instanceof RsWslToolchain ? ((RsWslToolchain)$this$distributionId).getWslPath().getDistributionId() : "Local";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00052\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lorg/rust/lang/core/macros/proc/ProcMacroApplicationService$DistributionIdAndExpanderPath;", "", "distributionId", "", "needsVersionCheck", "", "procMacroExpanderPath", "Ljava/nio/file/Path;", "<init>", "(Ljava/lang/String;ZLjava/nio/file/Path;)V", "getDistributionId", "()Ljava/lang/String;", "getNeedsVersionCheck", "()Z", "getProcMacroExpanderPath", "()Ljava/nio/file/Path;", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "intellij.rustrover.core"})
    private static final class DistributionIdAndExpanderPath {
        @NotNull
        private final String distributionId;
        private final boolean needsVersionCheck;
        @NotNull
        private final Path procMacroExpanderPath;

        public DistributionIdAndExpanderPath(@NotNull String distributionId, boolean needsVersionCheck, @NotNull Path procMacroExpanderPath) {
            Intrinsics.checkNotNullParameter((Object)distributionId, (String)"distributionId");
            Intrinsics.checkNotNullParameter((Object)procMacroExpanderPath, (String)"procMacroExpanderPath");
            this.distributionId = distributionId;
            this.needsVersionCheck = needsVersionCheck;
            this.procMacroExpanderPath = procMacroExpanderPath;
        }

        @NotNull
        public final String getDistributionId() {
            return this.distributionId;
        }

        public final boolean getNeedsVersionCheck() {
            return this.needsVersionCheck;
        }

        @NotNull
        public final Path getProcMacroExpanderPath() {
            return this.procMacroExpanderPath;
        }

        @NotNull
        public final String component1() {
            return this.distributionId;
        }

        public final boolean component2() {
            return this.needsVersionCheck;
        }

        @NotNull
        public final Path component3() {
            return this.procMacroExpanderPath;
        }

        @NotNull
        public final DistributionIdAndExpanderPath copy(@NotNull String distributionId, boolean needsVersionCheck, @NotNull Path procMacroExpanderPath) {
            Intrinsics.checkNotNullParameter((Object)distributionId, (String)"distributionId");
            Intrinsics.checkNotNullParameter((Object)procMacroExpanderPath, (String)"procMacroExpanderPath");
            return new DistributionIdAndExpanderPath(distributionId, needsVersionCheck, procMacroExpanderPath);
        }

        public static /* synthetic */ DistributionIdAndExpanderPath copy$default(DistributionIdAndExpanderPath distributionIdAndExpanderPath, String string, boolean bl, Path path, int n, Object object) {
            if ((n & 1) != 0) {
                string = distributionIdAndExpanderPath.distributionId;
            }
            if ((n & 2) != 0) {
                bl = distributionIdAndExpanderPath.needsVersionCheck;
            }
            if ((n & 4) != 0) {
                path = distributionIdAndExpanderPath.procMacroExpanderPath;
            }
            return distributionIdAndExpanderPath.copy(string, bl, path);
        }

        @NotNull
        public String toString() {
            return "DistributionIdAndExpanderPath(distributionId=" + this.distributionId + ", needsVersionCheck=" + this.needsVersionCheck + ", procMacroExpanderPath=" + this.procMacroExpanderPath + ")";
        }

        public int hashCode() {
            int result2 = this.distributionId.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.needsVersionCheck);
            result2 = result2 * 31 + ((Object)this.procMacroExpanderPath).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DistributionIdAndExpanderPath)) {
                return false;
            }
            DistributionIdAndExpanderPath distributionIdAndExpanderPath = (DistributionIdAndExpanderPath)other;
            if (!Intrinsics.areEqual((Object)this.distributionId, (Object)distributionIdAndExpanderPath.distributionId)) {
                return false;
            }
            if (this.needsVersionCheck != distributionIdAndExpanderPath.needsVersionCheck) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.procMacroExpanderPath, (Object)distributionIdAndExpanderPath.procMacroExpanderPath);
        }
    }
}

