/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.macros.proc;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.lang.core.macros.MacroExpansionManagerKt;
import org.rust.lang.core.macros.proc.ProcMacroServerProcess;
import org.rust.stdext.ConcurrencyKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u0013\u001a\u00020\u0006J\b\u0010\u0014\u001a\u00020\u0006H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0006J\b\u0010\u0018\u001a\u00020\u0016H\u0002J\b\u0010\u0019\u001a\u00020\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/rust/lang/core/macros/proc/Pool;", "Lcom/intellij/openapi/Disposable;", "limit", "", "supplier", "Lkotlin/Function0;", "Lorg/rust/lang/core/macros/proc/ProcMacroServerProcess;", "<init>", "(ILkotlin/jvm/functions/Function0;)V", "stack", "", "stackLock", "Ljava/util/concurrent/locks/Lock;", "stackIsNotEmpty", "Ljava/util/concurrent/locks/Condition;", "idleProcessCleaner", "Ljava/util/concurrent/ScheduledFuture;", "isDisposed", "", "alloc", "supply", "free", "", "t", "killIdleExpanders", "dispose", "Companion", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nProcMacroServerPool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProcMacroServerPool.kt\norg/rust/lang/core/macros/proc/Pool\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,439:1\n1617#2,9:440\n1869#2:449\n1870#2:451\n1626#2:452\n1#3:450\n*S KotlinDebug\n*F\n+ 1 ProcMacroServerPool.kt\norg/rust/lang/core/macros/proc/Pool\n*L\n199#1:440,9\n199#1:449\n199#1:451\n199#1:452\n199#1:450\n*E\n"})
final class Pool
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int limit;
    @NotNull
    private final Function0<ProcMacroServerProcess> supplier;
    @NotNull
    private final List<ProcMacroServerProcess> stack;
    @NotNull
    private final Lock stackLock;
    @NotNull
    private final Condition stackIsNotEmpty;
    @NotNull
    private final ScheduledFuture<?> idleProcessCleaner;
    private volatile boolean isDisposed;
    private static final long MAX_IDLE_MILLIS = 60000L;

    public Pool(int limit, @NotNull Function0<ProcMacroServerProcess> supplier) {
        Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
        this.limit = limit;
        this.supplier = supplier;
        this.stack = new ArrayList();
        this.stackLock = new ReentrantLock();
        Condition condition = this.stackLock.newCondition();
        Intrinsics.checkNotNullExpressionValue((Object)condition, (String)"newCondition(...)");
        this.stackIsNotEmpty = condition;
        int n = this.limit;
        int n2 = 0;
        while (n2 < n) {
            int it2 = n2++;
            boolean bl = false;
            this.stack.add(null);
        }
        ScheduledFuture<?> scheduledFuture = AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(this::killIdleExpanders, 60000L, 60000L, TimeUnit.MILLISECONDS);
        Intrinsics.checkNotNullExpressionValue(scheduledFuture, (String)"scheduleWithFixedDelay(...)");
        this.idleProcessCleaner = scheduledFuture;
    }

    @NotNull
    public final ProcMacroServerProcess alloc() {
        ProcMacroServerProcess procMacroServerProcess;
        if (!(!this.isDisposed)) {
            throw new IllegalStateException("Check failed.");
        }
        ProcMacroServerProcess value = (ProcMacroServerProcess)ConcurrencyKt.withLockAndCheckingCancelled(this.stackLock, () -> Pool.alloc$lambda$0(this));
        if (value == null) {
            procMacroServerProcess = this.supply();
        } else if (value.isValid()) {
            procMacroServerProcess = value;
        } else {
            Disposer.dispose((Disposable)value);
            procMacroServerProcess = this.supply();
        }
        return procMacroServerProcess;
    }

    private final ProcMacroServerProcess supply() {
        ProcMacroServerProcess procMacroServerProcess;
        try {
            procMacroServerProcess = (ProcMacroServerProcess)this.supplier.invoke();
        }
        catch (Throwable t) {
            this.free(null);
            throw t;
        }
        ProcMacroServerProcess newValue = procMacroServerProcess;
        Disposer.register((Disposable)this, (Disposable)newValue);
        return newValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void free(@Nullable ProcMacroServerProcess t) {
        Lock lock = this.stackLock;
        lock.lock();
        try {
            boolean bl = false;
            this.stack.add(t);
            this.stackIsNotEmpty.signal();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void killIdleExpanders() {
        List $i$a$-withLock-Pool$killIdleExpanders$processesToDispose$22;
        Lock lock = this.stackLock;
        lock.lock();
        try {
            void $this$mapNotNullTo$iv$iv;
            boolean $i$a$-withLock-Pool$killIdleExpanders$processesToDispose$22 = false;
            Iterable $this$mapNotNull$iv = CollectionsKt.withIndex((Iterable)this.stack);
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                ProcMacroServerProcess it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                IndexedValue indexedValue = (IndexedValue)element$iv$iv;
                boolean bl2 = false;
                int i2 = indexedValue.component1();
                ProcMacroServerProcess process2 = (ProcMacroServerProcess)indexedValue.component2();
                if (process2 != null && process2.getIdleTime() > 60000L) {
                    this.stack.set(i2, null);
                }
                if (process2 == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $i$a$-withLock-Pool$killIdleExpanders$processesToDispose$22 = (List)destination$iv$iv;
        }
        finally {
            lock.unlock();
        }
        List processesToDispose = $i$a$-withLock-Pool$killIdleExpanders$processesToDispose$22;
        for (ProcMacroServerProcess process3 : processesToDispose) {
            Disposer.dispose((Disposable)process3);
        }
    }

    public void dispose() {
        this.isDisposed = true;
        this.idleProcessCleaner.cancel(false);
        if (this.stack.size() != this.limit) {
            MacroExpansionManagerKt.MACRO_LOG.error("Some processes were not freed! " + this.stack.size() + " != " + this.limit);
        }
    }

    private static final ProcMacroServerProcess alloc$lambda$0(Pool this$0) {
        while (this$0.stack.isEmpty()) {
            ConcurrencyKt.awaitWithCheckCancelled(this$0.stackIsNotEmpty);
        }
        return this$0.stack.removeLast();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/rust/lang/core/macros/proc/Pool$Companion;", "", "<init>", "()V", "MAX_IDLE_MILLIS", "", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

