/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.macros.filesystem;

import com.intellij.openapi.util.io.BufferExposingByteArrayInputStream;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import com.intellij.openapi.vfs.newvfs.impl.FakeVirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathUtilRt;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.rust.lang.core.macros.MacroExpansionManagerKt;
import org.rust.lang.core.macros.MacroExpansionSharedCache;
import org.rust.lang.core.macros.filesystem.ExpandedMacroStorageKt;
import org.rust.lang.core.macros.filesystem.ExpansionNameInfo;
import org.rust.lang.core.macros.filesystem.MacroExpansionFileSystemKt;
import org.rust.lang.core.macros.filesystem.TrustedRequestor;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u0000\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0013\u0018\u0000 Y2\u00020\u0001:\tQRSTUVWXYB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0014J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0014J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000fH\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\r2\u0006\u0010\t\u001a\u00020\u0007H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\r2\u0006\u0010\t\u001a\u00020\u0007H\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\r2\u0006\u0010\t\u001a\u00020\u0007H\u0016J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u0007H\u0016J\"\u0010\u001b\u001a\u00020\r2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\u0007H\u0016J\"\u0010 \u001a\u00020\r2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u0007H\u0016J*\u0010!\u001a\u00020\r2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020\u0007H\u0016J\u001a\u0010$\u001a\u00020\u00142\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\f\u001a\u00020\rH\u0016J\"\u0010%\u001a\u00020\u00142\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\rH\u0016J\"\u0010&\u001a\u00020\u00142\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010'\u001a\u00020\u0007H\u0016J\u0012\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001c\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010\t\u001a\u00020\u00072\b\b\u0002\u0010*\u001a\u00020\u000fH\u0002J\u0010\u0010+\u001a\u00020\u000f2\u0006\u0010,\u001a\u00020\rH\u0016J\u001b\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00070.2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010/J\u0010\u00100\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u00101\u001a\u0002022\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u00103\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\r2\u0006\u00104\u001a\u000202H\u0016J\u0010\u00105\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u00106\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\r2\u0006\u00107\u001a\u00020\u000fH\u0016J\u0010\u00108\u001a\u0002092\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010:\u001a\u00020;2\u0006\u0010\f\u001a\u00020\rH\u0016J*\u0010<\u001a\u00020=2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010>\u001a\u0002022\u0006\u00104\u001a\u000202H\u0016J\u0010\u0010?\u001a\u0002022\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010@\u001a\u0004\u0018\u00010A2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010B\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010C\u001a\u0002092\b\b\u0002\u0010*\u001a\u00020\u000fJ \u0010D\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010E\u001a\u00020\u00122\b\b\u0002\u0010*\u001a\u00020\u000fJ\u0018\u0010F\u001a\u00020G2\u0006\u0010\t\u001a\u00020\u00072\b\b\u0002\u0010*\u001a\u00020\u000fJ\u0016\u0010H\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010C\u001a\u000209J\u000e\u0010I\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\u0007J \u0010J\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u00052\b\b\u0002\u0010K\u001a\u00020\u000fJ\u000e\u0010L\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\u0007J\u0010\u0010M\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\u0007J\u000e\u0010$\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\u0007J\u0018\u0010N\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\u00072\b\b\u0002\u0010O\u001a\u00020\u000fJ\u000e\u0010+\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u0007J\b\u0010P\u001a\u00020\u0014H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Z"}, d2={"Lorg/rust/lang/core/macros/filesystem/MacroExpansionInternalFileSystem;", "Lcom/intellij/openapi/vfs/newvfs/NewVirtualFileSystem;", "<init>", "()V", "root", "Lorg/rust/lang/core/macros/filesystem/MacroExpansionInternalFileSystem$FSItem$FSDir;", "getProtocol", "", "extractRootPath", "path", "normalize", "getCanonicallyCasedName", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isCaseSensitive", "", "isReadOnly", "getRank", "", "refresh", "", "asynchronous", "refreshAndFindFileByPath", "findFileByPath", "findFileByPathIfCached", "isValidName", "name", "createChildDirectory", "requestor", "", "parent", "dir", "createChildFile", "copyFile", "newParent", "copyName", "deleteFile", "moveFile", "renameFile", "newName", "convert", "Lorg/rust/lang/core/macros/filesystem/MacroExpansionInternalFileSystem$FSItem;", "mkdirs", "exists", "fileOrDirectory", "list", "", "(Lcom/intellij/openapi/vfs/VirtualFile;)[Ljava/lang/String;", "isDirectory", "getTimeStamp", "", "setTimeStamp", "timeStamp", "isWritable", "setWritable", "writableFlag", "contentsToByteArray", "", "getInputStream", "Ljava/io/InputStream;", "getOutputStream", "Ljava/io/OutputStream;", "modStamp", "getLength", "getAttributes", "Lcom/intellij/openapi/util/io/FileAttributes;", "createFileWithExplicitContent", "content", "createFileWithImplicitContent", "fileSize", "createFileWithoutContent", "Lorg/rust/lang/core/macros/filesystem/MacroExpansionInternalFileSystem$FSItem$FSFile;", "setFileContent", "createDirectoryIfNotExistsOrDummy", "setDirectory", "override", "makeDummy", "getDirectory", "cleanDirectoryIfExists", "bump", "verifyIntegrity", "FSItem", "FSException", "FSItemNotFoundException", "FSItemIsNotADirectoryException", "FSItemIsADirectoryException", "FSItemAlreadyExistsException", "IllegalPathException", "Helper", "Companion", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nMacroExpansionFileSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MacroExpansionFileSystem.kt\norg/rust/lang/core/macros/filesystem/MacroExpansionInternalFileSystem\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1101:1\n1#2:1102\n774#3:1103\n865#3,2:1104\n1563#3:1106\n1634#3,3:1107\n774#3:1110\n865#3,2:1111\n1563#3:1113\n1634#3,3:1114\n*S KotlinDebug\n*F\n+ 1 MacroExpansionFileSystem.kt\norg/rust/lang/core/macros/filesystem/MacroExpansionInternalFileSystem\n*L\n922#1:1103\n922#1:1104,2\n923#1:1106\n923#1:1107,3\n933#1:1110\n933#1:1111,2\n934#1:1113\n934#1:1114,3\n*E\n"})
public final class MacroExpansionInternalFileSystem
extends NewVirtualFileSystem {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FSItem.FSDir root = new FSItem.FSDir(null, "/", 0L, 4, null);
    @NotNull
    private static final String PROTOCOL = "rust-macros";

    @NotNull
    public String getProtocol() {
        return PROTOCOL;
    }

    @NotNull
    protected String extractRootPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return "/";
    }

    @NotNull
    protected String normalize(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return path;
    }

    @NotNull
    public String getCanonicallyCasedName(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    public boolean isCaseSensitive() {
        return true;
    }

    public boolean isReadOnly() {
        return false;
    }

    public int getRank() {
        return 1;
    }

    public void refresh(boolean asynchronous) {
        VfsImplUtil.refresh((NewVirtualFileSystem)this, (boolean)asynchronous);
    }

    @Nullable
    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return (VirtualFile)VfsImplUtil.refreshAndFindFileByPath((NewVirtualFileSystem)this, (String)path);
    }

    @Nullable
    public VirtualFile findFileByPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return (VirtualFile)NewVirtualFileSystem.findFileByPath((NewVirtualFileSystem)this, (String)path);
    }

    @Nullable
    public VirtualFile findFileByPathIfCached(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return (VirtualFile)NewVirtualFileSystem.findFileByPathIfCached((NewVirtualFileSystem)this, (String)path);
    }

    public boolean isValidName(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return PathUtilRt.isValidFileName((String)name2, (PathUtilRt.Platform)PathUtilRt.Platform.UNIX, (boolean)false, null);
    }

    @NotNull
    public VirtualFile createChildDirectory(@Nullable Object requestor, @NotNull VirtualFile parent2, @NotNull String dir) throws IOException {
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        if (!Intrinsics.areEqual((Object)requestor, (Object)TrustedRequestor.INSTANCE)) {
            throw new UnsupportedOperationException();
        }
        FSItem fSItem = this.convert(parent2);
        if (fSItem == null) {
            throw new FileNotFoundException(parent2.getPath() + " (No such file or directory)");
        }
        FSItem parentFsDir = fSItem;
        if (!(parentFsDir instanceof FSItem.FSDir)) {
            throw new IOException(parent2.getPath() + " is not a directory");
        }
        FSItem existingDir = ((FSItem.FSDir)parentFsDir).findChild(dir);
        if (existingDir == null) {
            ((FSItem.FSDir)parentFsDir).addChildDir(dir, true);
        } else if (!(existingDir instanceof FSItem.FSDir)) {
            throw new IOException("Directory already contains a file named " + dir);
        }
        return (VirtualFile)new FakeVirtualFile(parent2, dir);
    }

    @NotNull
    public VirtualFile createChildFile(@Nullable Object requestor, @NotNull VirtualFile parent2, @NotNull String file) throws IOException {
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        throw new UnsupportedOperationException();
    }

    @NotNull
    public VirtualFile copyFile(@Nullable Object requestor, @NotNull VirtualFile file, @NotNull VirtualFile newParent, @NotNull String copyName) throws IOException {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)newParent, (String)"newParent");
        Intrinsics.checkNotNullParameter((Object)copyName, (String)"copyName");
        throw new UnsupportedOperationException();
    }

    public void deleteFile(@Nullable Object requestor, @NotNull VirtualFile file) throws IOException {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!Intrinsics.areEqual((Object)requestor, (Object)TrustedRequestor.INSTANCE)) {
            throw new UnsupportedOperationException();
        }
        FSItem fSItem = this.convert(file);
        if (fSItem == null) {
            return;
        }
        FSItem fsItem = fSItem;
        FSItem.FSDir fSDir = fsItem.getParent();
        if (fSDir == null) {
            throw new IOException("Can't delete root (" + file.getPath() + ")");
        }
        FSItem.FSDir parent2 = fSDir;
        parent2.removeChild(fsItem.getName(), true);
    }

    public void moveFile(@Nullable Object requestor, @NotNull VirtualFile file, @NotNull VirtualFile newParent) throws IOException {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)newParent, (String)"newParent");
        if (!Intrinsics.areEqual((Object)requestor, (Object)TrustedRequestor.INSTANCE)) {
            throw new UnsupportedOperationException();
        }
        if (Intrinsics.areEqual((Object)file.getParent(), (Object)newParent)) {
            throw new IOException("Cannot move file `" + file.getPath() + "` to the same directory where it is already located");
        }
        FSItem fSItem = this.convert(file);
        if (fSItem == null) {
            throw new FileNotFoundException(file.getPath() + " (No such file or directory)");
        }
        FSItem fsItem = fSItem;
        FSItem fSItem2 = this.convert(newParent);
        if (fSItem2 == null) {
            throw new FileNotFoundException(newParent.getPath() + " (No such file or directory)");
        }
        FSItem newParentFsDir = fSItem2;
        if (!(newParentFsDir instanceof FSItem.FSDir)) {
            throw new IOException(newParent.getPath() + " is not a directory");
        }
        FSItem.FSDir fSDir = (FSItem.FSDir)newParentFsDir;
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (fSDir.findChild(string) != null) {
            throw new IOException("Directory already contains a file named " + file.getName());
        }
        FSItem.FSDir fSDir2 = fsItem.getParent();
        if (fSDir2 == null) {
            throw new IOException("Can't move root (" + file.getPath() + ")");
        }
        FSItem.FSDir oldParentFsDir = fSDir2;
        oldParentFsDir.removeChild(fsItem.getName(), true);
        fsItem.setParent((FSItem.FSDir)newParentFsDir);
        FSItem.FSDir.addChild$default((FSItem.FSDir)newParentFsDir, fsItem, true, false, 4, null);
    }

    public void renameFile(@Nullable Object requestor, @NotNull VirtualFile file, @NotNull String newName) throws IOException {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        if (!Intrinsics.areEqual((Object)requestor, (Object)TrustedRequestor.INSTANCE)) {
            throw new UnsupportedOperationException();
        }
        FSItem fSItem = this.convert(file);
        if (fSItem == null) {
            throw new FileNotFoundException(file.getPath() + " (No such file or directory)");
        }
        FSItem fsItem = fSItem;
        FSItem.FSDir fSDir = fsItem.getParent();
        if (fSDir == null) {
            throw new IOException("Can't rename root (" + file.getPath() + ")");
        }
        FSItem.FSDir parent2 = fSDir;
        FSItem.FSDir.removeChild$default(parent2, fsItem.getName(), false, 2, null);
        fsItem.setName(newName);
        FSItem.FSDir.addChild$default(parent2, fsItem, true, false, 4, null);
    }

    private final FSItem convert(VirtualFile file) {
        FSItem fSItem;
        VirtualFile virtualFile = file.getParent();
        if (virtualFile == null) {
            return this.root;
        }
        VirtualFile parentFile = virtualFile;
        FSItem parentItem = this.convert(parentFile);
        if (parentItem != null && parentItem instanceof FSItem.FSDir) {
            FSItem.FSDir fSDir = (FSItem.FSDir)parentItem;
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            fSItem = fSDir.findChild(string);
        } else {
            fSItem = null;
        }
        return fSItem;
    }

    private final FSItem convert(String path, boolean mkdirs) {
        FSItem file = this.root;
        for (String segment : StringUtil.split((String)path, (String)"/")) {
            if (!(file instanceof FSItem.FSDir)) {
                return null;
            }
            FSItem.FSDir fSDir = (FSItem.FSDir)file;
            Intrinsics.checkNotNull((Object)segment);
            FSItem fSItem = fSDir.findChild(segment);
            if (fSItem == null) {
                if (!mkdirs) {
                    return null;
                }
                fSItem = FSItem.FSDir.addChildDir$default((FSItem.FSDir)file, segment, false, 2, null);
            }
            file = fSItem;
        }
        return file;
    }

    static /* synthetic */ FSItem convert$default(MacroExpansionInternalFileSystem macroExpansionInternalFileSystem, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return macroExpansionInternalFileSystem.convert(string, bl);
    }

    public boolean exists(@NotNull VirtualFile fileOrDirectory) {
        Intrinsics.checkNotNullParameter((Object)fileOrDirectory, (String)"fileOrDirectory");
        return this.convert(fileOrDirectory) != null;
    }

    @NotNull
    public String[] list(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FSItem fSItem = this.convert(file);
        FSItem.FSDir fSDir = fSItem instanceof FSItem.FSDir ? (FSItem.FSDir)fSItem : null;
        if (fSDir == null) {
            Intrinsics.checkNotNullExpressionValue((Object)ArrayUtil.EMPTY_STRING_ARRAY, (String)"EMPTY_STRING_ARRAY");
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        FSItem.FSDir fsItem = fSDir;
        return fsItem.list();
    }

    public boolean isDirectory(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.convert(file) instanceof FSItem.FSDir;
    }

    public long getTimeStamp(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FSItem fSItem = this.convert(file);
        if (fSItem == null) {
            return 0L;
        }
        FSItem fsItem = fSItem;
        return fsItem.getTimestamp();
    }

    public void setTimeStamp(@NotNull VirtualFile file, long timeStamp) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FSItem fSItem = this.convert(file);
        if (fSItem == null) {
            return;
        }
        FSItem fsItem = fSItem;
        fsItem.setTimestamp(timeStamp > 0L ? timeStamp : MacroExpansionFileSystemKt.access$currentTimestamp());
    }

    public boolean isWritable(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return true;
    }

    public void setWritable(@NotNull VirtualFile file, boolean writableFlag) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public byte[] contentsToByteArray(@NotNull VirtualFile file) throws IOException {
        block9: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            v0 = this.convert(file);
            if (v0 == null) {
                throw new FileNotFoundException(file.getPath() + " (No such file or directory)");
            }
            fsItem = v0;
            if (!(fsItem instanceof FSItem.FSFile)) {
                throw new FileNotFoundException(file.getPath() + " (Is a directory)");
            }
            v1 = ((FSItem.FSFile)fsItem).fetchAndRemoveContent();
            if (v1 != null) break block9;
            $this$contentsToByteArray_u24lambda_u240 = this;
            $i$a$-run-MacroExpansionInternalFileSystem$contentsToByteArray$1 = false;
            v2 = ExpandedMacroStorageKt.extractExpansionNameInfo(file);
            if (v2 == null) {
                v2 = new ExpansionNameInfo(null, false, -1);
            }
            var5_5 = v2;
            mixHash = var5_5.component1();
            storedVersion = var5_5.component3();
            if (mixHash == null) ** GOTO lbl-1000
            it = var8_8 = mixHash;
            $i$a$-takeIf-MacroExpansionInternalFileSystem$contentsToByteArray$1$cachedExpansion$1 = false;
            v3 = var11_11 = storedVersion == 145 != false ? var8_8 : null;
            if (var11_11 != null) {
                it = var11_11;
                $i$a$-let-MacroExpansionInternalFileSystem$contentsToByteArray$1$cachedExpansion$2 = false;
                v4 = MacroExpansionSharedCache.Companion.getInstance().getExpansionIfCached(it);
                v5 = v4 != null ? v4.ok() : null;
            } else lbl-1000:
            // 2 sources

            {
                v5 = cachedExpansion = null;
            }
            if (cachedExpansion != null) {
                v6 = cachedExpansion.getText().getBytes(Charsets.UTF_8);
                v7 = v6;
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"getBytes(...)");
            } else if (storedVersion != 145) {
                v7 = ArrayUtil.EMPTY_BYTE_ARRAY;
            } else {
                fsItem.delete();
                e = new FileNotFoundException(file.getPath() + " (Content is not provided)");
                MacroExpansionManagerKt.MACRO_LOG.warn("The file content has already been fetched", (Throwable)e);
                throw e;
            }
            v1 = v7;
            Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"run(...)");
        }
        return v1;
    }

    @NotNull
    public InputStream getInputStream(@NotNull VirtualFile file) throws IOException {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return (InputStream)new BufferExposingByteArrayInputStream(this.contentsToByteArray(file));
    }

    @NotNull
    public OutputStream getOutputStream(@NotNull VirtualFile file, @Nullable Object requestor, long modStamp, long timeStamp) throws IOException {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!Intrinsics.areEqual((Object)requestor, (Object)TrustedRequestor.INSTANCE) && !Helper.INSTANCE.isWritingAllowed(file)) {
            throw new UnsupportedOperationException();
        }
        return new ByteArrayOutputStream(this, file, timeStamp){
            final /* synthetic */ MacroExpansionInternalFileSystem this$0;
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ long $timeStamp;
            {
                this.this$0 = $receiver;
                this.$file = $file;
                this.$timeStamp = $timeStamp;
            }

            public void close() throws IOException {
                super.close();
                FSItem fsItem = MacroExpansionInternalFileSystem.access$convert(this.this$0, this.$file);
                if (!(fsItem instanceof FSItem.FSFile)) {
                    throw new IOException("The file is a directory (" + this.$file.getPath());
                }
                ((FSItem.FSFile)fsItem).setLength(this.size());
                this.this$0.setTimeStamp(this.$file, this.$timeStamp);
            }
        };
    }

    public long getLength(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FSItem fSItem = this.convert(file);
        FSItem.FSFile fSFile = fSItem instanceof FSItem.FSFile ? (FSItem.FSFile)fSItem : null;
        if (fSFile == null) {
            return 0L;
        }
        FSItem.FSFile fsItem = fSFile;
        return fsItem.getLength();
    }

    @Nullable
    public FileAttributes getAttributes(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FSItem fSItem = this.convert(file);
        if (fSItem == null) {
            return null;
        }
        FSItem item = fSItem;
        FSItem.FSFile fSFile = item instanceof FSItem.FSFile ? (FSItem.FSFile)item : null;
        long length = fSFile != null ? fSFile.getLength() : 0;
        boolean isDir = item instanceof FSItem.FSDir;
        FileAttributes.CaseSensitivity caseSensitivity = isDir ? FileAttributes.CaseSensitivity.SENSITIVE : FileAttributes.CaseSensitivity.UNKNOWN;
        return new FileAttributes(isDir, false, false, false, length, item.getTimestamp(), true, caseSensitivity);
    }

    public final void createFileWithExplicitContent(@NotNull String path, @NotNull byte[] content, boolean mkdirs) throws FSException {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        this.createFileWithoutContent(path, mkdirs).setContent(content);
    }

    public static /* synthetic */ void createFileWithExplicitContent$default(MacroExpansionInternalFileSystem macroExpansionInternalFileSystem, String string, byte[] byArray, boolean bl, int n, Object object) throws FSException {
        if ((n & 4) != 0) {
            bl = false;
        }
        macroExpansionInternalFileSystem.createFileWithExplicitContent(string, byArray, bl);
    }

    public final void createFileWithImplicitContent(@NotNull String path, int fileSize, boolean mkdirs) throws FSException {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.createFileWithoutContent(path, mkdirs).setImplicitContent(fileSize);
    }

    public static /* synthetic */ void createFileWithImplicitContent$default(MacroExpansionInternalFileSystem macroExpansionInternalFileSystem, String string, int n, boolean bl, int n2, Object object) throws FSException {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        macroExpansionInternalFileSystem.createFileWithImplicitContent(string, n, bl);
    }

    @NotNull
    public final FSItem.FSFile createFileWithoutContent(@NotNull String path, boolean mkdirs) throws FSException {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Pair pair = MacroExpansionFileSystemKt.access$splitFilenameAndParent(path);
        String parentName = (String)pair.component1();
        String name2 = (String)pair.component2();
        FSItem fSItem = this.convert(parentName, mkdirs);
        if (fSItem == null) {
            throw new FSItemNotFoundException(parentName);
        }
        FSItem parent2 = fSItem;
        if (!(parent2 instanceof FSItem.FSDir)) {
            throw new FSItemIsNotADirectoryException(path);
        }
        return FSItem.FSDir.addChildFile$default((FSItem.FSDir)parent2, name2, false, 2, null);
    }

    public static /* synthetic */ FSItem.FSFile createFileWithoutContent$default(MacroExpansionInternalFileSystem macroExpansionInternalFileSystem, String string, boolean bl, int n, Object object) throws FSException {
        if ((n & 2) != 0) {
            bl = false;
        }
        return macroExpansionInternalFileSystem.createFileWithoutContent(string, bl);
    }

    public final void setFileContent(@NotNull String path, @NotNull byte[] content) throws FSException {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        FSItem fSItem = MacroExpansionInternalFileSystem.convert$default(this, path, false, 2, null);
        if (fSItem == null) {
            throw new FSItemNotFoundException(path);
        }
        FSItem item = fSItem;
        if (!(item instanceof FSItem.FSFile)) {
            throw new FSItemIsADirectoryException(path);
        }
        ((FSItem.FSFile)item).setContent(content);
    }

    public final void createDirectoryIfNotExistsOrDummy(@NotNull String path) throws FSException {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Pair pair = MacroExpansionFileSystemKt.access$splitFilenameAndParent(path);
        String parentName = (String)pair.component1();
        String name2 = (String)pair.component2();
        FSItem fSItem = MacroExpansionInternalFileSystem.convert$default(this, parentName, false, 2, null);
        if (fSItem == null) {
            throw new FSItemNotFoundException(parentName);
        }
        FSItem parent2 = fSItem;
        if (!(parent2 instanceof FSItem.FSDir)) {
            throw new FSItemIsNotADirectoryException(path);
        }
        FSItem child = ((FSItem.FSDir)parent2).findChild(name2);
        if (child == null || child instanceof FSItem.FSDir.DummyDir) {
            if (child != null) {
                FSItem.FSDir.removeChild$default((FSItem.FSDir)parent2, name2, false, 2, null);
            }
            ((FSItem.FSDir)parent2).addChildDir(name2, true);
        }
    }

    public final void setDirectory(@NotNull String path, @NotNull FSItem.FSDir dir, boolean override) throws FSException {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Pair pair = MacroExpansionFileSystemKt.access$splitFilenameAndParent(path);
        String parentName = (String)pair.component1();
        String name2 = (String)pair.component2();
        FSItem fSItem = MacroExpansionInternalFileSystem.convert$default(this, parentName, false, 2, null);
        if (fSItem == null) {
            throw new FSItemNotFoundException(parentName);
        }
        FSItem parent2 = fSItem;
        if (!(parent2 instanceof FSItem.FSDir)) {
            throw new FSItemIsNotADirectoryException(path);
        }
        dir.setParent((FSItem.FSDir)parent2);
        dir.setName(name2);
        ((FSItem.FSDir)parent2).addChild(dir, true, override);
    }

    public static /* synthetic */ void setDirectory$default(MacroExpansionInternalFileSystem macroExpansionInternalFileSystem, String string, FSItem.FSDir fSDir, boolean bl, int n, Object object) throws FSException {
        if ((n & 4) != 0) {
            bl = true;
        }
        macroExpansionInternalFileSystem.setDirectory(string, fSDir, bl);
    }

    public final void makeDummy(@NotNull String path) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            FSItem.FSDir fSDir = this.getDirectory(path);
            if (fSDir == null) break block0;
            FSItem.FSDir it2 = fSDir;
            boolean bl = false;
            MacroExpansionInternalFileSystem.setDirectory$default(this, path, it2.dummy(), false, 4, null);
        }
    }

    @Nullable
    public final FSItem.FSDir getDirectory(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        FSItem fSItem = MacroExpansionInternalFileSystem.convert$default(this, path, false, 2, null);
        return fSItem instanceof FSItem.FSDir ? (FSItem.FSDir)fSItem : null;
    }

    public final void deleteFile(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Pair pair = MacroExpansionFileSystemKt.access$splitFilenameAndParent(path);
        String parentName = (String)pair.component1();
        String name2 = (String)pair.component2();
        FSItem fSItem = MacroExpansionInternalFileSystem.convert$default(this, parentName, false, 2, null);
        if (fSItem == null) {
            return;
        }
        FSItem parent2 = fSItem;
        if (!(parent2 instanceof FSItem.FSDir)) {
            throw new FSItemIsNotADirectoryException(path);
        }
        ((FSItem.FSDir)parent2).removeChild(name2, true);
    }

    public final void cleanDirectoryIfExists(@NotNull String path, boolean bump) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        FSItem fSItem = MacroExpansionInternalFileSystem.convert$default(this, path, false, 2, null);
        if (fSItem == null) {
            return;
        }
        FSItem dir = fSItem;
        if (!(dir instanceof FSItem.FSDir)) {
            throw new FSItemIsNotADirectoryException(path);
        }
        ((FSItem.FSDir)dir).clear(bump);
    }

    public static /* synthetic */ void cleanDirectoryIfExists$default(MacroExpansionInternalFileSystem macroExpansionInternalFileSystem, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        macroExpansionInternalFileSystem.cleanDirectoryIfExists(string, bl);
    }

    public final boolean exists(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return MacroExpansionInternalFileSystem.convert$default(this, path, false, 2, null) != null;
    }

    /*
     * WARNING - void declaration
     */
    @TestOnly
    public final void verifyIntegrity() {
        List incorrectFilePaths;
        Collection collection;
        void $this$mapTo$iv$iv;
        boolean $i$f$mapTo;
        Iterable $this$map$iv;
        boolean $i$f$map;
        FSItem it2;
        Iterable $this$filterTo$iv$iv;
        boolean $i$f$filterTo;
        Collection destination$iv$iv;
        Iterable $this$filter$iv;
        boolean $i$f$filter;
        MacroExpansionInternalFileSystem vfs = this;
        String rootPath = "/rust_expanded_macros";
        if (vfs.exists(rootPath)) {
            FSItem.FSDir fSDir = vfs.getDirectory(rootPath);
            List list = fSDir != null ? fSDir.getChildren() : null;
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            Iterable iterable = list;
            $i$f$filter = false;
            void var6_7 = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it2 = (FSItem)element$iv$iv;
                boolean bl = false;
                if (!(!(it2 instanceof FSItem.FSDir.DummyDir))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it2 = (FSItem)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(rootPath + "/" + it2.getName());
            }
            incorrectFilePaths = (List)destination$iv$iv;
            if (!((Collection)incorrectFilePaths).isEmpty()) {
                for (String path : incorrectFilePaths) {
                    this.deleteFile(path);
                }
                throw new IllegalStateException((incorrectFilePaths + " are not dummy dirs").toString());
            }
        }
        FSItem.FSDir fSDir = vfs.getDirectory("/");
        List list = fSDir != null ? fSDir.getChildren() : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        $this$map$iv = list;
        $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it2 = (FSItem)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it2.getName(), (Object)"rust_expanded_macros"))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it2 = (FSItem)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add("/" + it2.getName());
        }
        incorrectFilePaths = (List)destination$iv$iv;
        if (!((Collection)incorrectFilePaths).isEmpty()) {
            for (String path : incorrectFilePaths) {
                this.deleteFile(path);
            }
            throw new IllegalStateException((incorrectFilePaths + " should have been removed at the end of the test").toString());
        }
    }

    public static final /* synthetic */ FSItem access$convert(MacroExpansionInternalFileSystem $this, VirtualFile file) {
        return $this.convert(file);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/rust/lang/core/macros/filesystem/MacroExpansionInternalFileSystem$Companion;", "", "<init>", "()V", "PROTOCOL", "", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0016\u0018\u00002\u00060\u0001j\u0002`\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/rust/lang/core/macros/filesystem/MacroExpansionInternalFileSystem$FSException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "path", "", "<init>", "(Ljava/lang/String;)V", "intellij.rustrover.core"})
    public static class FSException
    extends RuntimeException {
        public FSException(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            super(path);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u001b\u001cB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0017J\u0006\u0010\u0019\u001a\u00020\u000bJ\b\u0010\u001a\u001a\u00020\u000bH\u0016R\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0018\u0010\n\u001a\u00020\u000bX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\u00020\u0011X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u0082\u0001\u0002\u0005\u001d\u00a8\u0006\u001e"}, d2={"Lorg/rust/lang/core/macros/filesystem/MacroExpansionInternalFileSystem$FSItem;", "", "<init>", "()V", "parent", "Lorg/rust/lang/core/macros/filesystem/MacroExpansionInternalFileSystem$FSItem$FSDir;", "getParent", "()Lorg/rust/lang/core/macros/filesystem/MacroExpansionInternalFileSystem$FSItem$FSDir;", "setParent", "(Lorg/rust/lang/core/macros/filesystem/MacroExpansionInternalFileSystem$FSItem$FSDir;)V", "name", "", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "timestamp", "", "getTimestamp", "()J", "setTimestamp", "(J)V", "bumpTimestamp", "", "delete", "absolutePath", "toString", "FSDir", "FSFile", "Lorg/rust/lang/core/macros/filesystem/MacroExpansionInternalFileSystem$FSItem$FSFile;", "intellij.rustrover.core"})
    public static abstract sealed class FSItem {
        private FSItem() {
        }

        @Nullable
        public abstract FSDir getParent();

        public abstract void setParent(@Nullable FSDir var1);

        @NotNull
        public abstract String getName();

        public abstract void setName(@NotNull String var1);

        public abstract long getTimestamp();

        public abstract void setTimestamp(long var1);

        public final void bumpTimestamp() {
            this.setTimestamp(Math.max(MacroExpansionFileSystemKt.access$currentTimestamp(), this.getTimestamp() + 1L));
        }

        public final void delete() {
            block0: {
                FSDir fSDir = this.getParent();
                if (fSDir == null) break block0;
                fSDir.removeChild(this.getName(), true);
            }
        }

        @NotNull
        public final String absolutePath() {
            StringBuilder stringBuilder;
            StringBuilder $this$absolutePath_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            FSItem.absolutePath$lambda$0$go(this, $this$absolutePath_u24lambda_u240);
            return stringBuilder.toString();
        }

        @NotNull
        public String toString() {
            return this.getClass().getSimpleName() + ": " + this.getName();
        }

        private static final void absolutePath$lambda$0$go(FSItem $this$absolutePath_u24lambda_u240_u24go, StringBuilder $this_buildString) {
            FSDir fSDir = $this$absolutePath_u24lambda_u240_u24go.getParent();
            if (fSDir != null) {
                FSItem.absolutePath$lambda$0$go(fSDir, $this_buildString);
            }
            $this_buildString.append('/');
            $this_buildString.append($this$absolutePath_u24lambda_u240_u24go.getName());
        }

        public /* synthetic */ FSItem(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u000f\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001:\u0001+B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00010\u001aJ\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u0004J\"\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00012\b\b\u0002\u0010\u001f\u001a\u00020 2\b\b\u0002\u0010!\u001a\u00020 J\u0018\u0010\"\u001a\u00020#2\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u001f\u001a\u00020 J\u0018\u0010$\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u001f\u001a\u00020 J\u0018\u0010%\u001a\u00020\u001d2\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u001f\u001a\u00020 J\u0011\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00040'\u00a2\u0006\u0002\u0010(J\u0010\u0010)\u001a\u00020\u001d2\b\b\u0002\u0010\u001f\u001a\u00020 J\u0006\u0010*\u001a\u00020\u0000R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0000X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0003\u001a\u00020\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0005\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00010\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006,"}, d2={"Lorg/rust/lang/core/macros/filesystem/MacroExpansionInternalFileSystem$FSItem$FSDir;", "Lorg/rust/lang/core/macros/filesystem/MacroExpansionInternalFileSystem$FSItem;", "parent", "name", "", "timestamp", "", "<init>", "(Lorg/rust/lang/core/macros/filesystem/MacroExpansionInternalFileSystem$FSItem$FSDir;Ljava/lang/String;J)V", "getParent", "()Lorg/rust/lang/core/macros/filesystem/MacroExpansionInternalFileSystem$FSItem$FSDir;", "setParent", "(Lorg/rust/lang/core/macros/filesystem/MacroExpansionInternalFileSystem$FSItem$FSDir;)V", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "getTimestamp", "()J", "setTimestamp", "(J)V", "children", "", "getChildren", "()Ljava/util/List;", "copyChildren", "", "findChild", "addChild", "", "item", "bump", "", "override", "addChildFile", "Lorg/rust/lang/core/macros/filesystem/MacroExpansionInternalFileSystem$FSItem$FSFile;", "addChildDir", "removeChild", "list", "", "()[Ljava/lang/String;", "clear", "dummy", "DummyDir", "intellij.rustrover.core"})
        @SourceDebugExtension(value={"SMAP\nMacroExpansionFileSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MacroExpansionFileSystem.kt\norg/rust/lang/core/macros/filesystem/MacroExpansionInternalFileSystem$FSItem$FSDir\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,1101:1\n1#2:1102\n1761#3,3:1103\n1563#3:1106\n1634#3,3:1107\n37#4,2:1110\n*S KotlinDebug\n*F\n+ 1 MacroExpansionFileSystem.kt\norg/rust/lang/core/macros/filesystem/MacroExpansionInternalFileSystem$FSItem$FSDir\n*L\n751#1:1103,3\n776#1:1106\n776#1:1107,3\n776#1:1110,2\n*E\n"})
        public static non-sealed class FSDir
        extends FSItem {
            @Nullable
            private FSDir parent;
            @NotNull
            private String name;
            private long timestamp;
            @NotNull
            private final List<FSItem> children;

            public FSDir(@Nullable FSDir parent2, @NotNull String name2, long timestamp) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                super(null);
                this.parent = parent2;
                this.name = name2;
                this.timestamp = timestamp;
                this.children = new ArrayList();
            }

            public /* synthetic */ FSDir(FSDir fSDir, String string, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 4) != 0) {
                    l = MacroExpansionFileSystemKt.access$currentTimestamp();
                }
                this(fSDir, string, l);
            }

            @Override
            @Nullable
            public synchronized FSDir getParent() {
                return this.parent;
            }

            @Override
            public synchronized void setParent(@Nullable FSDir fSDir) {
                this.parent = fSDir;
            }

            @Override
            @NotNull
            public synchronized String getName() {
                return this.name;
            }

            @Override
            public synchronized void setName(@NotNull String string) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
                this.name = string;
            }

            @Override
            public synchronized long getTimestamp() {
                return this.timestamp;
            }

            @Override
            public synchronized void setTimestamp(long l) {
                this.timestamp = l;
            }

            @NotNull
            public List<FSItem> getChildren() {
                return this.children;
            }

            @NotNull
            public final synchronized List<FSItem> copyChildren() {
                return new ArrayList(this.getChildren());
            }

            @Nullable
            public final synchronized FSItem findChild(@NotNull String name2) {
                Object v0;
                block1: {
                    Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                    Iterable iterable = this.getChildren();
                    for (Object t : iterable) {
                        FSItem it2 = (FSItem)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it2.getName(), (Object)name2)) continue;
                        v0 = t;
                        break block1;
                    }
                    v0 = null;
                }
                return v0;
            }

            public final synchronized void addChild(@NotNull FSItem item, boolean bump, boolean override) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                if (!Intrinsics.areEqual((Object)item.getParent(), (Object)this)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                if (!(((CharSequence)item.getName()).length() > 0)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                if (override) {
                    this.getChildren().removeIf(arg_0 -> FSDir.addChild$lambda$1(arg_0 -> FSDir.addChild$lambda$0(item, arg_0), arg_0));
                } else {
                    boolean bl;
                    block9: {
                        Iterable $this$any$iv = this.getChildren();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                FSItem it2 = (FSItem)element$iv;
                                boolean bl2 = false;
                                if (!Intrinsics.areEqual((Object)it2.getName(), (Object)item.getName())) continue;
                                bl = true;
                                break block9;
                            }
                            bl = false;
                        }
                    }
                    if (bl) {
                        throw new FSItemAlreadyExistsException("File `" + item.getName() + "` already exists");
                    }
                }
                this.getChildren().add(item);
                if (bump) {
                    this.bumpTimestamp();
                }
            }

            public static /* synthetic */ void addChild$default(FSDir fSDir, FSItem fSItem, boolean bl, boolean bl2, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addChild");
                }
                if ((n & 2) != 0) {
                    bl = false;
                }
                if ((n & 4) != 0) {
                    bl2 = false;
                }
                fSDir.addChild(fSItem, bl, bl2);
            }

            @NotNull
            public final FSFile addChildFile(@NotNull String name2, boolean bump) {
                FSFile fSFile;
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                FSFile it2 = fSFile = new FSFile(this, name2, 0L, 0, null, 28, null);
                boolean bl = false;
                FSDir.addChild$default(this, it2, bump, false, 4, null);
                return fSFile;
            }

            public static /* synthetic */ FSFile addChildFile$default(FSDir fSDir, String string, boolean bl, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addChildFile");
                }
                if ((n & 2) != 0) {
                    bl = false;
                }
                return fSDir.addChildFile(string, bl);
            }

            @NotNull
            public final FSDir addChildDir(@NotNull String name2, boolean bump) {
                FSDir fSDir;
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                FSDir it2 = fSDir = new FSDir(this, name2, 0L, 4, null);
                boolean bl = false;
                FSDir.addChild$default(this, it2, bump, false, 4, null);
                return fSDir;
            }

            public static /* synthetic */ FSDir addChildDir$default(FSDir fSDir, String string, boolean bl, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addChildDir");
                }
                if ((n & 2) != 0) {
                    bl = false;
                }
                return fSDir.addChildDir(string, bl);
            }

            public final synchronized void removeChild(@NotNull String name2, boolean bump) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                this.getChildren().removeIf(arg_0 -> FSDir.removeChild$lambda$1(arg_0 -> FSDir.removeChild$lambda$0(name2, arg_0), arg_0));
                if (bump) {
                    this.bumpTimestamp();
                }
            }

            public static /* synthetic */ void removeChild$default(FSDir fSDir, String string, boolean bl, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: removeChild");
                }
                if ((n & 2) != 0) {
                    bl = false;
                }
                fSDir.removeChild(string, bl);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final synchronized String[] list() {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = this.getChildren();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    FSItem fSItem = (FSItem)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it2.getName());
                }
                Collection $this$toTypedArray$iv = (List)destination$iv$iv;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                return thisCollection$iv.toArray(new String[0]);
            }

            public final synchronized void clear(boolean bump) {
                this.getChildren().clear();
                if (bump) {
                    this.bumpTimestamp();
                }
            }

            public static /* synthetic */ void clear$default(FSDir fSDir, boolean bl, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: clear");
                }
                if ((n & 1) != 0) {
                    bl = false;
                }
                fSDir.clear(bl);
            }

            @NotNull
            public final FSDir dummy() {
                return new DummyDir(this.getParent(), this.getName(), this.getTimestamp());
            }

            private static final boolean addChild$lambda$0(FSItem $item, FSItem it2) {
                Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                return Intrinsics.areEqual((Object)it2.getName(), (Object)$item.getName());
            }

            private static final boolean addChild$lambda$1(Function1 $tmp0, Object p0) {
                return (Boolean)$tmp0.invoke(p0);
            }

            private static final boolean removeChild$lambda$0(String $name, FSItem it2) {
                Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                return Intrinsics.areEqual((Object)it2.getName(), (Object)$name);
            }

            private static final boolean removeChild$lambda$1(Function1 $tmp0, Object p0) {
                return (Boolean)$tmp0.invoke(p0);
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/rust/lang/core/macros/filesystem/MacroExpansionInternalFileSystem$FSItem$FSDir$DummyDir;", "Lorg/rust/lang/core/macros/filesystem/MacroExpansionInternalFileSystem$FSItem$FSDir;", "parent", "name", "", "timestamp", "", "<init>", "(Lorg/rust/lang/core/macros/filesystem/MacroExpansionInternalFileSystem$FSItem$FSDir;Ljava/lang/String;J)V", "children", "", "Lorg/rust/lang/core/macros/filesystem/MacroExpansionInternalFileSystem$FSItem;", "getChildren", "()Ljava/util/List;", "intellij.rustrover.core"})
            @SourceDebugExtension(value={"SMAP\nMacroExpansionFileSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MacroExpansionFileSystem.kt\norg/rust/lang/core/macros/filesystem/MacroExpansionInternalFileSystem$FSItem$FSDir$DummyDir\n+ 2 utils.kt\norg/rust/openapiext/UtilsKt\n*L\n1#1,1101:1\n323#2,5:1102\n*S KotlinDebug\n*F\n+ 1 MacroExpansionFileSystem.kt\norg/rust/lang/core/macros/filesystem/MacroExpansionInternalFileSystem$FSItem$FSDir$DummyDir\n*L\n793#1:1102,5\n*E\n"})
            public static final class DummyDir
            extends FSDir {
                public DummyDir(@Nullable FSDir parent2, @NotNull String name2, long timestamp) {
                    Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                    super(parent2, name2, timestamp);
                }

                public /* synthetic */ DummyDir(FSDir fSDir, String string, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
                    if ((n & 4) != 0) {
                        l = MacroExpansionFileSystemKt.access$currentTimestamp();
                    }
                    this(fSDir, string, l);
                }

                @Override
                @NotNull
                public List<FSItem> getChildren() {
                    boolean $i$f$weakAssert = false;
                    if (UtilsKt.isUnitTestMode() || UtilsKt.isInternal()) {
                        boolean bl = false;
                        if (!false) {
                            boolean bl2 = false;
                            String message$iv = "DummyDir should not be touched!";
                            throw new AssertionError((Object)message$iv);
                        }
                    }
                    return new ArrayList();
                }
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0017\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B9\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u000bJ\u000e\u0010%\u001a\u00020#2\u0006\u0010&\u001a\u00020\tJ\b\u0010'\u001a\u0004\u0018\u00010\u000bR\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0004\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0006\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!\u00a8\u0006("}, d2={"Lorg/rust/lang/core/macros/filesystem/MacroExpansionInternalFileSystem$FSItem$FSFile;", "Lorg/rust/lang/core/macros/filesystem/MacroExpansionInternalFileSystem$FSItem;", "parent", "Lorg/rust/lang/core/macros/filesystem/MacroExpansionInternalFileSystem$FSItem$FSDir;", "name", "", "timestamp", "", "length", "", "tempContent", "", "<init>", "(Lorg/rust/lang/core/macros/filesystem/MacroExpansionInternalFileSystem$FSItem$FSDir;Ljava/lang/String;JI[B)V", "getParent", "()Lorg/rust/lang/core/macros/filesystem/MacroExpansionInternalFileSystem$FSItem$FSDir;", "setParent", "(Lorg/rust/lang/core/macros/filesystem/MacroExpansionInternalFileSystem$FSItem$FSDir;)V", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "getTimestamp", "()J", "setTimestamp", "(J)V", "getLength", "()I", "setLength", "(I)V", "getTempContent", "()[B", "setTempContent", "([B)V", "setContent", "", "content", "setImplicitContent", "fileSize", "fetchAndRemoveContent", "intellij.rustrover.core"})
        public static final class FSFile
        extends FSItem {
            @Nullable
            private FSDir parent;
            @NotNull
            private String name;
            private long timestamp;
            private int length;
            @Nullable
            private byte[] tempContent;

            public FSFile(@Nullable FSDir parent2, @NotNull String name2, long timestamp, int length, @Nullable byte[] tempContent) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                super(null);
                this.parent = parent2;
                this.name = name2;
                this.timestamp = timestamp;
                this.length = length;
                this.tempContent = tempContent;
            }

            public /* synthetic */ FSFile(FSDir fSDir, String string, long l, int n, byte[] byArray, int n2, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n2 & 4) != 0) {
                    l = MacroExpansionFileSystemKt.access$currentTimestamp();
                }
                if ((n2 & 8) != 0) {
                    n = 0;
                }
                if ((n2 & 0x10) != 0) {
                    byArray = null;
                }
                this(fSDir, string, l, n, byArray);
            }

            @Override
            @Nullable
            public synchronized FSDir getParent() {
                return this.parent;
            }

            @Override
            public synchronized void setParent(@Nullable FSDir fSDir) {
                this.parent = fSDir;
            }

            @Override
            @NotNull
            public synchronized String getName() {
                return this.name;
            }

            @Override
            public synchronized void setName(@NotNull String string) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
                this.name = string;
            }

            @Override
            public synchronized long getTimestamp() {
                return this.timestamp;
            }

            @Override
            public synchronized void setTimestamp(long l) {
                this.timestamp = l;
            }

            public final synchronized int getLength() {
                return this.length;
            }

            public final void setLength(int n) {
                this.length = n;
            }

            @Nullable
            public final synchronized byte[] getTempContent() {
                return this.tempContent;
            }

            public final void setTempContent(@Nullable byte[] byArray) {
                this.tempContent = byArray;
            }

            public final synchronized void setContent(@NotNull byte[] content) {
                Intrinsics.checkNotNullParameter((Object)content, (String)"content");
                this.tempContent = content;
                this.length = content.length;
                this.bumpTimestamp();
            }

            public final synchronized void setImplicitContent(int fileSize) {
                this.tempContent = null;
                this.length = fileSize;
                this.bumpTimestamp();
            }

            @Nullable
            public final synchronized byte[] fetchAndRemoveContent() {
                byte[] tmp = this.tempContent;
                this.tempContent = null;
                return tmp;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lorg/rust/lang/core/macros/filesystem/MacroExpansionInternalFileSystem$FSItemAlreadyExistsException;", "Lorg/rust/lang/core/macros/filesystem/MacroExpansionInternalFileSystem$FSException;", "path", "", "<init>", "(Ljava/lang/String;)V", "intellij.rustrover.core"})
    public static final class FSItemAlreadyExistsException
    extends FSException {
        public FSItemAlreadyExistsException(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            super(path);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lorg/rust/lang/core/macros/filesystem/MacroExpansionInternalFileSystem$FSItemIsADirectoryException;", "Lorg/rust/lang/core/macros/filesystem/MacroExpansionInternalFileSystem$FSException;", "path", "", "<init>", "(Ljava/lang/String;)V", "intellij.rustrover.core"})
    public static final class FSItemIsADirectoryException
    extends FSException {
        public FSItemIsADirectoryException(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            super(path);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lorg/rust/lang/core/macros/filesystem/MacroExpansionInternalFileSystem$FSItemIsNotADirectoryException;", "Lorg/rust/lang/core/macros/filesystem/MacroExpansionInternalFileSystem$FSException;", "path", "", "<init>", "(Ljava/lang/String;)V", "intellij.rustrover.core"})
    public static final class FSItemIsNotADirectoryException
    extends FSException {
        public FSItemIsNotADirectoryException(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            super(path);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lorg/rust/lang/core/macros/filesystem/MacroExpansionInternalFileSystem$FSItemNotFoundException;", "Lorg/rust/lang/core/macros/filesystem/MacroExpansionInternalFileSystem$FSException;", "path", "", "<init>", "(Ljava/lang/String;)V", "intellij.rustrover.core"})
    public static final class FSItemNotFoundException
    extends FSException {
        public FSItemNotFoundException(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            super(path);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0012\u00a8\u0006\u0017"}, d2={"Lorg/rust/lang/core/macros/filesystem/MacroExpansionInternalFileSystem$Helper;", "", "<init>", "()V", "getInstance", "Lorg/rust/lang/core/macros/filesystem/MacroExpansionInternalFileSystem;", "getInstanceOrNull", "writeFSItem", "", "data", "Ljava/io/DataOutput;", "item", "Lorg/rust/lang/core/macros/filesystem/MacroExpansionInternalFileSystem$FSItem;", "readFSItem", "Ljava/io/DataInput;", "parent", "Lorg/rust/lang/core/macros/filesystem/MacroExpansionInternalFileSystem$FSItem$FSDir;", "isWritingAllowed", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "setAllowWriting", "allow", "intellij.rustrover.core"})
    @SourceDebugExtension(value={"SMAP\nMacroExpansionFileSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MacroExpansionFileSystem.kt\norg/rust/lang/core/macros/filesystem/MacroExpansionInternalFileSystem$Helper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1101:1\n1#2:1102\n*E\n"})
    public static final class Helper {
        @NotNull
        public static final Helper INSTANCE = new Helper();

        private Helper() {
        }

        @NotNull
        public final MacroExpansionInternalFileSystem getInstance() {
            VirtualFileSystem virtualFileSystem = VirtualFileManager.getInstance().getFileSystem(MacroExpansionInternalFileSystem.PROTOCOL);
            Intrinsics.checkNotNull((Object)virtualFileSystem, (String)"null cannot be cast to non-null type org.rust.lang.core.macros.filesystem.MacroExpansionInternalFileSystem");
            return (MacroExpansionInternalFileSystem)virtualFileSystem;
        }

        @Nullable
        public final MacroExpansionInternalFileSystem getInstanceOrNull() {
            VirtualFileSystem virtualFileSystem = VirtualFileManager.getInstance().getFileSystem(MacroExpansionInternalFileSystem.PROTOCOL);
            return virtualFileSystem instanceof MacroExpansionInternalFileSystem ? (MacroExpansionInternalFileSystem)virtualFileSystem : null;
        }

        public final void writeFSItem(@NotNull DataOutput data2, @NotNull FSItem item) throws IOException {
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            data2.writeBoolean(item instanceof FSItem.FSDir);
            data2.writeUTF(item.getName());
            data2.writeLong(item.getTimestamp());
            FSItem fSItem = item;
            if (fSItem instanceof FSItem.FSDir) {
                List<FSItem> children = ((FSItem.FSDir)item).copyChildren();
                data2.writeInt(children.size());
                for (FSItem child : children) {
                    this.writeFSItem(data2, child);
                }
            } else if (fSItem instanceof FSItem.FSFile) {
                Object object;
                int length = ((FSItem.FSFile)item).getLength();
                data2.writeInt(length);
                byte[] byArray = ((FSItem.FSFile)item).getTempContent();
                if (byArray != null) {
                    byte[] byArray2;
                    byte[] it2 = byArray2 = byArray;
                    boolean bl = false;
                    object = it2.length == length ? byArray2 : null;
                } else {
                    object = null;
                }
                byte[] content = object;
                data2.writeBoolean(content != null);
                if (content != null) {
                    data2.write(content);
                }
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }

        @NotNull
        public final FSItem readFSItem(@NotNull DataInput data2, @Nullable FSItem.FSDir parent2) throws IOException {
            FSItem fSItem;
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            boolean isDir = data2.readBoolean();
            String name2 = data2.readUTF();
            long timestamp = data2.readLong();
            if (isDir) {
                Intrinsics.checkNotNull((Object)name2);
                FSItem.FSDir dir = new FSItem.FSDir(parent2, name2, timestamp);
                int count = data2.readInt();
                for (int i2 = 0; i2 < count; ++i2) {
                    FSItem child = this.readFSItem(data2, dir);
                    FSItem.FSDir.addChild$default(dir, child, false, false, 6, null);
                }
                fSItem = dir;
            } else {
                byte[] byArray;
                int length = data2.readInt();
                boolean hasContent = data2.readBoolean();
                if (hasContent) {
                    byte[] byArray2;
                    byte[] it2 = byArray2 = new byte[length];
                    boolean bl = false;
                    data2.readFully(it2);
                    byArray = byArray2;
                } else {
                    byArray = null;
                }
                byte[] content = byArray;
                FSItem.FSDir fSDir = parent2;
                Intrinsics.checkNotNull((Object)fSDir);
                Intrinsics.checkNotNull((Object)name2);
                fSItem = new FSItem.FSFile(fSDir, name2, timestamp, length, content);
            }
            return fSItem;
        }

        public final boolean isWritingAllowed(@NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return Intrinsics.areEqual((Object)file.getUserData(MacroExpansionFileSystemKt.access$getRUST_MACROS_ALLOW_WRITING$p()), (Object)true);
        }

        public final void setAllowWriting(@NotNull VirtualFile file, boolean allow) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            file.putUserData(MacroExpansionFileSystemKt.access$getRUST_MACROS_ALLOW_WRITING$p(), (Object)(allow ? Boolean.valueOf(true) : null));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lorg/rust/lang/core/macros/filesystem/MacroExpansionInternalFileSystem$IllegalPathException;", "Lorg/rust/lang/core/macros/filesystem/MacroExpansionInternalFileSystem$FSException;", "path", "", "<init>", "(Ljava/lang/String;)V", "intellij.rustrover.core"})
    public static final class IllegalPathException
    extends FSException {
        public IllegalPathException(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            super(path);
        }
    }
}

