/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.macros.filesystem;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.rust.lang.core.macros.MacroExpansionManagerKt;
import org.rust.lang.core.macros.filesystem.MacroExpansionInternalFileSystem;
import org.rust.stdext.PathKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010\u0006\u001a\u00020\u0005J\b\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\t"}, d2={"Lorg/rust/lang/core/macros/filesystem/MacroExpansionFileSystemRootsLoader;", "", "<init>", "()V", "loadProjectDirs", "", "saveProjectDirs", "getProjectListDataFile", "Ljava/nio/file/Path;", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nMacroExpansionFileSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MacroExpansionFileSystem.kt\norg/rust/lang/core/macros/filesystem/MacroExpansionFileSystemRootsLoader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1101:1\n1563#2:1102\n1634#2,3:1103\n*S KotlinDebug\n*F\n+ 1 MacroExpansionFileSystem.kt\norg/rust/lang/core/macros/filesystem/MacroExpansionFileSystemRootsLoader\n*L\n1035#1:1102\n1035#1:1103,3\n*E\n"})
final class MacroExpansionFileSystemRootsLoader {
    @NotNull
    public static final MacroExpansionFileSystemRootsLoader INSTANCE = new MacroExpansionFileSystemRootsLoader();

    private MacroExpansionFileSystemRootsLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final synchronized void loadProjectDirs() {
        MacroExpansionInternalFileSystem vfs = MacroExpansionInternalFileSystem.Helper.INSTANCE.getInstance();
        if (!vfs.exists("/rust_expanded_macros")) {
            MacroExpansionInternalFileSystem.FSItem.FSDir root = new MacroExpansionInternalFileSystem.FSItem.FSDir(null, "rust_expanded_macros", 0L, 4, null);
            try {
                List list;
                Closeable closeable = PathKt.newInflaterDataInputStream(this.getProjectListDataFile());
                Throwable throwable = null;
                try {
                    void $this$mapTo$iv$iv;
                    DataInputStream data2 = (DataInputStream)closeable;
                    boolean bl = false;
                    int count = data2.readInt();
                    Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)count);
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    Iterator iterator2 = $this$mapTo$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        int item$iv$iv;
                        int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                        Collection collection = destination$iv$iv;
                        boolean bl2 = false;
                        String name2 = data2.readUTF();
                        long ts = data2.readLong();
                        Intrinsics.checkNotNull((Object)name2);
                        collection.add(new MacroExpansionInternalFileSystem.FSItem.FSDir.DummyDir(root, name2, ts));
                    }
                    list = (List)destination$iv$iv;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                List dirs = list;
                for (MacroExpansionInternalFileSystem.FSItem.FSDir.DummyDir dir : dirs) {
                    MacroExpansionInternalFileSystem.FSItem.FSDir.addChild$default(root, dir, false, false, 6, null);
                }
            }
            catch (NoSuchFileException dirs) {
            }
            catch (Exception e) {
                MacroExpansionManagerKt.MACRO_LOG.warn((Throwable)e);
            }
            finally {
                vfs.setDirectory("/rust_expanded_macros", root, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveProjectDirs() {
        MacroExpansionInternalFileSystem.FSItem.FSDir fSDir = MacroExpansionInternalFileSystem.Helper.INSTANCE.getInstance().getDirectory("/rust_expanded_macros");
        if (fSDir == null) {
            return;
        }
        MacroExpansionInternalFileSystem.FSItem.FSDir root = fSDir;
        Path dataFile = this.getProjectListDataFile();
        Files.createDirectories(dataFile.getParent(), new FileAttribute[0]);
        Closeable closeable = PathKt.newDeflaterDataOutputStream(dataFile);
        Throwable throwable = null;
        try {
            DataOutputStream data2 = (DataOutputStream)closeable;
            boolean bl = false;
            List<MacroExpansionInternalFileSystem.FSItem> children = root.copyChildren();
            data2.writeInt(children.size());
            for (MacroExpansionInternalFileSystem.FSItem dir : children) {
                data2.writeUTF(dir.getName());
                data2.writeLong(dir.getTimestamp());
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final Path getProjectListDataFile() {
        Path path = MacroExpansionManagerKt.getBaseMacroDir().resolve("project_list.dat");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }
}

