/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.macros.filesystem;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.lang.core.macros.filesystem.MacroExpansionFileSystem;
import org.rust.lang.core.macros.filesystem.MacroExpansionInternalFileSystem;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0002\u001a\b\u0010\u0007\u001a\u00020\bH\u0002\u001a\u001c\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\",\u0010\r\u001a\u0004\u0018\u00010\u0004*\u00020\u000e2\b\u0010\f\u001a\u0004\u0018\u00010\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"RUST_MACROS_ALLOW_WRITING", "Lcom/intellij/openapi/util/Key;", "", "MACRO_EXPANSION_VFS_ROOT", "", "projectExpansionPath", "projectId", "currentTimestamp", "", "splitFilenameAndParent", "Lkotlin/Pair;", "path", "value", "macroExpansionName", "Lcom/intellij/openapi/vfs/VirtualFile;", "getMacroExpansionName", "(Lcom/intellij/openapi/vfs/VirtualFile;)Ljava/lang/String;", "setMacroExpansionName", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/String;)V", "intellij.rustrover.core"})
public final class MacroExpansionFileSystemKt {
    @NotNull
    private static final Key<Boolean> RUST_MACROS_ALLOW_WRITING;
    @NotNull
    private static final String MACRO_EXPANSION_VFS_ROOT = "rust_expanded_macros";

    private static final String projectExpansionPath(String projectId) {
        return "/rust_expanded_macros/" + projectId;
    }

    private static final long currentTimestamp() {
        return System.currentTimeMillis();
    }

    private static final Pair<String, String> splitFilenameAndParent(String path) {
        int index = StringsKt.lastIndexOf$default((CharSequence)path, (char)'/', (int)0, (boolean)false, (int)6, null);
        if (index < 0) {
            throw new MacroExpansionInternalFileSystem.IllegalPathException(path);
        }
        String string = path.substring(0, index);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String pathStart = string;
        String string2 = path.substring(index + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String filename = string2;
        return TuplesKt.to((Object)pathStart, (Object)filename);
    }

    @Nullable
    public static final String getMacroExpansionName(@NotNull VirtualFile $this$macroExpansionName) {
        Intrinsics.checkNotNullParameter((Object)$this$macroExpansionName, (String)"<this>");
        byte[] bytes = MacroExpansionFileSystem.Helper.INSTANCE.getMacroExpansionNameFileAttribute().readAttributeBytes($this$macroExpansionName);
        if (bytes != null && !(bytes.length == 0)) {
            byte[] byArray = bytes;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            Charset charset2 = charset;
            return new String(byArray, charset2);
        }
        return null;
    }

    public static final void setMacroExpansionName(@NotNull VirtualFile $this$macroExpansionName, @Nullable String value) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)$this$macroExpansionName, (String)"<this>");
                object = value;
                if (object == null) break block2;
                String string = object;
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                byte[] byArray = string.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                object = byArray;
                if (byArray != null) break block3;
            }
            object = new byte[0];
        }
        Object bytes = object;
        MacroExpansionFileSystem.Helper.INSTANCE.getMacroExpansionNameFileAttribute().writeAttributeBytes($this$macroExpansionName, (byte[])bytes);
    }

    public static final /* synthetic */ String access$projectExpansionPath(String projectId) {
        return MacroExpansionFileSystemKt.projectExpansionPath(projectId);
    }

    public static final /* synthetic */ long access$currentTimestamp() {
        return MacroExpansionFileSystemKt.currentTimestamp();
    }

    public static final /* synthetic */ Pair access$splitFilenameAndParent(String path) {
        return MacroExpansionFileSystemKt.splitFilenameAndParent(path);
    }

    public static final /* synthetic */ Key access$getRUST_MACROS_ALLOW_WRITING$p() {
        return RUST_MACROS_ALLOW_WRITING;
    }

    static {
        Key key = Key.create((String)"RUST_MACROS_ALLOW_WRITING");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        RUST_MACROS_ALLOW_WRITING = key;
    }
}

