/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.macros.filesystem;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.util.LazyKt;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import com.intellij.util.io.DataOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.OutputStream;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.rust.lang.core.macros.MacroExpansionManagerKt;
import org.rust.lang.core.macros.filesystem.MacroExpansionFileSystemKt;
import org.rust.lang.core.macros.filesystem.MacroExpansionFileSystemRootsLoader;
import org.rust.lang.core.macros.filesystem.MacroExpansionInternalFileSystem;
import org.rust.lang.core.macros.filesystem.TrustedRequestor;
import org.rust.openapiext.UtilsKt;
import org.rust.stdext.PathKt;
import org.rust.stdext.StringKt;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001:\u0004:;<=B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0013\u001a\u00020\fJ\u0018\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\fH\u0007J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\rH\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0016\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\rJ\u0015\u0010!\u001a\u00020\u00182\u000b\u0010\"\u001a\u00070\f\u00a2\u0006\u0002\b#H\u0002J&\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00100%2\u0006\u0010\u0013\u001a\u00020\f2\n\u0010&\u001a\u00060'j\u0002`(J\u001e\u0010)\u001a\u0012\u0012\b\u0012\u00060'j\u0002`(\u0012\u0004\u0012\u00020*0%2\u0006\u0010\u0013\u001a\u00020\fJ,\u0010+\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\r2\n\u0010&\u001a\u00060'j\u0002`(2\u0006\u0010,\u001a\u00020\f2\u0006\u0010-\u001a\u00020'H\u0002J,\u0010.\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\r2\n\u0010&\u001a\u00060'j\u0002`(2\u0006\u0010,\u001a\u00020\f2\u0006\u0010/\u001a\u000200H\u0002J\u0010\u00101\u001a\u00020\u00182\u0006\u00102\u001a\u00020\u0010H\u0002J\u0010\u00103\u001a\u00020\u00182\b\u00104\u001a\u0004\u0018\u000105J\b\u00106\u001a\u00020\u0018H\u0007J\u0012\u00107\u001a\u0004\u0018\u0001082\u0006\u0010\"\u001a\u00020\fH\u0002J\u0010\u00109\u001a\u0004\u0018\u0001082\u0006\u0010\"\u001a\u00020\fR\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lorg/rust/lang/core/macros/filesystem/MacroExpansionFileSystem;", "", "<init>", "()V", "internalFS", "Lorg/rust/lang/core/macros/filesystem/MacroExpansionInternalFileSystem;", "getInternalFS", "()Lorg/rust/lang/core/macros/filesystem/MacroExpansionInternalFileSystem;", "internalFS$delegate", "Lkotlin/Lazy;", "projects", "", "", "Lorg/rust/lang/core/macros/filesystem/MacroExpansionFileSystem$MacroExpansionProject;", "dirtyExpansions", "", "Lorg/rust/lang/core/macros/filesystem/MacroExpansionFileSystem$MacroExpansionFile;", "obsoletePaths", "findProject", "projectId", "loadProject", "dataFile", "Ljava/nio/file/Path;", "buildCratesForProject", "", "project", "load", "Lorg/rust/lang/core/macros/filesystem/MacroExpansionInternalFileSystem$FSItem$FSDir;", "writeProjectData", "data", "Lcom/intellij/util/io/DataOutputStream;", "releaseExpansionDirectory", "macroExpansionProject", "deleteFile", "path", "Lorg/jetbrains/annotations/NonNls;", "getAllFiles", "", "crateId", "", "Lorg/rust/lang/core/crate/CratePersistentId;", "getAllCrates", "Lorg/rust/lang/core/macros/filesystem/MacroExpansionFileSystem$MacroExpansionCrate;", "createFileWithImplicitContent", "expansionName", "size", "createFileWithExplicitContent", "byteArray", "", "markDirty", "expansion", "applyToVfs", "callback", "Ljava/lang/Runnable;", "verifyIntegrity", "findVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "refreshAndFindVirtualFile", "Helper", "MacroExpansionProject", "MacroExpansionCrate", "MacroExpansionFile", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nMacroExpansionFileSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MacroExpansionFileSystem.kt\norg/rust/lang/core/macros/filesystem/MacroExpansionFileSystem\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,1101:1\n3919#2:1102\n4434#2,2:1103\n*S KotlinDebug\n*F\n+ 1 MacroExpansionFileSystem.kt\norg/rust/lang/core/macros/filesystem/MacroExpansionFileSystem\n*L\n104#1:1102\n104#1:1103,2\n*E\n"})
public final class MacroExpansionFileSystem {
    @NotNull
    private final Lazy internalFS$delegate = LazyKt.lazyPub(MacroExpansionFileSystem::internalFS_delegate$lambda$0);
    @NotNull
    private final Map<String, MacroExpansionProject> projects = new ConcurrentHashMap();
    @NotNull
    private final List<MacroExpansionFile> dirtyExpansions = new ArrayList();
    @NotNull
    private final List<String> obsoletePaths = new ArrayList();

    private final MacroExpansionInternalFileSystem getInternalFS() {
        Lazy lazy = this.internalFS$delegate;
        return (MacroExpansionInternalFileSystem)((Object)lazy.getValue());
    }

    @Nullable
    public final MacroExpansionProject findProject(@NotNull String projectId) {
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        return this.projects.get(projectId);
    }

    @RequiresBackgroundThread
    @NotNull
    public final MacroExpansionProject loadProject(@NotNull Path dataFile, @NotNull String projectId) {
        Intrinsics.checkNotNullParameter((Object)dataFile, (String)"dataFile");
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        MacroExpansionProject macroExpansionProject = this.projects.compute(projectId, (arg_0, arg_1) -> MacroExpansionFileSystem.loadProject$lambda$1((arg_0, arg_1) -> MacroExpansionFileSystem.loadProject$lambda$0(projectId, this, dataFile, arg_0, arg_1), arg_0, arg_1));
        if (macroExpansionProject == null) {
            throw new IllegalStateException(("Cannot load project " + projectId + " from " + dataFile + ": projects.compute returned null").toString());
        }
        return macroExpansionProject;
    }

    private final void buildCratesForProject(MacroExpansionProject project) {
        if (!UtilsKt.isUnitTestMode()) {
            UtilsKt.checkReadAccessNotAllowed();
        }
        VirtualFile virtualFile = this.getInternalFS().refreshAndFindFileByPath(project.getPath());
        if (virtualFile == null) {
            return;
        }
        VirtualFile dir = virtualFile;
        VirtualFile[] virtualFileArray = new VirtualFile[]{dir};
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])virtualFileArray);
        VirtualFile[] children = dir.getChildren();
        Intrinsics.checkNotNull((Object)children);
        for (VirtualFile child : children) {
            String string = child.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            Integer n = StringsKt.toIntOrNull((String)string);
            if (n == null) {
                continue;
            }
            int crateId = n;
            MacroExpansionCrate crate = project.addCrate(crateId);
            VirtualFile[] virtualFileArray2 = child.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray2, (String)"getChildren(...)");
            Sequence expansions = SequencesKt.flatMap((Sequence)SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])virtualFileArray2), MacroExpansionFileSystem::buildCratesForProject$lambda$0), MacroExpansionFileSystem::buildCratesForProject$lambda$1);
            for (VirtualFile virtualFile2 : expansions) {
                Object object;
                Intrinsics.checkNotNull((Object)virtualFile2);
                String expansionName = MacroExpansionFileSystemKt.getMacroExpansionName(virtualFile2);
                if (expansionName != null) {
                    String string2 = virtualFile2.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                    object = crate.addExpansion(expansionName, string2);
                    continue;
                }
                String string3 = virtualFile2.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
                object = this.obsoletePaths.add(string3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final MacroExpansionInternalFileSystem.FSItem.FSDir load(Path dataFile) {
        Object object;
        try {
            MacroExpansionInternalFileSystem.FSItem.FSDir fSDir;
            object = PathKt.newInflaterDataInputStream(dataFile);
            Throwable throwable = null;
            try {
                DataInputStream data2 = (DataInputStream)object;
                boolean bl = false;
                MacroExpansionInternalFileSystem.FSItem fSItem = MacroExpansionInternalFileSystem.Helper.INSTANCE.readFSItem(data2, null);
                fSDir = fSItem instanceof MacroExpansionInternalFileSystem.FSItem.FSDir ? (MacroExpansionInternalFileSystem.FSItem.FSDir)fSItem : null;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = fSDir;
        }
        catch (NoSuchFileException noSuchFileException) {
            object = null;
        }
        catch (Exception e) {
            MacroExpansionManagerKt.MACRO_LOG.warn((Throwable)e);
            object = null;
        }
        return object;
    }

    public final void writeProjectData(@NotNull String projectId, @NotNull DataOutputStream data2) {
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        String expansionDirPath = MacroExpansionFileSystemKt.access$projectExpansionPath(projectId);
        MacroExpansionInternalFileSystem.FSItem.FSDir fSDir = this.getInternalFS().getDirectory(expansionDirPath);
        if (fSDir == null) {
            MacroExpansionFileSystem $this$writeProjectData_u24lambda_u240 = this;
            boolean bl = false;
            MacroExpansionManagerKt.MACRO_LOG.warn("Expansion directory does not exist when saving the component: " + expansionDirPath);
            fSDir = new MacroExpansionInternalFileSystem.FSItem.FSDir(null, projectId, 0L, 4, null);
        }
        MacroExpansionInternalFileSystem.FSItem.FSDir dirToSave = fSDir;
        MacroExpansionInternalFileSystem.Helper.INSTANCE.writeFSItem((DataOutput)data2, dirToSave);
    }

    public final void releaseExpansionDirectory(@NotNull MacroExpansionProject macroExpansionProject) {
        Intrinsics.checkNotNullParameter((Object)macroExpansionProject, (String)"macroExpansionProject");
        String projectPath = macroExpansionProject.getPath();
        VirtualFile virtualFile = macroExpansionProject.getVirtualFile();
        RefreshQueue.Companion.getInstance().refresh(!UtilsKt.isUnitTestMode(), true, () -> MacroExpansionFileSystem.releaseExpansionDirectory$lambda$0(this, projectPath), (Collection)CollectionsKt.listOf((Object)virtualFile));
    }

    private final void deleteFile(String path) {
        this.getInternalFS().deleteFile(path);
    }

    @NotNull
    public final Map<String, MacroExpansionFile> getAllFiles(@NotNull String projectId, int crateId) {
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        MacroExpansionProject macroExpansionProject = this.projects.get(projectId);
        if (macroExpansionProject == null) {
            return MapsKt.emptyMap();
        }
        MacroExpansionProject project = macroExpansionProject;
        MacroExpansionCrate macroExpansionCrate = project.findCrate(crateId);
        if (macroExpansionCrate == null) {
            return MapsKt.emptyMap();
        }
        MacroExpansionCrate crate = macroExpansionCrate;
        return crate.getExpansions();
    }

    @NotNull
    public final Map<Integer, MacroExpansionCrate> getAllCrates(@NotNull String projectId) {
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        MacroExpansionProject macroExpansionProject = this.projects.get(projectId);
        if (macroExpansionProject == null) {
            return MapsKt.emptyMap();
        }
        MacroExpansionProject project = macroExpansionProject;
        return project.getCrates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void createFileWithImplicitContent(MacroExpansionProject project, int crateId, String expansionName, int size) {
        MacroExpansionCrate macroExpansionCrate = project.findCrate(crateId);
        if (macroExpansionCrate == null) {
            macroExpansionCrate = project.addCrate(crateId);
        }
        MacroExpansionCrate crate = macroExpansionCrate;
        MacroExpansionFile expansion = crate.addExpansion(expansionName);
        this.getInternalFS().createFileWithImplicitContent(expansion.getPath(), size, true);
        this.markDirty(expansion);
        List<MacroExpansionFile> list = this.dirtyExpansions;
        synchronized (list) {
            boolean bl = false;
            boolean bl2 = this.dirtyExpansions.add(expansion);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void createFileWithExplicitContent(MacroExpansionProject project, int crateId, String expansionName, byte[] byteArray) {
        MacroExpansionCrate macroExpansionCrate = project.findCrate(crateId);
        if (macroExpansionCrate == null) {
            macroExpansionCrate = project.addCrate(crateId);
        }
        MacroExpansionCrate crate = macroExpansionCrate;
        MacroExpansionFile expansion = crate.addExpansion(expansionName);
        this.getInternalFS().createFileWithExplicitContent(expansion.getPath(), byteArray, true);
        this.markDirty(expansion);
        List<MacroExpansionFile> list = this.dirtyExpansions;
        synchronized (list) {
            boolean bl = false;
            boolean bl2 = this.dirtyExpansions.add(expansion);
        }
    }

    private final void markDirty(MacroExpansionFile expansion) {
        VirtualFile virtualFile = (VirtualFile)UtilsKt.findNearestExistingFile(expansion.getCrate().getProject().getVirtualFile(), StringsKt.removePrefix((String)StringsKt.removePrefix((String)expansion.getPath(), (CharSequence)expansion.getCrate().getProject().getPath()), (CharSequence)"/")).getFirst();
        VirtualFile[] virtualFileArray = new VirtualFile[]{virtualFile};
        VfsUtil.markDirty((boolean)false, (boolean)false, (VirtualFile[])virtualFileArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void applyToVfs(@Nullable Runnable callback) {
        ArrayList arrayList;
        List<Object> list;
        VirtualFile virtualFile = this.getInternalFS().findFileByPath("/");
        if (virtualFile == null) {
            return;
        }
        VirtualFile root = virtualFile;
        List<MacroExpansionFile> list2 = this.dirtyExpansions;
        synchronized (list2) {
            boolean bl = false;
            ArrayList copy = new ArrayList(this.dirtyExpansions);
            this.dirtyExpansions.clear();
            list = copy;
        }
        ArrayList newDirtyExpansions = list;
        list = this.obsoletePaths;
        synchronized (list) {
            boolean bl = false;
            ArrayList copy = new ArrayList(this.obsoletePaths);
            this.obsoletePaths.clear();
            arrayList = copy;
        }
        ArrayList newObsoletePaths = arrayList;
        root.refresh(false, true, () -> MacroExpansionFileSystem.applyToVfs$lambda$2(newDirtyExpansions, this, newObsoletePaths, callback));
    }

    @TestOnly
    public final void verifyIntegrity() {
        this.getInternalFS().verifyIntegrity();
    }

    private final VirtualFile findVirtualFile(String path) {
        return this.getInternalFS().findFileByPath(path);
    }

    @Nullable
    public final VirtualFile refreshAndFindVirtualFile(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.getInternalFS().refreshAndFindFileByPath(path);
    }

    private static final MacroExpansionInternalFileSystem internalFS_delegate$lambda$0() {
        return MacroExpansionInternalFileSystem.Helper.INSTANCE.getInstance();
    }

    private static final MacroExpansionProject loadProject$lambda$0(String $projectId, MacroExpansionFileSystem this$0, Path $dataFile, String string, MacroExpansionProject macroExpansionProject) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        String projectPath = MacroExpansionFileSystemKt.access$projectExpansionPath($projectId);
        MacroExpansionInternalFileSystem.FSItem.FSDir loadedFsDir = this$0.load($dataFile);
        if (loadedFsDir != null) {
            MacroExpansionInternalFileSystem.setDirectory$default(this$0.getInternalFS(), projectPath, loadedFsDir, false, 4, null);
        } else {
            MacroExpansionManagerKt.MACRO_LOG.debug("Using fresh ExpandedMacroStorage");
            this$0.getInternalFS().createDirectoryIfNotExistsOrDummy(projectPath);
        }
        MacroExpansionProject project = new MacroExpansionProject($projectId, new LinkedHashMap());
        this$0.buildCratesForProject(project);
        return project;
    }

    private static final MacroExpansionProject loadProject$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return (MacroExpansionProject)$tmp0.invoke(p0, p1);
    }

    private static final boolean buildCratesForProject$lambda$0(VirtualFile it2) {
        return it2.isDirectory();
    }

    private static final Sequence buildCratesForProject$lambda$1(VirtualFile it2) {
        VirtualFile[] virtualFileArray = it2.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
        return SequencesKt.flatMapIterable((Sequence)SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])virtualFileArray), MacroExpansionFileSystem::buildCratesForProject$lambda$1$0), MacroExpansionFileSystem::buildCratesForProject$lambda$1$1);
    }

    private static final boolean buildCratesForProject$lambda$1$0(VirtualFile it2) {
        return it2.isDirectory();
    }

    /*
     * WARNING - void declaration
     */
    private static final Iterable buildCratesForProject$lambda$1$1(VirtualFile it2) {
        void $this$filterTo$iv$iv;
        VirtualFile[] virtualFileArray = it2.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
        Object[] $this$filter$iv = virtualFileArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile it3 = (VirtualFile)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it3);
            if (!VirtualFileUtil.isFile((VirtualFile)it3)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final void releaseExpansionDirectory$lambda$0(MacroExpansionFileSystem this$0, String $projectPath) {
        this$0.getInternalFS().makeDummy($projectPath);
    }

    private static final void applyToVfs$lambda$2(ArrayList $newDirtyExpansions, MacroExpansionFileSystem this$0, ArrayList $newObsoletePaths, Runnable $callback) {
        block3: {
            VirtualFile virtualFile;
            Iterator iterator2 = $newDirtyExpansions.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
            Iterator iterator3 = iterator2;
            while (iterator3.hasNext()) {
                MacroExpansionFile expansion = (MacroExpansionFile)iterator3.next();
                virtualFile = this$0.findVirtualFile(expansion.getPath());
                if (virtualFile == null) {
                    MacroExpansionManagerKt.MACRO_LOG.warn("Failed to find virtual file for dirty expansion " + expansion.getPath());
                    continue;
                }
                MacroExpansionFileSystemKt.setMacroExpansionName(virtualFile, expansion.getName());
            }
            Iterator iterator4 = $newObsoletePaths.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator4, (String)"iterator(...)");
            iterator3 = iterator4;
            while (iterator3.hasNext()) {
                String obsoletePath = (String)iterator3.next();
                Intrinsics.checkNotNull((Object)obsoletePath);
                VirtualFile virtualFile2 = virtualFile = this$0.findVirtualFile(obsoletePath);
                if (virtualFile2 == null) continue;
                virtualFile2.delete((Object)TrustedRequestor.INSTANCE);
            }
            Runnable runnable = $callback;
            if (runnable == null) break block3;
            runnable.run();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\tJ\b\u0010\n\u001a\u0004\u0018\u00010\tJ'\u0010\u000b\u001a\u0002H\f\"\u0004\b\u0000\u0010\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\f0\u0010\u00a2\u0006\u0002\u0010\u0011J\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0013J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lorg/rust/lang/core/macros/filesystem/MacroExpansionFileSystem$Helper;", "", "<init>", "()V", "macroExpansionNameFileAttribute", "Lcom/intellij/openapi/vfs/newvfs/FileAttribute;", "getMacroExpansionNameFileAttribute", "()Lcom/intellij/openapi/vfs/newvfs/FileAttribute;", "getInstance", "Lorg/rust/lang/core/macros/filesystem/MacroExpansionFileSystem;", "getInstanceOrNull", "withAllowedWriting", "T", "file", "Lorg/rust/lang/core/macros/filesystem/MacroExpansionFileSystem$MacroExpansionFile;", "f", "Lkotlin/Function0;", "(Lorg/rust/lang/core/macros/filesystem/MacroExpansionFileSystem$MacroExpansionFile;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "loadProjectDirs", "", "saveProjectDirs", "isExpansionFile", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.rustrover.core"})
    @SourceDebugExtension(value={"SMAP\nMacroExpansionFileSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MacroExpansionFileSystem.kt\norg/rust/lang/core/macros/filesystem/MacroExpansionFileSystem$Helper\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,1101:1\n42#2,3:1102\n50#2:1105\n*S KotlinDebug\n*F\n+ 1 MacroExpansionFileSystem.kt\norg/rust/lang/core/macros/filesystem/MacroExpansionFileSystem$Helper\n*L\n251#1:1102,3\n255#1:1105\n*E\n"})
    public static final class Helper {
        @NotNull
        public static final Helper INSTANCE = new Helper();
        @NotNull
        private static final FileAttribute macroExpansionNameFileAttribute = new FileAttribute("rust.macro.expansion.name", 1, false);

        private Helper() {
        }

        @NotNull
        public final FileAttribute getMacroExpansionNameFileAttribute() {
            return macroExpansionNameFileAttribute;
        }

        @NotNull
        public final MacroExpansionFileSystem getInstance() {
            boolean $i$f$service = false;
            Class<MacroExpansionFileSystem> serviceClass$iv = MacroExpansionFileSystem.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (MacroExpansionFileSystem)object;
        }

        @Nullable
        public final MacroExpansionFileSystem getInstanceOrNull() {
            boolean $i$f$serviceOrNull = false;
            Application application = ApplicationManager.getApplication();
            return (MacroExpansionFileSystem)(application != null ? application.getService(MacroExpansionFileSystem.class) : null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final <T> T withAllowedWriting(@NotNull MacroExpansionFile file, @NotNull Function0<? extends T> f) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter(f, (String)"f");
            MacroExpansionInternalFileSystem.Helper.INSTANCE.setAllowWriting(file.getVirtualFile(), true);
            try {
                Object object = f.invoke();
                return (T)object;
            }
            finally {
                MacroExpansionInternalFileSystem.Helper.INSTANCE.setAllowWriting(file.getVirtualFile(), false);
            }
        }

        public final void loadProjectDirs() {
            MacroExpansionFileSystemRootsLoader.INSTANCE.loadProjectDirs();
        }

        public final void saveProjectDirs() {
            MacroExpansionFileSystemRootsLoader.INSTANCE.saveProjectDirs();
        }

        public final boolean isExpansionFile(@NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return file.getFileSystem() instanceof MacroExpansionInternalFileSystem;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B/\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0016J\u0014\u0010\u0017\u001a\u0004\u0018\u00010\b2\n\u0010\u0018\u001a\u00060\u0007j\u0002`\u0019J\u000e\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u0007J\u0016\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0007J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\bJ\b\u0010)\u001a\u00020\u0007H\u0002J\u0010\u0010*\u001a\u00020\u00072\u0006\u0010+\u001a\u00020\u0007H\u0002J\u0016\u0010,\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010-\u001a\u00020\u0007R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010 \u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0013\u0010#\u001a\u0004\u0018\u00010$8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0011\u0010'\u001a\u00020$8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010&\u00a8\u0006."}, d2={"Lorg/rust/lang/core/macros/filesystem/MacroExpansionFileSystem$MacroExpansionCrate;", "", "id", "", "Lorg/rust/lang/core/crate/CratePersistentId;", "expansions", "", "", "Lorg/rust/lang/core/macros/filesystem/MacroExpansionFileSystem$MacroExpansionFile;", "project", "Lorg/rust/lang/core/macros/filesystem/MacroExpansionFileSystem$MacroExpansionProject;", "<init>", "(ILjava/util/Map;Lorg/rust/lang/core/macros/filesystem/MacroExpansionFileSystem$MacroExpansionProject;)V", "getId", "()I", "getProject", "()Lorg/rust/lang/core/macros/filesystem/MacroExpansionFileSystem$MacroExpansionProject;", "macroExpansionFS", "Lorg/rust/lang/core/macros/filesystem/MacroExpansionFileSystem;", "getMacroExpansionFS", "()Lorg/rust/lang/core/macros/filesystem/MacroExpansionFileSystem;", "getExpansions", "", "findFile", "expansionFileName", "Lorg/rust/lang/core/resolve2/MacroExpansionFileName;", "addExpansion", "expansionName", "virtualFileName", "deleteExpansion", "", "file", "path", "getPath", "()Ljava/lang/String;", "virtualFileOrNull", "Lcom/intellij/openapi/vfs/VirtualFile;", "getVirtualFileOrNull", "()Lcom/intellij/openapi/vfs/VirtualFile;", "virtualFile", "getVirtualFile", "generateInternalName", "withParentDirectories", "filename", "renameFile", "newName", "intellij.rustrover.core"})
    public static final class MacroExpansionCrate {
        private final int id;
        @NotNull
        private final Map<String, MacroExpansionFile> expansions;
        @NotNull
        private final MacroExpansionProject project;

        public MacroExpansionCrate(int id, @NotNull Map<String, MacroExpansionFile> expansions, @NotNull MacroExpansionProject project) {
            Intrinsics.checkNotNullParameter(expansions, (String)"expansions");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.id = id;
            this.expansions = expansions;
            this.project = project;
        }

        public final int getId() {
            return this.id;
        }

        @NotNull
        public final MacroExpansionProject getProject() {
            return this.project;
        }

        private final MacroExpansionFileSystem getMacroExpansionFS() {
            return Helper.INSTANCE.getInstance();
        }

        @NotNull
        public final synchronized Map<String, MacroExpansionFile> getExpansions() {
            return this.expansions;
        }

        @Nullable
        public final synchronized MacroExpansionFile findFile(@NotNull String expansionFileName) {
            Intrinsics.checkNotNullParameter((Object)expansionFileName, (String)"expansionFileName");
            return this.expansions.get(expansionFileName);
        }

        @NotNull
        public final synchronized MacroExpansionFile addExpansion(@NotNull String expansionName) {
            Intrinsics.checkNotNullParameter((Object)expansionName, (String)"expansionName");
            String newName = this.generateInternalName();
            MacroExpansionFile expansion = new MacroExpansionFile(expansionName, newName, this);
            this.expansions.put(expansionName, expansion);
            return expansion;
        }

        @NotNull
        public final synchronized MacroExpansionFile addExpansion(@NotNull String expansionName, @NotNull String virtualFileName) {
            Intrinsics.checkNotNullParameter((Object)expansionName, (String)"expansionName");
            Intrinsics.checkNotNullParameter((Object)virtualFileName, (String)"virtualFileName");
            MacroExpansionFile expansion = new MacroExpansionFile(expansionName, this.withParentDirectories(virtualFileName), this);
            this.expansions.put(expansionName, expansion);
            return expansion;
        }

        public final synchronized void deleteExpansion(@NotNull MacroExpansionFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            this.expansions.remove(file.getName());
            this.getMacroExpansionFS().deleteFile(file.getPath());
            this.getMacroExpansionFS().markDirty(file);
        }

        @NotNull
        public final String getPath() {
            return this.project.getPath() + "/" + this.id;
        }

        @Nullable
        public final VirtualFile getVirtualFileOrNull() {
            return this.getMacroExpansionFS().findVirtualFile(this.getPath());
        }

        @NotNull
        public final VirtualFile getVirtualFile() {
            VirtualFile virtualFile = this.getVirtualFileOrNull();
            if (virtualFile == null) {
                throw new IllegalStateException(("Cannot find virtual file for crate " + this.getPath()).toString());
            }
            return virtualFile;
        }

        private final String generateInternalName() {
            String randomName = StringKt.randomLowercaseAlphabetic(16);
            String path = this.withParentDirectories(randomName);
            return path + ".rs";
        }

        private final String withParentDirectories(String filename) {
            Pair pair = TuplesKt.to((Object)Character.valueOf(filename.charAt(0)), (Object)Character.valueOf(filename.charAt(1)));
            char first = ((Character)pair.component1()).charValue();
            char second = ((Character)pair.component2()).charValue();
            return first + "/" + second + "/" + filename;
        }

        public final synchronized void renameFile(@NotNull MacroExpansionFile file, @NotNull String newName) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
            MacroExpansionFileSystemKt.setMacroExpansionName(file.getVirtualFile(), newName);
            this.expansions.remove(file.getName());
            file.setName(newName);
            this.expansions.put(file.getName(), file);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0003J\u0006\u0010\u0017\u001a\u00020\u0018R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0019\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\nR\u0013\u0010\u001b\u001a\u0004\u0018\u00010\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001e\u00a8\u0006!"}, d2={"Lorg/rust/lang/core/macros/filesystem/MacroExpansionFileSystem$MacroExpansionFile;", "", "name", "", "internalFileSystemName", "crate", "Lorg/rust/lang/core/macros/filesystem/MacroExpansionFileSystem$MacroExpansionCrate;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lorg/rust/lang/core/macros/filesystem/MacroExpansionFileSystem$MacroExpansionCrate;)V", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "getCrate", "()Lorg/rust/lang/core/macros/filesystem/MacroExpansionFileSystem$MacroExpansionCrate;", "macroExpansionFS", "Lorg/rust/lang/core/macros/filesystem/MacroExpansionFileSystem;", "getMacroExpansionFS", "()Lorg/rust/lang/core/macros/filesystem/MacroExpansionFileSystem;", "delete", "", "rename", "newName", "getOutputStream", "Ljava/io/OutputStream;", "path", "getPath", "virtualFileOrNull", "Lcom/intellij/openapi/vfs/VirtualFile;", "getVirtualFileOrNull", "()Lcom/intellij/openapi/vfs/VirtualFile;", "virtualFile", "getVirtualFile", "intellij.rustrover.core"})
    public static final class MacroExpansionFile {
        @NotNull
        private volatile String name;
        @NotNull
        private final String internalFileSystemName;
        @NotNull
        private final MacroExpansionCrate crate;

        public MacroExpansionFile(@NotNull String name2, @NotNull String internalFileSystemName, @NotNull MacroExpansionCrate crate) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)internalFileSystemName, (String)"internalFileSystemName");
            Intrinsics.checkNotNullParameter((Object)crate, (String)"crate");
            this.name = name2;
            this.internalFileSystemName = internalFileSystemName;
            this.crate = crate;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final void setName(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.name = string;
        }

        @NotNull
        public final MacroExpansionCrate getCrate() {
            return this.crate;
        }

        private final MacroExpansionFileSystem getMacroExpansionFS() {
            return Helper.INSTANCE.getInstance();
        }

        public final void delete() {
            this.crate.deleteExpansion(this);
        }

        public final void rename(@NotNull String newName) {
            Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
            this.crate.renameFile(this, newName);
        }

        @NotNull
        public final OutputStream getOutputStream() {
            OutputStream outputStream = this.getVirtualFile().getOutputStream((Object)TrustedRequestor.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"getOutputStream(...)");
            return outputStream;
        }

        @NotNull
        public final String getPath() {
            return this.crate.getPath() + "/" + this.internalFileSystemName;
        }

        @Nullable
        public final VirtualFile getVirtualFileOrNull() {
            return this.getMacroExpansionFS().findVirtualFile(this.getPath());
        }

        @NotNull
        public final VirtualFile getVirtualFile() {
            VirtualFile virtualFile = this.getVirtualFileOrNull();
            if (virtualFile == null) {
                throw new IllegalStateException(("Cannot find virtual file for expansion " + this.getPath()).toString());
            }
            return virtualFile;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\n\n\u0002\u0010\u0012\n\u0002\b\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\u0010\u0004\u001a\u0012\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0007J\u0006\u0010\u0017\u001a\u00020\u0016J\u0006\u0010\u0018\u001a\u00020\u0016J\u0016\u0010\u0019\u001a\u0012\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0012\u0004\u0012\u00020\b0\u001aJ\u0014\u0010\u001b\u001a\u0004\u0018\u00010\b2\n\u0010\u001c\u001a\u00060\u0006j\u0002`\u0007J\u0012\u0010\u001d\u001a\u00020\b2\n\u0010\u001c\u001a\u00060\u0006j\u0002`\u0007J\u000e\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\bJ\"\u0010 \u001a\u00020\u00162\n\u0010\u001f\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u0006J\"\u0010#\u001a\u00020\u00162\n\u0010\u001f\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010!\u001a\u00020\u00032\u0006\u0010$\u001a\u00020%R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\u0004\u001a\u0012\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010&\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\fR\u0013\u0010(\u001a\u0004\u0018\u00010\u00148F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0011\u0010+\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b,\u0010*\u00a8\u0006-"}, d2={"Lorg/rust/lang/core/macros/filesystem/MacroExpansionFileSystem$MacroExpansionProject;", "", "id", "", "crates", "", "", "Lorg/rust/lang/core/crate/CratePersistentId;", "Lorg/rust/lang/core/macros/filesystem/MacroExpansionFileSystem$MacroExpansionCrate;", "<init>", "(Ljava/lang/String;Ljava/util/Map;)V", "getId", "()Ljava/lang/String;", "macroExpansionFS", "Lorg/rust/lang/core/macros/filesystem/MacroExpansionFileSystem;", "getMacroExpansionFS", "()Lorg/rust/lang/core/macros/filesystem/MacroExpansionFileSystem;", "isOwnsVirtualFile", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "markDirtyAndRefresh", "", "clean", "init", "getCrates", "", "findCrate", "crateId", "addCrate", "deleteCrate", "crate", "createFileWithImplicitContent", "expansionName", "size", "createFileWithExplicitContent", "byteArray", "", "path", "getPath", "virtualFileOrNull", "getVirtualFileOrNull", "()Lcom/intellij/openapi/vfs/VirtualFile;", "virtualFile", "getVirtualFile", "intellij.rustrover.core"})
    public static final class MacroExpansionProject {
        @NotNull
        private final String id;
        @NotNull
        private final Map<Integer, MacroExpansionCrate> crates;
        @NotNull
        private final String path;

        public MacroExpansionProject(@NotNull String id, @NotNull Map<Integer, MacroExpansionCrate> crates) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter(crates, (String)"crates");
            this.id = id;
            this.crates = crates;
            this.path = MacroExpansionFileSystemKt.access$projectExpansionPath(this.id);
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        private final MacroExpansionFileSystem getMacroExpansionFS() {
            return Helper.INSTANCE.getInstance();
        }

        public final boolean isOwnsVirtualFile(@NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return VfsUtil.isAncestor((VirtualFile)this.getVirtualFile(), (VirtualFile)file, (boolean)true);
        }

        @RequiresWriteLock
        public final void markDirtyAndRefresh() {
            VirtualFile[] virtualFileArray = new VirtualFile[]{this.getVirtualFile()};
            VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])virtualFileArray);
        }

        public final synchronized void clean() {
            this.crates.clear();
            MacroExpansionInternalFileSystem internalFS = MacroExpansionInternalFileSystem.Helper.INSTANCE.getInstance();
            MacroExpansionInternalFileSystem.cleanDirectoryIfExists$default(internalFS, this.path, false, 2, null);
        }

        public final synchronized void init() {
            MacroExpansionInternalFileSystem internalFS = MacroExpansionInternalFileSystem.Helper.INSTANCE.getInstance();
            internalFS.createDirectoryIfNotExistsOrDummy(this.path);
        }

        @NotNull
        public final synchronized Map<Integer, MacroExpansionCrate> getCrates() {
            return this.crates;
        }

        @Nullable
        public final synchronized MacroExpansionCrate findCrate(int crateId) {
            return this.crates.get(crateId);
        }

        @NotNull
        public final synchronized MacroExpansionCrate addCrate(int crateId) {
            MacroExpansionCrate crate = new MacroExpansionCrate(crateId, new LinkedHashMap(), this);
            this.crates.put(crateId, crate);
            return crate;
        }

        public final synchronized void deleteCrate(@NotNull MacroExpansionCrate crate) {
            Intrinsics.checkNotNullParameter((Object)crate, (String)"crate");
            this.crates.remove(crate.getId());
            this.getMacroExpansionFS().deleteFile(crate.getPath());
        }

        public final synchronized void createFileWithImplicitContent(int crate, @NotNull String expansionName, int size) {
            Intrinsics.checkNotNullParameter((Object)expansionName, (String)"expansionName");
            this.getMacroExpansionFS().createFileWithImplicitContent(this, crate, expansionName, size);
        }

        public final synchronized void createFileWithExplicitContent(int crate, @NotNull String expansionName, @NotNull byte[] byteArray) {
            Intrinsics.checkNotNullParameter((Object)expansionName, (String)"expansionName");
            Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
            this.getMacroExpansionFS().createFileWithExplicitContent(this, crate, expansionName, byteArray);
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        @Nullable
        public final VirtualFile getVirtualFileOrNull() {
            return this.getMacroExpansionFS().findVirtualFile(this.path);
        }

        @NotNull
        public final VirtualFile getVirtualFile() {
            VirtualFile virtualFile = this.getVirtualFileOrNull();
            if (virtualFile == null) {
                throw new IllegalStateException("Can't find virtual file for project " + this.path);
            }
            return virtualFile;
        }
    }
}

