/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.macros.errors;

import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.rust.lang.core.macros.decl.FragmentKind;
import org.rust.lang.core.macros.errors.BuiltinMacroExpansionError;
import org.rust.lang.core.macros.errors.DeclMacroExpansionError;
import org.rust.lang.core.macros.errors.MacroExpansionError;
import org.rust.lang.core.macros.errors.MacroMatchingError;
import org.rust.lang.core.macros.errors.ProcMacroExpansionError;
import org.rust.stdext.IoKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\n\u0010\u0005\u001a\u00020\u0004*\u00020\u0006\u001a\u0014\u0010\u0007\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\f\u0010\n\u001a\u00020\t*\u00020\u0006H\u0002\u001a\n\u0010\u000b\u001a\u00020\f*\u00020\u0004\u00a8\u0006\r"}, d2={"writeMacroExpansionError", "", "Ljava/io/DataOutput;", "err", "Lorg/rust/lang/core/macros/errors/MacroExpansionError;", "readMacroExpansionError", "Ljava/io/DataInput;", "saveMatchingError", "value", "Lorg/rust/lang/core/macros/errors/MacroMatchingError;", "readMatchingError", "canCacheError", "", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nMacroExpansionError.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MacroExpansionError.kt\norg/rust/lang/core/macros/errors/MacroExpansionErrorKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 io.kt\norg/rust/stdext/IoKt\n*L\n1#1,218:1\n1563#2:219\n1634#2,3:220\n28#3:223\n*S KotlinDebug\n*F\n+ 1 MacroExpansionError.kt\norg/rust/lang/core/macros/errors/MacroExpansionErrorKt\n*L\n136#1:219\n136#1:220,3\n201#1:223\n*E\n"})
public final class MacroExpansionErrorKt {
    public static final void writeMacroExpansionError(@NotNull DataOutput $this$writeMacroExpansionError, @NotNull MacroExpansionError err) throws IOException {
        block26: {
            MacroExpansionError macroExpansionError;
            block29: {
                block28: {
                    block27: {
                        block25: {
                            int n;
                            Intrinsics.checkNotNullParameter((Object)$this$writeMacroExpansionError, (String)"<this>");
                            Intrinsics.checkNotNullParameter((Object)err, (String)"err");
                            macroExpansionError = err;
                            if (macroExpansionError instanceof DeclMacroExpansionError.Matching) {
                                n = 0;
                            } else if (Intrinsics.areEqual((Object)macroExpansionError, (Object)DeclMacroExpansionError.DefSyntax.INSTANCE)) {
                                n = 1;
                            } else if (macroExpansionError instanceof ProcMacroExpansionError.ServerSideError) {
                                n = 2;
                            } else if (macroExpansionError instanceof ProcMacroExpansionError.ProcessAborted) {
                                n = 3;
                            } else if (macroExpansionError instanceof ProcMacroExpansionError.IOExceptionThrown) {
                                n = 4;
                            } else if (macroExpansionError instanceof ProcMacroExpansionError.Timeout) {
                                n = 5;
                            } else if (macroExpansionError instanceof ProcMacroExpansionError.UnsupportedExpanderVersion) {
                                n = 6;
                            } else if (Intrinsics.areEqual((Object)macroExpansionError, (Object)ProcMacroExpansionError.CantRunExpander.INSTANCE)) {
                                n = 7;
                            } else if (Intrinsics.areEqual((Object)macroExpansionError, (Object)ProcMacroExpansionError.ExecutableNotFound.INSTANCE)) {
                                n = 8;
                            } else if (Intrinsics.areEqual((Object)macroExpansionError, (Object)ProcMacroExpansionError.ProcMacroExpansionIsDisabled.INSTANCE)) {
                                n = 9;
                            } else if (Intrinsics.areEqual((Object)macroExpansionError, (Object)BuiltinMacroExpansionError.INSTANCE)) {
                                n = 10;
                            } else if (Intrinsics.areEqual((Object)macroExpansionError, (Object)DeclMacroExpansionError.TooLargeExpansion.INSTANCE)) {
                                n = 11;
                            } else {
                                throw new NoWhenBranchMatchedException();
                            }
                            int ordinal = n;
                            $this$writeMacroExpansionError.writeByte(ordinal);
                            macroExpansionError = err;
                            if (!(macroExpansionError instanceof DeclMacroExpansionError.Matching)) break block25;
                            IoKt.writeVarInt($this$writeMacroExpansionError, ((DeclMacroExpansionError.Matching)err).getErrors().size());
                            for (MacroMatchingError error : ((DeclMacroExpansionError.Matching)err).getErrors()) {
                                MacroExpansionErrorKt.saveMatchingError($this$writeMacroExpansionError, error);
                            }
                            break block26;
                        }
                        if (!(macroExpansionError instanceof ProcMacroExpansionError.ServerSideError)) break block27;
                        IOUtil.writeUTF((DataOutput)$this$writeMacroExpansionError, (String)((ProcMacroExpansionError.ServerSideError)err).getMessage());
                        break block26;
                    }
                    if (!(macroExpansionError instanceof ProcMacroExpansionError.ProcessAborted)) break block28;
                    $this$writeMacroExpansionError.writeInt(((ProcMacroExpansionError.ProcessAborted)err).getExitCode());
                    break block26;
                }
                if (!(macroExpansionError instanceof ProcMacroExpansionError.Timeout)) break block29;
                $this$writeMacroExpansionError.writeLong(((ProcMacroExpansionError.Timeout)err).getTimeout());
                break block26;
            }
            if (!(macroExpansionError instanceof ProcMacroExpansionError.UnsupportedExpanderVersion)) break block26;
            $this$writeMacroExpansionError.writeInt(((ProcMacroExpansionError.UnsupportedExpanderVersion)err).getVersion());
        }
    }

    @NotNull
    public static final MacroExpansionError readMacroExpansionError(@NotNull DataInput $this$readMacroExpansionError) throws IOException {
        Intrinsics.checkNotNullParameter((Object)$this$readMacroExpansionError, (String)"<this>");
        int ordinal = $this$readMacroExpansionError.readUnsignedByte();
        return switch (ordinal) {
            case 0 -> {
                void $this$mapTo$iv$iv;
                int size = IoKt.readVarInt($this$readMacroExpansionError);
                Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)size);
                boolean $i$f$map = false;
                Iterable var5_5 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator var8_8 = $this$mapTo$iv$iv.iterator();
                while (var8_8.hasNext()) {
                    int item$iv$iv;
                    int var10_10 = item$iv$iv = ((IntIterator)var8_8).nextInt();
                    Collection var12_12 = destination$iv$iv;
                    boolean $i$a$-map-MacroExpansionErrorKt$readMacroExpansionError$1 = false;
                    var12_12.add(MacroExpansionErrorKt.readMatchingError($this$readMacroExpansionError));
                }
                List var13_13 = (List)destination$iv$iv;
                yield new DeclMacroExpansionError.Matching(var13_13);
            }
            case 1 -> DeclMacroExpansionError.DefSyntax.INSTANCE;
            case 2 -> {
                String v1 = IOUtil.readUTF((DataInput)$this$readMacroExpansionError);
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"readUTF(...)");
                yield new ProcMacroExpansionError.ServerSideError(v1);
            }
            case 3 -> new ProcMacroExpansionError.ProcessAborted($this$readMacroExpansionError.readInt());
            case 4 -> ProcMacroExpansionError.IOExceptionThrown.INSTANCE;
            case 5 -> new ProcMacroExpansionError.Timeout($this$readMacroExpansionError.readLong());
            case 6 -> new ProcMacroExpansionError.UnsupportedExpanderVersion($this$readMacroExpansionError.readInt());
            case 7 -> ProcMacroExpansionError.CantRunExpander.INSTANCE;
            case 8 -> ProcMacroExpansionError.ExecutableNotFound.INSTANCE;
            case 9 -> ProcMacroExpansionError.ProcMacroExpansionIsDisabled.INSTANCE;
            case 10 -> BuiltinMacroExpansionError.INSTANCE;
            case 11 -> DeclMacroExpansionError.TooLargeExpansion.INSTANCE;
            default -> throw new IOException("Unknown expansion error code " + ordinal);
        };
    }

    private static final void saveMatchingError(DataOutput $this$saveMatchingError, MacroMatchingError value) throws IOException {
        block17: {
            MacroMatchingError macroMatchingError;
            block18: {
                block16: {
                    int n;
                    macroMatchingError = value;
                    if (macroMatchingError instanceof MacroMatchingError.PatternSyntax) {
                        n = 0;
                    } else if (macroMatchingError instanceof MacroMatchingError.ExtraInput) {
                        n = 1;
                    } else if (macroMatchingError instanceof MacroMatchingError.EndOfInput) {
                        n = 2;
                    } else if (macroMatchingError instanceof MacroMatchingError.UnmatchedToken) {
                        n = 3;
                    } else if (macroMatchingError instanceof MacroMatchingError.FragmentIsNotParsed) {
                        n = 4;
                    } else if (macroMatchingError instanceof MacroMatchingError.EmptyGroup) {
                        n = 5;
                    } else if (macroMatchingError instanceof MacroMatchingError.TooFewGroupElements) {
                        n = 6;
                    } else if (macroMatchingError instanceof MacroMatchingError.Nesting) {
                        n = 7;
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    int ordinal = n;
                    $this$saveMatchingError.writeByte(ordinal);
                    IoKt.writeVarInt($this$saveMatchingError, value.getOffsetInCallBody());
                    macroMatchingError = value;
                    if (!(macroMatchingError instanceof MacroMatchingError.UnmatchedToken)) break block16;
                    IOUtil.writeUTF((DataOutput)$this$saveMatchingError, (String)((MacroMatchingError.UnmatchedToken)value).getExpectedTokenType());
                    IOUtil.writeUTF((DataOutput)$this$saveMatchingError, (String)((MacroMatchingError.UnmatchedToken)value).getExpectedTokenText());
                    IOUtil.writeUTF((DataOutput)$this$saveMatchingError, (String)((MacroMatchingError.UnmatchedToken)value).getActualTokenType());
                    IOUtil.writeUTF((DataOutput)$this$saveMatchingError, (String)((MacroMatchingError.UnmatchedToken)value).getActualTokenText());
                    break block17;
                }
                if (!(macroMatchingError instanceof MacroMatchingError.FragmentIsNotParsed)) break block18;
                IOUtil.writeUTF((DataOutput)$this$saveMatchingError, (String)((MacroMatchingError.FragmentIsNotParsed)value).getVariableName());
                IoKt.writeEnum($this$saveMatchingError, (Enum)((MacroMatchingError.FragmentIsNotParsed)value).getKind());
                break block17;
            }
            if (!(macroMatchingError instanceof MacroMatchingError.Nesting)) break block17;
            IOUtil.writeUTF((DataOutput)$this$saveMatchingError, (String)((MacroMatchingError.Nesting)value).getVariableName());
        }
    }

    private static final MacroMatchingError readMatchingError(DataInput $this$readMatchingError) throws IOException {
        int ordinal = $this$readMatchingError.readUnsignedByte();
        int offsetInCallBody = IoKt.readVarInt($this$readMatchingError);
        return switch (ordinal) {
            case 0 -> new MacroMatchingError.PatternSyntax(offsetInCallBody);
            case 1 -> new MacroMatchingError.ExtraInput(offsetInCallBody);
            case 2 -> new MacroMatchingError.EndOfInput(offsetInCallBody);
            case 3 -> {
                String v1 = IOUtil.readUTF((DataInput)$this$readMatchingError);
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"readUTF(...)");
                String v2 = IOUtil.readUTF((DataInput)$this$readMatchingError);
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"readUTF(...)");
                String v3 = IOUtil.readUTF((DataInput)$this$readMatchingError);
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"readUTF(...)");
                String v4 = IOUtil.readUTF((DataInput)$this$readMatchingError);
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"readUTF(...)");
                yield new MacroMatchingError.UnmatchedToken(offsetInCallBody, v1, v2, v3, v4);
            }
            case 4 -> {
                String v5 = IOUtil.readUTF((DataInput)$this$readMatchingError);
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"readUTF(...)");
                DataInput $this$readEnum$iv = $this$readMatchingError;
                boolean $i$f$readEnum = false;
                yield new MacroMatchingError.FragmentIsNotParsed(offsetInCallBody, v5, FragmentKind.values()[$this$readEnum$iv.readUnsignedByte()]);
            }
            case 5 -> new MacroMatchingError.EmptyGroup(offsetInCallBody);
            case 6 -> new MacroMatchingError.TooFewGroupElements(offsetInCallBody);
            case 7 -> {
                String v6 = IOUtil.readUTF((DataInput)$this$readMatchingError);
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"readUTF(...)");
                yield new MacroMatchingError.Nesting(offsetInCallBody, v6);
            }
            default -> throw new IOException("Unknown matching error code " + ordinal);
        };
    }

    public static final boolean canCacheError(@NotNull MacroExpansionError $this$canCacheError) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$canCacheError, (String)"<this>");
        MacroExpansionError macroExpansionError = $this$canCacheError;
        if (macroExpansionError instanceof DeclMacroExpansionError) {
            bl = true;
        } else if (Intrinsics.areEqual((Object)macroExpansionError, (Object)BuiltinMacroExpansionError.INSTANCE)) {
            bl = true;
        } else if (macroExpansionError instanceof ProcMacroExpansionError) {
            bl = false;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }
}

