/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.macros.decl;

import com.intellij.lang.ASTNode;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.lang.core.macros.decl.MGNodeData;
import org.rust.lang.core.macros.decl.Matcher;
import org.rust.lang.core.psi.ext.RsMacroDefinitionBase;
import org.rust.lang.utils.Node;
import org.rust.lang.utils.PresentableGraph;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0013\u001a\u0016\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0018\u00010\u0007j\u0004\u0018\u0001`\nJ8\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\rj\u0002`\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0016\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\rj\u0002`\u000eH\u0002JY\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\rj\u0002`\u000e2\u0006\u0010\u0018\u001a\u00020\b22\u0010\u000b\u001a\u001a\u0012\u0016\b\u0001\u0012\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\rj\u0002`\u000e0\u0019\"\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\rj\u0002`\u000eH\u0002\u00a2\u0006\u0002\u0010\u001aJ8\u0010\u001b\u001a\u00020\t2\u0016\u0010\u001c\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\rj\u0002`\u000e2\u0016\u0010\u001d\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\rj\u0002`\u000eH\u0002J'\u0010\u001e\u001a\u00020\t2\u001c\u0010\u001f\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\rj\u0002`\u000e0 H\u0082\bJ \u0010\u001e\u001a\u00020\t2\u0016\u0010!\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\rj\u0002`\u000eH\u0002J\u0010\u0010\"\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000b\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\rj\u0002`\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\rj\u0002`\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\"\u0010\u0012\u001a\u0016\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0018\u00010\rj\u0004\u0018\u0001`\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/rust/lang/core/macros/decl/MacroGraphBuilder;", "", "macro", "Lorg/rust/lang/core/psi/ext/RsMacroDefinitionBase;", "<init>", "(Lorg/rust/lang/core/psi/ext/RsMacroDefinitionBase;)V", "graph", "Lorg/rust/lang/utils/PresentableGraph;", "Lorg/rust/lang/core/macros/decl/MGNodeData;", "", "Lorg/rust/lang/core/macros/decl/MacroGraph;", "preds", "Ljava/util/Deque;", "Lorg/rust/lang/utils/Node;", "Lorg/rust/lang/core/macros/decl/MacroGraphNode;", "pred", "getPred", "()Lorg/rust/lang/utils/Node;", "result", "build", "process", "matcher", "Lorg/rust/lang/core/macros/decl/Matcher;", "addNode", "nodeData", "", "(Lorg/rust/lang/core/macros/decl/MGNodeData;[Lorg/rust/lang/utils/Node;)Lorg/rust/lang/utils/Node;", "addEdge", "source", "target", "finishWith", "callable", "Lkotlin/Function0;", "value", "processMatcher", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nMacroGraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MacroGraph.kt\norg/rust/lang/core/macros/decl/MacroGraphBuilder\n+ 2 utils.kt\norg/rust/openapiext/UtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,131:1\n82#1,2:145\n82#1,2:147\n318#2,10:132\n1#3:142\n13805#4,2:143\n1803#5,3:149\n1563#5:152\n1634#5,3:153\n1803#5,3:158\n37#6,2:156\n*S KotlinDebug\n*F\n+ 1 MacroGraph.kt\norg/rust/lang/core/macros/decl/MacroGraphBuilder\n*L\n91#1:145,2\n93#1:147,2\n66#1:132,10\n73#1:143,2\n96#1:149,3\n102#1:152\n102#1:153,3\n117#1:158,3\n102#1:156,2\n*E\n"})
public final class MacroGraphBuilder {
    @NotNull
    private final RsMacroDefinitionBase macro;
    @NotNull
    private final PresentableGraph<MGNodeData, Unit> graph;
    @NotNull
    private final Deque<Node<MGNodeData, Unit>> preds;
    @Nullable
    private Node<MGNodeData, Unit> result;

    public MacroGraphBuilder(@NotNull RsMacroDefinitionBase macro) {
        Intrinsics.checkNotNullParameter((Object)macro, (String)"macro");
        this.macro = macro;
        this.graph = new PresentableGraph();
        this.preds = new ArrayDeque();
    }

    private final Node<MGNodeData, Unit> getPred() {
        Node<MGNodeData, Unit> node = this.preds.peek();
        Intrinsics.checkNotNullExpressionValue(node, (String)"peek(...)");
        return node;
    }

    @Nullable
    public final PresentableGraph<MGNodeData, Unit> build() {
        Matcher matcher = Matcher.Companion.buildFor(this.macro);
        if (matcher == null) {
            return null;
        }
        Matcher matcher2 = matcher;
        Node<MGNodeData, Unit> start2 = this.addNode(MGNodeData.Start.INSTANCE, new Node[0]);
        Node<MGNodeData, Unit> exit = this.process(matcher2, start2);
        Node[] nodeArray = new Node[]{exit};
        this.addNode(MGNodeData.End.INSTANCE, nodeArray);
        return this.graph;
    }

    private final Node<MGNodeData, Unit> process(Matcher matcher, Node<MGNodeData, Unit> pred) {
        this.result = null;
        int oldPredsSize = this.preds.size();
        this.preds.push(pred);
        this.processMatcher(matcher);
        this.preds.pop();
        boolean $i$f$weakAssert = false;
        boolean $i$f$weakAssert2 = false;
        if (UtilsKt.isUnitTestMode() || UtilsKt.isInternal()) {
            boolean bl = false;
            if (!(this.preds.size() == oldPredsSize)) {
                boolean bl2 = false;
                String message$iv$iv = "Assertion failed";
                throw new AssertionError((Object)message$iv$iv);
            }
        }
        Node<MGNodeData, Unit> node = this.result;
        if (node == null) {
            boolean bl = false;
            String string = "Processing ended inconclusively";
            throw new IllegalStateException(string.toString());
        }
        return node;
    }

    private final Node<MGNodeData, Unit> addNode(MGNodeData nodeData, Node<MGNodeData, Unit> ... preds) {
        Node<MGNodeData, Unit> newNode = this.graph.addNode(nodeData);
        Node<MGNodeData, Unit>[] $this$forEach$iv = preds;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int j = 0; j < n; ++j) {
            Node<MGNodeData, Unit> element$iv;
            Node<MGNodeData, Unit> it2 = element$iv = $this$forEach$iv[j];
            boolean bl = false;
            this.addEdge(it2, newNode);
        }
        return newNode;
    }

    private final void addEdge(Node<MGNodeData, Unit> source, Node<MGNodeData, Unit> target) {
        this.graph.addEdge(source, target, Unit.INSTANCE);
    }

    private final void finishWith(Function0<Node<MGNodeData, Unit>> callable) {
        boolean $i$f$finishWith = false;
        this.result = (Node)callable.invoke();
    }

    private final void finishWith(Node<MGNodeData, Unit> value) {
        this.result = value;
    }

    /*
     * WARNING - void declaration
     */
    private final void processMatcher(Matcher matcher) {
        Matcher matcher2 = matcher;
        if (matcher2 instanceof Matcher.Fragment) {
            MacroGraphBuilder this_$iv = this;
            boolean $i$f$finishWith = false;
            MacroGraphBuilder macroGraphBuilder = this_$iv;
            boolean bl = false;
            Node[] nodeArray = new Node[]{this.getPred()};
            macroGraphBuilder.result = this.addNode(new MGNodeData.Fragment(((Matcher.Fragment)matcher).getKind()), nodeArray);
        } else if (matcher2 instanceof Matcher.Literal) {
            MacroGraphBuilder this_$iv = this;
            boolean $i$f$finishWith = false;
            MacroGraphBuilder macroGraphBuilder = this_$iv;
            boolean bl = false;
            Node[] nodeArray = new Node[]{this.getPred()};
            macroGraphBuilder.result = this.addNode(new MGNodeData.Literal(((Matcher.Literal)matcher).getValue()), nodeArray);
        } else if (matcher2 instanceof Matcher.Sequence) {
            void $this$fold$iv;
            Iterable $i$f$finishWith = ((Matcher.Sequence)matcher).getMatchers();
            Node<MGNodeData, Unit> initial$iv = this.getPred();
            boolean $i$f$fold = false;
            Node<MGNodeData, Unit> accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void subMatcher;
                Matcher matcher3 = (Matcher)element$iv;
                Node<MGNodeData, Unit> acc = accumulator$iv;
                boolean bl = false;
                accumulator$iv = this.process((Matcher)subMatcher, acc);
            }
            Node<MGNodeData, Unit> subMatchersExit = accumulator$iv;
            this.finishWith(subMatchersExit);
        } else if (matcher2 instanceof Matcher.Choice) {
            void $this$toTypedArray$iv;
            void $this$mapTo$iv$iv;
            Node[] $this$fold$iv = new Node[]{this.getPred()};
            Node<MGNodeData, Unit> branchStart = this.addNode(MGNodeData.BranchStart.INSTANCE, $this$fold$iv);
            Iterable $this$map$iv = ((Matcher.Choice)matcher).getMatchers();
            boolean $i$f$map = false;
            Iterable accumulator$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                Matcher bl = (Matcher)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(this.process((Matcher)it2, branchStart));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            Node[] variantsExits = thisCollection$iv.toArray(new Node[0]);
            Node<MGNodeData, Unit> branchEnd = this.addNode(MGNodeData.BranchEnd.INSTANCE, Arrays.copyOf(variantsExits, variantsExits.length));
            this.finishWith(branchEnd);
        } else if (matcher2 instanceof Matcher.Optional) {
            Node[] variantsExits = new Node[]{this.getPred()};
            Node<MGNodeData, Unit> branchStart = this.addNode(MGNodeData.BranchStart.INSTANCE, variantsExits);
            Node<MGNodeData, Unit> optMatcherExit = this.process(((Matcher.Optional)matcher).getMatcher(), branchStart);
            Node[] $i$f$toTypedArray = new Node[]{optMatcherExit};
            Node<MGNodeData, Unit> branchEnd2 = this.addNode(MGNodeData.BranchEnd.INSTANCE, $i$f$toTypedArray);
            this.addEdge(branchStart, branchEnd2);
            this.finishWith(branchEnd2);
        } else if (matcher2 instanceof Matcher.Repeat) {
            void $this$fold$iv;
            Node[] optMatcherExit = new Node[]{this.getPred()};
            Node[] branchEnd = this.addNode(MGNodeData.BranchEnd.INSTANCE, optMatcherExit);
            Iterable branchEnd2 = ((Matcher.Repeat)matcher).getMatchers();
            Node[] initial$iv = branchEnd;
            boolean $i$f$fold = false;
            Object accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void subMatcher;
                Matcher item$iv$iv = (Matcher)element$iv;
                Node[] acc = accumulator$iv;
                boolean bl = false;
                accumulator$iv = this.process((Matcher)subMatcher, (Node<MGNodeData, Unit>)acc);
            }
            Node[] subMatchersExit = accumulator$iv;
            initial$iv = new Node[]{subMatchersExit};
            Node<MGNodeData, Unit> branchStart = this.addNode(MGNodeData.BranchStart.INSTANCE, initial$iv);
            ASTNode separator = ((Matcher.Repeat)matcher).getSeparator();
            if (separator != null) {
                Node[] nodeArray = new Node[]{branchStart};
                Node<MGNodeData, Unit> separatorNode = this.addNode(new MGNodeData.Literal(separator), nodeArray);
                this.addEdge(separatorNode, (Node<MGNodeData, Unit>)branchEnd);
            } else {
                this.addEdge(branchStart, (Node<MGNodeData, Unit>)branchEnd);
            }
            this.finishWith(branchStart);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }
}

