/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.macros.builtin;

import com.intellij.lang.PsiBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.rust.cargo.project.workspace.CargoWorkspace;
import org.rust.lang.core.macros.MacroCallBody;
import org.rust.lang.core.macros.MacroExpander;
import org.rust.lang.core.macros.MappedText;
import org.rust.lang.core.macros.MutableMappedText;
import org.rust.lang.core.macros.RangeMap;
import org.rust.lang.core.macros.RsBuiltinMacroData;
import org.rust.lang.core.macros.RsMacroCallData;
import org.rust.lang.core.macros.builtin.BuiltinMacroExpanderKt;
import org.rust.lang.core.macros.decl.MacroPattern;
import org.rust.lang.core.macros.decl.MacroSubstitution;
import org.rust.lang.core.macros.decl.MetaVarValue;
import org.rust.lang.core.macros.errors.BuiltinMacroExpansionError;
import org.rust.lang.core.macros.errors.MacroMatchingError;
import org.rust.lang.core.parser.RustParser;
import org.rust.lang.core.parser.UtilKt;
import org.rust.lang.core.psi.RsCfgSelectBranch;
import org.rust.lang.core.psi.RsCfgSelectExpansionTT;
import org.rust.lang.core.psi.RsCfgSelectMacroArgument;
import org.rust.lang.core.psi.RsCfgSelectPredicate;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsFormatArgumentOwner;
import org.rust.lang.core.psi.RsMacroCase;
import org.rust.lang.core.psi.RsMacroPatternContents;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.ext.LazyCfgEvaluator;
import org.rust.lang.core.psi.ext.PsiElementKt;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.utils.evaluation.CfgEvaluator;
import org.rust.lang.utils.evaluation.ThreeValuedLogic;
import org.rust.stdext.RsResult;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001a2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u001aB\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J0\u0010\n\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u0012\u0004\u0012\u00020\u00030\u000b2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001b"}, d2={"Lorg/rust/lang/core/macros/builtin/BuiltinMacroExpander;", "Lorg/rust/lang/core/macros/MacroExpander;", "Lorg/rust/lang/core/macros/RsBuiltinMacroData;", "Lorg/rust/lang/core/macros/errors/BuiltinMacroExpansionError;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "expandMacroAsTextWithErr", "Lorg/rust/stdext/RsResult;", "Lkotlin/Pair;", "", "Lorg/rust/lang/core/macros/RangeMap;", "def", "call", "Lorg/rust/lang/core/macros/RsMacroCallData;", "expandOffsetOf", "Lorg/rust/lang/core/macros/MappedText;", "macroBody", "Lorg/rust/lang/core/macros/MacroCallBody$FunctionLike;", "expandCfg", "cfgLazyEvaluator", "Lorg/rust/lang/core/psi/ext/LazyCfgEvaluator;", "expandCfgSelect", "Companion", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nBuiltinMacroExpander.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuiltinMacroExpander.kt\norg/rust/lang/core/macros/builtin/BuiltinMacroExpander\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,232:1\n1#2:233\n*E\n"})
public final class BuiltinMacroExpander
extends MacroExpander<RsBuiltinMacroData, BuiltinMacroExpansionError> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Set<String> BUILTIN_FORMAT_MACROS;
    @NotNull
    public static final String OFFSET_OF_MACRO = "offset_of";
    @NotNull
    public static final String CFG_MACRO = "cfg";
    @NotNull
    public static final String CFG_SELECT_MACRO = "cfg_select";
    public static final int EXPANDER_VERSION = 8;

    public BuiltinMacroExpander(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public RsResult<Pair<CharSequence, RangeMap>, BuiltinMacroExpansionError> expandMacroAsTextWithErr(@NotNull RsBuiltinMacroData def, @NotNull RsMacroCallData call2) {
        RsResult rsResult;
        Intrinsics.checkNotNullParameter((Object)def, (String)"def");
        Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
        MacroCallBody macroBody = call2.getMacroBody();
        if (!(macroBody instanceof MacroCallBody.FunctionLike)) {
            return new RsResult.Err<BuiltinMacroExpansionError>(BuiltinMacroExpansionError.INSTANCE);
        }
        String string = def.getName();
        if (BUILTIN_FORMAT_MACROS.contains(string)) {
            RsFormatArgumentOwner rsFormatArgumentOwner = BuiltinMacroExpanderKt.access$parseMacroBodyAsFormat(this.project, def.getName(), (MacroCallBody.FunctionLike)macroBody);
            if (rsFormatArgumentOwner == null) {
                return new RsResult.Err<BuiltinMacroExpansionError>(BuiltinMacroExpansionError.INSTANCE);
            }
            RsFormatArgumentOwner formatMacro = rsFormatArgumentOwner;
            MappedText mappedText = BuiltinMacroExpanderKt.access$handleFormatMacro(def.getName(), ((MacroCallBody.FunctionLike)macroBody).getText(), formatMacro);
            if (mappedText == null) {
                return new RsResult.Err<BuiltinMacroExpansionError>(BuiltinMacroExpansionError.INSTANCE);
            }
            MappedText result2 = mappedText;
            rsResult = new RsResult.Ok<Pair>(TuplesKt.to((Object)result2.getText(), (Object)result2.getRanges()));
        } else if (Intrinsics.areEqual((Object)string, (Object)OFFSET_OF_MACRO)) {
            MappedText mappedText = this.expandOffsetOf((MacroCallBody.FunctionLike)macroBody);
            if (mappedText == null) {
                return new RsResult.Err<BuiltinMacroExpansionError>(BuiltinMacroExpansionError.INSTANCE);
            }
            MappedText res2 = mappedText;
            rsResult = new RsResult.Ok<Pair>(TuplesKt.to((Object)res2.getText(), (Object)res2.getRanges()));
        } else if (Intrinsics.areEqual((Object)string, (Object)CFG_MACRO)) {
            MappedText mappedText = this.expandCfg((MacroCallBody.FunctionLike)macroBody, call2.getCfgEvaluator());
            if (mappedText == null) {
                return new RsResult.Err<BuiltinMacroExpansionError>(BuiltinMacroExpansionError.INSTANCE);
            }
            MappedText res3 = mappedText;
            rsResult = new RsResult.Ok<Pair>(TuplesKt.to((Object)res3.getText(), (Object)res3.getRanges()));
        } else if (Intrinsics.areEqual((Object)string, (Object)CFG_SELECT_MACRO)) {
            MappedText mappedText = this.expandCfgSelect((MacroCallBody.FunctionLike)macroBody, call2.getCfgEvaluator());
            if (mappedText == null) {
                return new RsResult.Err<BuiltinMacroExpansionError>(BuiltinMacroExpansionError.INSTANCE);
            }
            MappedText res4 = mappedText;
            rsResult = new RsResult.Ok<Pair>(TuplesKt.to((Object)res4.getText(), (Object)res4.getRanges()));
        } else {
            rsResult = new RsResult.Err<BuiltinMacroExpansionError>(BuiltinMacroExpansionError.INSTANCE);
        }
        return rsResult;
    }

    private final MappedText expandOffsetOf(MacroCallBody.FunctionLike macroBody) {
        String text = macroBody.getText();
        PsiBuilder macroCallBody = UtilKt.createAdaptedRustPsiBuilder(this.project, text);
        macroCallBody.eof();
        RsMacroCase rsMacroCase = new RsPsiFactory(this.project, false, false, 6, null).createMacroCase("($ Container:ty, $($ fields:expr)+ $(,)?) => {}");
        Intrinsics.checkNotNull((Object)rsMacroCase);
        RsMacroPatternContents it2 = rsMacroCase.getMacroPattern().getMacroPatternContents();
        boolean $i$a$-let-BuiltinMacroExpander$expandOffsetOf$pattern$22 = false;
        MacroPattern pattern2 = MacroPattern.Companion.valueOf(it2, CargoWorkspace.Edition.EDITION_2021);
        RsResult<MacroSubstitution, MacroMatchingError> $i$a$-let-BuiltinMacroExpander$expandOffsetOf$pattern$22 = pattern2.match(macroCallBody);
        RsResult.Ok ok = $i$a$-let-BuiltinMacroExpander$expandOffsetOf$pattern$22 instanceof RsResult.Ok ? (RsResult.Ok)$i$a$-let-BuiltinMacroExpander$expandOffsetOf$pattern$22 : null;
        if (ok == null) {
            return null;
        }
        RsResult.Ok matchResult = ok;
        MutableMappedText macroCallBuilder = new MutableMappedText(text.length() * 2);
        macroCallBuilder.appendUnmapped("{\n    let _tmp = |_val:");
        MetaVarValue metaVarValue = ((MacroSubstitution)matchResult.getOk()).getVariables().get("Container");
        MetaVarValue.Fragment fragment = metaVarValue instanceof MetaVarValue.Fragment ? (MetaVarValue.Fragment)metaVarValue : null;
        if (fragment == null) {
            return null;
        }
        MetaVarValue.Fragment container = fragment;
        macroCallBuilder.appendMapped(container.getValue(), container.getOffsetInCallBody());
        macroCallBuilder.appendUnmapped("| _val.");
        MetaVarValue metaVarValue2 = ((MacroSubstitution)matchResult.getOk()).getVariables().get("fields");
        MetaVarValue.Group group2 = metaVarValue2 instanceof MetaVarValue.Group ? (MetaVarValue.Group)metaVarValue2 : null;
        if (group2 == null) {
            return null;
        }
        MetaVarValue.Group fields = group2;
        for (MetaVarValue field : fields.getNested()) {
            MetaVarValue.Fragment fragment2;
            if ((field instanceof MetaVarValue.Fragment ? (MetaVarValue.Fragment)field : null) == null) {
                return null;
            }
            fragment2 = fragment2;
            macroCallBuilder.appendMapped(fragment2.getValue(), fragment2.getOffsetInCallBody());
        }
        macroCallBuilder.appendUnmapped(";\n");
        macroCallBuilder.appendUnmapped("0usize\n");
        macroCallBuilder.appendUnmapped("};");
        return macroCallBuilder.toMappedText();
    }

    private final MappedText expandCfg(MacroCallBody.FunctionLike macroBody, LazyCfgEvaluator cfgLazyEvaluator) {
        PsiBuilder builder = UtilKt.createAdaptedRustPsiBuilder(this.project, macroBody.getText());
        boolean result2 = RustParser.CfgSelectPredicate(builder, 0);
        if (!result2) {
            return null;
        }
        if (!builder.eof()) {
            return null;
        }
        PsiElement psiElement2 = builder.getTreeBuilt().getPsi();
        RsCfgSelectPredicate rsCfgSelectPredicate = psiElement2 instanceof RsCfgSelectPredicate ? (RsCfgSelectPredicate)psiElement2 : null;
        if (rsCfgSelectPredicate == null) {
            return null;
        }
        RsCfgSelectPredicate predicate = rsCfgSelectPredicate;
        CfgEvaluator cfgEvaluator = cfgLazyEvaluator.createEvaluator();
        if (cfgEvaluator == null) {
            return null;
        }
        CfgEvaluator evaluator = cfgEvaluator;
        MutableMappedText macroBuilder = new MutableMappedText(5);
        switch (WhenMappings.$EnumSwitchMapping$0[evaluator.evaluate(predicate).ordinal()]) {
            case 1: {
                macroBuilder.appendUnmapped("true");
                break;
            }
            case 2: {
                macroBuilder.appendUnmapped("false");
                break;
            }
            case 3: {
                return null;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return macroBuilder.toMappedText();
    }

    private final MappedText expandCfgSelect(MacroCallBody.FunctionLike macroBody, LazyCfgEvaluator cfgLazyEvaluator) {
        String text = "{" + macroBody.getText() + "}";
        PsiBuilder builder = UtilKt.createAdaptedRustPsiBuilder(this.project, text);
        boolean result2 = RustParser.CfgSelectMacroArgument(builder, 0);
        if (!result2) {
            return null;
        }
        PsiElement psiElement2 = builder.getTreeBuilt().getPsi();
        RsCfgSelectMacroArgument rsCfgSelectMacroArgument = psiElement2 instanceof RsCfgSelectMacroArgument ? (RsCfgSelectMacroArgument)psiElement2 : null;
        if (rsCfgSelectMacroArgument == null) {
            return null;
        }
        RsCfgSelectMacroArgument cfgSelectArg = rsCfgSelectMacroArgument;
        CfgEvaluator cfgEvaluator = cfgLazyEvaluator.createEvaluator();
        if (cfgEvaluator == null) {
            return null;
        }
        CfgEvaluator evaluator = cfgEvaluator;
        for (RsCfgSelectBranch branch : cfgSelectArg.getCfgSelectBranchList()) {
            RsElement rsElement;
            RsCfgSelectPredicate rsCfgSelectPredicate = branch.getCfgSelectPredicate();
            Intrinsics.checkNotNullExpressionValue((Object)rsCfgSelectPredicate, (String)"getCfgSelectPredicate(...)");
            ThreeValuedLogic result3 = evaluator.evaluate(rsCfgSelectPredicate);
            if (!result3.isTrue()) continue;
            RsExpr rsExpr = branch.getExpr();
            if (rsExpr != null) {
                rsElement = rsExpr;
            } else {
                RsCfgSelectExpansionTT rsCfgSelectExpansionTT = branch.getCfgSelectExpansionTT();
                if (rsCfgSelectExpansionTT != null) {
                    rsElement = rsCfgSelectExpansionTT;
                } else {
                    return null;
                }
            }
            RsElement expansionElement = rsElement;
            MutableMappedText macroBuilder = new MutableMappedText(expansionElement.getText().length());
            int srcOffset = PsiElementKt.getStartOffset(expansionElement) - 1;
            String string = expansionElement.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            macroBuilder.appendMapped(string, srcOffset);
            return macroBuilder.toMappedText();
        }
        return null;
    }

    static {
        Object[] objectArray = new String[]{"assert", "format_args", "format_args_nl", "panic"};
        BUILTIN_FORMAT_MACROS = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/rust/lang/core/macros/builtin/BuiltinMacroExpander$Companion;", "", "<init>", "()V", "BUILTIN_FORMAT_MACROS", "", "", "getBUILTIN_FORMAT_MACROS", "()Ljava/util/Set;", "OFFSET_OF_MACRO", "CFG_MACRO", "CFG_SELECT_MACRO", "EXPANDER_VERSION", "", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<String> getBUILTIN_FORMAT_MACROS() {
            return BUILTIN_FORMAT_MACROS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ThreeValuedLogic.values().length];
            try {
                nArray[ThreeValuedLogic.True.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ThreeValuedLogic.False.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ThreeValuedLogic.Unknown.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

