/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.macros;

import com.intellij.openapi.util.TextRange;
import java.io.DataInput;
import java.io.DataOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.rust.lang.core.macros.ExpansionTextRange;
import org.rust.lang.core.macros.ExpansionTransparency;
import org.rust.lang.core.macros.MacroProducedTextRange;
import org.rust.lang.core.macros.MappedTextRange;
import org.rust.lang.core.macros.RangeMap;
import org.rust.stdext.IoKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0000\u001a\u0010\u0010\u0000\u001a\u0006\u0012\u0002\b\u00030\u0001*\u00020\u0002H\u0002\u001a\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0001H\u0002\u001a\u0012\u0010\u0016\u001a\u00020\t*\u00020\t2\u0006\u0010\u0017\u001a\u00020\b\u001a\u0012\u0010\u0018\u001a\u00020\t*\u00020\t2\u0006\u0010\u0017\u001a\u00020\b\u001a\u0012\u0010\u0019\u001a\u00020\t*\u00020\t2\u0006\u0010\u0017\u001a\u00020\b\u001a\u0012\u0010\u001a\u001a\u00020\u001b*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\b\u001a\u0012\u0010\u001d\u001a\u00020\u001b*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\b\u001a\u0012\u0010\u001e\u001a\u00020\t*\u00020\t2\u0006\u0010\u001f\u001a\u00020\b\u001a\u0016\u0010 \u001a\u0004\u0018\u00010\t*\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0010H\u0002\u001a \u0010!\u001a\u00020\u0004*\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00010\"2\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0001\"\u0015\u0010\u0007\u001a\u00020\b*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\"\u0019\u0010\f\u001a\u00020\b*\u0006\u0012\u0002\b\u00030\u00018F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\"\u0015\u0010\u000f\u001a\u00020\u0010*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\"\u0019\u0010\u0013\u001a\u00020\u0010*\u0006\u0012\u0002\b\u00030\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006#"}, d2={"readExpansionTextRange", "Lorg/rust/lang/core/macros/ExpansionTextRange;", "Ljava/io/DataInput;", "writeExpansionTextRange", "", "Ljava/io/DataOutput;", "range", "srcEndOffset", "", "Lorg/rust/lang/core/macros/MappedTextRange;", "getSrcEndOffset", "(Lorg/rust/lang/core/macros/MappedTextRange;)I", "dstEndOffset", "getDstEndOffset", "(Lorg/rust/lang/core/macros/ExpansionTextRange;)I", "srcRange", "Lcom/intellij/openapi/util/TextRange;", "getSrcRange", "(Lorg/rust/lang/core/macros/MappedTextRange;)Lcom/intellij/openapi/util/TextRange;", "dstRange", "getDstRange", "(Lorg/rust/lang/core/macros/ExpansionTextRange;)Lcom/intellij/openapi/util/TextRange;", "srcShiftLeft", "delta", "srcShiftRight", "shiftRight", "shiftDstRangesRight", "Lorg/rust/lang/core/macros/RangeMap;", "offset", "shiftSrcRangesRight", "withLength", "length", "dstIntersection", "mergeAdd", "", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRangeMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RangeMap.kt\norg/rust/lang/core/macros/RangeMapKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,301:1\n1563#2:302\n1634#2,3:303\n1563#2:306\n1634#2,3:307\n*S KotlinDebug\n*F\n+ 1 RangeMap.kt\norg/rust/lang/core/macros/RangeMapKt\n*L\n253#1:302\n253#1:303,3\n255#1:306\n255#1:307,3\n*E\n"})
public final class RangeMapKt {
    private static final ExpansionTextRange<?> readExpansionTextRange(DataInput $this$readExpansionTextRange) {
        int length = IoKt.readVarInt($this$readExpansionTextRange);
        int dstOffset = IoKt.readVarInt($this$readExpansionTextRange);
        if (length < 0) {
            ExpansionTransparency transparency = ExpansionTransparency.Companion.readFrom($this$readExpansionTextRange);
            return new MacroProducedTextRange(transparency, dstOffset, -length);
        }
        int srcOffset = IoKt.readVarInt($this$readExpansionTextRange);
        return new MappedTextRange(srcOffset, dstOffset, length);
    }

    private static final void writeExpansionTextRange(DataOutput $this$writeExpansionTextRange, ExpansionTextRange<?> range) {
        ExpansionTextRange<?> expansionTextRange = range;
        if (expansionTextRange instanceof MacroProducedTextRange) {
            IoKt.writeVarInt($this$writeExpansionTextRange, -((MacroProducedTextRange)range).getLength());
            IoKt.writeVarInt($this$writeExpansionTextRange, ((MacroProducedTextRange)range).getDstOffset());
            ExpansionTransparency.Companion.writeTo(((MacroProducedTextRange)range).getTransparency(), $this$writeExpansionTextRange);
        } else if (expansionTextRange instanceof MappedTextRange) {
            IoKt.writeVarInt($this$writeExpansionTextRange, ((MappedTextRange)range).getLength());
            IoKt.writeVarInt($this$writeExpansionTextRange, ((MappedTextRange)range).getDstOffset());
            IoKt.writeVarInt($this$writeExpansionTextRange, ((MappedTextRange)range).getSrcOffset());
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    public static final int getSrcEndOffset(@NotNull MappedTextRange $this$srcEndOffset) {
        Intrinsics.checkNotNullParameter((Object)$this$srcEndOffset, (String)"<this>");
        return $this$srcEndOffset.getSrcOffset() + $this$srcEndOffset.getLength();
    }

    public static final int getDstEndOffset(@NotNull ExpansionTextRange<?> $this$dstEndOffset) {
        Intrinsics.checkNotNullParameter($this$dstEndOffset, (String)"<this>");
        return $this$dstEndOffset.getDstOffset() + $this$dstEndOffset.getLength();
    }

    @NotNull
    public static final TextRange getSrcRange(@NotNull MappedTextRange $this$srcRange) {
        Intrinsics.checkNotNullParameter((Object)$this$srcRange, (String)"<this>");
        return new TextRange($this$srcRange.getSrcOffset(), $this$srcRange.getSrcOffset() + $this$srcRange.getLength());
    }

    @NotNull
    public static final TextRange getDstRange(@NotNull ExpansionTextRange<?> $this$dstRange) {
        Intrinsics.checkNotNullParameter($this$dstRange, (String)"<this>");
        return new TextRange($this$dstRange.getDstOffset(), $this$dstRange.getDstOffset() + $this$dstRange.getLength());
    }

    @NotNull
    public static final MappedTextRange srcShiftLeft(@NotNull MappedTextRange $this$srcShiftLeft, int delta) {
        Intrinsics.checkNotNullParameter((Object)$this$srcShiftLeft, (String)"<this>");
        return MappedTextRange.copy$default($this$srcShiftLeft, $this$srcShiftLeft.getSrcOffset() - delta, 0, 0, 6, null);
    }

    @NotNull
    public static final MappedTextRange srcShiftRight(@NotNull MappedTextRange $this$srcShiftRight, int delta) {
        Intrinsics.checkNotNullParameter((Object)$this$srcShiftRight, (String)"<this>");
        return MappedTextRange.copy$default($this$srcShiftRight, $this$srcShiftRight.getSrcOffset() + delta, 0, 0, 6, null);
    }

    @NotNull
    public static final MappedTextRange shiftRight(@NotNull MappedTextRange $this$shiftRight, int delta) {
        Intrinsics.checkNotNullParameter((Object)$this$shiftRight, (String)"<this>");
        return MappedTextRange.copy$default($this$shiftRight, $this$shiftRight.getSrcOffset() + delta, $this$shiftRight.getDstOffset() + delta, 0, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final RangeMap shiftDstRangesRight(@NotNull RangeMap $this$shiftDstRangesRight, int offset) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$shiftDstRangesRight, (String)"<this>");
        Iterable $this$map$iv = $this$shiftDstRangesRight.getRanges();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            ExpansionTextRange expansionTextRange = (ExpansionTextRange)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it2.dstShiftRight(offset));
        }
        List list = (List)destination$iv$iv;
        return new RangeMap(list);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final RangeMap shiftSrcRangesRight(@NotNull RangeMap $this$shiftSrcRangesRight, int offset) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$shiftSrcRangesRight, (String)"<this>");
        Iterable $this$map$iv = $this$shiftSrcRangesRight.getRanges();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            ExpansionTextRange expansionTextRange = (ExpansionTextRange)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it2 instanceof MappedTextRange ? (ExpansionTextRange)RangeMapKt.srcShiftRight((MappedTextRange)it2, offset) : it2);
        }
        List list = (List)destination$iv$iv;
        return new RangeMap(list);
    }

    @NotNull
    public static final MappedTextRange withLength(@NotNull MappedTextRange $this$withLength, int length) {
        Intrinsics.checkNotNullParameter((Object)$this$withLength, (String)"<this>");
        return MappedTextRange.copy$default($this$withLength, 0, 0, length, 3, null);
    }

    private static final MappedTextRange dstIntersection(MappedTextRange $this$dstIntersection, TextRange range) {
        MappedTextRange mappedTextRange;
        int newDstEnd;
        int newDstStart = Math.max($this$dstIntersection.getDstOffset(), range.getStartOffset());
        if (newDstStart < (newDstEnd = Math.min(RangeMapKt.getDstEndOffset($this$dstIntersection), range.getEndOffset()))) {
            int srcDelta = newDstStart - $this$dstIntersection.getDstOffset();
            mappedTextRange = new MappedTextRange($this$dstIntersection.getSrcOffset() + srcDelta, newDstStart, newDstEnd - newDstStart);
        } else {
            mappedTextRange = null;
        }
        return mappedTextRange;
    }

    public static final void mergeAdd(@NotNull List<ExpansionTextRange<?>> $this$mergeAdd, @NotNull ExpansionTextRange<?> range) {
        Intrinsics.checkNotNullParameter($this$mergeAdd, (String)"<this>");
        Intrinsics.checkNotNullParameter(range, (String)"range");
        ExpansionTextRange last = (ExpansionTextRange)CollectionsKt.lastOrNull($this$mergeAdd);
        Object object = last instanceof MappedTextRange && range instanceof MappedTextRange && RangeMapKt.getSrcEndOffset((MappedTextRange)last) == ((MappedTextRange)range).getSrcOffset() && RangeMapKt.getDstEndOffset(last) == ((MappedTextRange)range).getDstOffset() ? $this$mergeAdd.set(CollectionsKt.getLastIndex($this$mergeAdd), new MappedTextRange(((MappedTextRange)last).getSrcOffset(), ((MappedTextRange)last).getDstOffset(), ((MappedTextRange)last).getLength() + ((MappedTextRange)range).getLength())) : (last instanceof MacroProducedTextRange && range instanceof MacroProducedTextRange && Intrinsics.areEqual((Object)((MacroProducedTextRange)last).getTransparency(), (Object)((MacroProducedTextRange)range).getTransparency()) && RangeMapKt.getDstEndOffset(last) == ((MacroProducedTextRange)range).getDstOffset() ? $this$mergeAdd.set(CollectionsKt.getLastIndex($this$mergeAdd), new MacroProducedTextRange(((MacroProducedTextRange)last).getTransparency(), ((MacroProducedTextRange)last).getDstOffset(), ((MacroProducedTextRange)last).getLength() + ((MacroProducedTextRange)range).getLength())) : Boolean.valueOf($this$mergeAdd.add(range)));
    }

    public static final /* synthetic */ ExpansionTextRange access$readExpansionTextRange(DataInput $receiver) {
        return RangeMapKt.readExpansionTextRange($receiver);
    }

    public static final /* synthetic */ MappedTextRange access$dstIntersection(MappedTextRange $receiver, TextRange range) {
        return RangeMapKt.dstIntersection($receiver, range);
    }

    public static final /* synthetic */ void access$writeExpansionTextRange(DataOutput $receiver, ExpansionTextRange range) {
        RangeMapKt.writeExpansionTextRange($receiver, range);
    }
}

