/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.macros;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.stubs.SerializationManagerImpl;
import com.intellij.psi.stubs.SerializedStubTree;
import com.intellij.psi.stubs.SerializedStubTreeDataExternalizer;
import com.intellij.psi.stubs.StubForwardIndexExternalizer;
import com.intellij.psi.stubs.StubTreeSerializer;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.lang.core.macros.ExpansionResultExternalizer;
import org.rust.lang.core.macros.ExpansionResultOk;
import org.rust.lang.core.macros.HashCodeKeyDescriptor;
import org.rust.lang.core.macros.MacroExpansionManager;
import org.rust.lang.core.macros.MacroExpansionManagerKt;
import org.rust.lang.core.macros.NullableExternalizer;
import org.rust.lang.core.macros.RangeMap;
import org.rust.lang.core.macros.RangeMapExternalizer;
import org.rust.lang.core.macros.errors.MacroExpansionError;
import org.rust.lang.core.stubs.RsFileStub;
import org.rust.stdext.HashCode;
import org.rust.stdext.RsResult;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bBa\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u001e\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u0005\u0012\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u0005\u0012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r0\u0005\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R)\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001f\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u001d\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/rust/lang/core/macros/PersistentCacheData;", "", "localSerMgr", "Lcom/intellij/psi/stubs/SerializationManagerImpl;", "expansions", "Lcom/intellij/util/io/PersistentHashMap;", "Lorg/rust/stdext/HashCode;", "Lorg/rust/stdext/RsResult;", "Lorg/rust/lang/core/macros/ExpansionResultOk;", "Lorg/rust/lang/core/macros/errors/MacroExpansionError;", "stubs", "Lcom/intellij/psi/stubs/SerializedStubTree;", "ranges", "Lorg/rust/lang/core/macros/RangeMap;", "localSerializationManagerCoroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/psi/stubs/SerializationManagerImpl;Lcom/intellij/util/io/PersistentHashMap;Lcom/intellij/util/io/PersistentHashMap;Lcom/intellij/util/io/PersistentHashMap;Lkotlinx/coroutines/CoroutineScope;)V", "getLocalSerMgr", "()Lcom/intellij/psi/stubs/SerializationManagerImpl;", "getExpansions", "()Lcom/intellij/util/io/PersistentHashMap;", "getStubs", "getRanges", "flush", "", "close", "Companion", "intellij.rustrover.core"})
final class PersistentCacheData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SerializationManagerImpl localSerMgr;
    @NotNull
    private final PersistentHashMap<HashCode, RsResult<ExpansionResultOk, MacroExpansionError>> expansions;
    @NotNull
    private final PersistentHashMap<HashCode, SerializedStubTree> stubs;
    @NotNull
    private final PersistentHashMap<HashCode, RangeMap> ranges;
    @NotNull
    private final CoroutineScope localSerializationManagerCoroutineScope;

    public PersistentCacheData(@NotNull SerializationManagerImpl localSerMgr, @NotNull PersistentHashMap<HashCode, RsResult<ExpansionResultOk, MacroExpansionError>> expansions, @NotNull PersistentHashMap<HashCode, SerializedStubTree> stubs, @NotNull PersistentHashMap<HashCode, RangeMap> ranges, @NotNull CoroutineScope localSerializationManagerCoroutineScope) {
        Intrinsics.checkNotNullParameter((Object)localSerMgr, (String)"localSerMgr");
        Intrinsics.checkNotNullParameter(expansions, (String)"expansions");
        Intrinsics.checkNotNullParameter(stubs, (String)"stubs");
        Intrinsics.checkNotNullParameter(ranges, (String)"ranges");
        Intrinsics.checkNotNullParameter((Object)localSerializationManagerCoroutineScope, (String)"localSerializationManagerCoroutineScope");
        this.localSerMgr = localSerMgr;
        this.expansions = expansions;
        this.stubs = stubs;
        this.ranges = ranges;
        this.localSerializationManagerCoroutineScope = localSerializationManagerCoroutineScope;
    }

    @NotNull
    public final SerializationManagerImpl getLocalSerMgr() {
        return this.localSerMgr;
    }

    @NotNull
    public final PersistentHashMap<HashCode, RsResult<ExpansionResultOk, MacroExpansionError>> getExpansions() {
        return this.expansions;
    }

    @NotNull
    public final PersistentHashMap<HashCode, SerializedStubTree> getStubs() {
        return this.stubs;
    }

    @NotNull
    public final PersistentHashMap<HashCode, RangeMap> getRanges() {
        return this.ranges;
    }

    public final void flush() {
        this.localSerMgr.flushNameStorage();
        this.expansions.force();
        this.stubs.force();
        this.ranges.force();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        try {
            PersistentCacheData.Companion.catchAndWarn((Function0<Unit>)((Function0)new Function0<Unit>(this.expansions){

                public final void invoke() {
                    ((PersistentHashMap)this.receiver).close();
                }
            }));
            PersistentCacheData.Companion.catchAndWarn((Function0<Unit>)((Function0)new Function0<Unit>(this.stubs){

                public final void invoke() {
                    ((PersistentHashMap)this.receiver).close();
                }
            }));
            PersistentCacheData.Companion.catchAndWarn((Function0<Unit>)((Function0)new Function0<Unit>(this.ranges){

                public final void invoke() {
                    ((PersistentHashMap)this.receiver).close();
                }
            }));
            Disposer.dispose((Disposable)((Disposable)this.localSerMgr));
        }
        finally {
            CoroutineScopeKt.cancel$default((CoroutineScope)this.localSerializationManagerCoroutineScope, null, (int)1, null);
        }
    }

    @JvmStatic
    @Nullable
    public static final PersistentCacheData tryCreate(@NotNull Path baseDir, @NotNull StubForwardIndexExternalizer<?> stubExternalizer) {
        return Companion.tryCreate(baseDir, stubExternalizer);
    }

    @JvmStatic
    private static final <K, V> PersistentHashMap<K, V> newPersistentHashMap(Path file, KeyDescriptor<K> keyDescriptor, DataExternalizer<V> valueExternalizer, int initialSize, int version) {
        return PersistentCacheData.Companion.newPersistentHashMap(file, keyDescriptor, valueExternalizer, initialSize, version);
    }

    @JvmStatic
    private static final void catchAndWarn(Function0<Unit> runnable) {
        PersistentCacheData.Companion.catchAndWarn((Function0<Unit>)runnable);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0007JT\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u0002H\r0\u000b\"\u0004\b\u0000\u0010\f\"\u0004\b\u0001\u0010\r2\u0006\u0010\u000e\u001a\u00020\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\f0\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\r0\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0003J\u0016\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u0019H\u0003\u00a8\u0006\u001a"}, d2={"Lorg/rust/lang/core/macros/PersistentCacheData$Companion;", "", "<init>", "()V", "tryCreate", "Lorg/rust/lang/core/macros/PersistentCacheData;", "baseDir", "Ljava/nio/file/Path;", "stubExternalizer", "Lcom/intellij/psi/stubs/StubForwardIndexExternalizer;", "newPersistentHashMap", "Lcom/intellij/util/io/PersistentHashMap;", "K", "V", "file", "keyDescriptor", "Lcom/intellij/util/io/KeyDescriptor;", "valueExternalizer", "Lcom/intellij/util/io/DataExternalizer;", "initialSize", "", "version", "catchAndWarn", "", "runnable", "Lkotlin/Function0;", "intellij.rustrover.core"})
    @SourceDebugExtension(value={"SMAP\nMacroExpansionSharedCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MacroExpansionSharedCache.kt\norg/rust/lang/core/macros/PersistentCacheData$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,524:1\n1869#2,2:525\n*S KotlinDebug\n*F\n+ 1 MacroExpansionSharedCache.kt\norg/rust/lang/core/macros/PersistentCacheData$Companion\n*L\n384#1:525,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final PersistentCacheData tryCreate(@NotNull Path baseDir, @NotNull StubForwardIndexExternalizer<?> stubExternalizer) {
            PersistentCacheData persistentCacheData;
            Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
            Intrinsics.checkNotNullParameter(stubExternalizer, (String)"stubExternalizer");
            MacroExpansionManager.Companion.checkInvalidatedStorage();
            List cleaners = new ArrayList();
            try {
                Path namesFile = baseDir.resolve("stub.names");
                Path stubCacheFile = baseDir.resolve("expansion-stubs-cache");
                Intrinsics.checkNotNull((Object)namesFile);
                LinkOption[] linkOptionArray = new LinkOption[]{};
                boolean namesFileExists = Files.exists(namesFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
                CoroutineScope localSerializationManagerCoroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)JobKt.Job$default(null, (int)1, null)));
                SerializationManagerImpl localSerMgr = new SerializationManagerImpl(namesFile, false, localSerializationManagerCoroutineScope);
                cleaners.add(() -> Companion.tryCreate$lambda$0(localSerMgr));
                if (!namesFileExists || localSerMgr.isNameStorageCorrupted()) {
                    if (localSerMgr.isNameStorageCorrupted()) {
                        localSerMgr.repairNameStorage(new Exception("The storage has already been corrupted"));
                        if (localSerMgr.isNameStorageCorrupted()) {
                            throw new IOException("Serialization Manager is corrupted after repair");
                        }
                    }
                    IOUtil.deleteAllFilesStartingWith((File)stubCacheFile.toFile());
                }
                Path path = baseDir.resolve("expansion-cache");
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
                PersistentHashMap expansions = this.newPersistentHashMap(path, HashCodeKeyDescriptor.INSTANCE, ExpansionResultExternalizer.INSTANCE, 0x100000, 145);
                ((Collection)cleaners).add(new Function0<Unit>(expansions){

                    public final void invoke() {
                        ((PersistentHashMap)this.receiver).close();
                    }
                });
                Intrinsics.checkNotNull((Object)stubCacheFile);
                PersistentHashMap stubs = this.newPersistentHashMap(stubCacheFile, HashCodeKeyDescriptor.INSTANCE, new NullableExternalizer((DataExternalizer)new SerializedStubTreeDataExternalizer((StubTreeSerializer)localSerMgr, stubExternalizer)), 0x100000, 45 + RsFileStub.Type.INSTANCE.getStubVersion() + 1);
                ((Collection)cleaners).add(new Function0<Unit>(stubs){

                    public final void invoke() {
                        ((PersistentHashMap)this.receiver).close();
                    }
                });
                Path path2 = baseDir.resolve("expansion-ranges-cache");
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
                PersistentHashMap ranges = this.newPersistentHashMap(path2, HashCodeKeyDescriptor.INSTANCE, RangeMapExternalizer.INSTANCE, 0x100000, 145);
                ((Collection)cleaners).add(new Function0<Unit>(ranges){

                    public final void invoke() {
                        ((PersistentHashMap)this.receiver).close();
                    }
                });
                persistentCacheData = new PersistentCacheData(localSerMgr, expansions, stubs, ranges, localSerializationManagerCoroutineScope);
            }
            catch (IOException e) {
                MacroExpansionManagerKt.MACRO_LOG.warn((Throwable)e);
                Iterable $this$forEach$iv = cleaners;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Function0 p0 = (Function0)element$iv;
                    boolean bl = false;
                    this.catchAndWarn((Function0<Unit>)p0);
                }
                persistentCacheData = null;
            }
            return persistentCacheData;
        }

        @JvmStatic
        private final <K, V> PersistentHashMap<K, V> newPersistentHashMap(Path file, KeyDescriptor<K> keyDescriptor, DataExternalizer<V> valueExternalizer, int initialSize, int version) {
            Object object = IOUtil.openCleanOrResetBroken(() -> Companion.newPersistentHashMap$lambda$0(file, keyDescriptor, valueExternalizer, initialSize, version), (Path)file);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"openCleanOrResetBroken(...)");
            return (PersistentHashMap)object;
        }

        @JvmStatic
        private final void catchAndWarn(Function0<Unit> runnable) {
            try {
                runnable.invoke();
            }
            catch (IOException e) {
                MacroExpansionManagerKt.MACRO_LOG.warn((Throwable)e);
            }
            catch (Throwable t) {
                MacroExpansionManagerKt.MACRO_LOG.error(t);
            }
        }

        private static final Unit tryCreate$lambda$0(SerializationManagerImpl $localSerMgr) {
            Disposer.dispose((Disposable)((Disposable)$localSerMgr));
            return Unit.INSTANCE;
        }

        private static final PersistentHashMap newPersistentHashMap$lambda$0(Path $file, KeyDescriptor $keyDescriptor, DataExternalizer $valueExternalizer, int $initialSize, int $version) {
            return new PersistentHashMap($file, $keyDescriptor, $valueExternalizer, $initialSize, $version);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

