/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.macros;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.SerializedStubTree;
import com.intellij.psi.stubs.Stub;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ApplicationKt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import java.lang.ref.SoftReference;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.lang.RsFileType;
import org.rust.lang.core.macros.MacroExpansionKt;
import org.rust.lang.core.macros.MacroExpansionSharedCache;
import org.rust.lang.core.psi.RsFile;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.stubs.RsFileStub;
import org.rust.stdext.HashCode;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\nJ\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R3\u0010\b\u001a'\u0012\u000e\u0012\f0\n\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\b\f\u0012\u000e\u0012\f0\r\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\b\f0\t\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/rust/lang/core/macros/NonRustIncludedFilesPsiStorage;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "cache", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "Lorg/rust/lang/core/macros/NonRustIncludedFilesPsiStorage$CachedPsi;", "getPsiForNonRustFile", "Lorg/rust/lang/core/psi/RsFile;", "file", "createPsiForFile", "text", "", "dispose", "", "CachedPsi", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nMacroExpansion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MacroExpansion.kt\norg/rust/lang/core/macros/NonRustIncludedFilesPsiStorage\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,387:1\n23#2:388\n1#3:389\n*S KotlinDebug\n*F\n+ 1 MacroExpansion.kt\norg/rust/lang/core/macros/NonRustIncludedFilesPsiStorage\n*L\n317#1:388\n*E\n"})
final class NonRustIncludedFilesPsiStorage
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final ConcurrentMap<VirtualFile, CachedPsi> cache;

    public NonRustIncludedFilesPsiStorage(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentWeakMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentWeakMap(...)");
        this.cache = concurrentMap;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final RsFile getPsiForNonRustFile(@NotNull VirtualFile file) {
        Document document;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (Intrinsics.areEqual((Object)file.getFileType(), (Object)((Object)RsFileType.INSTANCE))) {
            return null;
        }
        if (!VirtualFileUtil.isFile((VirtualFile)file)) {
            return null;
        }
        if (!Registry.Companion.is("rust.enable.inclusion.of.non.rust.file")) {
            return null;
        }
        if (!file.isValid() && ApplicationKt.getApplication().isReadAccessAllowed()) {
            NonRustIncludedFilesPsiStorage $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(NonRustIncludedFilesPsiStorage.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error((Throwable)new InvalidVirtualFileAccessException(file));
            return null;
        }
        ProgressManager.checkCanceled();
        Document document2 = document = FileDocumentManager.getInstance().getCachedDocument(file);
        long documentModificationStamp = document2 != null ? document2.getModificationStamp() : -1L;
        CachedPsi cached = (CachedPsi)this.cache.get(file);
        RsFile result2 = null;
        Object object = cached;
        RsFile rsFile = object != null && (object = ((CachedPsi)object).getPsi()) != null ? (RsFile)((SoftReference)object).get() : (result2 = null);
        if (cached == null || cached.getDocumentModificationStamp() != documentModificationStamp || cached.getFileModificationStamp() != file.getModificationStamp()) {
            SoftReference<RsFile> softReference;
            Object object2;
            try {
                object2 = VirtualFileUtil.readText((VirtualFile)file);
            }
            catch (Exception exception) {
                object2 = null;
            }
            String text = object2;
            result2 = text != null ? this.createPsiForFile(file, text) : null;
            object2 = this.cache;
            RsFile rsFile2 = result2;
            if (rsFile2 != null) {
                RsFile it2 = rsFile2;
                boolean bl = false;
                softReference = new SoftReference<RsFile>(result2);
            } else {
                softReference = null;
            }
            long l = file.getModificationStamp();
            long l2 = documentModificationStamp;
            SoftReference<RsFile> softReference2 = softReference;
            CachedPsi cachedPsi = new CachedPsi(softReference2, l2, l);
            object2.put(file, cachedPsi);
        }
        return result2;
    }

    private final RsFile createPsiForFile(VirtualFile file, String text) {
        if (file.getLength() > 0x800000L) {
            return null;
        }
        PsiFile psiFile = new RsPsiFactory(this.project, false, true).createPsiFile(text, "included.rs", file);
        RsFile rsFile = psiFile instanceof RsFile ? (RsFile)psiFile : null;
        if (rsFile == null) {
            return null;
        }
        RsFile psiFile2 = rsFile;
        VirtualFile virtualFile = psiFile2.getVirtualFile();
        Intrinsics.checkNotNull((Object)virtualFile, (String)"null cannot be cast to non-null type com.intellij.testFramework.LightVirtualFile");
        ((LightVirtualFile)virtualFile).setFileType((FileType)RsFileType.INSTANCE);
        HashCode hashCode = HashCode.Companion.compute(text);
        SerializedStubTree serializedStubTree = MacroExpansionSharedCache.Companion.getInstance().cachedBuildStub(hashCode, (Function0<? extends FileContent>)((Function0)() -> NonRustIncludedFilesPsiStorage.createPsiForFile$lambda$0(psiFile2, this)));
        if (serializedStubTree == null) {
            return null;
        }
        SerializedStubTree stub = serializedStubTree;
        Stub stub2 = stub.getStub();
        Intrinsics.checkNotNull((Object)stub2, (String)"null cannot be cast to non-null type org.rust.lang.core.stubs.RsFileStub");
        psiFile2.forceSetStubTree((PsiFileStub)((RsFileStub)stub2));
        psiFile2.putUserData(MacroExpansionKt.access$getINCLUDED_NON_RUST_PSI_FILE_MARKER$p(), Unit.INSTANCE);
        return psiFile2;
    }

    public void dispose() {
        this.cache.clear();
    }

    private static final FileContent createPsiForFile$lambda$0(RsFile $psiFile, NonRustIncludedFilesPsiStorage this$0) {
        FileContent fileContent2 = FileContentImpl.createByText((VirtualFile)$psiFile.getVirtualFile(), (CharSequence)$psiFile.getText(), (Project)this$0.project);
        Intrinsics.checkNotNullExpressionValue((Object)fileContent2, (String)"createByText(...)");
        return fileContent2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B'\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0011\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0006H\u00c6\u0003J/\u0010\u0012\u001a\u00020\u00002\u0010\b\u0002\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0019\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006\u001a"}, d2={"Lorg/rust/lang/core/macros/NonRustIncludedFilesPsiStorage$CachedPsi;", "", "psi", "Ljava/lang/ref/SoftReference;", "Lorg/rust/lang/core/psi/RsFile;", "documentModificationStamp", "", "fileModificationStamp", "<init>", "(Ljava/lang/ref/SoftReference;JJ)V", "getPsi", "()Ljava/lang/ref/SoftReference;", "getDocumentModificationStamp", "()J", "getFileModificationStamp", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.rustrover.core"})
    private static final class CachedPsi {
        @Nullable
        private final SoftReference<RsFile> psi;
        private final long documentModificationStamp;
        private final long fileModificationStamp;

        public CachedPsi(@Nullable SoftReference<RsFile> psi, long documentModificationStamp, long fileModificationStamp) {
            this.psi = psi;
            this.documentModificationStamp = documentModificationStamp;
            this.fileModificationStamp = fileModificationStamp;
        }

        @Nullable
        public final SoftReference<RsFile> getPsi() {
            return this.psi;
        }

        public final long getDocumentModificationStamp() {
            return this.documentModificationStamp;
        }

        public final long getFileModificationStamp() {
            return this.fileModificationStamp;
        }

        @Nullable
        public final SoftReference<RsFile> component1() {
            return this.psi;
        }

        public final long component2() {
            return this.documentModificationStamp;
        }

        public final long component3() {
            return this.fileModificationStamp;
        }

        @NotNull
        public final CachedPsi copy(@Nullable SoftReference<RsFile> psi, long documentModificationStamp, long fileModificationStamp) {
            return new CachedPsi(psi, documentModificationStamp, fileModificationStamp);
        }

        public static /* synthetic */ CachedPsi copy$default(CachedPsi cachedPsi, SoftReference softReference, long l, long l2, int n, Object object) {
            if ((n & 1) != 0) {
                softReference = cachedPsi.psi;
            }
            if ((n & 2) != 0) {
                l = cachedPsi.documentModificationStamp;
            }
            if ((n & 4) != 0) {
                l2 = cachedPsi.fileModificationStamp;
            }
            return cachedPsi.copy(softReference, l, l2);
        }

        @NotNull
        public String toString() {
            return "CachedPsi(psi=" + this.psi + ", documentModificationStamp=" + this.documentModificationStamp + ", fileModificationStamp=" + this.fileModificationStamp + ")";
        }

        public int hashCode() {
            int result2 = this.psi == null ? 0 : this.psi.hashCode();
            result2 = result2 * 31 + Long.hashCode(this.documentModificationStamp);
            result2 = result2 * 31 + Long.hashCode(this.fileModificationStamp);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CachedPsi)) {
                return false;
            }
            CachedPsi cachedPsi = (CachedPsi)other;
            if (!Intrinsics.areEqual(this.psi, cachedPsi.psi)) {
                return false;
            }
            if (this.documentModificationStamp != cachedPsi.documentModificationStamp) {
                return false;
            }
            return this.fileModificationStamp == cachedPsi.fileModificationStamp;
        }
    }
}

