/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.macros;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.lang.core.macros.MappedTextRange;
import org.rust.lang.core.macros.RangeMap;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/rust/lang/core/macros/MappedText;", "", "text", "", "ranges", "Lorg/rust/lang/core/macros/RangeMap;", "<init>", "(Ljava/lang/String;Lorg/rust/lang/core/macros/RangeMap;)V", "getText", "()Ljava/lang/String;", "getRanges", "()Lorg/rust/lang/core/macros/RangeMap;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "intellij.rustrover.core"})
public final class MappedText {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String text;
    @NotNull
    private final RangeMap ranges;
    @NotNull
    private static final MappedText EMPTY = new MappedText("", RangeMap.Companion.getEMPTY());

    public MappedText(@NotNull String text, @NotNull RangeMap ranges) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)ranges, (String)"ranges");
        this.text = text;
        this.ranges = ranges;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @NotNull
    public final RangeMap getRanges() {
        return this.ranges;
    }

    @NotNull
    public final String component1() {
        return this.text;
    }

    @NotNull
    public final RangeMap component2() {
        return this.ranges;
    }

    @NotNull
    public final MappedText copy(@NotNull String text, @NotNull RangeMap ranges) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)ranges, (String)"ranges");
        return new MappedText(text, ranges);
    }

    public static /* synthetic */ MappedText copy$default(MappedText mappedText, String string, RangeMap rangeMap, int n, Object object) {
        if ((n & 1) != 0) {
            string = mappedText.text;
        }
        if ((n & 2) != 0) {
            rangeMap = mappedText.ranges;
        }
        return mappedText.copy(string, rangeMap);
    }

    @NotNull
    public String toString() {
        return "MappedText(text=" + this.text + ", ranges=" + this.ranges + ")";
    }

    public int hashCode() {
        int result2 = this.text.hashCode();
        result2 = result2 * 31 + this.ranges.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MappedText)) {
            return false;
        }
        MappedText mappedText = (MappedText)other;
        if (!Intrinsics.areEqual((Object)this.text, (Object)mappedText.text)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.ranges, (Object)mappedText.ranges);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lorg/rust/lang/core/macros/MappedText$Companion;", "", "<init>", "()V", "EMPTY", "Lorg/rust/lang/core/macros/MappedText;", "getEMPTY", "()Lorg/rust/lang/core/macros/MappedText;", "single", "text", "", "srcOffset", "", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MappedText getEMPTY() {
            return EMPTY;
        }

        @NotNull
        public final MappedText single(@NotNull String text, int srcOffset) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            return ((CharSequence)text).length() > 0 ? new MappedText(text, new RangeMap(new MappedTextRange(srcOffset, 0, text.length()))) : this.getEMPTY();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

