/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.macros;

import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.lang.core.macros.MacroCallPreparedForHighlighting;
import org.rust.lang.core.macros.MacroExpansion;
import org.rust.lang.core.macros.MacroExpansionKt;
import org.rust.lang.core.macros.MacroHighlightingTestmarks;
import org.rust.lang.core.macros.RsExpandedElement;
import org.rust.lang.core.macros.RsExpandedElementKt;
import org.rust.lang.core.psi.ProcMacroAttribute;
import org.rust.lang.core.psi.RsMacroCall;
import org.rust.lang.core.psi.RsMetaItem;
import org.rust.lang.core.psi.ext.PsiElementKt;
import org.rust.lang.core.psi.ext.RsAttrProcMacroOwner;
import org.rust.lang.core.psi.ext.RsAttrProcMacroOwnerKt;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsMacroCallKt;
import org.rust.lang.core.psi.ext.RsMacroDefinitionBase;
import org.rust.lang.core.psi.ext.RsPossibleMacroCall;
import org.rust.lang.core.psi.ext.RsPossibleMacroCallKt;
import org.rust.lang.core.resolve2.DefMapServiceKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0001\u001a\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u0001*\u00020\u00052\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\r\u0010\u0006\u001a\u00020\u0007*\u00020\bH\u0082\u0010\u001a\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u0005H\u0002\u001a\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u0005H\u0002\" \u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"prepareForExpansionHighlighting", "Lorg/rust/lang/core/macros/MacroCallPreparedForHighlighting;", "Lorg/rust/lang/core/psi/ext/RsAttrProcMacroOwner;", "parentMacro", "prepareMacroForExpansionHighlighting", "Lorg/rust/lang/core/psi/ext/RsPossibleMacroCall;", "isDefinedInNonRustInclusion", "", "Lorg/rust/lang/core/psi/ext/RsMacroDefinitionBase;", "getElementsForHighlightingCached", "", "Lcom/intellij/psi/PsiElement;", "call", "doComputeElementsForHighlighting", "ELEMENTS_FOR_HIGHLIGHTING_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/psi/util/CachedValue;", "intellij.rustrover.core"})
public final class MacroHighlightingUtilKt {
    @NotNull
    private static final Key<CachedValue<List<PsiElement>>> ELEMENTS_FOR_HIGHLIGHTING_KEY;

    @Nullable
    public static final MacroCallPreparedForHighlighting prepareForExpansionHighlighting(@NotNull RsAttrProcMacroOwner $this$prepareForExpansionHighlighting, @Nullable MacroCallPreparedForHighlighting parentMacro) {
        RsMetaItem procMacroAttr;
        Intrinsics.checkNotNullParameter((Object)$this$prepareForExpansionHighlighting, (String)"<this>");
        ProcMacroAttribute<RsMetaItem> procMacroAttribute = RsAttrProcMacroOwnerKt.getProcMacroAttributeCached($this$prepareForExpansionHighlighting);
        RsMetaItem rsMetaItem = procMacroAttr = procMacroAttribute != null ? procMacroAttribute.getAttr() : null;
        if (procMacroAttr != null) {
            return MacroHighlightingUtilKt.prepareMacroForExpansionHighlighting(procMacroAttr, parentMacro);
        }
        if ($this$prepareForExpansionHighlighting instanceof RsMacroCall) {
            return MacroHighlightingUtilKt.prepareMacroForExpansionHighlighting((RsPossibleMacroCall)((Object)$this$prepareForExpansionHighlighting), parentMacro);
        }
        return null;
    }

    public static /* synthetic */ MacroCallPreparedForHighlighting prepareForExpansionHighlighting$default(RsAttrProcMacroOwner rsAttrProcMacroOwner, MacroCallPreparedForHighlighting macroCallPreparedForHighlighting, int n, Object object) {
        if ((n & 1) != 0) {
            macroCallPreparedForHighlighting = null;
        }
        return MacroHighlightingUtilKt.prepareForExpansionHighlighting(rsAttrProcMacroOwner, macroCallPreparedForHighlighting);
    }

    private static final MacroCallPreparedForHighlighting prepareMacroForExpansionHighlighting(RsPossibleMacroCall $this$prepareMacroForExpansionHighlighting, MacroCallPreparedForHighlighting parentMacro) {
        if ($this$prepareMacroForExpansionHighlighting instanceof RsMacroCall && ((RsMacroCall)$this$prepareMacroForExpansionHighlighting).getMacroArgument() == null) {
            return null;
        }
        Project project = $this$prepareMacroForExpansionHighlighting.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (DefMapServiceKt.getDefMapService(project).getHasManagedNonRustFiles() && !Registry.Companion.is("rust.highlight.non.rust.included.expanded.code")) {
            MacroHighlightingTestmarks.NonRustIncludedFileCheck.INSTANCE.hit();
            if ($this$prepareMacroForExpansionHighlighting instanceof RsMacroCall) {
                RsMacroDefinitionBase rsMacroDefinitionBase = RsMacroCallKt.resolveToMacro((RsMacroCall)$this$prepareMacroForExpansionHighlighting);
                boolean bl = rsMacroDefinitionBase != null ? MacroHighlightingUtilKt.isDefinedInNonRustInclusion(rsMacroDefinitionBase) : false;
                if (bl) {
                    MacroHighlightingTestmarks.NonRustIncludedFileFilteredOut.INSTANCE.hit();
                    return null;
                }
            }
        }
        MacroExpansion macroExpansion = RsPossibleMacroCallKt.getExpansion($this$prepareMacroForExpansionHighlighting);
        if (macroExpansion == null) {
            return null;
        }
        MacroExpansion expansion = macroExpansion;
        boolean isDeeplyAttrMacro = (parentMacro == null || parentMacro.isDeeplyAttrMacro()) && $this$prepareMacroForExpansionHighlighting instanceof RsMetaItem;
        return new MacroCallPreparedForHighlighting($this$prepareMacroForExpansionHighlighting, expansion, parentMacro, isDeeplyAttrMacro);
    }

    static /* synthetic */ MacroCallPreparedForHighlighting prepareMacroForExpansionHighlighting$default(RsPossibleMacroCall rsPossibleMacroCall, MacroCallPreparedForHighlighting macroCallPreparedForHighlighting, int n, Object object) {
        if ((n & 1) != 0) {
            macroCallPreparedForHighlighting = null;
        }
        return MacroHighlightingUtilKt.prepareMacroForExpansionHighlighting(rsPossibleMacroCall, macroCallPreparedForHighlighting);
    }

    private static final boolean isDefinedInNonRustInclusion(RsMacroDefinitionBase $this$isDefinedInNonRustInclusion) {
        while (true) {
            RsMacroDefinitionBase definedMacro;
            RsMacroCall call2;
            PsiFile psiFile = $this$isDefinedInNonRustInclusion.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
            if (MacroExpansionKt.isIncludedNonRustFile(psiFile)) {
                return true;
            }
            RsPossibleMacroCall rsPossibleMacroCall = RsExpandedElementKt.getExpandedFrom($this$isDefinedInNonRustInclusion);
            if ((rsPossibleMacroCall instanceof RsMacroCall ? (RsMacroCall)rsPossibleMacroCall : null) == null) {
                return false;
            }
            call2 = call2;
            PsiFile psiFile2 = call2.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getContainingFile(...)");
            if (MacroExpansionKt.isIncludedNonRustFile(psiFile2)) {
                return true;
            }
            if (RsMacroCallKt.resolveToMacro(call2) == null) {
                return false;
            }
            $this$isDefinedInNonRustInclusion = definedMacro;
        }
    }

    private static final List<PsiElement> getElementsForHighlightingCached(RsPossibleMacroCall call2) {
        Object object = CachedValuesManager.getCachedValue((PsiElement)call2, ELEMENTS_FOR_HIGHLIGHTING_KEY, () -> MacroHighlightingUtilKt.getElementsForHighlightingCached$lambda$0(call2));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (List)object;
    }

    private static final List<PsiElement> doComputeElementsForHighlighting(RsPossibleMacroCall call2) {
        MacroExpansion macroExpansion = RsPossibleMacroCallKt.getExpansion(call2);
        if (macroExpansion == null) {
            return CollectionsKt.emptyList();
        }
        MacroExpansion expansion = macroExpansion;
        RsExpandedElement rsExpandedElement = (RsExpandedElement)CollectionsKt.singleOrNull(expansion.getElements());
        RsElement expandedElement = rsExpandedElement != null ? (RsElement)rsExpandedElement : (RsElement)expansion.getFile();
        List list = CollectHighlightsUtil.getElementsInRange((PsiElement)expansion.getFile(), (int)PsiElementKt.getStartOffset(expandedElement), (int)PsiElementKt.getEndOffset(expandedElement));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getElementsInRange(...)");
        return list;
    }

    private static final CachedValueProvider.Result getElementsForHighlightingCached$lambda$0(RsPossibleMacroCall $call) {
        List<PsiElement> result2 = MacroHighlightingUtilKt.doComputeElementsForHighlighting($call);
        Object[] objectArray = new Object[]{PsiModificationTracker.MODIFICATION_COUNT};
        return CachedValueProvider.Result.create(result2, (Object[])objectArray);
    }

    public static final /* synthetic */ List access$getElementsForHighlightingCached(RsPossibleMacroCall call2) {
        return MacroHighlightingUtilKt.getElementsForHighlightingCached(call2);
    }

    static {
        Key key = Key.create((String)"org.rust.lang.core.macros.ELEMENTS_FOR_HIGHLIGHTING_KEY");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        ELEMENTS_FOR_HIGHLIGHTING_KEY = key;
    }
}

